/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import common.Properties;
import common.ScreenUtilities;
import data.JankenMatch;
import data.Palette;
import data.TextData;
import data.Tiles;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import panels.EntityPanel;
import transactions.TransactionManager;

public class JankenMatchEditor
extends JDialog {
    private static JankenMatchEditor editor;
    private final EntityPanel[] entityPanels = new EntityPanel[128];
    private final EntityPanel[] opponentEntityPanels = new EntityPanel[4];
    private int selectedDecision;
    private final int[][] decisions = new int[4][];
    private final JComboBox<?>[] messageSelection = new JComboBox[4];
    private JankenMatch jankenMatch;
    private TextData textData;
    private Vector<TextData.TextHandle> textHandles;
    private final ChangeListener textDataChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = 0;
            while (n < JankenMatchEditor.this.messageSelection.length) {
                ((TextData.TextHandle)JankenMatchEditor.this.messageSelection[n].getSelectedItem()).updateName();
                JankenMatchEditor.this.messageSelection[n].repaint();
                ++n;
            }
        }
    };
    private final ChangeListener jankenMatchChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(JankenMatchEditor.this.jankenMatch);
            if (n < 0) {
                n = -n - 1;
                JankenMatchEditor.this.messageSelection[n].setSelectedItem(JankenMatchEditor.this.textData.getTextHandle(JankenMatchEditor.this.jankenMatch.getMessage(n)));
            } else {
                ((JankenMatchEditor)JankenMatchEditor.this).decisions[n] = JankenMatchEditor.this.jankenMatch.getDecisions(n);
                int n2 = 0;
                while (n2 < JankenMatchEditor.this.decisions[n].length) {
                    JankenMatchEditor.this.entityPanels[n * JankenMatchEditor.this.decisions[n].length + n2].setEntityJankenMatchDecision(JankenMatchEditor.this.decisions[n][n2]);
                    ++n2;
                }
            }
        }
    };

    private JankenMatchEditor(JankenMatch jankenMatch, Tiles[] tilesArray, Palette palette, TextData textData, int n) {
        JComponent jComponent;
        JComponent jComponent2;
        final int[][] nArray = this.decisions;
        final EntityPanel[] entityPanelArray = this.entityPanels;
        final JComboBox[] jComboBoxArray = this.messageSelection;
        this.setTitle(TextProvider.get("TitleJankenMatch"));
        this.jankenMatch = jankenMatch;
        jankenMatch.addChangeListener(this.jankenMatchChangeListener);
        this.textData = textData;
        textData.addChangeListener(this.textDataChangeListener);
        Tileset tileset = new Tileset(tilesArray[0]);
        this.textHandles = new Vector();
        for (TextData.TextHandle object2 : textData.getTextHandles()) {
            if (object2.getMessageID() >= 256) continue;
            this.textHandles.add(object2);
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(nArray.length, 1, 0, 8));
        this.add((Component)jPanel, "Center");
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = jankenMatch.getDecisions(n2);
            jComponent2 = new JPanel(new BorderLayout());
            jPanel.add(jComponent2);
            this.opponentEntityPanels[n2] = new EntityPanel(24, n2, 5, new Tileset(tilesArray[1 + n2]), palette, n);
            this.opponentEntityPanels[n2].setEntitySpriteDescriptor(jankenMatch.getSpriteDescriptor(n2));
            jComponent2.add((Component)this.opponentEntityPanels[n2], "West");
            jComponent = new JPanel(new GridLayout(2, nArray[n2].length / 2));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jComponent, "Center");
            jComboBoxArray[n2] = new JComboBox<TextData.TextHandle>(this.textHandles);
            jComboBoxArray[n2].setFocusable(false);
            jPanel2.add((Component)jComboBoxArray[n2], "South");
            jComboBoxArray[n2].setSelectedItem(textData.getTextHandle(jankenMatch.getMessage(n2)));
            jComponent2.add((Component)jPanel2, "Center");
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                JPanel jPanel3 = new JPanel(new BorderLayout());
                EntityPanel entityPanel = new EntityPanel(11, 0, 6, tileset, palette, n);
                entityPanel.setEntityJankenMatchDecision(nArray[n2][n3]);
                final int n4 = n2 * nArray[n2].length + n3;
                entityPanelArray[n4] = entityPanel;
                entityPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(false);
                        JankenMatchEditor.this.selectedDecision = n4;
                        entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(true);
                    }
                });
                jPanel3.add((Component)entityPanel, "Center");
                jPanel3.setBorder(BorderFactory.createEtchedBorder());
                jComponent.add(jPanel3);
                ++n3;
            }
            ++n2;
        }
        this.selectedDecision = 0;
        entityPanelArray[this.selectedDecision].setSelected(true);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nArray[((JankenMatchEditor)JankenMatchEditor.this).selectedDecision / 32][((JankenMatchEditor)JankenMatchEditor.this).selectedDecision & 0x1F] = (nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F] + 1) % 3;
                entityPanelArray[JankenMatchEditor.this.selectedDecision].setEntityJankenMatchDecision(nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F]);
            }
        }, KeyStroke.getKeyStroke(38, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nArray[((JankenMatchEditor)JankenMatchEditor.this).selectedDecision / 32][((JankenMatchEditor)JankenMatchEditor.this).selectedDecision & 0x1F] = (nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F] + 2) % 3;
                entityPanelArray[JankenMatchEditor.this.selectedDecision].setEntityJankenMatchDecision(nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F]);
            }
        }, KeyStroke.getKeyStroke(40, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JankenMatchEditor.this.selectedDecision > 0) {
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(false);
                    JankenMatchEditor jankenMatchEditor = JankenMatchEditor.this;
                    jankenMatchEditor.selectedDecision = jankenMatchEditor.selectedDecision - 1;
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(true);
                }
            }
        }, KeyStroke.getKeyStroke(37, 0), 2);
        jPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JankenMatchEditor.this.selectedDecision < entityPanelArray.length - 1) {
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(false);
                    JankenMatchEditor jankenMatchEditor = JankenMatchEditor.this;
                    jankenMatchEditor.selectedDecision = jankenMatchEditor.selectedDecision + 1;
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setSelected(true);
                }
            }
        }, KeyStroke.getKeyStroke(39, 0), 2);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    nArray[((JankenMatchEditor)JankenMatchEditor.this).selectedDecision / 32][((JankenMatchEditor)JankenMatchEditor.this).selectedDecision & 0x1F] = (nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F] + 1) % 3;
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setEntityJankenMatchDecision(nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F]);
                } else if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    nArray[((JankenMatchEditor)JankenMatchEditor.this).selectedDecision / 32][((JankenMatchEditor)JankenMatchEditor.this).selectedDecision & 0x1F] = (nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F] + 2) % 3;
                    entityPanelArray[JankenMatchEditor.this.selectedDecision].setEntityJankenMatchDecision(nArray[JankenMatchEditor.this.selectedDecision / 32][JankenMatchEditor.this.selectedDecision & 0x1F]);
                }
                mouseWheelEvent.consume();
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jComponent2 = new JButton(TextProvider.get("ButtonOK"));
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        int n = 0;
                        while (n < nArray.length) {
                            JankenMatchEditor.this.jankenMatch.setDecisions(n, nArray[n]);
                            ++n;
                        }
                        n = 0;
                        while (n < jComboBoxArray.length) {
                            TextData.TextHandle textHandle = (TextData.TextHandle)jComboBoxArray[n].getSelectedItem();
                            JankenMatchEditor.this.jankenMatch.setMessage(n, textHandle.getMessageID());
                            ++n;
                        }
                    }
                });
                JankenMatchEditor.this.setVisible(false);
            }
        });
        jComponent = new JButton(TextProvider.get("ButtonCancel"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JankenMatchEditor.this.setVisible(false);
            }
        });
        jPanel4.add(jComponent2);
        jPanel4.add(jComponent);
        this.add((Component)jPanel4, "South");
        this.setResizable(false);
    }

    public static void open(JFrame jFrame, JankenMatch jankenMatch, Tiles[] tilesArray, Palette palette, TextData textData, int n, Properties properties) {
        if (editor == null) {
            editor = new JankenMatchEditor(jankenMatch, tilesArray, palette, textData, n);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            if (JankenMatchEditor.editor.jankenMatch != null && JankenMatchEditor.editor.jankenMatch != jankenMatch) {
                JankenMatchEditor.editor.jankenMatch.removeChangeListener(JankenMatchEditor.editor.jankenMatchChangeListener);
            }
            JankenMatchEditor.editor.jankenMatch = jankenMatch;
            jankenMatch.addChangeListener(JankenMatchEditor.editor.jankenMatchChangeListener);
            if (JankenMatchEditor.editor.textData != null && JankenMatchEditor.editor.textData != textData) {
                JankenMatchEditor.editor.textData.removeChangeListener(JankenMatchEditor.editor.textDataChangeListener);
            }
            JankenMatchEditor.editor.textData = textData;
            textData.addChangeListener(JankenMatchEditor.editor.textDataChangeListener);
            JankenMatchEditor.editor.textHandles.clear();
            for (TextData.TextHandle textHandle : textData.getTextHandles()) {
                if (textHandle.getMessageID() >= 256) continue;
                JankenMatchEditor.editor.textHandles.add(textHandle);
            }
            int n2 = 0;
            while (n2 < 4) {
                JankenMatchEditor.editor.decisions[n2] = jankenMatch.getDecisions(n2);
                int n3 = 0;
                while (n3 < JankenMatchEditor.editor.decisions[n2].length) {
                    JankenMatchEditor.editor.entityPanels[n2 * JankenMatchEditor.editor.decisions[n2].length + n3].setEntityJankenMatchDecision(JankenMatchEditor.editor.decisions[n2][n3]);
                    ++n3;
                }
                JankenMatchEditor.editor.messageSelection[n2].setSelectedItem(textData.getTextHandle(jankenMatch.getMessage(n2)));
                JankenMatchEditor.editor.opponentEntityPanels[n2].setTileset(new Tileset(tilesArray[1 + n2]));
                JankenMatchEditor.editor.opponentEntityPanels[n2].setEntitySpriteDescriptor(jankenMatch.getSpriteDescriptor(n2));
                ++n2;
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

