/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Change;
import data.SpriteTileset;
import data.Tileset;
import java.util.Arrays;
import rom.RomManager;
import transactions.TransactionManager;

public class LevelSpriteTileset
extends Tileset {
    public LevelSpriteTileset(int n) {
        super(2790, n);
    }

    public boolean isSubTileset(SpriteTileset spriteTileset) {
        int n = RomManager.StaticAccess.readWord(4418 + this.level * 2);
        boolean bl = false;
        while (!bl) {
            if (RomManager.StaticAccess.readByte(n) == 195 || RomManager.StaticAccess.readByte(n) == 201) {
                bl = true;
            } else if (RomManager.StaticAccess.readByte(n) != 205 && RomManager.StaticAccess.readByte(n) != 201 && RomManager.StaticAccess.readByte(n) != 0) break;
            int n2 = RomManager.StaticAccess.readWord(n + 1);
            if (n2 == spriteTileset.getAddress()) {
                return true;
            }
            n += 3;
        }
        return false;
    }

    public void addSubTileset(SpriteTileset spriteTileset) {
        int n = RomManager.StaticAccess.readWord(4418 + this.level * 2);
        boolean bl = false;
        while (!bl) {
            if (RomManager.StaticAccess.readByte(n) == 195 || RomManager.StaticAccess.readByte(n) == 201) {
                bl = true;
            } else if (RomManager.StaticAccess.readByte(n) != 205 && RomManager.StaticAccess.readByte(n) != 201 && RomManager.StaticAccess.readByte(n) != 0) break;
            int n2 = RomManager.StaticAccess.readWord(n + 1);
            if (n2 == 0) {
                TransactionManager.getInstance().addTransactionObject(this, spriteTileset.getDestination() / 32);
                RomManager.StaticAccess.writeByte(n, RomManager.StaticAccess.readByte(n) == 201 ? 195 : 205);
                RomManager.StaticAccess.writeByte(n + 1, spriteTileset.getAddress() & 0xFF);
                RomManager.StaticAccess.writeByte(n + 2, spriteTileset.getAddress() >> 8);
                this.memory[n] = RomManager.StaticAccess.readByte(n);
                this.memory[n + 1] = RomManager.StaticAccess.readByte(n + 1);
                this.memory[n + 2] = RomManager.StaticAccess.readByte(n + 2);
                this.cpu.execute(this.address);
                this.fireChangeOccurred(new Change(spriteTileset.getDestination() / 32));
                return;
            }
            n += 3;
        }
    }

    public void removeSubTileset(SpriteTileset spriteTileset) {
        int n = RomManager.StaticAccess.readWord(4418 + this.level * 2);
        boolean bl = false;
        while (!bl) {
            if (RomManager.StaticAccess.readByte(n) == 195 || RomManager.StaticAccess.readByte(n) == 201) {
                bl = true;
            } else if (RomManager.StaticAccess.readByte(n) != 205 && RomManager.StaticAccess.readByte(n) != 201 && RomManager.StaticAccess.readByte(n) != 0) break;
            int n2 = RomManager.StaticAccess.readWord(n + 1);
            if (n2 == spriteTileset.getAddress()) {
                TransactionManager.getInstance().addTransactionObject(this, spriteTileset.getDestination() / 32);
                RomManager.StaticAccess.writeByte(n, bl ? 201 : 0);
                RomManager.StaticAccess.writeByte(n + 1, 0);
                RomManager.StaticAccess.writeByte(n + 2, 0);
                this.memory[n] = RomManager.StaticAccess.readByte(n);
                this.memory[n + 1] = RomManager.StaticAccess.readByte(n + 1);
                this.memory[n + 2] = RomManager.StaticAccess.readByte(n + 2);
                Arrays.fill(this.vram, spriteTileset.getDestination(), spriteTileset.getDestination() + spriteTileset.getLength(), 0);
                Arrays.fill(this.tileSources, spriteTileset.getDestination() / 32, (spriteTileset.getDestination() + spriteTileset.getLength()) / 32, Integer.MAX_VALUE);
                this.cpu.execute(this.address);
                this.fireChangeOccurred(new Change(spriteTileset.getDestination() / 32));
                return;
            }
            n += 3;
        }
    }

    public boolean canAddMoreTilesets() {
        int n = RomManager.StaticAccess.readWord(4418 + this.level * 2);
        boolean bl = false;
        while (!bl) {
            if (RomManager.StaticAccess.readByte(n) == 195 || RomManager.StaticAccess.readByte(n) == 201) {
                bl = true;
            } else if (RomManager.StaticAccess.readByte(n) != 205 && RomManager.StaticAccess.readByte(n) != 201 && RomManager.StaticAccess.readByte(n) != 0) break;
            int n2 = RomManager.StaticAccess.readWord(n + 1);
            if (n2 == 0) {
                return true;
            }
            n += 3;
        }
        return false;
    }

    @Override
    public boolean contains(int n) {
        return n == 31 || super.contains(n);
    }

    @Override
    public boolean isSprite() {
        return true;
    }

    @Override
    public int[] getVRAM() {
        this.memory[49233] = 0;
        this.memory[49665] = 0;
        this.memory[26564] = 201;
        this.memory[27465] = 201;
        this.memory[26912] = 201;
        this.memory[27251] = 201;
        this.memory[26125] = 0;
        this.memory[26126] = 0;
        this.memory[14913] = 55;
        this.memory[14914] = 201;
        this.memory[2874] = 205;
        this.memory[2875] = 177;
        this.memory[2876] = 101;
        this.memory[2877] = 62;
        this.memory[2878] = 130;
        this.memory[2879] = 50;
        this.memory[2880] = 255;
        this.memory[2881] = 255;
        this.memory[2882] = 205;
        this.memory[2883] = 67;
        this.memory[2884] = 12;
        this.memory[2885] = 195;
        this.memory[2886] = 179;
        this.memory[2887] = 65;
        this.memory[3170] = 195;
        this.memory[3171] = 174;
        this.memory[3172] = 12;
        return super.getVRAM();
    }
}

