/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;

public class ScreenUtilities {
    private ScreenUtilities() {
    }

    public static final GraphicsDevice getScreen(Window window) {
        if (window == null) {
            return null;
        }
        return ScreenUtilities.getScreenAt(window.getX(), window.getY());
    }

    public static final GraphicsDevice getScreenAt(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment == null) {
            return null;
        }
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n3 = graphicsDeviceArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Rectangle rectangle;
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n4];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            if (graphicsConfiguration != null && (double)n >= (rectangle = graphicsConfiguration.getBounds()).getMinX() && (double)n <= rectangle.getMaxX() && (double)n2 >= rectangle.getMinY() && (double)n2 <= rectangle.getMaxY()) {
                return graphicsDevice;
            }
            ++n4;
        }
        return null;
    }

    public static final GraphicsDevice getDefaultScreen() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment == null) {
            return null;
        }
        return graphicsEnvironment.getDefaultScreenDevice();
    }
}

