/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private List<ListenerInfo> listenerList = new CopyOnWriteArrayList<ListenerInfo>();
    private final Executor executor;
    private final MBeanNotificationInfo[] notifInfo;
    private static final Executor defaultExecutor = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    };
    private static final MBeanNotificationInfo[] NO_NOTIFICATION_INFO = new MBeanNotificationInfo[0];
    private static final ClassLogger logger = new ClassLogger("javax.management", "NotificationBroadcasterSupport");

    public NotificationBroadcasterSupport() {
        this((Executor)null, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(Executor executor) {
        this(executor, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this((Executor)null, mBeanNotificationInfoArray);
    }

    public NotificationBroadcasterSupport(Executor executor, MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this.executor = executor != null ? executor : defaultExecutor;
        this.notifInfo = mBeanNotificationInfoArray == null ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        this.listenerList.add(new ListenerInfo(notificationListener, notificationFilter, object));
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        WildcardListenerInfo wildcardListenerInfo = new WildcardListenerInfo(notificationListener);
        boolean bl = this.listenerList.removeAll(Collections.singleton(wildcardListenerInfo));
        if (!bl) {
            throw new ListenerNotFoundException("Listener not registered");
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        ListenerInfo listenerInfo = new ListenerInfo(notificationListener, notificationFilter, object);
        boolean bl = this.listenerList.remove(listenerInfo);
        if (!bl) {
            throw new ListenerNotFoundException("Listener not registered (with this filter and handback)");
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfo.length == 0) {
            return this.notifInfo;
        }
        return (MBeanNotificationInfo[])this.notifInfo.clone();
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        for (ListenerInfo listenerInfo : this.listenerList) {
            boolean bl;
            try {
                bl = listenerInfo.filter == null || listenerInfo.filter.isNotificationEnabled(notification);
            }
            catch (Exception exception) {
                if (!logger.debugOn()) continue;
                logger.debug("sendNotification", exception);
                continue;
            }
            if (!bl) continue;
            this.executor.execute(new SendNotifJob(notification, listenerInfo));
        }
    }

    protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
        notificationListener.handleNotification(notification, object);
    }

    private static class ListenerInfo {
        NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        ListenerInfo(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ListenerInfo)) {
                return false;
            }
            ListenerInfo listenerInfo = (ListenerInfo)object;
            if (listenerInfo instanceof WildcardListenerInfo) {
                return listenerInfo.listener == this.listener;
            }
            return listenerInfo.listener == this.listener && listenerInfo.filter == this.filter && listenerInfo.handback == this.handback;
        }

        public int hashCode() {
            return Objects.hashCode(this.listener);
        }
    }

    private class SendNotifJob
    implements Runnable {
        private final Notification notif;
        private final ListenerInfo listenerInfo;

        public SendNotifJob(Notification notification, ListenerInfo listenerInfo) {
            this.notif = notification;
            this.listenerInfo = listenerInfo;
        }

        @Override
        public void run() {
            block2: {
                try {
                    NotificationBroadcasterSupport.this.handleNotification(this.listenerInfo.listener, this.notif, this.listenerInfo.handback);
                }
                catch (Exception exception) {
                    if (!logger.debugOn()) break block2;
                    logger.debug("SendNotifJob-run", exception);
                }
            }
        }
    }

    private static class WildcardListenerInfo
    extends ListenerInfo {
        WildcardListenerInfo(NotificationListener notificationListener) {
            super(notificationListener, null, null);
        }

        @Override
        public boolean equals(Object object) {
            assert (!(object instanceof WildcardListenerInfo));
            return object.equals(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

