/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.stream.AbstractTask;
import java.util.stream.Node;
import java.util.stream.PipelineHelper;
import java.util.stream.Sink;
import java.util.stream.SpinedBuffer;
import java.util.stream.StreamShape;

final class Nodes {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    static final String BAD_SIZE = "Stream size exceeds max array size";
    private static final Node EMPTY_NODE = new EmptyNode.OfRef();
    private static final Node.OfInt EMPTY_INT_NODE = new EmptyNode.OfInt();
    private static final Node.OfLong EMPTY_LONG_NODE = new EmptyNode.OfLong();
    private static final Node.OfDouble EMPTY_DOUBLE_NODE = new EmptyNode.OfDouble();
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];

    private Nodes() {
        throw new Error("no instances");
    }

    static <T> Node<T> emptyNode(StreamShape streamShape) {
        switch (streamShape) {
            case REFERENCE: {
                return EMPTY_NODE;
            }
            case INT_VALUE: {
                return EMPTY_INT_NODE;
            }
            case LONG_VALUE: {
                return EMPTY_LONG_NODE;
            }
            case DOUBLE_VALUE: {
                return EMPTY_DOUBLE_NODE;
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)streamShape));
    }

    static <T> Node<T> conc(StreamShape streamShape, Node<T> node, Node<T> node2) {
        switch (streamShape) {
            case REFERENCE: {
                return new ConcNode<T>(node, node2);
            }
            case INT_VALUE: {
                return new ConcNode.OfInt((Node.OfInt)node, (Node.OfInt)node2);
            }
            case LONG_VALUE: {
                return new ConcNode.OfLong((Node.OfLong)node, (Node.OfLong)node2);
            }
            case DOUBLE_VALUE: {
                return new ConcNode.OfDouble((Node.OfDouble)node, (Node.OfDouble)node2);
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)streamShape));
    }

    static <T> Node<T> node(T[] TArray) {
        return new ArrayNode<T>(TArray);
    }

    static <T> Node<T> node(Collection<T> collection) {
        return new CollectionNode<T>(collection);
    }

    static <T> Node.Builder<T> builder(long l, IntFunction<T[]> intFunction) {
        return l >= 0L && l < 0x7FFFFFF7L ? new FixedNodeBuilder(l, intFunction) : Nodes.builder();
    }

    static <T> Node.Builder<T> builder() {
        return new SpinedNodeBuilder();
    }

    static Node.OfInt node(int[] nArray) {
        return new IntArrayNode(nArray);
    }

    static Node.Builder.OfInt intBuilder(long l) {
        return l >= 0L && l < 0x7FFFFFF7L ? new IntFixedNodeBuilder(l) : Nodes.intBuilder();
    }

    static Node.Builder.OfInt intBuilder() {
        return new IntSpinedNodeBuilder();
    }

    static Node.OfLong node(long[] lArray) {
        return new LongArrayNode(lArray);
    }

    static Node.Builder.OfLong longBuilder(long l) {
        return l >= 0L && l < 0x7FFFFFF7L ? new LongFixedNodeBuilder(l) : Nodes.longBuilder();
    }

    static Node.Builder.OfLong longBuilder() {
        return new LongSpinedNodeBuilder();
    }

    static Node.OfDouble node(double[] dArray) {
        return new DoubleArrayNode(dArray);
    }

    static Node.Builder.OfDouble doubleBuilder(long l) {
        return l >= 0L && l < 0x7FFFFFF7L ? new DoubleFixedNodeBuilder(l) : Nodes.doubleBuilder();
    }

    static Node.Builder.OfDouble doubleBuilder() {
        return new DoubleSpinedNodeBuilder();
    }

    public static <P_IN, P_OUT> Node<P_OUT> collect(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<P_OUT[]> intFunction) {
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        if (l >= 0L && spliterator.hasCharacteristics(16384)) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            P_OUT[] P_OUTArray = intFunction.apply((int)l);
            new SizedCollectorTask.OfRef<P_IN, P_OUT>(spliterator, pipelineHelper, P_OUTArray).invoke();
            return Nodes.node(P_OUTArray);
        }
        Node node = (Node)new CollectorTask.OfRef<P_IN, P_OUT>(pipelineHelper, intFunction, spliterator).invoke();
        return bl ? Nodes.flatten(node, intFunction) : node;
    }

    public static <P_IN> Node.OfInt collectInt(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        if (l >= 0L && spliterator.hasCharacteristics(16384)) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            int[] nArray = new int[(int)l];
            new SizedCollectorTask.OfInt<P_IN>(spliterator, pipelineHelper, nArray).invoke();
            return Nodes.node(nArray);
        }
        Node.OfInt ofInt = (Node.OfInt)new CollectorTask.OfInt<P_IN>(pipelineHelper, spliterator).invoke();
        return bl ? Nodes.flattenInt(ofInt) : ofInt;
    }

    public static <P_IN> Node.OfLong collectLong(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        if (l >= 0L && spliterator.hasCharacteristics(16384)) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            long[] lArray = new long[(int)l];
            new SizedCollectorTask.OfLong<P_IN>(spliterator, pipelineHelper, lArray).invoke();
            return Nodes.node(lArray);
        }
        Node.OfLong ofLong = (Node.OfLong)new CollectorTask.OfLong<P_IN>(pipelineHelper, spliterator).invoke();
        return bl ? Nodes.flattenLong(ofLong) : ofLong;
    }

    public static <P_IN> Node.OfDouble collectDouble(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
        long l = pipelineHelper.exactOutputSizeIfKnown(spliterator);
        if (l >= 0L && spliterator.hasCharacteristics(16384)) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            double[] dArray = new double[(int)l];
            new SizedCollectorTask.OfDouble<P_IN>(spliterator, pipelineHelper, dArray).invoke();
            return Nodes.node(dArray);
        }
        Node.OfDouble ofDouble = (Node.OfDouble)new CollectorTask.OfDouble<P_IN>(pipelineHelper, spliterator).invoke();
        return bl ? Nodes.flattenDouble(ofDouble) : ofDouble;
    }

    public static <T> Node<T> flatten(Node<T> node, IntFunction<T[]> intFunction) {
        if (node.getChildCount() > 0) {
            long l = node.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            Object[] objectArray = intFunction.apply((int)l);
            new ToArrayTask.OfRef(node, objectArray, 0).invoke();
            return Nodes.node(objectArray);
        }
        return node;
    }

    public static Node.OfInt flattenInt(Node.OfInt ofInt) {
        if (ofInt.getChildCount() > 0) {
            long l = ofInt.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            int[] nArray = new int[(int)l];
            new ToArrayTask.OfInt(ofInt, nArray, 0).invoke();
            return Nodes.node(nArray);
        }
        return ofInt;
    }

    public static Node.OfLong flattenLong(Node.OfLong ofLong) {
        if (ofLong.getChildCount() > 0) {
            long l = ofLong.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            long[] lArray = new long[(int)l];
            new ToArrayTask.OfLong(ofLong, lArray, 0).invoke();
            return Nodes.node(lArray);
        }
        return ofLong;
    }

    public static Node.OfDouble flattenDouble(Node.OfDouble ofDouble) {
        if (ofDouble.getChildCount() > 0) {
            long l = ofDouble.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(BAD_SIZE);
            }
            double[] dArray = new double[(int)l];
            new ToArrayTask.OfDouble(ofDouble, dArray, 0).invoke();
            return Nodes.node(dArray);
        }
        return ofDouble;
    }

    private static abstract class AbstractConcNode<T, T_NODE extends Node<T>>
    implements Node<T> {
        protected final T_NODE left;
        protected final T_NODE right;
        private final long size;

        AbstractConcNode(T_NODE T_NODE, T_NODE T_NODE2) {
            this.left = T_NODE;
            this.right = T_NODE2;
            this.size = T_NODE.count() + T_NODE2.count();
        }

        @Override
        public int getChildCount() {
            return 2;
        }

        public T_NODE getChild(int n) {
            if (n == 0) {
                return this.left;
            }
            if (n == 1) {
                return this.right;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public long count() {
            return this.size;
        }
    }

    private static class ArrayNode<T>
    implements Node<T> {
        final T[] array;
        int curSize;

        ArrayNode(long l, IntFunction<T[]> intFunction) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = intFunction.apply((int)l);
            this.curSize = 0;
        }

        ArrayNode(T[] TArray) {
            this.array = TArray;
            this.curSize = TArray.length;
        }

        @Override
        public Spliterator<T> spliterator() {
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            System.arraycopy(this.array, 0, TArray, n, this.curSize);
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            throw new IllegalStateException();
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            for (int i = 0; i < this.curSize; ++i) {
                consumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("ArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class CollectionNode<T>
    implements Node<T> {
        private final Collection<T> c;

        CollectionNode(Collection<T> collection) {
            this.c = collection;
        }

        @Override
        public Spliterator<T> spliterator() {
            return this.c.stream().spliterator();
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            for (T t : this.c) {
                TArray[n++] = t;
            }
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            return this.c.toArray(intFunction.apply(this.c.size()));
        }

        @Override
        public long count() {
            return this.c.size();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            this.c.forEach(consumer);
        }

        public String toString() {
            return String.format("CollectionNode[%d][%s]", this.c.size(), this.c);
        }
    }

    private static class CollectorTask<P_IN, P_OUT, T_NODE extends Node<P_OUT>, T_BUILDER extends Node.Builder<P_OUT>>
    extends AbstractTask<P_IN, P_OUT, T_NODE, CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>> {
        protected final PipelineHelper<P_OUT> helper;
        protected final LongFunction<T_BUILDER> builderFactory;
        protected final BinaryOperator<T_NODE> concFactory;

        CollectorTask(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, LongFunction<T_BUILDER> longFunction, BinaryOperator<T_NODE> binaryOperator) {
            super(pipelineHelper, spliterator);
            this.helper = pipelineHelper;
            this.builderFactory = longFunction;
            this.concFactory = binaryOperator;
        }

        CollectorTask(CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> collectorTask, Spliterator<P_IN> spliterator) {
            super(collectorTask, spliterator);
            this.helper = collectorTask.helper;
            this.builderFactory = collectorTask.builderFactory;
            this.concFactory = collectorTask.concFactory;
        }

        @Override
        protected CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER> makeChild(Spliterator<P_IN> spliterator) {
            return new CollectorTask<P_IN, P_OUT, T_NODE, T_BUILDER>(this, spliterator);
        }

        @Override
        protected T_NODE doLeaf() {
            Node.Builder builder = (Node.Builder)this.builderFactory.apply(this.helper.exactOutputSizeIfKnown(this.spliterator));
            return (T_NODE)this.helper.wrapAndCopyInto(builder, this.spliterator).build();
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            if (!this.isLeaf()) {
                this.setLocalResult(this.concFactory.apply(((CollectorTask)this.leftChild).getLocalResult(), ((CollectorTask)this.rightChild).getLocalResult()));
            }
            super.onCompletion(countedCompleter);
        }

        private static final class OfDouble<P_IN>
        extends CollectorTask<P_IN, Double, Node.OfDouble, Node.Builder.OfDouble> {
            OfDouble(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator) {
                super(pipelineHelper, spliterator, Nodes::doubleBuilder, ConcNode.OfDouble::new);
            }
        }

        private static final class OfInt<P_IN>
        extends CollectorTask<P_IN, Integer, Node.OfInt, Node.Builder.OfInt> {
            OfInt(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator) {
                super(pipelineHelper, spliterator, Nodes::intBuilder, ConcNode.OfInt::new);
            }
        }

        private static final class OfLong<P_IN>
        extends CollectorTask<P_IN, Long, Node.OfLong, Node.Builder.OfLong> {
            OfLong(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator) {
                super(pipelineHelper, spliterator, Nodes::longBuilder, ConcNode.OfLong::new);
            }
        }

        private static final class OfRef<P_IN, P_OUT>
        extends CollectorTask<P_IN, P_OUT, Node<P_OUT>, Node.Builder<P_OUT>> {
            OfRef(PipelineHelper<P_OUT> pipelineHelper, IntFunction<P_OUT[]> intFunction, Spliterator<P_IN> spliterator) {
                super(pipelineHelper, spliterator, l -> Nodes.builder(l, intFunction), ConcNode::new);
            }
        }
    }

    static final class ConcNode<T>
    extends AbstractConcNode<T, Node<T>>
    implements Node<T> {
        ConcNode(Node<T> node, Node<T> node2) {
            super(node, node2);
        }

        @Override
        public Spliterator<T> spliterator() {
            return new InternalNodeSpliterator.OfRef(this);
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            Objects.requireNonNull(TArray);
            this.left.copyInto(TArray, n);
            this.right.copyInto(TArray, n + (int)this.left.count());
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            long l = this.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            T[] TArray = intFunction.apply((int)l);
            this.copyInto(TArray, 0);
            return TArray;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            this.left.forEach(consumer);
            this.right.forEach(consumer);
        }

        @Override
        public Node<T> truncate(long l, long l2, IntFunction<T[]> intFunction) {
            if (l == 0L && l2 == this.count()) {
                return this;
            }
            long l3 = this.left.count();
            if (l >= l3) {
                return this.right.truncate(l - l3, l2 - l3, intFunction);
            }
            if (l2 <= l3) {
                return this.left.truncate(l, l2, intFunction);
            }
            return Nodes.conc(this.getShape(), this.left.truncate(l, l3, intFunction), this.right.truncate(0L, l2 - l3, intFunction));
        }

        public String toString() {
            if (this.count() < 32L) {
                return String.format("ConcNode[%s.%s]", this.left, this.right);
            }
            return String.format("ConcNode[size=%d]", this.count());
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Node.OfDouble {
            OfDouble(Node.OfDouble ofDouble, Node.OfDouble ofDouble2) {
                super(ofDouble, ofDouble2);
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                return new InternalNodeSpliterator.OfDouble(this);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Node.OfInt {
            OfInt(Node.OfInt ofInt, Node.OfInt ofInt2) {
                super(ofInt, ofInt2);
            }

            @Override
            public Spliterator.OfInt spliterator() {
                return new InternalNodeSpliterator.OfInt(this);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Node.OfLong {
            OfLong(Node.OfLong ofLong, Node.OfLong ofLong2) {
                super(ofLong, ofLong2);
            }

            @Override
            public Spliterator.OfLong spliterator() {
                return new InternalNodeSpliterator.OfLong(this);
            }
        }

        private static abstract class OfPrimitive<E, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<E, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends AbstractConcNode<E, T_NODE>
        implements Node.OfPrimitive<E, T_CONS, T_ARR, T_SPLITR, T_NODE> {
            OfPrimitive(T_NODE T_NODE, T_NODE T_NODE2) {
                super(T_NODE, T_NODE2);
            }

            @Override
            public void forEach(T_CONS T_CONS) {
                ((Node.OfPrimitive)this.left).forEach(T_CONS);
                ((Node.OfPrimitive)this.right).forEach(T_CONS);
            }

            @Override
            public void copyInto(T_ARR T_ARR, int n) {
                ((Node.OfPrimitive)this.left).copyInto(T_ARR, n);
                ((Node.OfPrimitive)this.right).copyInto(T_ARR, n + (int)((Node.OfPrimitive)this.left).count());
            }

            @Override
            public T_ARR asPrimitiveArray() {
                long l = this.count();
                if (l >= 0x7FFFFFF7L) {
                    throw new IllegalArgumentException(Nodes.BAD_SIZE);
                }
                Object T_ARR = this.newArray((int)l);
                this.copyInto(T_ARR, 0);
                return T_ARR;
            }

            public String toString() {
                if (this.count() < 32L) {
                    return String.format("%s[%s.%s]", this.getClass().getName(), this.left, this.right);
                }
                return String.format("%s[size=%d]", this.getClass().getName(), this.count());
            }
        }
    }

    private static class DoubleArrayNode
    implements Node.OfDouble {
        final double[] array;
        int curSize;

        DoubleArrayNode(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new double[(int)l];
            this.curSize = 0;
        }

        DoubleArrayNode(double[] dArray) {
            this.array = dArray;
            this.curSize = dArray.length;
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public double[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(double[] dArray, int n) {
            System.arraycopy(this.array, 0, dArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            for (int i = 0; i < this.curSize; ++i) {
                doubleConsumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("DoubleArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class DoubleFixedNodeBuilder
    extends DoubleArrayNode
    implements Node.Builder.OfDouble {
        DoubleFixedNodeBuilder(long l) {
            super(l);
            assert (l < 0x7FFFFFF7L);
        }

        @Override
        public Node.OfDouble build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long l) {
            if (l != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", l, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(double d) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = d;
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public String toString() {
            return String.format("DoubleFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class DoubleSpinedNodeBuilder
    extends SpinedBuffer.OfDouble
    implements Node.OfDouble,
    Node.Builder.OfDouble {
        private boolean building = false;

        DoubleSpinedNodeBuilder() {
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            assert (!this.building) : "during building";
            return super.spliterator();
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            assert (!this.building) : "during building";
            super.forEach(doubleConsumer);
        }

        @Override
        public void begin(long l) {
            assert (!this.building) : "was already building";
            this.building = true;
            this.clear();
            this.ensureCapacity(l);
        }

        @Override
        public void accept(double d) {
            assert (this.building) : "not building";
            super.accept(d);
        }

        @Override
        public void end() {
            assert (this.building) : "was not building";
            this.building = false;
        }

        @Override
        public void copyInto(double[] dArray, int n) {
            assert (!this.building) : "during building";
            super.copyInto(dArray, n);
        }

        @Override
        public double[] asPrimitiveArray() {
            assert (!this.building) : "during building";
            return (double[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfDouble build() {
            assert (!this.building) : "during building";
            return this;
        }
    }

    private static abstract class EmptyNode<T, T_ARR, T_CONS>
    implements Node<T> {
        EmptyNode() {
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            return intFunction.apply(0);
        }

        public void copyInto(T_ARR T_ARR, int n) {
        }

        @Override
        public long count() {
            return 0L;
        }

        public void forEach(T_CONS T_CONS) {
        }

        private static final class OfDouble
        extends EmptyNode<Double, double[], DoubleConsumer>
        implements Node.OfDouble {
            OfDouble() {
            }

            @Override
            public Spliterator.OfDouble spliterator() {
                return Spliterators.emptyDoubleSpliterator();
            }

            @Override
            public double[] asPrimitiveArray() {
                return EMPTY_DOUBLE_ARRAY;
            }
        }

        private static final class OfInt
        extends EmptyNode<Integer, int[], IntConsumer>
        implements Node.OfInt {
            OfInt() {
            }

            @Override
            public Spliterator.OfInt spliterator() {
                return Spliterators.emptyIntSpliterator();
            }

            @Override
            public int[] asPrimitiveArray() {
                return EMPTY_INT_ARRAY;
            }
        }

        private static final class OfLong
        extends EmptyNode<Long, long[], LongConsumer>
        implements Node.OfLong {
            OfLong() {
            }

            @Override
            public Spliterator.OfLong spliterator() {
                return Spliterators.emptyLongSpliterator();
            }

            @Override
            public long[] asPrimitiveArray() {
                return EMPTY_LONG_ARRAY;
            }
        }

        private static class OfRef<T>
        extends EmptyNode<T, T[], Consumer<? super T>> {
            private OfRef() {
            }

            @Override
            public Spliterator<T> spliterator() {
                return Spliterators.emptySpliterator();
            }
        }
    }

    private static final class FixedNodeBuilder<T>
    extends ArrayNode<T>
    implements Node.Builder<T> {
        FixedNodeBuilder(long l, IntFunction<T[]> intFunction) {
            super(l, intFunction);
            assert (l < 0x7FFFFFF7L);
        }

        @Override
        public Node<T> build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long l) {
            if (l != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", l, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(T t) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = t;
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public String toString() {
            return String.format("FixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static class IntArrayNode
    implements Node.OfInt {
        final int[] array;
        int curSize;

        IntArrayNode(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new int[(int)l];
            this.curSize = 0;
        }

        IntArrayNode(int[] nArray) {
            this.array = nArray;
            this.curSize = nArray.length;
        }

        @Override
        public Spliterator.OfInt spliterator() {
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public int[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(int[] nArray, int n) {
            System.arraycopy(this.array, 0, nArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            for (int i = 0; i < this.curSize; ++i) {
                intConsumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("IntArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class IntFixedNodeBuilder
    extends IntArrayNode
    implements Node.Builder.OfInt {
        IntFixedNodeBuilder(long l) {
            super(l);
            assert (l < 0x7FFFFFF7L);
        }

        @Override
        public Node.OfInt build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long l) {
            if (l != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", l, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(int n) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = n;
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public String toString() {
            return String.format("IntFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class IntSpinedNodeBuilder
    extends SpinedBuffer.OfInt
    implements Node.OfInt,
    Node.Builder.OfInt {
        private boolean building = false;

        IntSpinedNodeBuilder() {
        }

        @Override
        public Spliterator.OfInt spliterator() {
            assert (!this.building) : "during building";
            return super.spliterator();
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            assert (!this.building) : "during building";
            super.forEach(intConsumer);
        }

        @Override
        public void begin(long l) {
            assert (!this.building) : "was already building";
            this.building = true;
            this.clear();
            this.ensureCapacity(l);
        }

        @Override
        public void accept(int n) {
            assert (this.building) : "not building";
            super.accept(n);
        }

        @Override
        public void end() {
            assert (this.building) : "was not building";
            this.building = false;
        }

        @Override
        public void copyInto(int[] nArray, int n) throws IndexOutOfBoundsException {
            assert (!this.building) : "during building";
            super.copyInto(nArray, n);
        }

        @Override
        public int[] asPrimitiveArray() {
            assert (!this.building) : "during building";
            return (int[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfInt build() {
            assert (!this.building) : "during building";
            return this;
        }
    }

    private static abstract class InternalNodeSpliterator<T, S extends Spliterator<T>, N extends Node<T>>
    implements Spliterator<T> {
        N curNode;
        int curChildIndex;
        S lastNodeSpliterator;
        S tryAdvanceSpliterator;
        Deque<N> tryAdvanceStack;

        InternalNodeSpliterator(N n) {
            this.curNode = n;
        }

        protected final Deque<N> initStack() {
            ArrayDeque arrayDeque = new ArrayDeque(8);
            for (int i = this.curNode.getChildCount() - 1; i >= this.curChildIndex; --i) {
                arrayDeque.addFirst(this.curNode.getChild(i));
            }
            return arrayDeque;
        }

        protected final N findNextLeafNode(Deque<N> deque) {
            Node node = null;
            while ((node = (Node)deque.pollFirst()) != null) {
                if (node.getChildCount() == 0) {
                    if (node.count() <= 0L) continue;
                    return (N)node;
                }
                for (int i = node.getChildCount() - 1; i >= 0; --i) {
                    deque.addFirst(node.getChild(i));
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected final boolean initTryAdvance() {
            if (this.curNode == null) {
                return false;
            }
            if (this.tryAdvanceSpliterator != null) return true;
            if (this.lastNodeSpliterator != null) {
                this.tryAdvanceSpliterator = this.lastNodeSpliterator;
                return true;
            }
            this.tryAdvanceStack = this.initStack();
            N n = this.findNextLeafNode(this.tryAdvanceStack);
            if (n != null) {
                this.tryAdvanceSpliterator = n.spliterator();
                return true;
            }
            this.curNode = null;
            return false;
        }

        public final S trySplit() {
            if (this.curNode == null || this.tryAdvanceSpliterator != null) {
                return null;
            }
            if (this.lastNodeSpliterator != null) {
                return (S)this.lastNodeSpliterator.trySplit();
            }
            if (this.curChildIndex < this.curNode.getChildCount() - 1) {
                return (S)this.curNode.getChild(this.curChildIndex++).spliterator();
            }
            this.curNode = this.curNode.getChild(this.curChildIndex);
            if (this.curNode.getChildCount() == 0) {
                this.lastNodeSpliterator = this.curNode.spliterator();
                return (S)this.lastNodeSpliterator.trySplit();
            }
            this.curChildIndex = 0;
            return (S)this.curNode.getChild(this.curChildIndex++).spliterator();
        }

        @Override
        public final long estimateSize() {
            if (this.curNode == null) {
                return 0L;
            }
            if (this.lastNodeSpliterator != null) {
                return this.lastNodeSpliterator.estimateSize();
            }
            long l = 0L;
            for (int i = this.curChildIndex; i < this.curNode.getChildCount(); ++i) {
                l += this.curNode.getChild(i).count();
            }
            return l;
        }

        @Override
        public final int characteristics() {
            return 64;
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Node.OfDouble ofDouble) {
                super(ofDouble);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt>
        implements Spliterator.OfInt {
            OfInt(Node.OfInt ofInt) {
                super(ofInt);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong>
        implements Spliterator.OfLong {
            OfLong(Node.OfLong ofLong) {
                super(ofLong);
            }
        }

        private static abstract class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, N extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, N>>
        extends InternalNodeSpliterator<T, T_SPLITR, N>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(N n) {
                super(n);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                if (!this.initTryAdvance()) {
                    return false;
                }
                boolean bl = ((Spliterator.OfPrimitive)this.tryAdvanceSpliterator).tryAdvance(T_CONS);
                if (!bl) {
                    Node.OfPrimitive ofPrimitive;
                    if (this.lastNodeSpliterator == null && (ofPrimitive = (Node.OfPrimitive)this.findNextLeafNode(this.tryAdvanceStack)) != null) {
                        this.tryAdvanceSpliterator = ofPrimitive.spliterator();
                        return ((Spliterator.OfPrimitive)this.tryAdvanceSpliterator).tryAdvance(T_CONS);
                    }
                    this.curNode = null;
                }
                return bl;
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                if (this.curNode == null) {
                    return;
                }
                if (this.tryAdvanceSpliterator == null) {
                    if (this.lastNodeSpliterator == null) {
                        Node.OfPrimitive ofPrimitive;
                        Deque deque = this.initStack();
                        while ((ofPrimitive = (Node.OfPrimitive)this.findNextLeafNode(deque)) != null) {
                            ofPrimitive.forEach(T_CONS);
                        }
                        this.curNode = null;
                    } else {
                        ((Spliterator.OfPrimitive)this.lastNodeSpliterator).forEachRemaining(T_CONS);
                    }
                } else {
                    while (this.tryAdvance(T_CONS)) {
                    }
                }
            }
        }

        private static final class OfRef<T>
        extends InternalNodeSpliterator<T, Spliterator<T>, Node<T>> {
            OfRef(Node<T> node) {
                super(node);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (!this.initTryAdvance()) {
                    return false;
                }
                boolean bl = this.tryAdvanceSpliterator.tryAdvance(consumer);
                if (!bl) {
                    Object n;
                    if (this.lastNodeSpliterator == null && (n = this.findNextLeafNode(this.tryAdvanceStack)) != null) {
                        this.tryAdvanceSpliterator = n.spliterator();
                        return this.tryAdvanceSpliterator.tryAdvance(consumer);
                    }
                    this.curNode = null;
                }
                return bl;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                if (this.curNode == null) {
                    return;
                }
                if (this.tryAdvanceSpliterator == null) {
                    if (this.lastNodeSpliterator == null) {
                        Object n;
                        Deque deque = this.initStack();
                        while ((n = this.findNextLeafNode(deque)) != null) {
                            n.forEach(consumer);
                        }
                        this.curNode = null;
                    } else {
                        this.lastNodeSpliterator.forEachRemaining(consumer);
                    }
                } else {
                    while (this.tryAdvance(consumer)) {
                    }
                }
            }
        }
    }

    private static class LongArrayNode
    implements Node.OfLong {
        final long[] array;
        int curSize;

        LongArrayNode(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException(Nodes.BAD_SIZE);
            }
            this.array = new long[(int)l];
            this.curSize = 0;
        }

        LongArrayNode(long[] lArray) {
            this.array = lArray;
            this.curSize = lArray.length;
        }

        @Override
        public Spliterator.OfLong spliterator() {
            return Arrays.spliterator(this.array, 0, this.curSize);
        }

        @Override
        public long[] asPrimitiveArray() {
            if (this.array.length == this.curSize) {
                return this.array;
            }
            return Arrays.copyOf(this.array, this.curSize);
        }

        @Override
        public void copyInto(long[] lArray, int n) {
            System.arraycopy(this.array, 0, lArray, n, this.curSize);
        }

        @Override
        public long count() {
            return this.curSize;
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            for (int i = 0; i < this.curSize; ++i) {
                longConsumer.accept(this.array[i]);
            }
        }

        public String toString() {
            return String.format("LongArrayNode[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class LongFixedNodeBuilder
    extends LongArrayNode
    implements Node.Builder.OfLong {
        LongFixedNodeBuilder(long l) {
            super(l);
            assert (l < 0x7FFFFFF7L);
        }

        @Override
        public Node.OfLong build() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("Current size %d is less than fixed size %d", this.curSize, this.array.length));
            }
            return this;
        }

        @Override
        public void begin(long l) {
            if (l != (long)this.array.length) {
                throw new IllegalStateException(String.format("Begin size %d is not equal to fixed size %d", l, this.array.length));
            }
            this.curSize = 0;
        }

        @Override
        public void accept(long l) {
            if (this.curSize >= this.array.length) {
                throw new IllegalStateException(String.format("Accept exceeded fixed size of %d", this.array.length));
            }
            this.array[this.curSize++] = l;
        }

        @Override
        public void end() {
            if (this.curSize < this.array.length) {
                throw new IllegalStateException(String.format("End size %d is less than fixed size %d", this.curSize, this.array.length));
            }
        }

        @Override
        public String toString() {
            return String.format("LongFixedNodeBuilder[%d][%s]", this.array.length - this.curSize, Arrays.toString(this.array));
        }
    }

    private static final class LongSpinedNodeBuilder
    extends SpinedBuffer.OfLong
    implements Node.OfLong,
    Node.Builder.OfLong {
        private boolean building = false;

        LongSpinedNodeBuilder() {
        }

        @Override
        public Spliterator.OfLong spliterator() {
            assert (!this.building) : "during building";
            return super.spliterator();
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            assert (!this.building) : "during building";
            super.forEach(longConsumer);
        }

        @Override
        public void begin(long l) {
            assert (!this.building) : "was already building";
            this.building = true;
            this.clear();
            this.ensureCapacity(l);
        }

        @Override
        public void accept(long l) {
            assert (this.building) : "not building";
            super.accept(l);
        }

        @Override
        public void end() {
            assert (this.building) : "was not building";
            this.building = false;
        }

        @Override
        public void copyInto(long[] lArray, int n) {
            assert (!this.building) : "during building";
            super.copyInto(lArray, n);
        }

        @Override
        public long[] asPrimitiveArray() {
            assert (!this.building) : "during building";
            return (long[])super.asPrimitiveArray();
        }

        @Override
        public Node.OfLong build() {
            assert (!this.building) : "during building";
            return this;
        }
    }

    private static abstract class SizedCollectorTask<P_IN, P_OUT, T_SINK extends Sink<P_OUT>, K extends SizedCollectorTask<P_IN, P_OUT, T_SINK, K>>
    extends CountedCompleter<Void>
    implements Sink<P_OUT> {
        protected final Spliterator<P_IN> spliterator;
        protected final PipelineHelper<P_OUT> helper;
        protected final long targetSize;
        protected long offset;
        protected long length;
        protected int index;
        protected int fence;

        SizedCollectorTask(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> pipelineHelper, int n) {
            assert (spliterator.hasCharacteristics(16384));
            this.spliterator = spliterator;
            this.helper = pipelineHelper;
            this.targetSize = AbstractTask.suggestTargetSize(spliterator.estimateSize());
            this.offset = 0L;
            this.length = n;
        }

        SizedCollectorTask(K k, Spliterator<P_IN> spliterator, long l, long l2, int n) {
            super((CountedCompleter<?>)k);
            assert (spliterator.hasCharacteristics(16384));
            this.spliterator = spliterator;
            this.helper = ((SizedCollectorTask)k).helper;
            this.targetSize = ((SizedCollectorTask)k).targetSize;
            this.offset = l;
            this.length = l2;
            if (l < 0L || l2 < 0L || l + l2 - 1L >= (long)n) {
                throw new IllegalArgumentException(String.format("offset and length interval [%d, %d + %d) is not within array size interval [0, %d)", l, l, l2, n));
            }
        }

        @Override
        public void compute() {
            Spliterator<P_IN> spliterator;
            SizedCollectorTask<P_IN, P_OUT, T_SINK, K> sizedCollectorTask = this;
            Spliterator<P_IN> spliterator2 = this.spliterator;
            while (spliterator2.estimateSize() > sizedCollectorTask.targetSize && (spliterator = spliterator2.trySplit()) != null) {
                sizedCollectorTask.setPendingCount(1);
                long l = spliterator.estimateSize();
                ((ForkJoinTask)sizedCollectorTask.makeChild(spliterator, sizedCollectorTask.offset, l)).fork();
                sizedCollectorTask = sizedCollectorTask.makeChild(spliterator2, sizedCollectorTask.offset + l, sizedCollectorTask.length - l);
            }
            assert (sizedCollectorTask.offset + sizedCollectorTask.length < 0x7FFFFFF7L);
            SizedCollectorTask sizedCollectorTask2 = sizedCollectorTask;
            sizedCollectorTask.helper.wrapAndCopyInto(sizedCollectorTask2, spliterator2);
            sizedCollectorTask.propagateCompletion();
        }

        abstract K makeChild(Spliterator<P_IN> var1, long var2, long var4);

        @Override
        public void begin(long l) {
            if (l > this.length) {
                throw new IllegalStateException("size passed to Sink.begin exceeds array length");
            }
            this.index = (int)this.offset;
            this.fence = this.index + (int)this.length;
        }

        static final class OfDouble<P_IN>
        extends SizedCollectorTask<P_IN, Double, Sink.OfDouble, OfDouble<P_IN>>
        implements Sink.OfDouble {
            private final double[] array;

            OfDouble(Spliterator<P_IN> spliterator, PipelineHelper<Double> pipelineHelper, double[] dArray) {
                super(spliterator, pipelineHelper, dArray.length);
                this.array = dArray;
            }

            OfDouble(OfDouble<P_IN> ofDouble, Spliterator<P_IN> spliterator, long l, long l2) {
                super(ofDouble, spliterator, l, l2, ofDouble.array.length);
                this.array = ofDouble.array;
            }

            @Override
            OfDouble<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                return new OfDouble<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(double d) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = d;
            }
        }

        static final class OfInt<P_IN>
        extends SizedCollectorTask<P_IN, Integer, Sink.OfInt, OfInt<P_IN>>
        implements Sink.OfInt {
            private final int[] array;

            OfInt(Spliterator<P_IN> spliterator, PipelineHelper<Integer> pipelineHelper, int[] nArray) {
                super(spliterator, pipelineHelper, nArray.length);
                this.array = nArray;
            }

            OfInt(OfInt<P_IN> ofInt, Spliterator<P_IN> spliterator, long l, long l2) {
                super(ofInt, spliterator, l, l2, ofInt.array.length);
                this.array = ofInt.array;
            }

            @Override
            OfInt<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                return new OfInt<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(int n) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = n;
            }
        }

        static final class OfLong<P_IN>
        extends SizedCollectorTask<P_IN, Long, Sink.OfLong, OfLong<P_IN>>
        implements Sink.OfLong {
            private final long[] array;

            OfLong(Spliterator<P_IN> spliterator, PipelineHelper<Long> pipelineHelper, long[] lArray) {
                super(spliterator, pipelineHelper, lArray.length);
                this.array = lArray;
            }

            OfLong(OfLong<P_IN> ofLong, Spliterator<P_IN> spliterator, long l, long l2) {
                super(ofLong, spliterator, l, l2, ofLong.array.length);
                this.array = ofLong.array;
            }

            @Override
            OfLong<P_IN> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                return new OfLong<P_IN>(this, spliterator, l, l2);
            }

            @Override
            public void accept(long l) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = l;
            }
        }

        static final class OfRef<P_IN, P_OUT>
        extends SizedCollectorTask<P_IN, P_OUT, Sink<P_OUT>, OfRef<P_IN, P_OUT>>
        implements Sink<P_OUT> {
            private final P_OUT[] array;

            OfRef(Spliterator<P_IN> spliterator, PipelineHelper<P_OUT> pipelineHelper, P_OUT[] P_OUTArray) {
                super(spliterator, pipelineHelper, P_OUTArray.length);
                this.array = P_OUTArray;
            }

            OfRef(OfRef<P_IN, P_OUT> ofRef, Spliterator<P_IN> spliterator, long l, long l2) {
                super(ofRef, spliterator, l, l2, ofRef.array.length);
                this.array = ofRef.array;
            }

            @Override
            OfRef<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator, long l, long l2) {
                return new OfRef<P_IN, P_OUT>(this, spliterator, l, l2);
            }

            @Override
            public void accept(P_OUT P_OUT) {
                if (this.index >= this.fence) {
                    throw new IndexOutOfBoundsException(Integer.toString(this.index));
                }
                this.array[this.index++] = P_OUT;
            }
        }
    }

    private static final class SpinedNodeBuilder<T>
    extends SpinedBuffer<T>
    implements Node<T>,
    Node.Builder<T> {
        private boolean building = false;

        SpinedNodeBuilder() {
        }

        @Override
        public Spliterator<T> spliterator() {
            assert (!this.building) : "during building";
            return super.spliterator();
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            assert (!this.building) : "during building";
            super.forEach(consumer);
        }

        @Override
        public void begin(long l) {
            assert (!this.building) : "was already building";
            this.building = true;
            this.clear();
            this.ensureCapacity(l);
        }

        @Override
        public void accept(T t) {
            assert (this.building) : "not building";
            super.accept(t);
        }

        @Override
        public void end() {
            assert (this.building) : "was not building";
            this.building = false;
        }

        @Override
        public void copyInto(T[] TArray, int n) {
            assert (!this.building) : "during building";
            super.copyInto(TArray, n);
        }

        @Override
        public T[] asArray(IntFunction<T[]> intFunction) {
            assert (!this.building) : "during building";
            return super.asArray(intFunction);
        }

        @Override
        public Node<T> build() {
            assert (!this.building) : "during building";
            return this;
        }
    }

    private static abstract class ToArrayTask<T, T_NODE extends Node<T>, K extends ToArrayTask<T, T_NODE, K>>
    extends CountedCompleter<Void> {
        protected final T_NODE node;
        protected final int offset;

        ToArrayTask(T_NODE T_NODE, int n) {
            this.node = T_NODE;
            this.offset = n;
        }

        ToArrayTask(K k, T_NODE T_NODE, int n) {
            super((CountedCompleter<?>)k);
            this.node = T_NODE;
            this.offset = n;
        }

        abstract void copyNodeToArray();

        abstract K makeChild(int var1, int var2);

        @Override
        public void compute() {
            ToArrayTask<T, T_NODE, K> toArrayTask = this;
            while (true) {
                int n;
                if (toArrayTask.node.getChildCount() == 0) {
                    toArrayTask.copyNodeToArray();
                    toArrayTask.propagateCompletion();
                    return;
                }
                toArrayTask.setPendingCount(toArrayTask.node.getChildCount() - 1);
                int n2 = 0;
                for (n = 0; n < toArrayTask.node.getChildCount() - 1; ++n) {
                    K k = toArrayTask.makeChild(n, toArrayTask.offset + n2);
                    n2 = (int)((long)n2 + ((ToArrayTask)k).node.count());
                    ((ForkJoinTask)k).fork();
                }
                toArrayTask = toArrayTask.makeChild(n, toArrayTask.offset + n2);
            }
        }

        private static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, Node.OfDouble> {
            private OfDouble(Node.OfDouble ofDouble, double[] dArray, int n) {
                super(ofDouble, dArray, n, null);
            }
        }

        private static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, Node.OfInt> {
            private OfInt(Node.OfInt ofInt, int[] nArray, int n) {
                super(ofInt, nArray, n, null);
            }
        }

        private static final class OfLong
        extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, Node.OfLong> {
            private OfLong(Node.OfLong ofLong, long[] lArray, int n) {
                super(ofLong, lArray, n, null);
            }
        }

        private static class OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_NODE extends Node.OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>>
        extends ToArrayTask<T, T_NODE, OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>> {
            private final T_ARR array;

            private OfPrimitive(T_NODE T_NODE, T_ARR T_ARR, int n) {
                super(T_NODE, n);
                this.array = T_ARR;
            }

            private OfPrimitive(OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> ofPrimitive, T_NODE T_NODE, int n) {
                super(ofPrimitive, T_NODE, n);
                this.array = ofPrimitive.array;
            }

            @Override
            OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE> makeChild(int n, int n2) {
                return new OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, Node>(this, ((Node.OfPrimitive)this.node).getChild(n), n2);
            }

            @Override
            void copyNodeToArray() {
                ((Node.OfPrimitive)this.node).copyInto(this.array, this.offset);
            }

            /* synthetic */ OfPrimitive(Node.OfPrimitive ofPrimitive, Object object, int n, 1 var4_4) {
                this(ofPrimitive, object, n);
            }
        }

        private static final class OfRef<T>
        extends ToArrayTask<T, Node<T>, OfRef<T>> {
            private final T[] array;

            private OfRef(Node<T> node, T[] TArray, int n) {
                super(node, n);
                this.array = TArray;
            }

            private OfRef(OfRef<T> ofRef, Node<T> node, int n) {
                super(ofRef, node, n);
                this.array = ofRef.array;
            }

            @Override
            OfRef<T> makeChild(int n, int n2) {
                return new OfRef(this, this.node.getChild(n), n2);
            }

            @Override
            void copyNodeToArray() {
                this.node.copyInto(this.array, this.offset);
            }
        }
    }
}

