/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import java.util.LinkedList;
import mastersystem.OutputListener;

public abstract class CPU {
    private LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    protected int[] memory;
    protected int regPC;
    protected int regSP;
    private int cyclesToExecute;
    protected int[] cycles;
    protected int cycleCount;

    public CPU(int[] nArray) {
        this.memory = nArray;
    }

    protected final void PUSH(int n) {
        if (this.regSP == 0) {
            this.regSP = this.memory.length;
        }
        this.WRITE_BYTE(--this.regSP, n >> 8);
        this.WRITE_BYTE(--this.regSP, n & 0xFF);
    }

    protected final int POP() {
        return this.READ_BYTE(this.regSP++) | this.READ_BYTE(this.regSP++) << 8;
    }

    protected final int READ_BYTE() {
        return this.READ_BYTE(this.regPC++);
    }

    protected final int READ_BYTE(int n) {
        return this.memory[n];
    }

    protected final int READ_WORD() {
        return this.READ_BYTE() | this.READ_BYTE() << 8;
    }

    protected final int READ_WORD(int n) {
        return this.READ_BYTE(n) | this.READ_BYTE((n + 1) % this.memory.length) << 8;
    }

    protected final void WRITE_WORD(int n, int n2) {
        this.WRITE_BYTE(n, n2 & 0xFF);
        this.WRITE_BYTE(n + 1, n2 >> 8);
    }

    protected final void WRITE_BYTE(int n, int n2) {
        this.writeByte(n, n2);
    }

    protected void writeByte(int n, int n2) {
        this.memory[n] = n2;
    }

    protected final void setCycles(int[] nArray) {
        this.cycles = nArray;
    }

    public final boolean execute(int n) {
        boolean bl = n >= 49152;
        this.regSP = 57328;
        this.regPC = n;
        this.setInterruptLine(2, true);
        int n2 = 0;
        while (this.regPC > 0 && this.regPC < 65536 && (bl || this.regPC < 49152)) {
            this.executeInstruction(this.READ_BYTE());
            if (++n2 != 10000000) continue;
            throw new IllegalArgumentException("Code executed from " + Integer.toHexString(n) + " took too long to finish.");
        }
        return this.regSP > 57328 && this.regSP < 65535;
    }

    public abstract void reset();

    public abstract void setInterruptLine(int var1, boolean var2);

    protected abstract void executeInstruction(int var1);

    protected abstract void handleInterrupts();

    protected final void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, this.cyclesToExecute - this.cycleCount);
            ++n4;
        }
    }

    public final void addOutputListener(OutputListener outputListener) {
        this.listenerList.addFirst(outputListener);
        this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
    }

    public final void removeOutputListener(OutputListener outputListener) {
        this.listenerList.remove(outputListener);
        this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
    }
}

