/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import changes.UndoRedoManager;
import common.ComponentWrapper;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.Palette;
import data.SpriteTileset;
import data.Tiles;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import panels.TilesPanel;
import panels.TilesetPanel;
import transactions.TransactionManager;
import widgets.IntegerTextField;
import widgets.TilesetComboBox;

public class SpriteTilesetEditor
extends JDialog {
    private static SpriteTilesetEditor editor;
    private Palette palette;
    private Tiles spriteTiles;
    private Tiles itemTiles;
    private final TilesetPanel spriteTileset;
    private final TilesetComboBox spriteTilesetsComboBox;
    private final JPanel[] dataSourcePanels = new JPanel[]{new JPanel(new BorderLayout()), new JPanel(new BorderLayout()), new JPanel(new BorderLayout())};
    private final JRadioButton[] dataSourceTiles = new JRadioButton[]{new JRadioButton(TextProvider.get("Tiles")), new JRadioButton(TextProvider.get("Tiles")), new JRadioButton(TextProvider.get("Tiles"))};
    private final JRadioButton[] dataSourceMirroredTiles = new JRadioButton[]{new JRadioButton(TextProvider.get("MirroredTiles")), new JRadioButton(TextProvider.get("MirroredTiles")), new JRadioButton(TextProvider.get("MirroredTiles"))};
    private final JRadioButton[] dataSourceInvisible = new JRadioButton[]{new JRadioButton(TextProvider.get("InvisibleTiles")), new JRadioButton(TextProvider.get("InvisibleTiles")), new JRadioButton(TextProvider.get("InvisibleTiles"))};
    private final IntegerTextField[] invisibleTiles = new IntegerTextField[3];
    private final JPanel[] dataSourcePanelContent = new JPanel[]{new JPanel(), new JPanel(), new JPanel()};
    private final TilesPanel[] tiles = new TilesPanel[3];
    private final JPanel[] invisibleTilesPanels = new JPanel[]{new JPanel(), new JPanel(), new JPanel()};
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteTilesetEditor.this.updateSelections();
        }
    };
    private SpriteTileset selectedSpriteTileset;

    private SpriteTilesetEditor(SpriteTileset[] spriteTilesetArray, Tiles tiles, Tiles tiles2, Palette palette) {
        this.setTitle(TextProvider.get("TitleSpriteTileset"));
        this.palette = palette;
        this.spriteTiles = tiles;
        this.itemTiles = tiles2;
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.spriteTileset = new TilesetPanel(spriteTilesetArray[0], palette);
        this.spriteTileset.setEditable(true);
        this.add((Component)this.spriteTileset, "Center");
        this.spriteTilesetsComboBox = new TilesetComboBox(spriteTilesetArray, palette);
        this.spriteTilesetsComboBox.setScaleParent(this.spriteTileset);
        this.spriteTilesetsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteTileset spriteTileset = (SpriteTileset)SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset();
                SpriteTilesetEditor.this.spriteTileset.setTileset(spriteTileset, SpriteTilesetEditor.this.palette);
                if (SpriteTilesetEditor.this.selectedSpriteTileset != spriteTileset) {
                    SpriteTilesetEditor.this.selectedSpriteTileset.removeChangeListener(SpriteTilesetEditor.this.tilesetChangeListener);
                }
                SpriteTilesetEditor.this.selectedSpriteTileset = spriteTileset;
                SpriteTilesetEditor.this.selectedSpriteTileset.addChangeListener(SpriteTilesetEditor.this.tilesetChangeListener);
                SpriteTilesetEditor.this.updateSelections();
            }
        });
        this.add((Component)this.spriteTilesetsComboBox, "North");
        this.selectedSpriteTileset = spriteTilesetArray[0];
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final SpriteTileset spriteTileset = (SpriteTileset)SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset();
                int n = 0;
                while (n < SpriteTilesetEditor.this.dataSourcePanels.length) {
                    final int n2 = n;
                    if (SpriteTilesetEditor.this.dataSourceTiles[n].isSelected() && !spriteTileset.isTiles(n)) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                spriteTileset.setFunction(n2, 325);
                            }
                        });
                    } else if (SpriteTilesetEditor.this.dataSourceMirroredTiles[n].isSelected() && !spriteTileset.isMirroredTiles(n)) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                spriteTileset.setFunction(n2, 709);
                            }
                        });
                    } else if (SpriteTilesetEditor.this.dataSourceInvisible[n].isSelected() && !spriteTileset.isInvisible(n)) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                spriteTileset.setFunction(n2, 388);
                            }
                        });
                    }
                    ++n;
                }
                SpriteTilesetEditor.this.updateSouthPanel();
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)this.dataSourcePanels[0], "North");
        jPanel2.add((Component)this.dataSourcePanels[1], "North");
        jPanel2.add((Component)this.dataSourcePanels[2], "South");
        int n = 0;
        while (n < this.dataSourcePanels.length) {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.dataSourceTiles[n].addActionListener(actionListener);
            this.dataSourceMirroredTiles[n].addActionListener(actionListener);
            this.dataSourceInvisible[n].addActionListener(actionListener);
            JPanel jPanel3 = new JPanel(new GridLayout(1, n == 0 ? 2 : 3));
            jPanel3.add(this.dataSourceTiles[n]);
            buttonGroup.add(this.dataSourceTiles[n]);
            if (n > 0) {
                jPanel3.add(this.dataSourceMirroredTiles[n]);
                buttonGroup.add(this.dataSourceMirroredTiles[n]);
            }
            jPanel3.add(this.dataSourceInvisible[n]);
            buttonGroup.add(this.dataSourceInvisible[n]);
            this.dataSourcePanels[n].add((Component)ComponentWrapper.wrapComponent(jPanel3), "North");
            this.dataSourcePanels[n].add((Component)this.dataSourcePanelContent[n], "Center");
            this.tiles[n] = new TilesPanel(tiles, palette);
            this.tiles[n].setScaleParent(this.spriteTileset);
            this.tiles[n].setPal(1);
            this.tiles[n].setAllowDiscontinuousSelection(false);
            this.tiles[n].setSelectOnChange(false);
            final int n2 = n;
            this.tiles[n].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final SpriteTileset spriteTileset = (SpriteTileset)SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset();
                    final int[][] nArray = SpriteTilesetEditor.this.tiles[n2].getSelectedTileIndices();
                    if (nArray != null) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                boolean bl = spriteTileset.isItemTiles(n2);
                                boolean bl2 = spriteTileset.isSpriteTiles(n2);
                                if (!bl && !bl2) {
                                    return;
                                }
                                int n = spriteTileset.isItemTiles(n2) ? SpriteTilesetEditor.this.itemTiles.getSource() : SpriteTilesetEditor.this.spriteTiles.getSource();
                                spriteTileset.setTilesSource(n2, 0x8000 | n + nArray[0][0] * 32 & 0x3FFF);
                                spriteTileset.setTilesLength(n2, nArray[0].length);
                            }
                        });
                    }
                }
            });
            this.dataSourcePanelContent[n].add(this.tiles[n]);
            this.invisibleTilesPanels[n].add(new JLabel(String.valueOf(TextProvider.get("NumberOfInvisibleTiles")) + ": "));
            this.invisibleTiles[n] = new IntegerTextField(1, 1, false, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final SpriteTileset spriteTileset = (SpriteTileset)SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset();
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            spriteTileset.setTilesLength(n2, SpriteTilesetEditor.this.invisibleTiles[n2].getValue());
                        }
                    });
                }
            });
            this.invisibleTilesPanels[n].add(this.invisibleTiles[n]);
            this.dataSourcePanelContent[n].add(this.invisibleTilesPanels[n]);
            ++n;
        }
        this.add((Component)jPanel, "South");
        this.spriteTilesetsComboBox.setSelectedIndex(0);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(SpriteTilesetEditor.this.spriteTileset.getScale() + 1.5f));
                        SpriteTilesetEditor.this.spriteTileset.setPreferredScale(f);
                        SpriteTilesetEditor.this.pack();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(SpriteTilesetEditor.this.spriteTileset.getScale() - 0.5f));
                    SpriteTilesetEditor.this.spriteTileset.setPreferredScale(f);
                    SpriteTilesetEditor.this.pack();
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private void updateSelections() {
        SpriteTileset spriteTileset = (SpriteTileset)this.spriteTilesetsComboBox.getSelectedTileset();
        int n = 0;
        while (n < this.dataSourcePanels.length) {
            boolean bl = spriteTileset.isItemTiles(n) || spriteTileset.isSpriteTiles(n);
            this.dataSourceTiles[n].setSelected(bl && spriteTileset.isTiles(n));
            this.dataSourceMirroredTiles[n].setSelected(bl && spriteTileset.isMirroredTiles(n));
            this.dataSourceInvisible[n].setSelected(bl && spriteTileset.isInvisible(n));
            if (this.dataSourceInvisible[n].isSelected()) {
                this.invisibleTiles[n].setValue(spriteTileset.getTilesLength(n));
            }
            ++n;
        }
        this.updateSouthPanel();
    }

    private void updateSouthPanel() {
        SpriteTileset spriteTileset = (SpriteTileset)this.spriteTilesetsComboBox.getSelectedTileset();
        int n = 0;
        while (n < this.dataSourcePanels.length) {
            this.dataSourceTiles[n].setEnabled(this.dataSourceTiles[n].isSelected() || spriteTileset.canSetFunction(n, 325));
            this.dataSourceMirroredTiles[n].setEnabled(this.dataSourceMirroredTiles[n].isSelected() || spriteTileset.canSetFunction(n, 709));
            this.dataSourceInvisible[n].setEnabled(this.dataSourceInvisible[n].isSelected() || spriteTileset.canSetFunction(n, 388));
            this.dataSourcePanels[n].setVisible(n < spriteTileset.countDataSources() && spriteTileset.canEditTiles(n));
            if (this.dataSourcePanels[n].isVisible()) {
                this.tiles[n].setVisible(this.dataSourceTiles[n].isSelected() || this.dataSourceMirroredTiles[n].isSelected());
                this.tiles[n].setMirrored(this.dataSourceMirroredTiles[n].isSelected());
                if (this.tiles[n].isVisible()) {
                    if (spriteTileset.isItemTiles(n)) {
                        this.tiles[n].setTiles(this.itemTiles, this.palette);
                    } else {
                        this.tiles[n].setTiles(this.spriteTiles, this.palette);
                    }
                    int n2 = spriteTileset.getTilesLength(n);
                    if (n2 >= 0) {
                        int n3 = spriteTileset.isItemTiles(n) ? this.itemTiles.getSource() : this.spriteTiles.getSource();
                        int[] nArray = new int[n2];
                        int n4 = spriteTileset.getTilesSource(n) - n3;
                        int n5 = 0;
                        while (n5 < nArray.length) {
                            nArray[n5] = (n4 & 0x3FFF) / 32 + n5;
                            ++n5;
                        }
                        this.tiles[n].setSelectedTiles(new int[][]{nArray});
                    }
                }
                this.invisibleTilesPanels[n].setVisible(!this.tiles[n].isVisible());
            }
            ++n;
        }
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset());
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset());
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset()));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(SpriteTilesetEditor.this.spriteTilesetsComboBox.getSelectedTileset()));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public static void open(JFrame jFrame, SpriteTileset[] spriteTilesetArray, Tiles tiles, Tiles tiles2, Palette palette, Properties properties) {
        if (editor == null) {
            editor = new SpriteTilesetEditor(spriteTilesetArray, tiles, tiles2, palette);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            SpriteTilesetEditor.editor.palette = palette;
            SpriteTilesetEditor.editor.spriteTiles = tiles;
            SpriteTilesetEditor.editor.itemTiles = tiles2;
            SpriteTilesetEditor.editor.spriteTilesetsComboBox.setSelectedIndex(SpriteTilesetEditor.editor.spriteTilesetsComboBox.getSelectedIndex());
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        SpriteTilesetEditor.editor.spriteTileset.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        TilesPanel[] tilesPanelArray = SpriteTilesetEditor.editor.tiles;
        int n = SpriteTilesetEditor.editor.tiles.length;
        int n2 = 0;
        while (n2 < n) {
            TilesPanel tilesPanel = tilesPanelArray[n2];
            tilesPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
            ++n2;
        }
        editor.setVisible(true);
    }

    public static void close() {
        SpriteTilesetEditor.destroy();
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

