/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexTextField
extends JTextField {
    private final int size;

    public HexTextField(int n, int n2) {
        this(n, n2, null);
    }

    public HexTextField(int n, int n2, final ActionListener actionListener) {
        super(n * 2);
        this.size = n;
        this.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (this.getLength() >= HexTextField.this.getMaxLength()) {
                    return;
                }
                super.insertString(n, string.replaceAll("[^" + HexTextField.this.getAllowedCharClass() + "]", "").toUpperCase(), attributeSet);
                if (actionListener != null && this.getLength() > 0) {
                    actionListener.actionPerformed(new ActionEvent(HexTextField.this, 1001, null));
                }
            }

            @Override
            public void remove(int n, int n2) throws BadLocationException {
                super.remove(n, n2);
                if (actionListener != null && this.getLength() > 0) {
                    actionListener.actionPerformed(new ActionEvent(HexTextField.this, 1001, null));
                }
            }
        });
        this.setValue(n2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getComponent();
                jTextField.setText(HexTextField.this.getValueString());
            }
        });
    }

    protected String getAllowedCharClass() {
        return "a-fA-F0-9";
    }

    protected int getMaxLength() {
        return this.size * 2;
    }

    protected String getValueString() {
        return String.format("%0" + this.getMaxLength() + "X", this.getValue());
    }

    public void setValue(int n) {
        this.setText(String.format("%0" + this.getMaxLength() + "X", n));
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

