/*
 * Decompiled with CFR 0.152.
 */
package transactions;

import changes.Changable;
import changes.Change;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import rom.RomManager;
import transactions.ArrayDequeTransaction;
import transactions.RollbackTransaction;
import transactions.Transaction;
import transactions.TransactionListener;
import transactions.TransactionObject;

public class TransactionManager {
    private static TransactionManager instance;
    private final LinkedList<TransactionListener> listeners = new LinkedList();
    private Deque<int[]> transaction;
    private ArrayList<TransactionObject> transactionObjects;

    private TransactionManager() {
    }

    public static TransactionManager getInstance() {
        if (instance == null) {
            instance = new TransactionManager();
        }
        return instance;
    }

    public void reset() {
        this.transaction = null;
        this.transactionObjects = null;
    }

    public boolean isTransactionRunning() {
        return this.transaction != null && !this.transaction.isEmpty();
    }

    public void startTransaction() {
        this.transaction = new ArrayDeque<int[]>();
        this.transactionObjects = new ArrayList();
        this.fireTransactionStarted();
    }

    public void runTransaction(Runnable runnable) {
        this.startTransaction();
        try {
            runnable.run();
            this.commit();
        }
        catch (Exception exception) {
            this.rollBack(exception);
        }
    }

    public void addTransactionObject(Changable changable, int n) {
        TransactionObject transactionObject;
        if (this.transactionObjects != null && !this.transactionObjects.contains(transactionObject = new TransactionObject(changable, n))) {
            this.transactionObjects.add(transactionObject);
        }
    }

    public void addToTransaction(int n) {
        if (this.transaction != null) {
            this.transaction.addFirst(new int[]{n, RomManager.getInstance().readByte(n)});
        }
    }

    public void addToTransaction(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length must not be negative: " + n2);
        }
        if (n / 16384 != (n + n2 - 1) / 16384) {
            throw new IllegalArgumentException("Transactions must be within bank boundaries: " + Integer.toHexString(n) + "-" + Integer.toHexString(n + n2));
        }
        if (this.transaction != null) {
            while (n2-- > 0) {
                this.transaction.addFirst(new int[]{n, RomManager.getInstance().readByte(n++)});
            }
        }
    }

    private void fireTransactionStarted() {
        for (TransactionListener transactionListener : this.listeners) {
            transactionListener.transactionStarted();
        }
    }

    public void commit() {
        try {
            boolean bl;
            Change change = null;
            boolean bl2 = bl = this.transaction != null && !this.transaction.isEmpty() && !this.transactionObjects.isEmpty();
            if (bl) {
                change = new Change(this.transactionObjects, (int[][])this.transaction.toArray((T[])new int[this.transaction.size()][]));
            }
            if (this.transactionObjects != null) {
                if (change == null) {
                    change = new Change(this.transactionObjects, new int[0][0]);
                }
                for (TransactionObject object2 : this.transactionObjects) {
                    object2.getObject().fireChangeOccurred(change);
                }
            }
            ArrayDequeTransaction arrayDequeTransaction = new ArrayDequeTransaction();
            arrayDequeTransaction.add(change);
            this.fireTransactionCommitted(arrayDequeTransaction, bl);
            if (bl) {
                this.transaction = null;
            }
        }
        catch (Exception exception) {
            this.rollBack(exception);
        }
    }

    public void rollBack(Exception exception) {
        Deque<int[]> deque = this.transaction;
        this.transaction = RollbackTransaction.INSTANCE;
        if (deque != null) {
            for (Object object : deque) {
                RomManager.getInstance().writeByte(object[0], object[1]);
            }
        }
        if (this.transactionObjects != null) {
            Object object;
            object = new Change(this.transactionObjects, new int[0][0]);
            for (TransactionObject transactionObject : this.transactionObjects) {
                transactionObject.getObject().fireChangeOccurred((Change)object);
            }
        }
        this.transaction = null;
        this.transactionObjects = null;
        this.fireTransactionRolledBack(exception);
    }

    private void fireTransactionCommitted(Transaction transaction, boolean bl) {
        for (TransactionListener transactionListener : this.listeners) {
            transactionListener.transactionCommitted(transaction, bl);
        }
    }

    private void fireTransactionRolledBack(Exception exception) {
        for (TransactionListener transactionListener : this.listeners) {
            transactionListener.transactionRolledBack(exception);
        }
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.listeners.add(transactionListener);
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        this.listeners.remove(transactionListener);
    }
}

