/*
 * Decompiled with CFR 0.152.
 */
package patching;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import util.io.IOUtilities;

public class IPS {
    static final String[] PREFIXED_HEX_STRINGS = new String[256];
    private final List<Record> records = new ArrayList<Record>();
    private int[] affectedLocations;
    private int truncateOffset;

    static {
        int n = 0;
        while (n < PREFIXED_HEX_STRINGS.length) {
            IPS.PREFIXED_HEX_STRINGS[n] = " $" + String.format("%02X", n);
            ++n;
        }
    }

    public IPS(File file) throws IOException {
        InputStream inputStream;
        ZipFile zipFile = null;
        String string = file.getAbsolutePath();
        if (string.contains(".zip")) {
            int n = string.lastIndexOf(File.separatorChar);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            zipFile = new ZipFile(string2);
            ZipEntry zipEntry = zipFile.getEntry(string3);
            inputStream = zipFile.getInputStream(zipEntry);
        } else {
            inputStream = new FileInputStream(file);
        }
        this.fromStream(inputStream);
        if (zipFile != null) {
            zipFile.close();
        }
    }

    public IPS(InputStream inputStream) throws IOException {
        this.fromStream(inputStream);
    }

    private final void fromStream(InputStream inputStream) throws IOException {
        byte[] byArray = IOUtilities.toByteArray(inputStream);
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        n = 0;
        if (nArray[n++] != 80 || nArray[n++] != 65 || nArray[n++] != 84 || nArray[n++] != 67 || nArray[n++] != 72) {
            return;
        }
        Record record = new Record(nArray, n);
        while (n < nArray.length && record.type != Record.Type.EOF) {
            this.records.add(record);
            record = new Record(nArray, n += record.length);
        }
        if ((n += 3) < nArray.length) {
            this.truncateOffset = nArray[n++] << 16 | nArray[n++] << 8 | nArray[n++];
        }
    }

    public IPS(int[] nArray, File file) throws IOException {
        if (file.getName().contains(".zip")) {
            throw new IOException("Creating IPS patches for zip files is not supported.");
        }
        byte[] byArray = IOUtilities.toByteArray(new FileInputStream(file));
        int[] nArray2 = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray2[n] = byArray[n] & 0xFF;
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            if (!IPS.matches(nArray, nArray2, n)) {
                if (n == 4542278) {
                    --n;
                }
                int n2 = 0;
                int n3 = n + 1;
                while (n3 <= nArray.length) {
                    if (n3 < nArray.length && !IPS.matches(nArray, nArray2, n3)) {
                        n2 = 0;
                    } else if (n3 < nArray.length && n2 < 5) {
                        ++n2;
                    } else {
                        int n4 = n3 - n2;
                        int n5 = 0;
                        int n6 = 0;
                        while (n4 + n5 < nArray.length && nArray[n4 + n5] == nArray[n4 + n5 - 1]) {
                            if (IPS.matches(nArray, nArray2, n4 + n5)) {
                                ++n6;
                            }
                            ++n5;
                        }
                        if (n5 - n6 > 8) {
                            n = Math.max(n, this.divideRange(nArray, nArray2, n, n3 += n5 - n2));
                            break;
                        }
                        n = Math.max(n, this.divideRange(nArray, nArray2, n, n3 - n2));
                        break;
                    }
                    ++n3;
                }
                if (n3 > n) {
                    n = n3 - 1;
                }
            }
            ++n;
        }
        if (nArray.length != nArray2.length) {
            this.truncateOffset = nArray.length;
        }
    }

    private static final boolean matches(int[] nArray, int[] nArray2, int n) {
        return n < nArray2.length && nArray[n] == nArray2[n];
    }

    private int divideRange(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 1;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (n3 < 65535 && n4 < n2 && nArray[n4] == nArray[n4 - 1]) {
                ++n3;
            } else {
                int n5 = n3;
                int n6 = n4 - n5;
                while (n6 < n4 && IPS.matches(nArray, nArray2, n6)) {
                    ++n6;
                }
                int n7 = n4 - 1;
                while (n7 > n6 && IPS.matches(nArray, nArray2, n7)) {
                    --n7;
                }
                n3 = n7 - n6 + 1;
                int n8 = n5 + 5 * ((n5 - 1) / 65535 + 1);
                int n9 = 8;
                if (n4 - n5 - n > 0) {
                    n9 += 5;
                }
                if (n4 < n2) {
                    n9 += 5;
                }
                if (n9 < n8) {
                    if (n4 - n5 - n > 0) {
                        this.divideRange(nArray, nArray2, n, n4 - n5);
                    }
                    this.records.add(new Record(Record.Type.RLE, n6, n3, new int[]{nArray[n4 - 1]}));
                    while (n4 < n2 && IPS.matches(nArray, nArray2, n4)) {
                        ++n4;
                    }
                    n = n4;
                } else if (n4 == n2) {
                    while (n < n4) {
                        int n10 = Math.min(n4 - n, 65535);
                        int[] nArray3 = new int[n10];
                        System.arraycopy(nArray, n, nArray3, 0, nArray3.length);
                        this.records.add(new Record(Record.Type.Normal, n, nArray3.length, nArray3));
                        n += n10;
                    }
                }
                n3 = 1;
            }
            ++n4;
        }
        return n - 1;
    }

    public int[] apply(int[] nArray) {
        int n = this.truncateOffset;
        if (n == 0) {
            n = nArray.length;
        }
        int[] nArray2 = nArray;
        for (Record record : this.records) {
            while (record.offset + record.size > n) {
                n += 16384;
            }
        }
        nArray = new int[n];
        System.arraycopy(nArray2, 0, nArray, 0, Math.min(nArray.length, nArray2.length));
        for (Record record : this.records) {
            switch (record.type) {
                case Normal: {
                    System.arraycopy(record.data, 0, nArray, record.offset, record.size);
                    break;
                }
                case RLE: {
                    Arrays.fill(nArray, record.offset, record.offset + record.size, record.data[0]);
                    break;
                }
                case EOF: {
                    return nArray;
                }
            }
        }
        return nArray;
    }

    public int calculateSize() {
        int n = new byte[]{80, 65, 84, 67, 72}.length;
        for (Record record : this.records) {
            n += record.calcRequiredSize();
        }
        n += new byte[]{69, 79, 70}.length;
        if (this.truncateOffset > 0) {
            n += 3;
        }
        return n;
    }

    public int[] getAffectedLocations() {
        if (this.affectedLocations == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            block4: for (Record record : this.records) {
                switch (record.type) {
                    case Normal: {
                        int n = 0;
                        while (n < record.data.length) {
                            arrayList.add(record.offset + n);
                            ++n;
                        }
                        continue block4;
                    }
                    case RLE: {
                        int n = 0;
                        while (n < record.size) {
                            arrayList.add(record.offset + n);
                            ++n;
                        }
                        continue block4;
                    }
                }
            }
            this.affectedLocations = new int[arrayList.size()];
            int n = 0;
            while (n < this.affectedLocations.length) {
                this.affectedLocations[n] = (Integer)arrayList.get(n);
                ++n;
            }
        }
        return this.affectedLocations;
    }

    public void writeToFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((OutputStream)fileOutputStream).write(new byte[]{80, 65, 84, 67, 72});
        for (Record record : this.records) {
            record.writeToStream(fileOutputStream);
        }
        Record.EOF.writeToStream(fileOutputStream);
        if (this.truncateOffset > 0) {
            ((OutputStream)fileOutputStream).write(new byte[]{(byte)(this.truncateOffset >> 16), (byte)(this.truncateOffset >> 8 & 0xFF), (byte)(this.truncateOffset & 0xFF)});
        }
        ((OutputStream)fileOutputStream).close();
    }

    public String toString() {
        String string = "";
        for (Record record : this.records) {
            string = String.valueOf(string) + record.toString() + "\n";
        }
        return string;
    }

    private static final class Record {
        final Type type;
        int length;
        int offset;
        int size;
        int[] data;
        public static final Record EOF = new Record(Type.EOF);

        public Record(Type type) {
            this.type = type;
        }

        public Record(Type type, int n, int n2, int[] nArray) {
            if (n2 >= 65536) {
                throw new IllegalArgumentException("The specified size of $" + Integer.toHexString(n2) + " bytes is too large for a patch record.");
            }
            this.type = type;
            this.offset = n;
            this.size = n2;
            this.data = nArray;
        }

        public Record(int[] nArray, int n) {
            if (n >= nArray.length) {
                this.type = Type.EOF;
                return;
            }
            int n2 = n;
            if (nArray[n] == 69 && nArray[n + 1] == 79 && nArray[n + 2] == 70) {
                this.type = Type.EOF;
                this.length = 3;
            } else {
                this.offset = nArray[n++] << 16 | nArray[n++] << 8 | nArray[n++];
                this.size = nArray[n++] << 8 | nArray[n++];
                if (this.size == 0) {
                    this.size = nArray[n++] << 8 | nArray[n++];
                    this.data = new int[]{nArray[n++]};
                    this.type = Type.RLE;
                } else {
                    this.data = new int[this.size];
                    int n3 = 0;
                    while (n3 < this.data.length && n < nArray.length) {
                        this.data[n3] = nArray[n++];
                        ++n3;
                    }
                    this.type = Type.Normal;
                }
                this.length = n - n2;
            }
        }

        public void writeToStream(OutputStream outputStream) throws IOException {
            if (this.type != Type.EOF) {
                outputStream.write(new byte[]{(byte)(this.offset >> 16), (byte)(this.offset >> 8 & 0xFF), (byte)(this.offset & 0xFF)});
            }
            switch (this.type) {
                case Normal: {
                    outputStream.write(new byte[]{(byte)(this.size >> 8 & 0xFF), (byte)(this.size & 0xFF)});
                    byte[] byArray = new byte[this.data.length];
                    int n = 0;
                    while (n < this.data.length) {
                        byArray[n] = (byte)this.data[n];
                        ++n;
                    }
                    outputStream.write(byArray);
                    break;
                }
                case RLE: {
                    outputStream.write(new byte[2]);
                    outputStream.write(new byte[]{(byte)(this.size >> 8 & 0xFF), (byte)(this.size & 0xFF)});
                    outputStream.write((byte)this.data[0]);
                    break;
                }
                case EOF: {
                    outputStream.write(new byte[]{69, 79, 70});
                }
            }
        }

        public int calcRequiredSize() {
            switch (this.type) {
                case Normal: {
                    return 5 + this.data.length;
                }
                case RLE: {
                    return 8;
                }
                case EOF: {
                    return new byte[]{69, 79, 70}.length;
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            String string = String.valueOf(String.format("$%04X", this.offset)) + " (" + this.calcRequiredSize() + ")" + (this.type == Type.RLE ? " " + this.size : "");
            int[] nArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                string = String.valueOf(string) + PREFIXED_HEX_STRINGS[n3];
                ++n2;
            }
            return string;
        }

        private static enum Type {
            Normal,
            RLE,
            EOF;

        }
    }
}

