/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.TextData;
import data.Tiles;
import data.Tileset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JScrollBar;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class TextPanel
extends ScalablePanel {
    private final BufferedImage textImage = new BufferedImage(256, 192, 1);
    private final Color[] colors = new Color[32];
    private Tileset tileset;
    private TextData textData;
    private Palette palette;
    private Tiles fontTiles;
    private TextData.TextHandle messageToShow;
    private int selectedCharacter = -1;
    private int textScroll;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private final JScrollBar verticalScrollBar = new JScrollBar(1);
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(TextPanel.this.tileset) > 0 && change.getData(TextPanel.this.tileset) < 256) {
                TextPanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TextPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 != 1) {
                    int n3 = 0;
                    while (n3 < 1 << TextPanel.this.fontTiles.getBPP()) {
                        int n4 = TextPanel.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((TextPanel)TextPanel.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n < 1 << TextPanel.this.fontTiles.getBPP()) {
                int n8 = TextPanel.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((TextPanel)TextPanel.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                TextPanel.this.update();
            }
        }
    };
    private final ChangeListener textDataChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TextPanel.this.textData);
            if (n >= 0) {
                TextPanel.this.selectedCharacter = n;
            }
            TextPanel.this.update();
        }
    };
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            TextPanel.this.update();
        }
    };

    public TextPanel(TextData textData, Tileset tileset, Palette palette, Tiles tiles) {
        final Cursor cursor = this.getCursor();
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.setTextData(textData, tileset, palette, tiles);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = TextPanel.this.toScreenY(mouseEvent.getY()) / 8 * 32 + TextPanel.this.toScreenX(mouseEvent.getX()) / 8;
                if (TextPanel.this.textData.isCharacter(n)) {
                    TextPanel.this.selectedCharacter = n;
                }
                TextPanel.this.repaint();
                TextPanel.this.requestFocusInWindow();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TextPanel.this.toScreenY(mouseEvent.getY()) / 8 * 32 + TextPanel.this.toScreenX(mouseEvent.getX()) / 8;
                if (TextPanel.this.textData.isCharacter(n)) {
                    TextPanel.this.setCursor(cursor2);
                } else {
                    TextPanel.this.setCursor(cursor);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isAltDown()) {
                    return;
                }
                if (TextPanel.this.verticalScrollBar.isVisible()) {
                    if (mouseWheelEvent.getUnitsToScroll() > 0) {
                        TextPanel.this.doScrollDown();
                    } else if (mouseWheelEvent.getUnitsToScroll() < 0) {
                        TextPanel.this.doScrollUp();
                    }
                }
                mouseWheelEvent.consume();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        TextPanel.this.moveLeft();
                        break;
                    }
                    case 39: {
                        TextPanel.this.moveRight();
                        break;
                    }
                    case 38: {
                        TextPanel.this.moveUp();
                        break;
                    }
                    case 40: {
                        TextPanel.this.moveDown();
                        break;
                    }
                    case 33: {
                        TextPanel.this.doScrollUp();
                        break;
                    }
                    case 34: {
                        TextPanel.this.doScrollDown();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                TextPanel.this.characterTyped(keyEvent.getKeyChar());
                if (keyEvent.getKeyChar() == '\b') {
                    TextPanel.this.backspaceTyped();
                } else if (keyEvent.getKeyChar() == '\u007f') {
                    TextPanel.this.deleteTyped();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.verticalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (TextPanel.this.textScroll < adjustmentEvent.getValue()) {
                    TextPanel.this.doScrollDown();
                } else if (TextPanel.this.textScroll > adjustmentEvent.getValue()) {
                    TextPanel.this.doScrollUp();
                }
            }
        });
        this.add((Component)this.verticalScrollBar, "East");
    }

    public void setTextData(TextData textData, Tileset tileset, Palette palette, Tiles tiles) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.textData != null && this.textData != textData) {
            this.textData.removeChangeListener(this.textDataChangeListener);
        }
        if (this.fontTiles != null && this.fontTiles != tiles) {
            this.fontTiles.removeChangeListener(this.tilesChangeListener);
        }
        this.tileset = tileset;
        this.textData = textData;
        this.palette = palette;
        this.fontTiles = tiles;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        textData.addChangeListener(this.textDataChangeListener);
        tiles.addChangeListener(this.tilesChangeListener);
        this.setMessageToShow(textData.getTextHandles().firstElement());
    }

    private void moveLeft() {
        if (this.selectedCharacter > 0) {
            do {
                --this.selectedCharacter;
            } while (this.selectedCharacter > 0 && !this.textData.isCharacter(this.selectedCharacter));
            if (this.selectedCharacter == 0 && this.scrollUp()) {
                if (!this.textData.isCharacter(this.selectedCharacter)) {
                    while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter)) {
                        ++this.selectedCharacter;
                    }
                }
                this.update();
                this.selectedCharacter += 32;
                do {
                    --this.selectedCharacter;
                } while (this.selectedCharacter > 0 && !this.textData.isCharacter(this.selectedCharacter));
            }
            if (!this.textData.isCharacter(this.selectedCharacter)) {
                while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter)) {
                    ++this.selectedCharacter;
                }
            }
        }
        this.repaint();
    }

    private void moveRight() {
        do {
            ++this.selectedCharacter;
        } while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter));
        if (this.selectedCharacter == 768) {
            while (this.scrollDown()) {
                this.update();
                this.selectedCharacter -= 32;
                do {
                    ++this.selectedCharacter;
                } while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter));
                if (this.selectedCharacter == 768) continue;
            }
            if (this.selectedCharacter == 768) {
                do {
                    --this.selectedCharacter;
                } while (this.selectedCharacter > 0 && !this.textData.isCharacter(this.selectedCharacter));
            }
        }
        this.repaint();
    }

    private void moveUp() {
        if (this.selectedCharacter - 64 < 0) {
            if (this.scrollUp() && (this.selectedCharacter - 64 >= 0 || this.scrollUp())) {
                this.selectedCharacter -= 64;
                this.update();
                while (this.selectedCharacter > 0 && !this.textData.isCharacter(this.selectedCharacter)) {
                    --this.selectedCharacter;
                }
                while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter)) {
                    ++this.selectedCharacter;
                }
            }
        } else {
            this.selectedCharacter -= 64;
            if (!this.textData.isCharacter(this.selectedCharacter)) {
                this.moveLeft();
            }
        }
        this.repaint();
    }

    private void moveDown() {
        if (this.selectedCharacter + 64 >= 768) {
            if (this.scrollDown() && (this.selectedCharacter + 64 < 768 || this.scrollDown())) {
                this.selectedCharacter += 64;
                this.update();
                while (this.selectedCharacter > 0 && !this.textData.isCharacter(this.selectedCharacter)) {
                    --this.selectedCharacter;
                }
                while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter)) {
                    ++this.selectedCharacter;
                }
            }
        } else {
            int n = this.selectedCharacter;
            this.selectedCharacter += 64;
            if (!this.textData.isCharacter(this.selectedCharacter)) {
                this.moveLeft();
                if (n < 0 || this.selectedCharacter <= n) {
                    this.moveRight();
                }
            }
        }
        this.repaint();
    }

    private void deleteTyped() {
        if (this.textData.isCharacter(this.selectedCharacter)) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    TextPanel.this.textData.setCharacter(TextPanel.this.selectedCharacter, ' ');
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void backspaceTyped() {
        block1: {
            if (this.selectedCharacter <= 0) break block1;
            this.moveLeft();
            if (!this.textData.isCharacter(this.selectedCharacter)) ** GOTO lbl7
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    TextPanel.this.textData.setCharacter(TextPanel.this.selectedCharacter, ' ');
                }
            });
            break block1;
lbl-1000:
            // 1 sources

            {
                ++this.selectedCharacter;
lbl7:
                // 2 sources

                ** while (this.selectedCharacter < 768 && !this.textData.isCharacter((int)this.selectedCharacter))
            }
        }
    }

    private void characterTyped(final char c) {
        if (this.selectedCharacter >= 0) {
            final boolean[] blArray = new boolean[1];
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = TextPanel.this.textData.setCharacter(TextPanel.this.selectedCharacter, c);
                }
            });
            if (blArray[0]) {
                this.moveRight();
            }
        }
    }

    private void doScrollUp() {
        this.scrollUp();
        this.update();
        if (this.selectedCharacter >= 768) {
            this.moveUp();
        }
    }

    private void doScrollDown() {
        this.scrollDown();
        this.update();
        if (this.selectedCharacter < 0) {
            this.moveDown();
        }
    }

    public boolean supportsControlCodes() {
        return this.textData.supportsControlCodes(this.messageToShow);
    }

    public void copyToClipboard(int n) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){
            private final Object data;
            {
                this.data = TextPanel.this.textData.getText();
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.data;
            }
        }, null);
    }

    public boolean canPasteFromClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public void pasteFromClipboard(final int n) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                Object object = clipboard.getData(DataFlavor.stringFlavor);
                final String string = (String)object;
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TextPanel.this.textData.setText(string, n);
                    }
                });
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void copyToClipboard() {
        this.copyToClipboard(Math.max(0, this.selectedCharacter));
    }

    public void pasteFromClipboard() {
        this.pasteFromClipboard(Math.max(0, this.selectedCharacter));
    }

    public void setMessageToShow(TextData.TextHandle textHandle) {
        this.textScroll = 0;
        this.messageToShow = textHandle;
        this.update();
        this.selectedCharacter = 0;
        do {
            ++this.selectedCharacter;
        } while (this.selectedCharacter < 768 && !this.textData.isCharacter(this.selectedCharacter));
    }

    private void update() {
        int[] nArray = this.textData.getVRAM(this.messageToShow, this.textScroll);
        int[] nArray2 = this.tileset.getVRAM();
        Color color = this.colors[0];
        Color color2 = this.colors[16];
        if (this.textData.hasBlackBackground(this.messageToShow)) {
            this.colors[0] = Color.BLACK;
            this.colors[16] = Color.BLACK;
        } else if (Color.BLACK.equals(this.colors[0])) {
            this.colors[0] = Color.BLUE;
        }
        Graphics2D graphics2D = this.textImage.createGraphics();
        int n = 0;
        while (n < 24) {
            int n2 = 0;
            while (n2 < 32) {
                int n3 = (n + this.textData.getVerticalScroll() / 8) % 28;
                int n4 = 14336 + (n3 << 6 | n2 << 1);
                Renderer.renderCharacter(nArray2, (nArray[n4 | 1] & 0xF) << 8 | nArray[n4], n2 * 8, n * 8, this.colors, graphics2D);
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
        this.colors[0] = color;
        this.colors[16] = color2;
        this.updateScrollBar();
        this.repaint();
    }

    private void updateScrollBar() {
        this.verticalScrollBar.setEnabled(this.canScrollUp() || this.canScrollDown());
        this.verticalScrollBar.setValues(this.textScroll, 1, 0, this.textData.getMaxTextScroll());
    }

    private boolean canScrollUp() {
        return this.textScroll > 0;
    }

    private boolean scrollUp() {
        if (this.canScrollUp()) {
            --this.textScroll;
            this.selectedCharacter += 32;
            return true;
        }
        return false;
    }

    private boolean canScrollDown() {
        return this.textData.canScrollDown();
    }

    private boolean scrollDown() {
        if (this.canScrollDown()) {
            ++this.textScroll;
            this.selectedCharacter -= 32;
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.verticalScrollBar.getPreferredSize().width;
        return new Dimension((int)((float)this.textImage.getWidth() * this.getPreferredScale()) + n, (int)((float)this.textImage.getHeight() * this.getPreferredScale()));
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        BufferedImage bufferedImage = new BufferedImage(this.textImage.getWidth(), this.textImage.getHeight(), this.textImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.textImage, 0, 0, null);
        if (this.selectedCharacter >= 0) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(this.selectedCharacter % 32 * 8, this.selectedCharacter / 32 * 8, 8, 8);
        }
        Insets insets = this.getInsets();
        int n = this.getWidth() - (insets.left + insets.right + this.verticalScrollBar.getWidth());
        int n2 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n / (float)bufferedImage.getWidth();
        float f2 = (float)n2 / (float)bufferedImage.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)bufferedImage.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)bufferedImage.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n - (float)bufferedImage.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n2 - (float)bufferedImage.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, (int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), null);
    }
}

