/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionManager;

public class GameSettings
implements Changable {
    private final int address;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public GameSettings(int n) {
        this.address = n;
    }

    public void setScore(int n) {
        RomManager.StaticAccess.writeByte(this.address + 1, n & 0xFF);
        RomManager.StaticAccess.writeByte(this.address + 2, n >> 8 & 0xFF);
        RomManager.StaticAccess.writeByte(this.address + 3, n >> 16);
    }

    public int getScore() {
        return RomManager.StaticAccess.readByte(this.address + 3) << 16 | RomManager.StaticAccess.readByte(this.address + 2) << 8 | RomManager.StaticAccess.readByte(this.address + 1);
    }

    public void setLevel(int n) {
        if (n != RomManager.StaticAccess.readByte(this.address + 4)) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(this.address + 4, n);
        }
    }

    public int getLevel() {
        return RomManager.StaticAccess.readByte(this.address + 4);
    }

    public void setLives(int n) {
        if (n != RomManager.StaticAccess.readByte(this.address + 6)) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(this.address + 6, n);
        }
    }

    public int getLives() {
        return RomManager.StaticAccess.readByte(this.address + 6);
    }

    public void setMoney(int n) {
        if (n != (RomManager.StaticAccess.readByte(this.address + 19) << 16 | RomManager.StaticAccess.readByte(this.address + 18) << 8 | RomManager.StaticAccess.readByte(this.address + 17))) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(this.address + 17, n & 0xFF);
            RomManager.StaticAccess.writeByte(this.address + 18, n >> 8 & 0xFF);
            RomManager.StaticAccess.writeByte(this.address + 19, n >> 16);
        }
    }

    public int getMoney() {
        return RomManager.StaticAccess.readByte(this.address + 19) << 16 | RomManager.StaticAccess.readByte(this.address + 18) << 8 | RomManager.StaticAccess.readByte(this.address + 17);
    }

    public void setContinueLives(int n) {
        if (n != RomManager.StaticAccess.readByte(28289)) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(28289, n);
        }
    }

    public int getContinueLives() {
        return RomManager.StaticAccess.readByte(28289);
    }

    public void setContinueCost(int n) {
        int n2 = 28242;
        if (n != (RomManager.StaticAccess.readByte(n2 + 2) << 16 | RomManager.StaticAccess.readByte(n2 + 1) << 8 | RomManager.StaticAccess.readByte(n2))) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(n2++, 33);
            RomManager.StaticAccess.writeWord(n2, 28247);
            n2 += 2;
            RomManager.StaticAccess.writeByte(n2++, 24);
            RomManager.StaticAccess.writeByte(n2++, 3);
            RomManager.StaticAccess.writeByte(n2++, n & 0xFF);
            RomManager.StaticAccess.writeByte(n2++, n >> 8 & 0xFF);
            RomManager.StaticAccess.writeByte(n2++, n >> 16);
        }
    }

    public int getContinueCost() {
        if (RomManager.StaticAccess.readByte(28246) == 33 && RomManager.StaticAccess.readByte(28242) == 14) {
            int n = RomManager.StaticAccess.readWord(28247) + RomManager.StaticAccess.readByte(28243);
            return RomManager.StaticAccess.readByte(n + 2) << 16 | RomManager.StaticAccess.readByte(n + 1) << 8 | RomManager.StaticAccess.readByte(n);
        }
        if (RomManager.StaticAccess.readByte(28242) == 33 && RomManager.StaticAccess.readWord(28243) == 28247) {
            return RomManager.StaticAccess.readByte(28249) << 16 | RomManager.StaticAccess.readByte(28248) << 8 | RomManager.StaticAccess.readByte(28247);
        }
        throw new IllegalStateException();
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeGameSettings");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

