/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.oracle.webservices.internal.api.message.BaseDistributedPropertySet;
import com.oracle.webservices.internal.api.message.BasePropertySet;
import com.oracle.webservices.internal.api.message.ContentType;
import com.oracle.webservices.internal.api.message.MessageContext;
import com.oracle.webservices.internal.api.message.PropertySet;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.marshaller.SAX2DOMEx;
import com.sun.xml.internal.ws.addressing.WsaPropertyBag;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.DistributedPropertySet;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.MessageMetadata;
import com.sun.xml.internal.ws.api.message.MessageWrapper;
import com.sun.xml.internal.ws.api.message.MessageWritable;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.WSDLOperationMapping;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.client.Stub;
import com.sun.xml.internal.ws.message.RelatesToHeader;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Packet
extends BaseDistributedPropertySet
implements MessageContext,
MessageMetadata {
    private Message message;
    private WSDLOperationMapping wsdlOperationMapping = null;
    private QName wsdlOperation;
    public boolean wasTransportSecure;
    public static final String INBOUND_TRANSPORT_HEADERS = "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers";
    public static final String OUTBOUND_TRANSPORT_HEADERS = "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers";
    public static final String HA_INFO = "com.sun.xml.internal.ws.api.message.packet.hainfo";
    @PropertySet.Property(value={"com.sun.xml.internal.ws.handler.config"})
    public HandlerConfiguration handlerConfig;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.handle"})
    public BindingProvider proxy;
    public boolean isAdapterDeliversNonAnonymousResponse;
    public boolean packetTakesPriorityOverRequestContext = false;
    public EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation;
    public String acceptableMimeTypes;
    public WebServiceContextDelegate webServiceContextDelegate;
    @Nullable
    public TransportBackChannel transportBackChannel;
    public Component component;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.server.WSEndpoint"})
    public WSEndpoint endpoint;
    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String soapAction;
    @PropertySet.Property(value={"com.sun.xml.internal.ws.server.OneWayOperation"})
    public Boolean expectReply;
    @Deprecated
    public Boolean isOneWay;
    public Boolean isSynchronousMEP;
    public Boolean nonNullAsyncHandlerGiven;
    private Boolean isRequestReplyMEP;
    private Set<String> handlerScopePropertyNames;
    public final Map<String, Object> invocationProperties;
    private static final BasePropertySet.PropertyMap model = Packet.parse(Packet.class);
    private static final Logger LOGGER = Logger.getLogger(Packet.class.getName());
    public Codec codec = null;
    private ContentType contentType;
    private Boolean mtomRequest;
    private Boolean mtomAcceptable;
    private MTOMFeature mtomFeature;
    Boolean checkMtomAcceptable;
    private Boolean fastInfosetAcceptable;
    private State state = State.ServerRequest;
    private boolean isFastInfosetDisabled;

    public Packet(Message message) {
        this();
        this.message = message;
        if (this.message != null) {
            this.message.setMessageMedadata(this);
        }
    }

    public Packet() {
        this.invocationProperties = new HashMap<String, Object>();
    }

    private Packet(Packet packet) {
        this.relatePackets(packet, true);
        this.invocationProperties = packet.invocationProperties;
    }

    public Packet copy(boolean bl) {
        Packet packet = new Packet(this);
        if (bl && this.message != null) {
            packet.message = this.message.copy();
        }
        if (packet.message != null) {
            packet.message.setMessageMedadata(packet);
        }
        return packet;
    }

    public Message getMessage() {
        if (this.message != null && !(this.message instanceof MessageWrapper)) {
            this.message = new MessageWrapper(this, this.message);
        }
        return this.message;
    }

    public Message getInternalMessage() {
        return this.message instanceof MessageWrapper ? ((MessageWrapper)this.message).delegate : this.message;
    }

    public WSBinding getBinding() {
        if (this.endpoint != null) {
            return this.endpoint.getBinding();
        }
        if (this.proxy != null) {
            return (WSBinding)this.proxy.getBinding();
        }
        return null;
    }

    public void setMessage(Message message) {
        this.message = message;
        if (message != null) {
            this.message.setMessageMedadata(this);
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.wsdl.operation"})
    @Nullable
    public final QName getWSDLOperation() {
        if (this.wsdlOperation != null) {
            return this.wsdlOperation;
        }
        if (this.wsdlOperationMapping == null) {
            this.wsdlOperationMapping = this.getWSDLOperationMapping();
        }
        if (this.wsdlOperationMapping != null) {
            this.wsdlOperation = this.wsdlOperationMapping.getOperationName();
        }
        return this.wsdlOperation;
    }

    @Override
    public WSDLOperationMapping getWSDLOperationMapping() {
        if (this.wsdlOperationMapping != null) {
            return this.wsdlOperationMapping;
        }
        OperationDispatcher operationDispatcher = null;
        if (this.endpoint != null) {
            operationDispatcher = this.endpoint.getOperationDispatcher();
        } else if (this.proxy != null) {
            operationDispatcher = ((Stub)this.proxy).getOperationDispatcher();
        }
        if (operationDispatcher != null) {
            try {
                this.wsdlOperationMapping = operationDispatcher.getWSDLOperationMapping(this);
            }
            catch (DispatchException dispatchException) {
                // empty catch block
            }
        }
        return this.wsdlOperationMapping;
    }

    public void setWSDLOperation(QName qName) {
        this.wsdlOperation = qName;
    }

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        if (this.endpointAddress == null) {
            return null;
        }
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String string) {
        this.endpointAddress = string == null ? null : EndpointAddress.create(string);
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation != null ? this.contentNegotiation.toString() : null;
    }

    public void setContentNegotiationString(String string) {
        if (string == null) {
            this.contentNegotiation = null;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.reference.parameters"})
    @NotNull
    public List<Element> getReferenceParameters() {
        Message message = this.getMessage();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (message == null) {
            return arrayList;
        }
        MessageHeaders messageHeaders = message.getHeaders();
        for (Header header : messageHeaders.asList()) {
            String string = header.getAttribute(AddressingVersion.W3C.nsUri, "IsReferenceParameter");
            if (string == null || !string.equals("true") && !string.equals("1")) continue;
            Document document = DOMUtil.createDom();
            SAX2DOMEx sAX2DOMEx = new SAX2DOMEx(document);
            try {
                header.writeTo(sAX2DOMEx, XmlUtil.DRACONIAN_ERROR_HANDLER);
                arrayList.add((Element)document.getLastChild());
            }
            catch (SAXException sAXException) {
                throw new WebServiceException(sAXException);
            }
        }
        return arrayList;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.api.message.HeaderList"})
    MessageHeaders getHeaderList() {
        Message message = this.getMessage();
        if (message == null) {
            return null;
        }
        return message.getHeaders();
    }

    public TransportBackChannel keepTransportBackChannelOpen() {
        TransportBackChannel transportBackChannel = this.transportBackChannel;
        this.transportBackChannel = null;
        return transportBackChannel;
    }

    public Boolean isRequestReplyMEP() {
        return this.isRequestReplyMEP;
    }

    public void setRequestReplyMEP(Boolean bl) {
        this.isRequestReplyMEP = bl;
    }

    public final Set<String> getHandlerScopePropertyNames(boolean bl) {
        Set<String> set = this.handlerScopePropertyNames;
        if (set == null) {
            if (bl) {
                return Collections.emptySet();
            }
            this.handlerScopePropertyNames = set = new HashSet<String>();
        }
        return set;
    }

    public final Set<String> getApplicationScopePropertyNames(boolean bl) {
        assert (false);
        return new HashSet<String>();
    }

    @Deprecated
    public Packet createResponse(Message message) {
        Packet packet = new Packet(this);
        packet.setMessage(message);
        return packet;
    }

    public Packet createClientResponse(Message message) {
        Packet packet = new Packet(this);
        packet.setMessage(message);
        this.finishCreateRelateClientResponse(packet);
        return packet;
    }

    public Packet relateClientResponse(Packet packet) {
        packet.relatePackets(this, true);
        this.finishCreateRelateClientResponse(packet);
        return packet;
    }

    private void finishCreateRelateClientResponse(Packet packet) {
        packet.soapAction = null;
        packet.setState(State.ClientResponse);
    }

    public Packet createServerResponse(@Nullable Message message, @Nullable WSDLPort wSDLPort, @Nullable SEIModel sEIModel, @NotNull WSBinding wSBinding) {
        Packet packet = this.createClientResponse(message);
        return this.relateServerResponse(packet, wSDLPort, sEIModel, wSBinding);
    }

    public void copyPropertiesTo(@Nullable Packet packet) {
        this.relatePackets(packet, false);
    }

    private void relatePackets(@Nullable Packet packet, boolean bl) {
        Packet packet2;
        Packet packet3;
        if (!bl) {
            packet3 = this;
            packet2 = packet;
            packet2.soapAction = null;
            packet2.invocationProperties.putAll(packet3.invocationProperties);
            if (this.getState().equals((Object)State.ServerRequest)) {
                packet2.setState(State.ServerResponse);
            }
        } else {
            packet3 = packet;
            packet2 = this;
            packet2.soapAction = packet3.soapAction;
            packet2.setState(packet3.getState());
        }
        packet3.copySatelliteInto(packet2);
        packet2.isAdapterDeliversNonAnonymousResponse = packet3.isAdapterDeliversNonAnonymousResponse;
        packet2.handlerConfig = packet3.handlerConfig;
        packet2.handlerScopePropertyNames = packet3.handlerScopePropertyNames;
        packet2.contentNegotiation = packet3.contentNegotiation;
        packet2.wasTransportSecure = packet3.wasTransportSecure;
        packet2.transportBackChannel = packet3.transportBackChannel;
        packet2.endpointAddress = packet3.endpointAddress;
        packet2.wsdlOperation = packet3.wsdlOperation;
        packet2.wsdlOperationMapping = packet3.wsdlOperationMapping;
        packet2.acceptableMimeTypes = packet3.acceptableMimeTypes;
        packet2.endpoint = packet3.endpoint;
        packet2.proxy = packet3.proxy;
        packet2.webServiceContextDelegate = packet3.webServiceContextDelegate;
        packet2.expectReply = packet3.expectReply;
        packet2.component = packet3.component;
        packet2.mtomAcceptable = packet3.mtomAcceptable;
        packet2.mtomRequest = packet3.mtomRequest;
    }

    public Packet relateServerResponse(@Nullable Packet packet, @Nullable WSDLPort wSDLPort, @Nullable SEIModel sEIModel, @NotNull WSBinding wSBinding) {
        this.relatePackets(packet, false);
        packet.setState(State.ServerResponse);
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        if (addressingVersion == null) {
            return packet;
        }
        if (this.getMessage() == null) {
            return packet;
        }
        String string = AddressingUtils.getAction(this.getMessage().getHeaders(), addressingVersion, wSBinding.getSOAPVersion());
        if (string == null) {
            return packet;
        }
        if (packet.getMessage() == null || wSDLPort != null && this.getMessage().isOneWay(wSDLPort)) {
            return packet;
        }
        this.populateAddressingHeaders(wSBinding, packet, wSDLPort, sEIModel);
        return packet;
    }

    public Packet createServerResponse(@Nullable Message message, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string) {
        Packet packet = this.createClientResponse(message);
        packet.setState(State.ServerResponse);
        if (addressingVersion == null) {
            return packet;
        }
        String string2 = AddressingUtils.getAction(this.getMessage().getHeaders(), addressingVersion, sOAPVersion);
        if (string2 == null) {
            return packet;
        }
        this.populateAddressingHeaders(packet, addressingVersion, sOAPVersion, string, false);
        return packet;
    }

    public void setResponseMessage(@NotNull Packet packet, @Nullable Message message, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string) {
        Packet packet2 = packet.createServerResponse(message, addressingVersion, sOAPVersion, string);
        this.setMessage(packet2.getMessage());
    }

    private void populateAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, String string, boolean bl) {
        String string2;
        if (addressingVersion == null) {
            return;
        }
        if (packet.getMessage() == null) {
            return;
        }
        MessageHeaders messageHeaders = packet.getMessage().getHeaders();
        WsaPropertyBag wsaPropertyBag = this.getSatellite(WsaPropertyBag.class);
        Message message = this.getMessage();
        WSEndpointReference wSEndpointReference = null;
        Header header = AddressingUtils.getFirstHeader(message.getHeaders(), addressingVersion.replyToTag, true, sOAPVersion);
        Header header2 = messageHeaders.get(addressingVersion.toTag, false);
        boolean bl2 = true;
        try {
            if (header != null) {
                wSEndpointReference = header.readAsEPR(addressingVersion);
            }
            if (header2 != null && wSEndpointReference == null) {
                bl2 = false;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), xMLStreamException);
        }
        if (wSEndpointReference == null) {
            wSEndpointReference = AddressingUtils.getReplyTo(message.getHeaders(), addressingVersion, sOAPVersion);
        }
        if (AddressingUtils.getAction(packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) == null) {
            messageHeaders.add(new StringHeader(addressingVersion.actionTag, string, sOAPVersion, bl));
        }
        if (packet.getMessage().getHeaders().get(addressingVersion.messageIDTag, false) == null) {
            string2 = Message.generateMessageID();
            messageHeaders.add(new StringHeader(addressingVersion.messageIDTag, string2));
        }
        string2 = null;
        if (wsaPropertyBag != null) {
            string2 = wsaPropertyBag.getMessageID();
        }
        if (string2 == null) {
            string2 = AddressingUtils.getMessageID(message.getHeaders(), addressingVersion, sOAPVersion);
        }
        if (string2 != null) {
            messageHeaders.addOrReplace(new RelatesToHeader(addressingVersion.relatesToTag, string2));
        }
        WSEndpointReference wSEndpointReference2 = null;
        if (packet.getMessage().isFault()) {
            if (wsaPropertyBag != null) {
                wSEndpointReference2 = wsaPropertyBag.getFaultToFromRequest();
            }
            if (wSEndpointReference2 == null) {
                wSEndpointReference2 = AddressingUtils.getFaultTo(message.getHeaders(), addressingVersion, sOAPVersion);
            }
            if (wSEndpointReference2 == null) {
                wSEndpointReference2 = wSEndpointReference;
            }
        } else {
            wSEndpointReference2 = wSEndpointReference;
        }
        if (bl2 && wSEndpointReference2 != null) {
            messageHeaders.addOrReplace(new StringHeader(addressingVersion.toTag, wSEndpointReference2.getAddress()));
            wSEndpointReference2.addReferenceParametersToList(messageHeaders);
        }
    }

    private void populateAddressingHeaders(WSBinding wSBinding, Packet packet, WSDLPort wSDLPort, SEIModel sEIModel) {
        String string;
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        if (addressingVersion == null) {
            return;
        }
        WsaTubeHelper wsaTubeHelper = addressingVersion.getWsaHelper(wSDLPort, sEIModel, wSBinding);
        String string2 = string = packet.getMessage().isFault() ? wsaTubeHelper.getFaultAction(this, packet) : wsaTubeHelper.getOutputAction(this);
        if (string == null) {
            LOGGER.info("WSA headers are not added as value for wsa:Action cannot be resolved for this message");
            return;
        }
        this.populateAddressingHeaders(packet, addressingVersion, wSBinding.getSOAPVersion(), string, AddressingVersion.isRequired(wSBinding));
    }

    public String toShortString() {
        return super.toString();
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        try {
            Message message = this.getMessage();
            if (message != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(byteArrayOutputStream, "UTF-8");
                message.copy().writeTo(xMLStreamWriter);
                xMLStreamWriter.flush();
                xMLStreamWriter.close();
                byteArrayOutputStream.flush();
                XMLStreamWriterFactory.recycle(xMLStreamWriter);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                string = new String(byArray, "UTF-8");
            } else {
                string = "<none>";
            }
        }
        catch (Throwable throwable) {
            throw new WebServiceException(throwable);
        }
        stringBuilder.append(" Content: ").append(string);
        return stringBuilder.toString();
    }

    @Override
    protected BasePropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    public Map<String, Object> asMapIncludingInvocationProperties() {
        final Map<String, Object> map = this.asMap();
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object object) {
                Object v = map.get(object);
                if (v != null) {
                    return v;
                }
                return Packet.this.invocationProperties.get(object);
            }

            @Override
            public int size() {
                return map.size() + Packet.this.invocationProperties.size();
            }

            @Override
            public boolean containsKey(Object object) {
                if (map.containsKey(object)) {
                    return true;
                }
                return Packet.this.invocationProperties.containsKey(object);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                final Set set = map.entrySet();
                final Set<Map.Entry<String, Object>> set2 = Packet.this.invocationProperties.entrySet();
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        final Iterator iterator = set.iterator();
                        final Iterator iterator2 = set2.iterator();
                        return new Iterator<Map.Entry<String, Object>>(){

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext() || iterator2.hasNext();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                if (iterator.hasNext()) {
                                    return (Map.Entry)iterator.next();
                                }
                                return (Map.Entry)iterator2.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.size() + Packet.this.invocationProperties.size();
                    }
                };
            }

            @Override
            public Object put(String string, Object object) {
                if (Packet.this.supports(string)) {
                    return map.put(string, object);
                }
                return Packet.this.invocationProperties.put(string, object);
            }

            @Override
            public void clear() {
                map.clear();
                Packet.this.invocationProperties.clear();
            }

            @Override
            public Object remove(Object object) {
                if (Packet.this.supports(object)) {
                    return map.remove(object);
                }
                return Packet.this.invocationProperties.remove(object);
            }
        };
    }

    @Override
    public SOAPMessage getSOAPMessage() throws SOAPException {
        return this.getAsSOAPMessage();
    }

    @Override
    public SOAPMessage getAsSOAPMessage() throws SOAPException {
        Message message = this.getMessage();
        if (message == null) {
            return null;
        }
        if (message instanceof MessageWritable) {
            ((MessageWritable)((Object)message)).setMTOMConfiguration(this.mtomFeature);
        }
        return message.readAsSOAPMessage(this, this.getState().isInbound());
    }

    public Codec getCodec() {
        WSBinding wSBinding;
        if (this.codec != null) {
            return this.codec;
        }
        if (this.endpoint != null) {
            this.codec = this.endpoint.createCodec();
        }
        if ((wSBinding = this.getBinding()) != null) {
            this.codec = wSBinding.getBindingId().createEncoder(wSBinding);
        }
        return this.codec;
    }

    @Override
    public ContentType writeTo(OutputStream outputStream) throws IOException {
        Message message = this.getInternalMessage();
        if (message instanceof MessageWritable) {
            ((MessageWritable)((Object)message)).setMTOMConfiguration(this.mtomFeature);
            return ((MessageWritable)((Object)message)).writeTo(outputStream);
        }
        return this.getCodec().encode(this, outputStream);
    }

    public ContentType writeTo(WritableByteChannel writableByteChannel) {
        return this.getCodec().encode(this, writableByteChannel);
    }

    public Boolean getMtomRequest() {
        return this.mtomRequest;
    }

    public void setMtomRequest(Boolean bl) {
        this.mtomRequest = bl;
    }

    public Boolean getMtomAcceptable() {
        return this.mtomAcceptable;
    }

    public void checkMtomAcceptable() {
        if (this.checkMtomAcceptable == null) {
            this.checkMtomAcceptable = this.acceptableMimeTypes == null || this.isFastInfosetDisabled ? Boolean.valueOf(false) : Boolean.valueOf(this.acceptableMimeTypes.indexOf("application/xop+xml") != -1);
        }
        this.mtomAcceptable = this.checkMtomAcceptable;
    }

    public Boolean getFastInfosetAcceptable(String string) {
        if (this.fastInfosetAcceptable == null) {
            this.fastInfosetAcceptable = this.acceptableMimeTypes == null || this.isFastInfosetDisabled ? Boolean.valueOf(false) : Boolean.valueOf(this.acceptableMimeTypes.indexOf(string) != -1);
        }
        return this.fastInfosetAcceptable;
    }

    public void setMtomFeature(MTOMFeature mTOMFeature) {
        this.mtomFeature = mTOMFeature;
    }

    public MTOMFeature getMtomFeature() {
        WSBinding wSBinding = this.getBinding();
        if (wSBinding != null) {
            return wSBinding.getFeature(MTOMFeature.class);
        }
        return this.mtomFeature;
    }

    @Override
    public ContentType getContentType() {
        if (this.contentType == null) {
            this.contentType = this.getInternalContentType();
        }
        if (this.contentType == null) {
            this.contentType = this.getCodec().getStaticContentType(this);
        }
        if (this.contentType == null) {
            // empty if block
        }
        return this.contentType;
    }

    public ContentType getInternalContentType() {
        Message message = this.getInternalMessage();
        if (message instanceof MessageWritable) {
            return ((MessageWritable)((Object)message)).getContentType();
        }
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean shouldUseMtom() {
        if (this.getState().isInbound()) {
            return this.isMtomContentType();
        }
        return this.shouldUseMtomOutbound();
    }

    private boolean shouldUseMtomOutbound() {
        MTOMFeature mTOMFeature = this.getMtomFeature();
        if (mTOMFeature != null && mTOMFeature.isEnabled()) {
            if (this.getMtomAcceptable() == null && this.getMtomRequest() == null) {
                return true;
            }
            if (this.getMtomAcceptable() != null && this.getMtomAcceptable().booleanValue() && this.getState().equals((Object)State.ServerResponse)) {
                return true;
            }
            if (this.getMtomRequest() != null && this.getMtomRequest().booleanValue() && this.getState().equals((Object)State.ServerResponse)) {
                return true;
            }
            if (this.getMtomRequest() != null && this.getMtomRequest().booleanValue() && this.getState().equals((Object)State.ClientRequest)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMtomContentType() {
        return this.getInternalContentType() != null && this.getInternalContentType().getContentType().contains("application/xop+xml");
    }

    public void addSatellite(@NotNull PropertySet propertySet) {
        super.addSatellite(propertySet);
    }

    public void addSatellite(@NotNull Class clazz, @NotNull PropertySet propertySet) {
        super.addSatellite(clazz, propertySet);
    }

    public void copySatelliteInto(@NotNull DistributedPropertySet distributedPropertySet) {
        super.copySatelliteInto(distributedPropertySet);
    }

    public void removeSatellite(PropertySet propertySet) {
        super.removeSatellite(propertySet);
    }

    public void setFastInfosetDisabled(boolean bl) {
        this.isFastInfosetDisabled = bl;
    }

    public static enum State {
        ServerRequest(true),
        ClientRequest(false),
        ServerResponse(false),
        ClientResponse(true);

        private boolean inbound;

        private State(boolean bl) {
            this.inbound = bl;
        }

        public boolean isInbound() {
            return this.inbound;
        }
    }

    public static enum Status {
        Request,
        Response,
        Unknown;


        public boolean isRequest() {
            return Request.equals((Object)this);
        }

        public boolean isResponse() {
            return Response.equals((Object)this);
        }
    }
}

