/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private HashMap loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public JavaClass findClass(String string) {
        if (this.loadedClasses.containsKey(string)) {
            return (JavaClass)this.loadedClasses.get(string);
        }
        return null;
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            InputStream inputStream = this.loader.getResourceAsStream(string2 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string + " not found.");
            }
            ClassParser classParser = new ClassParser(inputStream, string);
            javaClass = classParser.parse();
            this.storeClass(javaClass);
            return javaClass;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

