/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Shop;
import data.Tileset;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import mastersystem.Renderer;

public class ItemPanel
extends JPanel {
    private BufferedImage image = new BufferedImage(24, 24, 1);
    private Color[] colors = new Color[32];
    private int[] vram;
    private Shop shop;
    private Shop.ItemHandle item;
    private Tileset tileset;
    private Palette palette;
    private final ChangeListener shopChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            ItemPanel.this.update();
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(ItemPanel.this.tileset) < 256) {
                ItemPanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(ItemPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = ItemPanel.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((ItemPanel)ItemPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = ItemPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((ItemPanel)ItemPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            ItemPanel.this.update();
        }
    };

    public ItemPanel(int[] nArray, Shop shop, Shop.ItemHandle itemHandle, Tileset tileset, Palette palette) {
        this.setItem(nArray, shop, itemHandle, tileset, palette);
    }

    public void setItem(int[] nArray, Shop shop, Shop.ItemHandle itemHandle, Tileset tileset, Palette palette) {
        if (this.shop != null && this.shop != shop) {
            this.shop.removeChangeListener(this.shopChangeListener);
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.shop = shop;
        this.item = itemHandle;
        this.tileset = tileset;
        this.palette = palette;
        this.vram = nArray;
        int n = 0;
        int[] nArray2 = palette.getColors();
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        this.setPreferredSize(new Dimension(this.image.getWidth() * 2, this.image.getHeight() * 2));
        this.setSize(this.getPreferredSize());
        shop.addChangeListener(this.shopChangeListener);
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    private void update() {
        int[] nArray = this.shop.getItemNameTable(this.item);
        Graphics2D graphics2D = this.image.createGraphics();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = n * 6 + n2 * 2;
                Renderer.renderCharacter(this.vram, (nArray[n3 | 1] & 0xF) << 8 | nArray[n3], n2 * 8, n * 8, this.colors, graphics2D);
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.drawImage(this.image, 0, 0, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, null);
        graphics.translate(-insets.left, -insets.top);
    }
}

