/*
 * Decompiled with CFR 0.152.
 */
package miracleworld;

import changes.Change;
import changes.ChangeListener;
import common.MenuItem;
import common.Properties;
import data.CompressedTiles;
import data.Level;
import data.LevelPalette;
import data.LevelSpriteTileset;
import data.LevelTileset;
import data.MetaTileset;
import data.NameTable;
import data.Palette;
import data.Shop;
import data.Sound;
import data.SpriteContainer;
import data.SpriteTileset;
import data.TextData;
import data.Tiles;
import data.Tileset;
import editor.Z80Factory;
import editormodels.GameDataModel;
import editormodels.GameEditorModel;
import editormodels.GameEditorModelManager;
import editors.BoxContentEditor;
import editors.FileChooser;
import editors.GameSettingsEditor;
import editors.JankenMatchEditor;
import editors.KiddEd;
import editors.LevelSettingsEditor;
import editors.MetaTilesetEditor;
import editors.ModifyEntityDialog;
import editors.NameTableEditor;
import editors.PaletteEditor;
import editors.PhysicsEditor;
import editors.RiddleEditor;
import editors.ShopEditor;
import editors.SoundEditor;
import editors.SpriteEditor;
import editors.SpriteTilesetEditor;
import editors.TextEditor;
import editors.TextProvider;
import editors.TileEditor;
import editors.TilesetEditor;
import editors.TitleScreenEditor;
import gsengine.GSEngineExporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import miracleworld.MiracleWorldAddresses;
import miracleworld.MiracleWorldDataModel;
import miracleworld.data.MiracleWorldMetaTileset;
import panels.LevelPanel;
import panels.MetaTilesetPanel;
import rom.RomManager;
import transactions.TransactionManager;
import widgets.EntityList;
import widgets.MetaTileIcon;
import widgets.ScalableIcon;
import widgets.SpriteIcon;

public class MiracleWorldEditorModel
implements GameEditorModel,
MiracleWorldAddresses {
    private final JFrame window;
    private MiracleWorldDataModel dataModel;
    private LevelPanel levelPanel;
    private MetaTilesetPanel metaTilesetPanel;
    private EntityList entityList;
    private JPanel east;
    private JComboBox<String> levelSelection;
    private JButton eraseButton;
    private JToggleButton addHiddenTilesButton;
    private JToggleButton removeHiddenTilesButton;
    private JToggleButton buttonEntityEditing;
    private JToggleButton buttonLayoutEditing;
    public static final String NAME_ICON_LAYOUT_EDITING = "ICON_LAYOUT_EDITING";
    private static final MetaTileIcon ICON_LAYOUT_EDITING = new MetaTileIcon();
    public static final String NAME_ICON_ENTITY_EDITING = "ICON_ENTITY_EDITING";
    private static final SpriteIcon ICON_ENTITY_EDITING = new SpriteIcon();
    private static final MetaTileIcon ICON_ADD_HIDDEN_TILES = new MetaTileIcon();
    private static final MetaTileIcon ICON_REMOVE_HIDDEN_TILES = new MetaTileIcon();
    public static final String NAME_ICON_ERASE = "ICON_ERASE";
    private static final SpriteIcon ICON_ERASE = new SpriteIcon();
    public static final String[] LEVEL_NAMES = new String[19];

    public MiracleWorldEditorModel(final JFrame jFrame) {
        this.window = jFrame;
        int n = 0;
        while (n < 17) {
            MiracleWorldEditorModel.LEVEL_NAMES[n] = String.format("%s %02X: %s", TextProvider.get("Level"), n + 1, TextProvider.get("LevelName" + n));
            ++n;
        }
        MiracleWorldEditorModel.LEVEL_NAMES[17] = TextProvider.get("LevelNameBonus");
        MiracleWorldEditorModel.LEVEL_NAMES[18] = String.valueOf(TextProvider.get("LevelName16")) + " " + TextProvider.get("LevelNameBonus");
        jFrame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 65: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                MiracleWorldEditorModel.this.dataModel.addAdditionalTileset();
                            }
                        });
                        break;
                    }
                    case 76: {
                        if (keyEvent.isControlDown() && keyEvent.isAltDown() && keyEvent.isShiftDown()) {
                            final Level[] levelArray = MiracleWorldEditorModel.this.dataModel.getLevels();
                            TransactionManager.getInstance().runTransaction(new Runnable(){

                                @Override
                                public void run() {
                                    levelArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()].moveTo(KiddEd.findFreeBlock(16384, true));
                                }
                            });
                            break;
                        }
                        if (keyEvent.isControlDown()) {
                            MiracleWorldEditorModel.this.levelPanel.printLevelData();
                            break;
                        }
                        MiracleWorldEditorModel.this.levelPanel.printLevelDescriptor();
                        break;
                    }
                    case 84: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        NameTable[] nameTableArray = MiracleWorldEditorModel.this.dataModel.getTitleScreenNameTables();
                        MiracleWorldEditorModel.this.dataModel.resizeTitleScreenNameTable(0, 1, 1);
                        int n = 1;
                        while (n < nameTableArray.length) {
                            MiracleWorldEditorModel.this.dataModel.resizeTitleScreenNameTable(n, 31, 24);
                            nameTableArray[n].setDestination(14338);
                            ++n;
                        }
                        break;
                    }
                    case 77: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        MiracleWorldEditorModel.this.dataModel.relocateMapTiles();
                        break;
                    }
                    case 71: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        Palette[] paletteArray = MiracleWorldEditorModel.this.dataModel.getPalettes();
                        int n = 0;
                        while (n < 17) {
                            Palette palette = paletteArray[n];
                            palette.setColor(0, palette.getColors()[0]);
                            ++n;
                        }
                        n = KiddEd.findFreeBlock(1088);
                        if (n < 0) {
                            return;
                        }
                        RomManager.StaticAccess.writeByte(4352, n / 16384);
                        RomManager.StaticAccess.writeByte(4367, 64);
                        int n2 = 4370;
                        int n3 = 0;
                        while (n3 < 17) {
                            int n4 = n;
                            int[] nArray = paletteArray[n3].getColors();
                            int n5 = nArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                int n7 = nArray[n6];
                                RomManager.StaticAccess.writeWord(n4, ((n7 & 0x30) << 4) * 5 | ((n7 & 0xC) << 2) * 5 | (n7 & 3) * 5);
                                n4 += 2;
                                ++n6;
                            }
                            RomManager.StaticAccess.writeWord(n2, 0x8000 | n & 0x3FFF);
                            n2 += 2;
                            n = n4;
                            ++n3;
                        }
                        break;
                    }
                    case 69: {
                        MiracleWorldEditorModel.this.levelPanel.printEntityData();
                        break;
                    }
                    case 80: {
                        MiracleWorldEditorModel.this.levelPanel.printPointers();
                        break;
                    }
                    case 39: {
                        MiracleWorldEditorModel.this.levelPanel.increaseHorizontalScreenNumber();
                        break;
                    }
                    case 37: {
                        MiracleWorldEditorModel.this.levelPanel.decreaseHorizontalScreenNumber();
                        break;
                    }
                    case 38: {
                        MiracleWorldEditorModel.this.levelPanel.decreaseVerticalScreenNumber();
                        break;
                    }
                    case 40: {
                        MiracleWorldEditorModel.this.levelPanel.increaseVerticalScreenNumber();
                        break;
                    }
                    case 36: {
                        MiracleWorldEditorModel.this.levelPanel.resetScreenNumbers();
                        break;
                    }
                    case 127: {
                        if (keyEvent.isShiftDown()) {
                            MiracleWorldEditorModel.this.levelPanel.removeCurrentScreen();
                            break;
                        }
                        MiracleWorldEditorModel.this.levelPanel.removeSelectedEntity();
                    }
                }
            }
        });
        jFrame.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(MiracleWorldEditorModel.this.levelPanel.getScale() + 1.5f));
                        MiracleWorldEditorModel.this.levelPanel.setPreferredScale(f);
                        jFrame.pack();
                    } else if ((mouseWheelEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        if (mouseWheelEvent.isShiftDown()) {
                            MiracleWorldEditorModel.this.levelPanel.decreaseHorizontalScreenNumber();
                        }
                        MiracleWorldEditorModel.this.levelPanel.decreaseHorizontalScreenNumber();
                    } else {
                        if (mouseWheelEvent.isShiftDown()) {
                            MiracleWorldEditorModel.this.levelPanel.decreaseVerticalScreenNumber();
                        }
                        MiracleWorldEditorModel.this.levelPanel.decreaseVerticalScreenNumber();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(MiracleWorldEditorModel.this.levelPanel.getScale() - 0.5f));
                        MiracleWorldEditorModel.this.levelPanel.setPreferredScale(f);
                        jFrame.pack();
                    } else if ((mouseWheelEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        if (mouseWheelEvent.isShiftDown()) {
                            MiracleWorldEditorModel.this.levelPanel.increaseHorizontalScreenNumber();
                        }
                        MiracleWorldEditorModel.this.levelPanel.increaseHorizontalScreenNumber();
                    } else {
                        if (mouseWheelEvent.isShiftDown()) {
                            MiracleWorldEditorModel.this.levelPanel.increaseVerticalScreenNumber();
                        }
                        MiracleWorldEditorModel.this.levelPanel.increaseVerticalScreenNumber();
                    }
                }
                mouseWheelEvent.consume();
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (!jFrame.isFocused()) {
                    return false;
                }
                if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16) {
                    if (keyEvent.getKeyCode() == 16) {
                        MiracleWorldEditorModel.this.addHiddenTilesButton.setSelected(MiracleWorldEditorModel.this.levelPanel.isEditHiddenTiles() && keyEvent.isShiftDown());
                        MiracleWorldEditorModel.this.removeHiddenTilesButton.setSelected(MiracleWorldEditorModel.this.levelPanel.isEditHiddenTiles() && !keyEvent.isShiftDown());
                    } else {
                        MiracleWorldEditorModel.this.addHiddenTilesButton.setSelected((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && keyEvent.isShiftDown());
                        MiracleWorldEditorModel.this.removeHiddenTilesButton.setSelected((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && !keyEvent.isShiftDown());
                    }
                    MiracleWorldEditorModel.this.levelPanel.setEditHiddenTiles(MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected() || MiracleWorldEditorModel.this.removeHiddenTilesButton.isSelected(), MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected());
                }
                if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 401) {
                    if (MiracleWorldEditorModel.this.buttonEntityEditing.isSelected()) {
                        MiracleWorldEditorModel.this.buttonLayoutEditing.doClick();
                    } else if (MiracleWorldEditorModel.this.buttonLayoutEditing.isSelected()) {
                        MiracleWorldEditorModel.this.buttonEntityEditing.doClick();
                    }
                }
                return false;
            }
        });
    }

    @Override
    public GameDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void createDataModel() {
        this.dataModel = new MiracleWorldDataModel();
    }

    @Override
    public List<MenuItem> getEditorMenuItems() {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        MenuItem menuItem = new MenuItem(TextProvider.get("MenuPalette"), 112);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.openPaletteEditor(MiracleWorldEditorModel.this.dataModel.getPalettes());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuTile"), 116);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.openTileEditor(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getTiles(), MiracleWorldEditorModel.this.dataModel.getPalettes(), MiracleWorldEditorModel.getSelectedLevelNumber(), new int[][]{new int[1]});
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuTileset"), 105);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.openTilesetEditor();
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuSpriteTileset"), 114);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.openSpriteTilesetEditor();
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuMetaTileset"), 109);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaTilesetEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getMetaTilesets(), MiracleWorldEditorModel.this.dataModel.getLevelTilesets(), MiracleWorldEditorModel.this.dataModel.getPalettes(), MiracleWorldEditorModel.getSelectedLevelNumber(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuSprite"), 115);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.openSpriteEditor();
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuBoxContent"), 98);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getLevelTilesets();
                LevelPalette[] levelPaletteArray = MiracleWorldEditorModel.this.dataModel.getLevelPalettes();
                BoxContentEditor.open(MiracleWorldEditorModel.this.window, 3543, 3632, 9876, (LevelSpriteTileset)tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], MiracleWorldEditorModel.getSelectedLevelNumber(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuGameSettings"), 103);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameSettingsEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getInitialValues(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuLevelSettings"), 108);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelSettingsEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getLevels(), MiracleWorldEditorModel.this.dataModel.getShop(), MiracleWorldEditorModel.this.dataModel.getSound(), MiracleWorldEditorModel.this.getSelectedLevelIndex(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuNameTable"), 110);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.openNameTableEditor(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getNameTables(), MiracleWorldEditorModel.this.dataModel.getNameTableTilesets(), MiracleWorldEditorModel.this.dataModel.getNameTablePalettes());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuTitleScreen"), 99);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getNameTableTilesets();
                Palette[] paletteArray = MiracleWorldEditorModel.this.dataModel.getNameTablePalettes();
                Tiles[] tilesArray = MiracleWorldEditorModel.this.dataModel.getTiles();
                CompressedTiles[] compressedTilesArray = MiracleWorldEditorModel.this.dataModel.getJankenMatchTiles();
                TitleScreenEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getTitleScreen(), tilesetArray[0], paletteArray[0], MiracleWorldEditorModel.this.dataModel.getTitleScreenNameTables(), tilesArray[0], compressedTilesArray[1], MiracleWorldEditorModel.this.dataModel.getSprites(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuShop"), 104);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getNameTableTilesets();
                Palette[] paletteArray = MiracleWorldEditorModel.this.dataModel.getNameTablePalettes();
                NameTable[] nameTableArray = MiracleWorldEditorModel.this.dataModel.getNameTables();
                NameTable[] nameTableArray2 = MiracleWorldEditorModel.this.dataModel.getTitleScreenNameTables();
                Tiles[] tilesArray = MiracleWorldEditorModel.this.dataModel.getTiles();
                ShopEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getShop(), tilesetArray[1], paletteArray[1], nameTableArray[nameTableArray2.length], tilesArray[2], KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuJankenMatch"), 106);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelPalette[] levelPaletteArray = MiracleWorldEditorModel.this.dataModel.getLevelPalettes();
                JankenMatchEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getJankenMatch(), MiracleWorldEditorModel.this.dataModel.getJankenMatchTiles(), levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], MiracleWorldEditorModel.this.dataModel.getTextData(), 9876, KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuRiddle"), 100);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tiles[] tilesArray = MiracleWorldEditorModel.this.dataModel.getTiles();
                MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = MiracleWorldEditorModel.this.dataModel.getMetaTilesets();
                Palette[] paletteArray = MiracleWorldEditorModel.this.dataModel.getPalettes();
                RiddleEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getRiddle(), tilesArray[3], miracleWorldMetaTilesetArray[16], paletteArray[16], KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuText"), 120);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getLevelTilesets();
                LevelPalette[] levelPaletteArray = MiracleWorldEditorModel.this.dataModel.getLevelPalettes();
                Tiles[] tilesArray = MiracleWorldEditorModel.this.dataModel.getTiles();
                CompressedTiles[] compressedTilesArray = MiracleWorldEditorModel.this.dataModel.getLevelMainTilesets();
                Tiles[] tilesArray2 = MiracleWorldEditorModel.this.dataModel.getLevelAdditionalTilesets();
                TextEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getTextData(), tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], tilesArray[7 + compressedTilesArray.length + tilesArray2.length + 6], KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuPhysics"), 121);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PhysicsEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getPhysics(), KiddEd.getProperties());
            }
        });
        menuItem = new MenuItem(TextProvider.get("MenuSound"), 111);
        arrayList.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundEditor.open(MiracleWorldEditorModel.this.window, MiracleWorldEditorModel.this.dataModel.getSound(), 38991, KiddEd.getProperties());
            }
        });
        return arrayList;
    }

    @Override
    public List<MenuItem> getRunInEmulatorMenuItems() {
        MenuItem menuItem = new MenuItem(TextProvider.get("MenuRunROMinEmulatorAndStartLevel"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.runInEmulatorAndStartLevel();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        return Arrays.asList(menuItem);
    }

    @Override
    public List<MenuItem> getImportExportMenuItems() {
        MenuItem menuItem = new MenuItem(String.valueOf(TextProvider.get("MenuExportLevel")) + "...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MiracleWorldEditorModel.this.exportCurrentLevel(MiracleWorldEditorModel.this.showExportLevelChooser(MiracleWorldEditorModel.this.window));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MiracleWorldEditorModel.this.window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                }
            }
        });
        return Arrays.asList(new MenuItem[0]);
    }

    @Override
    public void installEditMenuItems(JMenu jMenu) {
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuStartScreen"), 115);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.setStartScreen();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuCopyEntity"), 99);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.copySelectedEntityToClipboard();
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem3 = new MenuItem(TextProvider.get("MenuPasteEntity"), 112);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.pasteEntityFromClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("MenuRemoveEntity"), 109);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.removeSelectedEntity();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        jMenu.addSeparator();
        final MenuItem menuItem5 = new MenuItem(TextProvider.get("MenuCopyLayout"), 121);
        jMenu.add(menuItem5);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.copyLayoutToClipboard();
            }
        });
        menuItem5.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        final MenuItem menuItem6 = new MenuItem(TextProvider.get("MenuPasteLayout"), 108);
        jMenu.add(menuItem6);
        menuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.pasteLayoutFromClipboard();
            }
        });
        menuItem6.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        jMenu.addSeparator();
        final MenuItem menuItem7 = new MenuItem(TextProvider.get("MenuCopyScreen"), 111);
        jMenu.add(menuItem7);
        menuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.copyCurrentScreenToClipboard();
            }
        });
        menuItem7.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem8 = new MenuItem(TextProvider.get("MenuPasteScreen"), 115);
        jMenu.add(menuItem8);
        menuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.pasteScreenFromClipboard();
            }
        });
        menuItem8.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem9 = new MenuItem(TextProvider.get("MenuAddScreen"), 97);
        jMenu.add(menuItem9);
        menuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.addScreen();
            }
        });
        menuItem9.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem10 = new MenuItem(TextProvider.get("MenuRemoveScreen"), 118);
        jMenu.add(menuItem10);
        menuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.removeCurrentScreen();
            }
        });
        menuItem10.setAccelerator(KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(MiracleWorldEditorModel.this.levelPanel.canSetStartScreen());
                menuItem7.setEnabled(MiracleWorldEditorModel.this.levelPanel.canCopyCurrentScreenToClipboard());
                menuItem8.setEnabled(MiracleWorldEditorModel.this.levelPanel.canPasteScreenFromClipboard());
                menuItem5.setEnabled(MiracleWorldEditorModel.this.levelPanel.canCopyLayoutToClipboard());
                menuItem6.setEnabled(MiracleWorldEditorModel.this.levelPanel.canPasteLayoutFromClipboard());
                menuItem9.setEnabled(MiracleWorldEditorModel.this.levelPanel.canAddScreen());
                menuItem10.setEnabled(MiracleWorldEditorModel.this.levelPanel.canRemoveCurrentScreen());
                menuItem2.setEnabled(MiracleWorldEditorModel.this.levelPanel.canCopySelectedEntity());
                menuItem3.setEnabled(MiracleWorldEditorModel.this.levelPanel.canPasteEntityFromClipboard());
                menuItem4.setEnabled(MiracleWorldEditorModel.this.levelPanel.canRemoveSelectedEntity());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem7.setEnabled(true);
                menuItem8.setEnabled(true);
                menuItem5.setEnabled(true);
                menuItem6.setEnabled(true);
                menuItem9.setEnabled(true);
                menuItem10.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem3.setEnabled(true);
                menuItem4.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private void exportCurrentLevel(File file) {
        int n = this.getSelectedLevelIndex();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = this.dataModel.getMetaTilesets();
        Level[] levelArray = this.dataModel.getLevels();
        GSEngineExporter.export(file, levelPaletteArray[n], tilesetArray[n * 2], miracleWorldMetaTilesetArray[this.dataModel.getLevelNumber(n)], levelArray[n]);
    }

    public static void openAlexTileEditor(JFrame jFrame, int[][] nArray, Palette palette) {
        Tiles[] tilesArray = MiracleWorldEditorModel.getInstance().dataModel.getTiles();
        MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{tilesArray[0]}, new Palette[]{palette}, 0, nArray);
    }

    public static void openSpriteTileEditor(JFrame jFrame, Tileset tileset, int[][] nArray, Palette palette) {
        MiracleWorldDataModel miracleWorldDataModel = MiracleWorldEditorModel.getInstance().dataModel;
        Tiles[] tilesArray = miracleWorldDataModel.getTiles();
        CompressedTiles[] compressedTilesArray = miracleWorldDataModel.getJankenMatchTiles();
        CompressedTiles[] compressedTilesArray2 = miracleWorldDataModel.getLevelMainTilesets();
        Tiles[] tilesArray2 = miracleWorldDataModel.getLevelAdditionalTilesets();
        if (tileset.getSource() >= tilesArray[1].getSource() && tileset.getSource() < tilesArray[1].getSource() + tilesArray[1].getLength()) {
            MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{tilesArray[1]}, new Palette[]{palette}, 0, tileset.getTiles(nArray, tilesArray[1]));
        } else if (tileset.getSource() >= tilesArray[2].getSource() && tileset.getSource() < tilesArray[2].getSource() + tilesArray[2].getLength()) {
            MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{tilesArray[2]}, new Palette[]{palette}, 0, tileset.getTiles(nArray, tilesArray[2]));
        } else {
            CompressedTiles compressedTiles = null;
            CompressedTiles[] compressedTilesArray3 = compressedTilesArray;
            int n = compressedTilesArray.length;
            int n2 = 0;
            while (n2 < n) {
                CompressedTiles compressedTiles2 = compressedTilesArray3[n2];
                if (tileset.getSource() >= ((Tiles)compressedTiles2).getSource() && tileset.getSource() < ((Tiles)compressedTiles2).getSource() + ((Tiles)compressedTiles2).getLength() && (compressedTiles == null || ((Tiles)compressedTiles2).getSource() > ((Tiles)compressedTiles).getSource())) {
                    compressedTiles = compressedTiles2;
                }
                ++n2;
            }
            if (compressedTiles != null) {
                MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{compressedTiles}, new Palette[]{palette}, 0, tileset.getTiles(nArray, compressedTiles));
            } else if (tileset.getSource() >= tilesArray[7 + compressedTilesArray2.length + tilesArray2.length].getSource() && tileset.getSource() < tilesArray[7 + compressedTilesArray2.length + tilesArray2.length].getSource() + tilesArray[7 + compressedTilesArray2.length + tilesArray2.length].getLength()) {
                MiracleWorldEditorModel.openTileEditor(jFrame, new Tiles[]{tilesArray[7 + compressedTilesArray2.length + tilesArray2.length]}, new Palette[]{palette}, 0, tileset.getTiles(nArray, tilesArray[7 + compressedTilesArray2.length + tilesArray2.length]));
            }
        }
    }

    public static void openTileEditor(JFrame jFrame, Tiles[] tilesArray, Palette[] paletteArray, int n, int[][] nArray) {
        String[] stringArray = new String[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 6];
        stringArray[0] = TextProvider.get("AlexKidd");
        stringArray[1] = TextProvider.get("Sprites");
        stringArray[2] = TextProvider.get("Items");
        stringArray[3] = TextProvider.get("Boxes");
        stringArray[4] = TextProvider.get("Liquids");
        stringArray[5] = TextProvider.get("Digits");
        stringArray[6] = TextProvider.get("CloudAndCoinBag");
        int n2 = 0;
        while (n2 < MiracleWorldEditorModel.getNumLevelMainTilesets()) {
            stringArray[7 + n2] = String.valueOf(TextProvider.get("LevelMainTileset")) + " " + (n2 + 1);
            ++n2;
        }
        n2 = 0;
        while (n2 < MiracleWorldEditorModel.getNumLevelAdditionalTilesets()) {
            stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + n2] = String.valueOf(TextProvider.get("LevelAdditionalTileset")) + " " + (n2 + 1);
            ++n2;
        }
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets()] = TextProvider.get("AlexEating");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 1] = TextProvider.get("TilesScore");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 2] = TextProvider.get("HirottaStone");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 3] = TextProvider.get("Shop");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 4] = TextProvider.get("ShopExit");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 5] = TextProvider.get("Map");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 6] = TextProvider.get("Font");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 7] = TextProvider.get("TitleScreen");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8] = TextProvider.get("JankenMatch");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 1] = TextProvider.get("Janken");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 2] = TextProvider.get("StoneHead");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 3] = TextProvider.get("ScissorsHead");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 4] = TextProvider.get("PaperHead");
        stringArray[7 + MiracleWorldEditorModel.getNumLevelMainTilesets() + MiracleWorldEditorModel.getNumLevelAdditionalTilesets() + 8 + 5] = TextProvider.get("JankenPetrified");
        String[] stringArray2 = new String[21];
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = String.format("%s %02X %s", TextProvider.get("Level"), n3 + 1, TextProvider.get("Palette"));
            ++n3;
        }
        stringArray2[17] = TextProvider.get("PaletteTitleScreen");
        stringArray2[18] = TextProvider.get("PaletteShop");
        stringArray2[19] = TextProvider.get("PaletteMap");
        stringArray2[20] = TextProvider.get("PaletteHirotta");
        TileEditor.open(jFrame, tilesArray, paletteArray, n, nArray, stringArray, stringArray2, KiddEd.getProperties());
    }

    public static void openNameTableEditor(JFrame jFrame, NameTable[] nameTableArray, Tileset[] tilesetArray, Palette[] paletteArray) {
        String[] stringArray = new String[MiracleWorldEditorModel.getNumTitleScreenNameTables() + 4];
        int n = 0;
        while (n < MiracleWorldEditorModel.getNumTitleScreenNameTables()) {
            stringArray[n] = TextProvider.get("NameTableTitleScreen" + n);
            ++n;
        }
        stringArray[MiracleWorldEditorModel.getNumTitleScreenNameTables()] = TextProvider.get("NameTableShop");
        stringArray[MiracleWorldEditorModel.getNumTitleScreenNameTables() + 1] = TextProvider.get("NameTableShopExit");
        stringArray[MiracleWorldEditorModel.getNumTitleScreenNameTables() + 2] = TextProvider.get("NameTableMap");
        stringArray[MiracleWorldEditorModel.getNumTitleScreenNameTables() + 3] = TextProvider.get("NameTableHirotta");
        NameTableEditor.open(jFrame, nameTableArray, tilesetArray, paletteArray, stringArray, KiddEd.getProperties());
    }

    private void openSpriteEditor() {
        this.dataModel.combineSpriteTilesets();
        SpriteTileset[] spriteTilesetArray = this.dataModel.getSpriteTilesets();
        CompressedTiles[] compressedTilesArray = this.dataModel.getJankenMatchTiles();
        Tiles[] tilesArray = this.dataModel.getTiles();
        CompressedTiles[] compressedTilesArray2 = this.dataModel.getLevelMainTilesets();
        Tiles[] tilesArray2 = this.dataModel.getLevelAdditionalTilesets();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        Tileset[] tilesetArray = new Tileset[spriteTilesetArray.length + compressedTilesArray.length - 1 + 1 + 1];
        int n = 0;
        while (n < spriteTilesetArray.length) {
            tilesetArray[n] = spriteTilesetArray[n];
            ++n;
        }
        n = 1;
        while (n < compressedTilesArray.length) {
            Tileset tileset = new Tileset(compressedTilesArray[n]);
            tileset.addTiles(compressedTilesArray[0]);
            tilesetArray[spriteTilesetArray.length + n - 1] = tileset;
            ++n;
        }
        tilesetArray[spriteTilesetArray.length + compressedTilesArray.length - 1] = new Tileset(MiracleWorldDataModel.createPetrifiedJankenTiles(false));
        tilesetArray[spriteTilesetArray.length + compressedTilesArray.length] = new Tileset(tilesArray[7 + compressedTilesArray2.length + tilesArray2.length]);
        SpriteEditor.open(this.window, this.dataModel.getSprites(), levelPaletteArray[this.getSelectedLevelIndex()], tilesetArray, tilesArray[0], KiddEd.getProperties());
    }

    private void openTilesetEditor() {
        this.dataModel.combineSpriteTilesets();
        this.dataModel.enableLevelTilesetsPerLevel();
        TilesetEditor.open(this.window, this.dataModel.getTilesets(), this.dataModel.getLevelMainTilesets(), this.dataModel.getLevelAdditionalTilesets(), this.dataModel.getSpriteTilesets(), this.dataModel.getPalettes(), MiracleWorldEditorModel.getSelectedLevelNumber(), KiddEd.getProperties());
    }

    private void openSpriteTilesetEditor() {
        this.dataModel.combineSpriteTilesets();
        Palette[] paletteArray = this.dataModel.getPalettes();
        Tiles[] tilesArray = this.dataModel.getTiles();
        SpriteTilesetEditor.open(this.window, this.dataModel.getSpriteTilesets(), tilesArray[1], tilesArray[2], paletteArray[this.getSelectedLevelIndex()], KiddEd.getProperties());
    }

    public static void openModifyEntityDialog(JFrame jFrame, int[] nArray, int[] nArray2, boolean[] blArray, boolean bl, LevelSpriteTileset levelSpriteTileset, Palette palette) {
        ModifyEntityDialog.open(jFrame, nArray, nArray2, blArray, Level.getTopPrioritySlot(), bl, levelSpriteTileset, palette, 9876, KiddEd.getEntityLabelProvider());
    }

    private void openPaletteEditor(Palette[] paletteArray) {
        String[] stringArray = new String[24];
        int n = 0;
        while (n < 17) {
            stringArray[n] = String.format("%s %02X %s", TextProvider.get("Level"), n + 1, TextProvider.get("Palette"));
            ++n;
        }
        stringArray[17] = TextProvider.get("PaletteTitleScreen");
        stringArray[18] = TextProvider.get("PaletteShop");
        stringArray[19] = TextProvider.get("PaletteMap");
        stringArray[20] = TextProvider.get("PaletteHirotta");
        stringArray[21] = TextProvider.get("PaletteCycleTitleScreen");
        stringArray[22] = TextProvider.get("PaletteCycleWater");
        stringArray[23] = TextProvider.get("PaletteCycleInvincibility");
        PaletteEditor.open(this.window, paletteArray, MiracleWorldEditorModel.getSelectedLevelNumber(), stringArray, KiddEd.getProperties());
    }

    @Override
    public void reopenEditors() {
        Palette[] paletteArray = this.dataModel.getPalettes();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        Palette[] paletteArray2 = this.dataModel.getNameTablePalettes();
        Tiles[] tilesArray = this.dataModel.getTiles();
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        MetaTileset[] metaTilesetArray = this.dataModel.getMetaTilesets();
        NameTable[] nameTableArray = this.dataModel.getNameTables();
        Tiles[] tilesArray2 = this.dataModel.getJankenMatchTiles();
        Tileset[] tilesetArray2 = this.dataModel.getNameTableTilesets();
        CompressedTiles[] compressedTilesArray = this.dataModel.getLevelMainTilesets();
        Tiles[] tilesArray3 = this.dataModel.getLevelAdditionalTilesets();
        NameTable[] nameTableArray2 = this.dataModel.getTitleScreenNameTables();
        SpriteContainer[] spriteContainerArray = this.dataModel.getSprites();
        TextData textData = this.dataModel.getTextData();
        Shop shop = this.dataModel.getShop();
        Sound sound = this.dataModel.getSound();
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + BoxContentEditor.class.getSimpleName() + "Open"))) {
            BoxContentEditor.open(this.window, 3543, 3632, 9876, (LevelSpriteTileset)tilesetArray[this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[this.getSelectedLevelIndex()], MiracleWorldEditorModel.getSelectedLevelNumber(), KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + GameSettingsEditor.class.getSimpleName() + "Open"))) {
            GameSettingsEditor.open(this.window, this.dataModel.getInitialValues(), KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + JankenMatchEditor.class.getSimpleName() + "Open"))) {
            JankenMatchEditor.open(this.window, this.dataModel.getJankenMatch(), tilesArray2, levelPaletteArray[this.getSelectedLevelIndex()], textData, 9876, KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + LevelSettingsEditor.class.getSimpleName() + "Open"))) {
            LevelSettingsEditor.open(this.window, this.dataModel.getLevels(), shop, sound, this.getSelectedLevelIndex(), KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + MetaTilesetEditor.class.getSimpleName() + "Open"))) {
            MetaTilesetEditor.open(this.window, metaTilesetArray, tilesetArray, paletteArray, MiracleWorldEditorModel.getSelectedLevelNumber(), KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + NameTableEditor.class.getSimpleName() + "Open"))) {
            MiracleWorldEditorModel.openNameTableEditor(this.window, nameTableArray, tilesetArray2, paletteArray2);
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + PaletteEditor.class.getSimpleName() + "Open"))) {
            this.openPaletteEditor(paletteArray);
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + PhysicsEditor.class.getSimpleName() + "Open"))) {
            PhysicsEditor.open(this.window, this.dataModel.getPhysics(), KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + RiddleEditor.class.getSimpleName() + "Open"))) {
            RiddleEditor.open(this.window, this.dataModel.getRiddle(), tilesArray[3], metaTilesetArray[16], paletteArray[16], KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + ShopEditor.class.getSimpleName() + "Open"))) {
            ShopEditor.open(this.window, shop, tilesetArray2[1], paletteArray2[1], nameTableArray[nameTableArray2.length], tilesArray[2], KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + SoundEditor.class.getSimpleName() + "Open"))) {
            SoundEditor.open(this.window, sound, 38991, KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + SpriteEditor.class.getSimpleName() + "Open"))) {
            this.openSpriteEditor();
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + TextEditor.class.getSimpleName() + "Open"))) {
            TextEditor.open(this.window, textData, tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()], tilesArray[7 + compressedTilesArray.length + tilesArray3.length + 6], KiddEd.getProperties());
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + TileEditor.class.getSimpleName() + "Open"))) {
            MiracleWorldEditorModel.openTileEditor(this.window, tilesArray, paletteArray, MiracleWorldEditorModel.getSelectedLevelNumber(), new int[][]{new int[1]});
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + TilesetEditor.class.getSimpleName() + "Open"))) {
            this.openTilesetEditor();
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + SpriteTilesetEditor.class.getSimpleName() + "Open"))) {
            this.openSpriteTilesetEditor();
        }
        if (Boolean.parseBoolean(KiddEd.getProperties().getProperty("Window" + TitleScreenEditor.class.getSimpleName() + "Open"))) {
            TitleScreenEditor.open(this.window, this.dataModel.getTitleScreen(), tilesetArray2[0], paletteArray2[0], nameTableArray2, tilesArray[0], tilesArray2[1], spriteContainerArray, KiddEd.getProperties());
        }
        this.window.setVisible(true);
    }

    @Override
    public void destroyEditors() {
        this.saveEditorStates();
        BoxContentEditor.destroy();
        GameSettingsEditor.destroy();
        JankenMatchEditor.destroy();
        LevelSettingsEditor.destroy();
        MetaTilesetEditor.destroy();
        NameTableEditor.destroy();
        PaletteEditor.destroy();
        PhysicsEditor.destroy();
        RiddleEditor.destroy();
        ShopEditor.destroy();
        SoundEditor.destroy();
        SpriteEditor.destroy();
        TextEditor.destroy();
        TileEditor.destroy();
        TilesetEditor.destroy();
        SpriteTilesetEditor.destroy();
        TitleScreenEditor.destroy();
    }

    @Override
    public void closeEditors() {
        this.saveEditorStates();
        BoxContentEditor.close();
        GameSettingsEditor.close();
        JankenMatchEditor.close();
        LevelSettingsEditor.close();
        MetaTilesetEditor.close();
        NameTableEditor.close();
        PaletteEditor.close();
        PhysicsEditor.close();
        RiddleEditor.close();
        ShopEditor.close();
        SoundEditor.close();
        SpriteEditor.close();
        TextEditor.close();
        TileEditor.close();
        TilesetEditor.close();
        SpriteTilesetEditor.close();
        TitleScreenEditor.close();
    }

    @Override
    public void saveEditorStates() {
        try {
            Properties properties = KiddEd.getProperties();
            properties.setProperty("LevelPanelMode", "" + this.levelPanel.getMode());
            properties.setProperty("Level", "" + this.getSelectedLevelIndex());
            BoxContentEditor.saveState(properties);
            GameSettingsEditor.saveState(properties);
            JankenMatchEditor.saveState(properties);
            LevelSettingsEditor.saveState(properties);
            MetaTilesetEditor.saveState(properties);
            NameTableEditor.saveState(properties);
            PaletteEditor.saveState(properties);
            PhysicsEditor.saveState(properties);
            RiddleEditor.saveState(properties);
            ShopEditor.saveState(properties);
            SoundEditor.saveState(properties);
            SpriteEditor.saveState(properties);
            TextEditor.saveState(properties);
            TileEditor.saveState(properties);
            TilesetEditor.saveState(properties);
            SpriteTilesetEditor.saveState(properties);
            TitleScreenEditor.saveState(properties);
        }
        catch (Exception exception) {}
    }

    @Override
    public Runnable createAnimationUpdater() {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray, 2);
        nArray[49696] = 1;
        nArray[49701] = 1;
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        z80.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        tMS9918A.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                LevelPalette[] levelPaletteArray = MiracleWorldEditorModel.this.dataModel.getLevelPalettes();
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getLevelTilesets();
                if (n == 2) {
                    levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()].setDirty(n2 & 0x1F, tMS9918A.getCRAM()[n2 & 0x1F]);
                } else if (n == 3) {
                    tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2].setDirty(n2 & 0x3FFF, tMS9918A.getVRAM()[n2 & 0x3FFF]);
                }
            }
        });
        return new Runnable(){
            private ChangeListener liquidsChangeListener = new ChangeListener(){

                @Override
                public void changeOccurred(Change change) {
                    memoryDirty = true;
                }
            };
            private ChangeListener waterPaletteCycleChangeListener = new ChangeListener(){

                @Override
                public void changeOccurred(Change change) {
                    memoryDirty = true;
                }
            };
            private boolean memoryDirty;

            @Override
            public void run() {
                Tiles[] tilesArray = MiracleWorldEditorModel.this.dataModel.getTiles();
                Palette[] paletteArray = MiracleWorldEditorModel.this.dataModel.getPalettes();
                Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getLevelTilesets();
                tilesArray[4].addChangeListener(this.liquidsChangeListener);
                paletteArray[22].addChangeListener(this.waterPaletteCycleChangeListener);
                try {
                    while (true) {
                        long l;
                        long l2 = System.currentTimeMillis();
                        try {
                            z80.execute(RomManager.StaticAccess.readWord(3372 + MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2));
                            int n = RomManager.StaticAccess.readWord(5485 + MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2);
                            nArray[49699] = n & 0xFF;
                            nArray[49700] = n >> 8;
                            if (this.memoryDirty) {
                                RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
                                RomManager.StaticAccess.loadBank2(nArray, 2);
                            }
                            z80.execute(5519);
                            tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2].updateDirty();
                        }
                        catch (Exception exception) {}
                        if ((l = System.currentTimeMillis() - l2) >= 16L) continue;
                        Thread.sleep(16L - l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    paletteArray[22].removeChangeListener(this.waterPaletteCycleChangeListener);
                    tilesArray[4].removeChangeListener(this.liquidsChangeListener);
                    return;
                }
            }
        };
    }

    protected void updateLevelPanel() {
        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = this.dataModel.getMetaTilesets();
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        SpriteContainer[] spriteContainerArray = this.dataModel.getSprites();
        if (this.levelPanel == null) {
            Properties properties = KiddEd.getProperties();
            Level[] levelArray = this.dataModel.getLevels();
            JPanel jPanel = new JPanel(new BorderLayout());
            this.levelSelection = new JComboBox<String>(LEVEL_NAMES);
            int n = MiracleWorldEditorModel.getPropertyLevel();
            if (n < this.levelSelection.getItemCount() && levelArray[n].isValid()) {
                this.levelSelection.setSelectedIndex(n);
            }
            jPanel.add(this.levelSelection, "North");
            this.levelSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = MiracleWorldEditorModel.this.dataModel.getMetaTilesets();
                        Tileset[] tilesetArray = MiracleWorldEditorModel.this.dataModel.getLevelTilesets();
                        SpriteTileset[] spriteTilesetArray = MiracleWorldEditorModel.this.dataModel.getSpriteTilesets();
                        LevelPalette[] levelPaletteArray = MiracleWorldEditorModel.this.dataModel.getLevelPalettes();
                        SpriteContainer[] spriteContainerArray = MiracleWorldEditorModel.this.dataModel.getSprites();
                        MiracleWorldEditorModel.this.levelPanel.setLevel(MiracleWorldEditorModel.this.getSelectedLevel(), miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], (LevelSpriteTileset)tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], spriteContainerArray);
                        MiracleWorldEditorModel.this.metaTilesetPanel.setTileset(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()]);
                        MiracleWorldEditorModel.this.entityList.setTileset((LevelSpriteTileset)tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], spriteTilesetArray, spriteContainerArray);
                        ICON_LAYOUT_EDITING.setMetaTile(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()].getMetaTile(3), tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()]);
                        ICON_ADD_HIDDEN_TILES.setMetaTile(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()].getMetaTile(4), tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()]);
                        ICON_REMOVE_HIDDEN_TILES.setMetaTile(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()].getMetaTile(8), tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()]);
                        int n = 0;
                        while (n < spriteContainerArray.length) {
                            if (spriteContainerArray[n].isAlexSprite()) {
                                ICON_ENTITY_EDITING.setSprite(spriteContainerArray[n], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2 + 1]);
                                break;
                            }
                            ++n;
                        }
                        ICON_ERASE.setSprite(spriteContainerArray[20], levelPaletteArray[MiracleWorldEditorModel.this.getSelectedLevelIndex()], tilesetArray[MiracleWorldEditorModel.this.getSelectedLevelIndex() * 2 + 1]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (MiracleWorldEditorModel.this.getSelectedLevelIndex() > 0) {
                            MiracleWorldEditorModel.this.levelSelection.setSelectedIndex(MiracleWorldEditorModel.this.getSelectedLevelIndex() - 1);
                        } else {
                            MiracleWorldEditorModel.this.levelSelection.setSelectedIndex(1);
                        }
                        this.actionPerformed(actionEvent);
                    }
                    LevelSettingsEditor.setSelectedLevel(MiracleWorldEditorModel.this.getSelectedLevelIndex());
                }
            });
            this.levelSelection.setFocusable(false);
            this.levelPanel = new LevelPanel(this.getSelectedLevel(), miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[this.getSelectedLevelIndex() * 2], (LevelSpriteTileset)tilesetArray[this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[this.getSelectedLevelIndex()], spriteContainerArray, KiddEd.getEntityLabelProvider());
            this.levelPanel.setAdditionalTransferHandler(this.window.getTransferHandler());
            this.levelPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
            this.levelPanel.setMode(MiracleWorldEditorModel.getPropertyLevelPanelMode());
            this.levelPanel.setShowTileAttributes(Boolean.parseBoolean(properties.getProperty("ShowTileAttributes")));
            jPanel.add((Component)this.levelPanel, "Center");
            this.window.add((Component)jPanel, "Center");
        } else {
            this.levelPanel.setLevel(this.getSelectedLevel(), miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[this.getSelectedLevelIndex() * 2], (LevelSpriteTileset)tilesetArray[this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[this.getSelectedLevelIndex()], spriteContainerArray);
        }
    }

    protected void updateMetaTilesetPanel() {
        if (this.east == null) {
            this.east = new JPanel(new BorderLayout());
            this.window.add((Component)this.east, "East");
        }
        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = this.dataModel.getMetaTilesets();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        if (this.metaTilesetPanel == null) {
            Properties properties = KiddEd.getProperties();
            this.metaTilesetPanel = new MetaTilesetPanel(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()]);
            this.metaTilesetPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
            this.metaTilesetPanel.setScaleParent(this.levelPanel);
            this.metaTilesetPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.metaTilesetPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MiracleWorldEditorModel.this.levelPanel.setSelectedMetaTile(MiracleWorldEditorModel.this.metaTilesetPanel.getSelectedMetaTileIndex());
                }
            });
            this.metaTilesetPanel.setShowTileAttributes(Boolean.parseBoolean(properties.getProperty("ShowTileAttributes")));
            this.levelPanel.setSelectedMetaTile(this.metaTilesetPanel.getSelectedMetaTileIndex());
            this.levelPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MiracleWorldEditorModel.this.metaTilesetPanel.setSelectedMetaTile(MiracleWorldEditorModel.this.levelPanel.getSelectedTileMetaTile());
                }
            });
            this.metaTilesetPanel.setVisible(MiracleWorldEditorModel.getPropertyLevelPanelMode() == 1);
            this.east.add((Component)this.metaTilesetPanel, "East");
            try {
                this.window.setSize(properties.getInt("WindowWidth"), properties.getInt("WindowHeight"));
                this.window.setExtendedState(properties.getInt("WindowExtendedState"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
        } else {
            this.metaTilesetPanel.setTileset(miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()], tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()]);
        }
    }

    protected void updateEntityList() {
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        SpriteTileset[] spriteTilesetArray = this.dataModel.getSpriteTilesets();
        SpriteContainer[] spriteContainerArray = this.dataModel.getSprites();
        if (this.entityList == null) {
            this.entityList = new EntityList((LevelSpriteTileset)tilesetArray[this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[this.getSelectedLevelIndex()], spriteTilesetArray, spriteContainerArray, 9876, KiddEd.getEntityLabelProvider());
            this.entityList.setScaleParent(this.levelPanel);
            this.entityList.setBackground(Color.LIGHT_GRAY);
            this.entityList.setVisible(MiracleWorldEditorModel.getPropertyLevelPanelMode() == 0);
            this.east.add((Component)this.entityList, "West");
        } else {
            this.entityList.setTileset((LevelSpriteTileset)tilesetArray[this.getSelectedLevelIndex() * 2 + 1], levelPaletteArray[this.getSelectedLevelIndex()], spriteTilesetArray, spriteContainerArray);
        }
    }

    protected void updateIcons() {
        MiracleWorldMetaTileset[] miracleWorldMetaTilesetArray = this.dataModel.getMetaTilesets();
        Tileset[] tilesetArray = this.dataModel.getLevelTilesets();
        LevelPalette[] levelPaletteArray = this.dataModel.getLevelPalettes();
        SpriteContainer[] spriteContainerArray = this.dataModel.getSprites();
        ICON_LAYOUT_EDITING.setMetaTile(((MetaTileset)miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()]).getMetaTile(3), tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()]);
        ICON_LAYOUT_EDITING.setScaleParent(this.levelPanel);
        ICON_ADD_HIDDEN_TILES.setMetaTile(((MetaTileset)miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()]).getMetaTile(4), tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()]);
        ICON_ADD_HIDDEN_TILES.setScaleParent(this.levelPanel);
        ICON_REMOVE_HIDDEN_TILES.setMetaTile(((MetaTileset)miracleWorldMetaTilesetArray[MiracleWorldEditorModel.getSelectedLevelNumber()]).getMetaTile(8), tilesetArray[this.getSelectedLevelIndex() * 2], levelPaletteArray[this.getSelectedLevelIndex()]);
        ICON_REMOVE_HIDDEN_TILES.setScaleParent(this.levelPanel);
        int n = 0;
        while (n < spriteContainerArray.length) {
            if (spriteContainerArray[n].isAlexSprite()) {
                ICON_ENTITY_EDITING.setSprite(spriteContainerArray[n], levelPaletteArray[this.getSelectedLevelIndex()], tilesetArray[this.getSelectedLevelIndex() * 2 + 1]);
                ICON_ENTITY_EDITING.setScaleParent(this.levelPanel);
                this.window.setIconImage(ICON_ENTITY_EDITING.getImage());
                break;
            }
            ++n;
        }
        ICON_ERASE.setSprite(spriteContainerArray[20], levelPaletteArray[this.getSelectedLevelIndex()], tilesetArray[this.getSelectedLevelIndex() * 2 + 1]);
        ICON_ERASE.setScaleParent(this.levelPanel);
    }

    private static int getPropertyLevel() {
        return KiddEd.getProperties().getInt("Level", 0);
    }

    private static int getPropertyLevelPanelMode() {
        return KiddEd.getProperties().getInt("LevelPanelMode", 0);
    }

    @Override
    public void installToolBarButtons(JToolBar jToolBar) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttonEntityEditing = new JToggleButton(ICON_ENTITY_EDITING, MiracleWorldEditorModel.getPropertyLevelPanelMode() == 0);
        ICON_ENTITY_EDITING.setOwner(this.buttonEntityEditing);
        this.buttonEntityEditing.setFocusable(false);
        this.buttonEntityEditing.setMargin(new Insets(0, 0, 0, 0));
        this.buttonEntityEditing.setToolTipText(TextProvider.get("ToolbarModeEntity"));
        this.buttonEntityEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.setMode(0);
                MiracleWorldEditorModel.this.metaTilesetPanel.setVisible(false);
                MiracleWorldEditorModel.this.entityList.setVisible(true);
                MiracleWorldEditorModel.this.eraseButton.setVisible(true);
                MiracleWorldEditorModel.this.addHiddenTilesButton.setVisible(false);
                MiracleWorldEditorModel.this.removeHiddenTilesButton.setVisible(false);
            }
        });
        buttonGroup.add(this.buttonEntityEditing);
        jToolBar.add(this.buttonEntityEditing);
        this.buttonLayoutEditing = new JToggleButton(ICON_LAYOUT_EDITING, MiracleWorldEditorModel.getPropertyLevelPanelMode() == 1);
        ICON_LAYOUT_EDITING.setOwner(this.buttonLayoutEditing);
        this.buttonLayoutEditing.setFocusable(false);
        this.buttonLayoutEditing.setMargin(new Insets(4, 0, 4, 0));
        this.buttonLayoutEditing.setToolTipText(TextProvider.get("ToolbarModeLayout"));
        this.buttonLayoutEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.setMode(1);
                MiracleWorldEditorModel.this.entityList.setVisible(false);
                MiracleWorldEditorModel.this.metaTilesetPanel.setVisible(true);
                MiracleWorldEditorModel.this.eraseButton.setVisible(false);
                MiracleWorldEditorModel.this.addHiddenTilesButton.setVisible(true);
                MiracleWorldEditorModel.this.removeHiddenTilesButton.setVisible(true);
            }
        });
        buttonGroup.add(this.buttonLayoutEditing);
        jToolBar.add(this.buttonLayoutEditing);
        jToolBar.addSeparator();
        this.eraseButton = new JButton(ICON_ERASE);
        ICON_ERASE.setOwner(this.eraseButton);
        this.eraseButton.setVisible(MiracleWorldEditorModel.getPropertyLevelPanelMode() == 0);
        this.eraseButton.setFocusable(false);
        this.eraseButton.setMargin(new Insets(4, 0, 4, 0));
        this.eraseButton.setToolTipText(TextProvider.get("ToolbarDelete"));
        this.eraseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.levelPanel.removeSelectedEntity();
            }
        });
        jToolBar.add(this.eraseButton);
        this.addHiddenTilesButton = new JToggleButton(ICON_ADD_HIDDEN_TILES);
        ICON_ADD_HIDDEN_TILES.setOwner(this.addHiddenTilesButton);
        this.addHiddenTilesButton.setVisible(MiracleWorldEditorModel.getPropertyLevelPanelMode() == 1);
        this.addHiddenTilesButton.setFocusable(false);
        this.addHiddenTilesButton.setMargin(new Insets(4, 0, 4, 0));
        this.addHiddenTilesButton.setToolTipText(TextProvider.get("ToolbarAddHiddenTiles"));
        this.addHiddenTilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.removeHiddenTilesButton.setSelected(false);
                MiracleWorldEditorModel.this.levelPanel.setEditHiddenTiles(MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected() || MiracleWorldEditorModel.this.removeHiddenTilesButton.isSelected(), MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected());
            }
        });
        jToolBar.add(this.addHiddenTilesButton);
        this.removeHiddenTilesButton = new JToggleButton(ICON_REMOVE_HIDDEN_TILES);
        ICON_REMOVE_HIDDEN_TILES.setOwner(this.removeHiddenTilesButton);
        this.removeHiddenTilesButton.setVisible(MiracleWorldEditorModel.getPropertyLevelPanelMode() == 1);
        this.removeHiddenTilesButton.setFocusable(false);
        this.removeHiddenTilesButton.setMargin(new Insets(4, 0, 4, 0));
        this.removeHiddenTilesButton.setToolTipText(TextProvider.get("ToolbarRemoveHiddenTiles"));
        this.removeHiddenTilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiracleWorldEditorModel.this.addHiddenTilesButton.setSelected(false);
                MiracleWorldEditorModel.this.levelPanel.setEditHiddenTiles(MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected() || MiracleWorldEditorModel.this.removeHiddenTilesButton.isSelected(), MiracleWorldEditorModel.this.addHiddenTilesButton.isSelected());
            }
        });
        jToolBar.add(this.removeHiddenTilesButton);
    }

    @Override
    public void settingChanged(String string, boolean bl) {
        if ("IntegerScaling".equals(string)) {
            this.closeEditors();
            this.levelPanel.setIntegerScaling(bl);
            this.metaTilesetPanel.setIntegerScaling(bl);
        } else if ("ShowTileAttributes".equals(string)) {
            this.levelPanel.setShowTileAttributes(bl);
            this.metaTilesetPanel.setShowTileAttributes(bl);
        }
    }

    private static void runInEmulatorAndStartLevel() {
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{59, 12};
        nArrayArray[1] = new int[]{60, 8};
        nArrayArray[2] = new int[]{2084, 10};
        nArrayArray[3] = new int[]{2088, MiracleWorldEditorModel.getSelectedLevelNumber() + 1};
        nArrayArray[4] = new int[]{6376, 10};
        int[] nArray = new int[2];
        nArray[0] = 153;
        nArrayArray[5] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 154;
        nArrayArray[6] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 155;
        nArrayArray[7] = nArray3;
        int[][] nArrayArray2 = nArrayArray;
        KiddEd.runInEmulator(nArrayArray2);
    }

    private int getSelectedLevelIndex() {
        return this.levelSelection.getSelectedIndex();
    }

    public static int getSelectedLevelNumber() {
        return MiracleWorldEditorModel.getInstance().dataModel.getLevelNumber(MiracleWorldEditorModel.getInstance().levelSelection.getSelectedIndex());
    }

    private Level getSelectedLevel() {
        Level[] levelArray = this.dataModel.getLevels();
        return levelArray[this.levelSelection.getSelectedIndex()];
    }

    public static MiracleWorldEditorModel getInstance() {
        return (MiracleWorldEditorModel)GameEditorModelManager.getGameEditorModel();
    }

    public static boolean canSwapLevels(int n, int n2) {
        return MiracleWorldEditorModel.getInstance().dataModel.canSwapLevels(n, n2);
    }

    public static boolean moveMetaTileset(int n, int n2) {
        return MiracleWorldEditorModel.getInstance().dataModel.moveMetaTileset(n, n2);
    }

    private static int getNumLevelMainTilesets() {
        return MiracleWorldEditorModel.getInstance().dataModel.getLevelMainTilesets().length;
    }

    private static int getNumLevelAdditionalTilesets() {
        return MiracleWorldEditorModel.getInstance().dataModel.getLevelAdditionalTilesets().length;
    }

    public static int getNumTitleScreenNameTables() {
        return MiracleWorldEditorModel.getInstance().dataModel.getTitleScreenNameTables().length;
    }

    public static int getSourceOfSpriteTiles() {
        Tiles[] tilesArray = MiracleWorldEditorModel.getInstance().dataModel.getTiles();
        return tilesArray[1].getSource();
    }

    public static int getSourceOfItemTiles() {
        Tiles[] tilesArray = MiracleWorldEditorModel.getInstance().dataModel.getTiles();
        return tilesArray[2].getSource();
    }

    public static boolean isAlexWalkingToShopInGround() {
        return MiracleWorldEditorModel.getInstance().dataModel.isAlexWalkingToShopInGround();
    }

    public static void swapLevels(int n, int n2) {
        if (MiracleWorldEditorModel.canSwapLevels(n, n2)) {
            MiracleWorldEditorModel miracleWorldEditorModel = (MiracleWorldEditorModel)GameEditorModelManager.getGameEditorModel();
            MiracleWorldDataModel miracleWorldDataModel = miracleWorldEditorModel.dataModel;
            miracleWorldDataModel.swapLevels(n, n2);
            if (miracleWorldEditorModel.levelSelection != null) {
                miracleWorldEditorModel.levelSelection.setSelectedIndex(n);
            }
            miracleWorldEditorModel.closeEditors();
            miracleWorldEditorModel.reopenEditors();
            Level.applyScrollabilityHacks();
            KiddEd.clearChanges();
        }
    }

    @Override
    public void updateUIcomponents() {
        this.updateLevelPanel();
        this.updateIcons();
        this.updateMetaTilesetPanel();
        this.updateEntityList();
    }

    private File showExportLevelChooser(Component component) {
        File file = KiddEd.getRomFile();
        File file2 = KiddEd.getGameFile();
        File file3 = KiddEd.getMostRecentFile();
        File file4 = file.getParentFile();
        if (file2 != null) {
            file4 = file2.getParentFile();
        }
        if (file3 != null) {
            file4 = file3.getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file4);
        fileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleExportLevelAs")) + "...");
        if (file2 != null) {
            String string = file2.getPath();
            fileChooser.setSelectedFile(new File(String.valueOf(string.substring(0, string.lastIndexOf(46))) + String.format("_level%02X", this.getSelectedLevelIndex() + 1) + ".inc"));
        } else {
            fileChooser.setSelectedFile(new File(String.valueOf(String.format("level%02X", this.getSelectedLevelIndex() + 1)) + ".inc"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static ScalableIcon getIcon(String string) {
        if (NAME_ICON_LAYOUT_EDITING.equals(string)) {
            return ICON_LAYOUT_EDITING.derive();
        }
        if (NAME_ICON_ENTITY_EDITING.equals(string)) {
            return ICON_ENTITY_EDITING.derive();
        }
        if (NAME_ICON_ERASE.equals(string)) {
            return ICON_ERASE.derive();
        }
        return null;
    }

    public static void fixBonusLevelEntities() {
        MiracleWorldEditorModel.getInstance().dataModel.fixBonusLevelEntities();
    }

    public static boolean isBonusLevelCompressed() {
        return MiracleWorldEditorModel.getInstance().dataModel.isBonusLevelCompressed();
    }

    public static boolean relocateBonusLevel() {
        return MiracleWorldEditorModel.getInstance().dataModel.relocateBonusLevel();
    }

    public static boolean isLevelMainTileset(Tiles tiles) {
        return MiracleWorldEditorModel.getInstance().dataModel.isLevelMainTileset(tiles);
    }

    public static boolean moveEntityData() {
        return MiracleWorldEditorModel.getInstance().dataModel.moveEntityData();
    }

    public static void relocateDataInRange(int n, int n2, HashSet<Integer> hashSet) {
        MiracleWorldEditorModel.getInstance().dataModel.relocateDataInRange(n, n2, hashSet);
    }

    public static boolean moveMetaTilesets() {
        return MiracleWorldEditorModel.getInstance().dataModel.moveMetaTilesets();
    }

    public static void relocateAssetsInBank(int n) {
        MiracleWorldEditorModel.getInstance().dataModel.relocateAssetsInBank(n);
    }

    public static void addAdditionalTileset(LevelTileset levelTileset) {
        MiracleWorldEditorModel.getInstance().dataModel.addAdditionalTileset(levelTileset);
    }

    public static boolean canAddClearTiles() {
        return MiracleWorldEditorModel.getInstance().dataModel.canAddClearTiles();
    }

    public static void addClearTiles(LevelTileset levelTileset) {
        MiracleWorldEditorModel.getInstance().dataModel.addClearTiles(levelTileset);
    }

    public static boolean canAddMainTileset() {
        return MiracleWorldEditorModel.getInstance().dataModel.canAddMainTileset();
    }

    public static void addMainTileset(LevelTileset levelTileset) {
        MiracleWorldEditorModel.getInstance().dataModel.addMainTileset(levelTileset);
    }

    public static boolean canAddAdditionalTileset() {
        return MiracleWorldEditorModel.getInstance().dataModel.canAddAdditionalTileset();
    }

    public static void removeAdditionalTileset(LevelTileset levelTileset, int n) {
        MiracleWorldEditorModel.getInstance().dataModel.removeAdditionalTileset(levelTileset, n);
    }

    public static void removeClearTiles(LevelTileset levelTileset) {
        MiracleWorldEditorModel.getInstance().dataModel.removeClearTiles(levelTileset);
    }

    public static void removeMainTileset(LevelTileset levelTileset) {
        MiracleWorldEditorModel.getInstance().dataModel.removeMainTileset(levelTileset);
    }
}

