/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.Tiles;
import editor.Z80Factory;
import editors.TextProvider;
import java.util.Arrays;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionObject;

public class Tileset
implements Changable {
    protected final int[] vram;
    protected final int address;
    protected int level;
    protected boolean memoryDirty = true;
    private volatile boolean dirty;
    protected int destination;
    private int length;
    protected int[] tileSources = new int[512];
    private LinkedList<Tiles> tilesList;
    protected final int[] memory;
    protected final Z80 cpu;
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n;
            int n2;
            Object object2;
            if (Tileset.this.cpu != null) {
                object2 = change.getOldData();
                n2 = ((int[][])object2).length;
                int n22 = 0;
                while (n22 < n2) {
                    int[] object3 = object2[n22];
                    n = object3[0];
                    if (n < 32768 || n / 16384 == (Tileset.this.memory[65535] & 0x7F)) {
                        if (n >= 32768) {
                            n = 0x8000 | n & 0x3FFF;
                        }
                        Tileset.this.memory[n] = RomManager.StaticAccess.readByte(object3[0]);
                        Tileset.this.memoryDirty = true;
                    } else if (n >= 32768) {
                        Tileset.this.memoryDirty = true;
                    }
                    ++n22;
                }
            } else {
                Tileset.this.memoryDirty = true;
            }
            for (TransactionObject transactionObject : change.getTransactionObjects()) {
                if (!(transactionObject.getObject() instanceof Tiles)) continue;
                if (Tileset.this.contains((Tiles)transactionObject.getObject())) {
                    Tileset.this.fireChangeOccurred(new Change(Tileset.this, Tileset.this.destination / 32, change.getOldData()));
                    return;
                }
                n2 = change.getData(transactionObject.getObject());
                object2 = (Tiles)transactionObject.getObject();
                n = ((Tiles)object2).getSource() + n2 * 32;
                if (n2 >= 0 && (n < Tileset.this.getSource() || n >= Tileset.this.getSource() + Tileset.this.getLength())) continue;
                Tileset.this.fireChangeOccurred(new Change(Tileset.this, Tileset.this.destination / 32, change.getOldData()));
                return;
            }
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (Tileset.this.cpu != null) {
                int[][] nArray = change.getOldData();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int[] object = nArray[n2];
                    int n3 = object[0];
                    if (n3 < 32768 || n3 / 16384 == (Tileset.this.memory[65535] & 0x7F)) {
                        if (n3 >= 32768) {
                            n3 = 0x8000 | n3 & 0x3FFF;
                        }
                        Tileset.this.memory[n3] = RomManager.StaticAccess.readByte(object[0]);
                        Tileset.this.memoryDirty = true;
                    } else if (n3 >= 32768) {
                        Tileset.this.memoryDirty = true;
                    }
                    ++n2;
                }
            }
            for (TransactionObject transactionObject : change.getTransactionObjects()) {
                Changable changable = transactionObject.getObject();
                if (!(changable instanceof Tileset) || !((Tileset)changable).isSprite()) continue;
                Tileset.this.fireChangeOccurred(new Change(Tileset.this, 256, change.getOldData()));
                return;
            }
            Tileset.this.fireChangeOccurred(new Change(Tileset.this, 0, change.getOldData()));
        }
    };
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Tileset(int n) {
        this(n, 1);
    }

    protected Tileset(int n, int n2) {
        this.address = n;
        this.level = n2 - 1;
        this.memory = new int[65536];
        this.updateMemory();
        RomManager.StaticAccess.loadBank2(this.memory, 3);
        this.memory[49187] = n2;
        this.cpu = Z80Factory.create(this.memory);
        final TMS9918A tMS9918A = new TMS9918A(262);
        this.vram = tMS9918A.getVRAM();
        this.cpu.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65534) {
                    RomManager.StaticAccess.loadBank1(Tileset.this.memory, n2);
                } else if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(Tileset.this.memory, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        Tileset.this.cpu.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        tMS9918A.addOutputListener(new OutputListener(){
            private int end;

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 3 && (n2 & 0x3FFF) < 14336) {
                    if (Tileset.this.destination >= Tileset.this.vram.length) {
                        this.end = 0;
                        Tileset.this.length = 0;
                    }
                    if (RomManager.RESOLVE_ADDRESS(Tileset.this.cpu.getHL(), Tileset.this.memory[65535]) < Tileset.this.tileSources[(n2 & 0x3FFF) >> 5]) {
                        Tileset.this.tileSources[(n2 & 0x3FFF) >> 5] = RomManager.RESOLVE_ADDRESS(Tileset.this.cpu.getHL(), Tileset.this.memory[65535]);
                    }
                    if ((n2 & 0x3FE0) < Tileset.this.destination) {
                        Tileset.this.destination = n2 & 0x3FE0;
                        Tileset.this.length = this.end - Tileset.this.destination;
                    }
                    if ((n2 & 0x3FE0) + 32 > this.end) {
                        this.end = (n2 & 0x3FE0) + 32;
                        Tileset.this.length = this.end - Tileset.this.destination;
                    }
                }
            }
        });
    }

    public Tileset(int n, int n2, int n3) {
        this.address = n;
        this.memory = new int[65536];
        this.updateMemory();
        if (n2 != 0) {
            RomManager.StaticAccess.loadBank2(this.memory, n2 / 16384);
        }
        this.cpu = Z80Factory.create(this.memory);
        final TMS9918A tMS9918A = new TMS9918A(262);
        this.cpu.setHL(n2 < 32768 ? n2 : 0x8000 | n2 & 0x3FFF);
        this.cpu.setDE(n3);
        this.vram = tMS9918A.getVRAM();
        this.cpu.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(Tileset.this.memory, n2);
                } else if (n == 65534) {
                    RomManager.StaticAccess.loadBank1(Tileset.this.memory, n2);
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        Tileset.this.cpu.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        tMS9918A.addOutputListener(new OutputListener(){
            private int end;

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 3 && (n2 & 0x3FFF) < 14336) {
                    if (Tileset.this.destination >= Tileset.this.vram.length) {
                        this.end = 0;
                        Tileset.this.length = 0;
                    }
                    if (RomManager.RESOLVE_ADDRESS(Tileset.this.cpu.getHL(), Tileset.this.memory[65535]) < Tileset.this.tileSources[(n2 & 0x3FFF) >> 5]) {
                        Tileset.this.tileSources[(n2 & 0x3FFF) >> 5] = RomManager.RESOLVE_ADDRESS(Tileset.this.cpu.getHL(), Tileset.this.memory[65535]);
                    }
                    if ((n2 & 0x3FE0) < Tileset.this.destination) {
                        Tileset.this.destination = n2 & 0x3FE0;
                        Tileset.this.length = this.end - Tileset.this.destination;
                    }
                    if ((n2 & 0x3FE0) + 32 > this.end) {
                        this.end = (n2 & 0x3FE0) + 32;
                        Tileset.this.length = this.end - Tileset.this.destination;
                    }
                }
            }
        });
    }

    public Tileset(Tiles tiles) {
        this.address = 0;
        this.memory = null;
        this.cpu = null;
        this.vram = new int[16384];
        this.addTiles(tiles);
        this.addTilesListener(tiles);
    }

    protected final int getAddress() {
        return this.address;
    }

    public int getSource() {
        this.getVRAM();
        return this.tileSources[(this.getDestination() & 0x3FFF) >> 5];
    }

    public int getDestination() {
        this.getVRAM();
        return this.destination;
    }

    public int getLength() {
        this.getVRAM();
        return this.length;
    }

    public int getCount() {
        int n = 0;
        int n2 = this.destination / 32;
        while (n2 < (this.destination + this.length) / 32) {
            if (this.tileSources[n2] < Integer.MAX_VALUE) {
                ++n;
            }
            ++n2;
        }
        if (this.tilesList != null) {
            for (Tiles tiles : this.tilesList) {
                n += tiles.getLength() / 32;
            }
        }
        if ((this.destination & 0x2000) == 0) {
            ++n;
        }
        return n;
    }

    public int[] getCharCodes() {
        int[] nArray = new int[this.getCount()];
        int n = 0;
        if ((this.destination & 0x2000) == 0) {
            nArray[n++] = 0;
        }
        int n2 = this.destination / 32;
        while (n2 < (this.destination + this.length) / 32) {
            if (this.tileSources[n2] < Integer.MAX_VALUE) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        if (this.tilesList != null) {
            for (Tiles tiles : this.tilesList) {
                int n3 = tiles.getDestination() / 32;
                while (n3 < (tiles.getDestination() + tiles.getLength()) / 32) {
                    nArray[n++] = n3++;
                }
            }
        }
        return nArray;
    }

    public boolean contains(int n) {
        if (n < 0) {
            return false;
        }
        if ((this.destination & 0x2000) == 0 && n == 0) {
            return true;
        }
        this.getVRAM();
        int n2 = (n |= (this.destination & 0x2000) >> 5) << 5;
        if (this.tilesList != null) {
            for (Tiles tiles : this.tilesList) {
                if (n2 < tiles.getDestination() || n2 >= tiles.getDestination() + tiles.getLength()) continue;
                return true;
            }
        }
        return n < this.tileSources.length && this.tileSources[n] < Integer.MAX_VALUE;
    }

    protected boolean contains(Tiles tiles) {
        return this.tilesList != null && this.tilesList.contains(tiles);
    }

    public boolean isSprite() {
        if (this.tilesList != null && !this.tilesList.isEmpty()) {
            return this.tilesList.get(0).isSprite();
        }
        return false;
    }

    public void clearDirty() {
        this.memoryDirty = true;
    }

    public synchronized void setDirty(int n, int n2) {
        if (this.vram[n] != n2) {
            this.vram[n] = n2;
            this.dirty = true;
        }
    }

    public synchronized void updateDirty() {
        if (this.dirty) {
            this.fireChangeOccurred(new Change(0));
        }
        this.dirty = false;
    }

    public void updateMemory() {
        RomManager.StaticAccess.copyFromROM(0, this.memory, 0, 32768);
        this.memoryDirty = true;
    }

    protected void updateMemory(Change change) {
        if (this.cpu != null) {
            int[][] nArray = change.getOldData();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int[] nArray2 = nArray[n2];
                int n3 = nArray2[0];
                if (n3 < 32768 || n3 / 16384 == (this.memory[65535] & 0x7F)) {
                    if (n3 >= 32768) {
                        n3 = 0x8000 | n3 & 0x3FFF;
                    }
                    this.memory[n3] = RomManager.StaticAccess.readByte(nArray2[0]);
                    this.memoryDirty = true;
                }
                ++n2;
            }
        }
    }

    public void addTiles(Tiles tiles) {
        if (this.tilesList == null) {
            this.tilesList = new LinkedList();
        }
        this.tilesList.add(tiles);
        this.memoryDirty = true;
    }

    public void addTilesListener(Tiles tiles) {
        tiles.addChangeListener(this.tilesChangeListener);
    }

    public void removeTilesListener(Tiles tiles) {
        tiles.removeChangeListener(this.tilesChangeListener);
    }

    public void addTilesetListener(Tileset tileset) {
        tileset.addChangeListener(this.tilesetChangeListener);
    }

    public void removeTilesetListener(Tileset tileset) {
        tileset.removeChangeListener(this.tilesetChangeListener);
    }

    public Tiles getTilesAt(int n) {
        if (this.tilesList != null) {
            for (Tiles tiles : this.tilesList) {
                if (n < tiles.getDestination() || n >= tiles.getDestination() + tiles.getLength()) continue;
                return tiles;
            }
        }
        return null;
    }

    public boolean canSetTilesDestination(Tiles tiles) {
        return false;
    }

    public void setTilesDestination(Tiles tiles, int n) {
        throw new UnsupportedOperationException();
    }

    public int getTilesDestination(Tiles tiles) {
        if (tiles == null) {
            return -1;
        }
        return tiles.getDestination();
    }

    public int[][] getTiles(int[][] nArray, Tiles tiles) {
        this.getVRAM();
        int[][] nArray2 = new int[nArray.length][nArray[0].length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                nArray2[n][n2] = nArray[n][n2] < 0 ? -1 : (this.tileSources[nArray[n][n2]] - tiles.getSource()) / 32;
                ++n2;
            }
            ++n;
        }
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVRAM() {
        if (this.memoryDirty) {
            Tileset tileset = this;
            synchronized (tileset) {
                Arrays.fill(this.vram, 0);
                Arrays.fill(this.tileSources, Integer.MAX_VALUE);
                this.destination = this.vram.length;
                this.length = 0;
                if (this.cpu != null) {
                    this.destination = this.vram.length;
                    this.cpu.execute(this.address);
                }
                if (this.tilesList != null) {
                    int n = this.destination + this.length & 0x3FE0;
                    for (Tiles tiles : this.tilesList) {
                        if ((tiles.getDestination() & 0x3FE0) < this.destination) {
                            this.destination = tiles.getDestination() & 0x3FE0;
                        }
                        if (tiles.getDestination() + tiles.getLength() > n) {
                            n = tiles.getDestination() + tiles.getLength();
                        }
                        System.arraycopy(tiles.getVRAM(), tiles.getDestination(), this.vram, tiles.getDestination(), tiles.getLength());
                        int n2 = 0;
                        while (n2 < tiles.getLength() / 32) {
                            this.tileSources[n2 + (tiles.getDestination() & 0x3FFF) / 32] = tiles.getSource() + n2 * 32;
                            ++n2;
                        }
                    }
                    this.length = n - this.destination;
                }
                this.memoryDirty = false;
            }
        }
        return this.vram;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeTileset");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        this.updateMemory(change);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return this.tilesList.getFirst().toString();
    }
}

