/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionManager;

public class Riddle
implements Changable {
    private final int address;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Riddle(int n) {
        this.address = n;
    }

    public int[] getPieces() {
        return RomManager.StaticAccess.readBytes(new int[10], this.address);
    }

    public void setPieces(int[] nArray) {
        boolean bl = false;
        int n = 0;
        while (n < nArray.length && !bl) {
            if (RomManager.StaticAccess.readByte(this.address + n) != nArray[n]) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeBytes(nArray, this.address);
        }
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeRiddle");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

