/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTableHeaderUI
extends TableHeaderUI {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;
    private int rolloverColumn = -1;
    private int selectedColumnIndex = 0;
    private static FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintHeader(focusEvent.getSource());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintHeader(focusEvent.getSource());
        }

        private void repaintHeader(Object object) {
            if (object instanceof JTableHeader) {
                JTableHeader jTableHeader = (JTableHeader)object;
                BasicTableHeaderUI basicTableHeaderUI = (BasicTableHeaderUI)BasicLookAndFeel.getUIOfType(jTableHeader.getUI(), BasicTableHeaderUI.class);
                if (basicTableHeaderUI == null) {
                    return;
                }
                jTableHeader.repaint(jTableHeader.getHeaderRect(basicTableHeaderUI.getSelectedColumnIndex()));
            }
        }
    };

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(this.header, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
        this.header.addFocusListener(focusListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)DefaultLookup.get(this.header, this, "TableHeader.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.header, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.header, BasicTableHeaderUI.class, "TableHeader.actionMap");
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.header, 0, null);
        SwingUtilities.replaceUIActionMap(this.header, null);
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("toggleSortOrder"));
        lazyActionMap.put(new Actions("selectColumnToLeft"));
        lazyActionMap.put(new Actions("selectColumnToRight"));
        lazyActionMap.put(new Actions("moveColumnLeft"));
        lazyActionMap.put(new Actions("moveColumnRight"));
        lazyActionMap.put(new Actions("resizeLeft"));
        lazyActionMap.put(new Actions("resizeRight"));
        lazyActionMap.put(new Actions("focusTable"));
    }

    protected int getRolloverColumn() {
        return this.rolloverColumn;
    }

    protected void rolloverColumnUpdated(int n, int n2) {
    }

    private void updateRolloverColumn(MouseEvent mouseEvent) {
        int n;
        if (this.header.getDraggedColumn() == null && this.header.contains(mouseEvent.getPoint()) && (n = this.header.columnAtPoint(mouseEvent.getPoint())) != this.rolloverColumn) {
            int n2 = this.rolloverColumn;
            this.rolloverColumn = n;
            this.rolloverColumnUpdated(n2, this.rolloverColumn);
        }
    }

    private int selectNextColumn(boolean bl) {
        int n = this.getSelectedColumnIndex();
        if (n < this.header.getColumnModel().getColumnCount() - 1) {
            ++n;
            if (bl) {
                this.selectColumn(n);
            }
        }
        return n;
    }

    private int selectPreviousColumn(boolean bl) {
        int n = this.getSelectedColumnIndex();
        if (n > 0) {
            --n;
            if (bl) {
                this.selectColumn(n);
            }
        }
        return n;
    }

    void selectColumn(int n) {
        this.selectColumn(n, true);
    }

    void selectColumn(int n, boolean bl) {
        Rectangle rectangle = this.header.getHeaderRect(this.selectedColumnIndex);
        this.header.repaint(rectangle);
        this.selectedColumnIndex = n;
        rectangle = this.header.getHeaderRect(n);
        this.header.repaint(rectangle);
        if (bl) {
            this.scrollToColumn(n);
        }
    }

    private void scrollToColumn(int n) {
        JTable jTable;
        Container container;
        if (this.header.getParent() == null || (container = this.header.getParent().getParent()) == null || !(container instanceof JScrollPane) || (jTable = this.header.getTable()) == null) {
            return;
        }
        Rectangle rectangle = jTable.getVisibleRect();
        Rectangle rectangle2 = jTable.getCellRect(0, n, true);
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        jTable.scrollRectToVisible(rectangle);
    }

    private int getSelectedColumnIndex() {
        int n = this.header.getColumnModel().getColumnCount();
        if (this.selectedColumnIndex >= n && n > 0) {
            this.selectedColumnIndex = n - 1;
        }
        return this.selectedColumnIndex;
    }

    private static boolean canResize(TableColumn tableColumn, JTableHeader jTableHeader) {
        return tableColumn != null && jTableHeader.getResizingAllowed() && tableColumn.getResizable();
    }

    private int changeColumnWidth(TableColumn tableColumn, JTableHeader jTableHeader, int n, int n2) {
        JTable jTable;
        Container container;
        tableColumn.setWidth(n2);
        if (jTableHeader.getParent() == null || (container = jTableHeader.getParent().getParent()) == null || !(container instanceof JScrollPane) || (jTable = jTableHeader.getTable()) == null) {
            return 0;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !jTableHeader.getComponentOrientation().isLeftToRight()) {
            JViewport jViewport = ((JScrollPane)container).getViewport();
            int n3 = jViewport.getWidth();
            int n4 = n2 - n;
            int n5 = jTable.getWidth() + n4;
            Dimension dimension = jTable.getSize();
            dimension.width += n4;
            jTable.setSize(dimension);
            if (n5 >= n3 && jTable.getAutoResizeMode() == 0) {
                Point point = jViewport.getViewPosition();
                point.x = Math.max(0, Math.min(n5 - n3, point.x + n4));
                jViewport.setViewPosition(point);
                return n4;
            }
        }
        return 0;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        int n3 = -1;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Component component = this.getHeaderRenderer(i);
            Dimension dimension = component.getPreferredSize();
            int n4 = component.getBaseline(dimension.width, n2);
            if (n4 < 0) continue;
            if (n3 == -1) {
                n3 = n4;
                continue;
            }
            if (n3 == n4) continue;
            n3 = -1;
            break;
        }
        return n3;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                int n4;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n4 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n4;
            }
        } else {
            for (n = n3; n >= n2; --n) {
                int n5;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        boolean bl = !this.header.isPaintingForPrint() && n == this.getSelectedColumnIndex() && this.header.hasFocus();
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, bl, -1, n);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private int getHeaderHeight() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Object object;
            boolean bl2;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            boolean bl3 = bl2 = tableColumn.getHeaderRenderer() == null;
            if (bl2 && bl) continue;
            Component component = this.getHeaderRenderer(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (!bl2 || n2 <= 0 || (object = tableColumn.getHeaderValue()) == null || (object = object.toString()) == null || object.equals("")) continue;
            bl = true;
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l);
    }

    private static class Actions
    extends UIAction {
        public static final String TOGGLE_SORT_ORDER = "toggleSortOrder";
        public static final String SELECT_COLUMN_TO_LEFT = "selectColumnToLeft";
        public static final String SELECT_COLUMN_TO_RIGHT = "selectColumnToRight";
        public static final String MOVE_COLUMN_LEFT = "moveColumnLeft";
        public static final String MOVE_COLUMN_RIGHT = "moveColumnRight";
        public static final String RESIZE_LEFT = "resizeLeft";
        public static final String RESIZE_RIGHT = "resizeRight";
        public static final String FOCUS_TABLE = "focusTable";

        public Actions(String string) {
            super(string);
        }

        @Override
        public boolean isEnabled(Object object) {
            if (object instanceof JTableHeader) {
                JTableHeader jTableHeader = (JTableHeader)object;
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                if (tableColumnModel.getColumnCount() <= 0) {
                    return false;
                }
                String string = this.getName();
                BasicTableHeaderUI basicTableHeaderUI = (BasicTableHeaderUI)BasicLookAndFeel.getUIOfType(jTableHeader.getUI(), BasicTableHeaderUI.class);
                if (basicTableHeaderUI != null) {
                    if (string == MOVE_COLUMN_LEFT) {
                        return jTableHeader.getReorderingAllowed() && this.maybeMoveColumn(true, jTableHeader, basicTableHeaderUI, false);
                    }
                    if (string == MOVE_COLUMN_RIGHT) {
                        return jTableHeader.getReorderingAllowed() && this.maybeMoveColumn(false, jTableHeader, basicTableHeaderUI, false);
                    }
                    if (string == RESIZE_LEFT || string == RESIZE_RIGHT) {
                        return BasicTableHeaderUI.canResize(tableColumnModel.getColumn(basicTableHeaderUI.getSelectedColumnIndex()), jTableHeader);
                    }
                    if (string == FOCUS_TABLE) {
                        return jTableHeader.getTable() != null;
                    }
                }
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable;
            JTableHeader jTableHeader = (JTableHeader)actionEvent.getSource();
            BasicTableHeaderUI basicTableHeaderUI = (BasicTableHeaderUI)BasicLookAndFeel.getUIOfType(jTableHeader.getUI(), BasicTableHeaderUI.class);
            if (basicTableHeaderUI == null) {
                return;
            }
            String string = this.getName();
            if (TOGGLE_SORT_ORDER == string) {
                RowSorter<? extends TableModel> rowSorter;
                JTable jTable2 = jTableHeader.getTable();
                RowSorter<? extends TableModel> rowSorter2 = rowSorter = jTable2 == null ? null : jTable2.getRowSorter();
                if (rowSorter != null) {
                    int n = basicTableHeaderUI.getSelectedColumnIndex();
                    n = jTable2.convertColumnIndexToModel(n);
                    rowSorter.toggleSortOrder(n);
                }
            } else if (SELECT_COLUMN_TO_LEFT == string) {
                if (jTableHeader.getComponentOrientation().isLeftToRight()) {
                    basicTableHeaderUI.selectPreviousColumn(true);
                } else {
                    basicTableHeaderUI.selectNextColumn(true);
                }
            } else if (SELECT_COLUMN_TO_RIGHT == string) {
                if (jTableHeader.getComponentOrientation().isLeftToRight()) {
                    basicTableHeaderUI.selectNextColumn(true);
                } else {
                    basicTableHeaderUI.selectPreviousColumn(true);
                }
            } else if (MOVE_COLUMN_LEFT == string) {
                this.moveColumn(true, jTableHeader, basicTableHeaderUI);
            } else if (MOVE_COLUMN_RIGHT == string) {
                this.moveColumn(false, jTableHeader, basicTableHeaderUI);
            } else if (RESIZE_LEFT == string) {
                this.resize(true, jTableHeader, basicTableHeaderUI);
            } else if (RESIZE_RIGHT == string) {
                this.resize(false, jTableHeader, basicTableHeaderUI);
            } else if (FOCUS_TABLE == string && (jTable = jTableHeader.getTable()) != null) {
                jTable.requestFocusInWindow();
            }
        }

        private void moveColumn(boolean bl, JTableHeader jTableHeader, BasicTableHeaderUI basicTableHeaderUI) {
            this.maybeMoveColumn(bl, jTableHeader, basicTableHeaderUI, true);
        }

        private boolean maybeMoveColumn(boolean bl, JTableHeader jTableHeader, BasicTableHeaderUI basicTableHeaderUI, boolean bl2) {
            int n;
            int n2 = basicTableHeaderUI.getSelectedColumnIndex();
            if (jTableHeader.getComponentOrientation().isLeftToRight()) {
                n = bl ? basicTableHeaderUI.selectPreviousColumn(bl2) : basicTableHeaderUI.selectNextColumn(bl2);
            } else {
                int n3 = n = bl ? basicTableHeaderUI.selectNextColumn(bl2) : basicTableHeaderUI.selectPreviousColumn(bl2);
            }
            if (n != n2) {
                if (bl2) {
                    jTableHeader.getColumnModel().moveColumn(n2, n);
                } else {
                    return true;
                }
            }
            return false;
        }

        private void resize(boolean bl, JTableHeader jTableHeader, BasicTableHeaderUI basicTableHeaderUI) {
            int n;
            int n2 = basicTableHeaderUI.getSelectedColumnIndex();
            TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n2);
            jTableHeader.setResizingColumn(tableColumn);
            int n3 = n = tableColumn.getWidth();
            n3 = jTableHeader.getComponentOrientation().isLeftToRight() ? (n3 += bl ? -1 : 1) : (n3 += bl ? 1 : -1);
            basicTableHeaderUI.changeColumnWidth(tableColumn, jTableHeader, n, n3);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = BasicTableHeaderUI.access$100();

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            RowSorter<? extends TableModel> rowSorter;
            JTable jTable;
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            if (mouseEvent.getClickCount() % 2 == 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && (jTable = BasicTableHeaderUI.this.header.getTable()) != null && (rowSorter = jTable.getRowSorter()) != null && (n = BasicTableHeaderUI.this.header.columnAtPoint(mouseEvent.getPoint())) != -1) {
                n = jTable.convertColumnIndexToModel(n);
                rowSorter.toggleSortOrder(n);
            }
        }

        private TableColumn getResizingColumn(Point point) {
            return this.getResizingColumn(point, BasicTableHeaderUI.this.header.columnAtPoint(point));
        }

        private TableColumn getResizingColumn(Point point, int n) {
            int n2;
            if (n == -1) {
                return null;
            }
            Rectangle rectangle = BasicTableHeaderUI.this.header.getHeaderRect(n);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n3 = rectangle.x + rectangle.width / 2;
            if (BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                n2 = point.x < n3 ? n - 1 : n;
            } else {
                int n4 = n2 = point.x < n3 ? n : n - 1;
            }
            if (n2 == -1) {
                return null;
            }
            return BasicTableHeaderUI.this.header.getColumnModel().getColumn(n2);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = BasicTableHeaderUI.this.header.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = this.getResizingColumn(point, n);
                if (BasicTableHeaderUI.canResize(tableColumn, BasicTableHeaderUI.this.header)) {
                    BasicTableHeaderUI.this.header.setResizingColumn(tableColumn);
                    this.mouseXOffset = BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
                } else if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    BasicTableHeaderUI.this.header.setDraggedColumn(tableColumn2);
                    this.mouseXOffset = point.x;
                }
            }
            if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                int n2 = BasicTableHeaderUI.this.rolloverColumn;
                BasicTableHeaderUI.this.rolloverColumn = -1;
                BasicTableHeaderUI.this.rolloverColumnUpdated(n2, BasicTableHeaderUI.this.rolloverColumn);
            }
        }

        private void swapCursor() {
            Cursor cursor = BasicTableHeaderUI.this.header.getCursor();
            BasicTableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = cursor;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            if (BasicTableHeaderUI.canResize(this.getResizingColumn(mouseEvent.getPoint()), BasicTableHeaderUI.this.header) != (BasicTableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
            BasicTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            int n = mouseEvent.getX();
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = BasicTableHeaderUI.this.header.getDraggedColumn();
            boolean bl = BasicTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (tableColumn != null) {
                int n2 = tableColumn.getWidth();
                int n3 = bl ? n - this.mouseXOffset : this.mouseXOffset - n;
                this.mouseXOffset += BasicTableHeaderUI.this.changeColumnWidth(tableColumn, BasicTableHeaderUI.this.header, n2, n3);
            } else if (tableColumn2 != null) {
                TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
                int n4 = n - this.mouseXOffset;
                int n5 = n4 < 0 ? -1 : 1;
                int n6 = BasicTableHeaderUI.this.viewIndexForColumn(tableColumn2);
                int n7 = n6 + (bl ? n5 : -n5);
                if (0 <= n7 && n7 < tableColumnModel.getColumnCount()) {
                    int n8 = tableColumnModel.getColumn(n7).getWidth();
                    if (Math.abs(n4) > n8 / 2) {
                        this.mouseXOffset += n5 * n8;
                        BasicTableHeaderUI.this.header.setDraggedDistance(n4 - n5 * n8);
                        int n9 = SwingUtilities2.convertColumnIndexToModel(BasicTableHeaderUI.this.header.getColumnModel(), BasicTableHeaderUI.this.getSelectedColumnIndex());
                        tableColumnModel.moveColumn(n6, n7);
                        BasicTableHeaderUI.this.selectColumn(SwingUtilities2.convertColumnIndexToView(BasicTableHeaderUI.this.header.getColumnModel(), n9), false);
                        return;
                    }
                }
                this.setDraggedDistance(n4, n6);
            }
            BasicTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            this.setDraggedDistance(0, BasicTableHeaderUI.this.viewIndexForColumn(BasicTableHeaderUI.this.header.getDraggedColumn()));
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            BasicTableHeaderUI.this.updateRolloverColumn(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!BasicTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            int n = BasicTableHeaderUI.this.rolloverColumn;
            BasicTableHeaderUI.this.rolloverColumn = -1;
            BasicTableHeaderUI.this.rolloverColumnUpdated(n, BasicTableHeaderUI.this.rolloverColumn);
        }

        private void setDraggedDistance(int n, int n2) {
            BasicTableHeaderUI.this.header.setDraggedDistance(n);
            if (n2 != -1) {
                BasicTableHeaderUI.this.header.getColumnModel().moveColumn(n2, n2);
            }
        }
    }
}

