/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi.db;

import com.sun.xml.internal.ws.spi.db.PropertyGetterBase;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class MethodGetter
extends PropertyGetterBase {
    private Method method;

    public MethodGetter(Method method) {
        this.method = method;
        this.type = method.getReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public <A> A getAnnotation(Class<A> clazz) {
        Class<A> clazz2 = clazz;
        return this.method.getAnnotation(clazz2);
    }

    @Override
    public Object get(Object object) {
        Object[] objectArray = new Object[]{};
        try {
            if (this.method.isAccessible()) {
                return this.method.invoke(object, objectArray);
            }
            PrivilegedGetter privilegedGetter = new PrivilegedGetter(this.method, object);
            try {
                AccessController.doPrivileged(privilegedGetter);
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            return privilegedGetter.value;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static class PrivilegedGetter
    implements PrivilegedExceptionAction {
        private Object value;
        private Method method;
        private Object instance;

        public PrivilegedGetter(Method method, Object object) {
            this.method = method;
            this.instance = object;
        }

        public Object run() throws IllegalAccessException {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            try {
                this.value = this.method.invoke(this.instance, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

