/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public final class ModelNode
implements Iterable<ModelNode>,
Cloneable {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(ModelNode.class);
    private LinkedList<ModelNode> children;
    private Collection<ModelNode> unmodifiableViewOnContent;
    private final Type type;
    private ModelNode parentNode;
    private PolicySourceModel parentModel;
    private PolicyReferenceData referenceData;
    private PolicySourceModel referencedModel;
    private AssertionData nodeData;

    static ModelNode createRootPolicyNode(PolicySourceModel policySourceModel) throws IllegalArgumentException {
        if (policySourceModel == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0039_POLICY_SRC_MODEL_INPUT_PARAMETER_MUST_NOT_BE_NULL()));
        }
        return new ModelNode(Type.POLICY, policySourceModel);
    }

    private ModelNode(Type type, PolicySourceModel policySourceModel) {
        this.type = type;
        this.parentModel = policySourceModel;
        this.children = new LinkedList();
        this.unmodifiableViewOnContent = Collections.unmodifiableCollection(this.children);
    }

    private ModelNode(Type type, PolicySourceModel policySourceModel, AssertionData assertionData) {
        this(type, policySourceModel);
        this.nodeData = assertionData;
    }

    private ModelNode(PolicySourceModel policySourceModel, PolicyReferenceData policyReferenceData) {
        this(Type.POLICY_REFERENCE, policySourceModel);
        this.referenceData = policyReferenceData;
    }

    private void checkCreateChildOperationSupportForType(Type type) throws UnsupportedOperationException {
        if (!this.type.isChildTypeSupported(type)) {
            throw LOGGER.logSevereException(new UnsupportedOperationException(LocalizationMessages.WSP_0073_CREATE_CHILD_NODE_OPERATION_NOT_SUPPORTED((Object)type, (Object)this.type)));
        }
    }

    public ModelNode createChildPolicyNode() {
        this.checkCreateChildOperationSupportForType(Type.POLICY);
        ModelNode modelNode = new ModelNode(Type.POLICY, this.parentModel);
        this.addChild(modelNode);
        return modelNode;
    }

    public ModelNode createChildAllNode() {
        this.checkCreateChildOperationSupportForType(Type.ALL);
        ModelNode modelNode = new ModelNode(Type.ALL, this.parentModel);
        this.addChild(modelNode);
        return modelNode;
    }

    public ModelNode createChildExactlyOneNode() {
        this.checkCreateChildOperationSupportForType(Type.EXACTLY_ONE);
        ModelNode modelNode = new ModelNode(Type.EXACTLY_ONE, this.parentModel);
        this.addChild(modelNode);
        return modelNode;
    }

    public ModelNode createChildAssertionNode() {
        this.checkCreateChildOperationSupportForType(Type.ASSERTION);
        ModelNode modelNode = new ModelNode(Type.ASSERTION, this.parentModel);
        this.addChild(modelNode);
        return modelNode;
    }

    public ModelNode createChildAssertionNode(AssertionData assertionData) {
        this.checkCreateChildOperationSupportForType(Type.ASSERTION);
        ModelNode modelNode = new ModelNode(Type.ASSERTION, this.parentModel, assertionData);
        this.addChild(modelNode);
        return modelNode;
    }

    public ModelNode createChildAssertionParameterNode() {
        this.checkCreateChildOperationSupportForType(Type.ASSERTION_PARAMETER_NODE);
        ModelNode modelNode = new ModelNode(Type.ASSERTION_PARAMETER_NODE, this.parentModel);
        this.addChild(modelNode);
        return modelNode;
    }

    ModelNode createChildAssertionParameterNode(AssertionData assertionData) {
        this.checkCreateChildOperationSupportForType(Type.ASSERTION_PARAMETER_NODE);
        ModelNode modelNode = new ModelNode(Type.ASSERTION_PARAMETER_NODE, this.parentModel, assertionData);
        this.addChild(modelNode);
        return modelNode;
    }

    ModelNode createChildPolicyReferenceNode(PolicyReferenceData policyReferenceData) {
        this.checkCreateChildOperationSupportForType(Type.POLICY_REFERENCE);
        ModelNode modelNode = new ModelNode(this.parentModel, policyReferenceData);
        this.parentModel.addNewPolicyReference(modelNode);
        this.addChild(modelNode);
        return modelNode;
    }

    Collection<ModelNode> getChildren() {
        return this.unmodifiableViewOnContent;
    }

    void setParentModel(PolicySourceModel policySourceModel) throws IllegalAccessException {
        if (this.parentNode != null) {
            throw LOGGER.logSevereException(new IllegalAccessException(LocalizationMessages.WSP_0049_PARENT_MODEL_CAN_NOT_BE_CHANGED()));
        }
        this.updateParentModelReference(policySourceModel);
    }

    private void updateParentModelReference(PolicySourceModel policySourceModel) {
        this.parentModel = policySourceModel;
        for (ModelNode modelNode : this.children) {
            modelNode.updateParentModelReference(policySourceModel);
        }
    }

    public PolicySourceModel getParentModel() {
        return this.parentModel;
    }

    public Type getType() {
        return this.type;
    }

    public ModelNode getParentNode() {
        return this.parentNode;
    }

    public AssertionData getNodeData() {
        return this.nodeData;
    }

    PolicyReferenceData getPolicyReferenceData() {
        return this.referenceData;
    }

    public AssertionData setOrReplaceNodeData(AssertionData assertionData) {
        if (!this.isDomainSpecific()) {
            throw LOGGER.logSevereException(new UnsupportedOperationException(LocalizationMessages.WSP_0051_OPERATION_NOT_SUPPORTED_FOR_THIS_BUT_ASSERTION_RELATED_NODE_TYPE((Object)this.type)));
        }
        AssertionData assertionData2 = this.nodeData;
        this.nodeData = assertionData;
        return assertionData2;
    }

    boolean isDomainSpecific() {
        return this.type == Type.ASSERTION || this.type == Type.ASSERTION_PARAMETER_NODE;
    }

    private boolean addChild(ModelNode modelNode) {
        this.children.add(modelNode);
        modelNode.parentNode = this;
        return true;
    }

    void setReferencedModel(PolicySourceModel policySourceModel) {
        if (this.type != Type.POLICY_REFERENCE) {
            throw LOGGER.logSevereException(new UnsupportedOperationException(LocalizationMessages.WSP_0050_OPERATION_NOT_SUPPORTED_FOR_THIS_BUT_POLICY_REFERENCE_NODE_TYPE((Object)this.type)));
        }
        this.referencedModel = policySourceModel;
    }

    PolicySourceModel getReferencedModel() {
        return this.referencedModel;
    }

    public int childrenSize() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Iterator<ModelNode> iterator() {
        return this.children.iterator();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModelNode)) {
            return false;
        }
        boolean bl = true;
        ModelNode modelNode = (ModelNode)object;
        boolean bl2 = bl = bl && this.type.equals((Object)modelNode.type);
        boolean bl3 = bl && (this.nodeData == null ? modelNode.nodeData == null : this.nodeData.equals(modelNode.nodeData)) ? true : (bl = false);
        bl = bl && (this.children == null ? modelNode.children == null : this.children.equals(modelNode.children));
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + (this.parentNode == null ? 0 : this.parentNode.hashCode());
        n = 37 * n + (this.nodeData == null ? 0 : this.nodeData.hashCode());
        n = 37 * n + this.children.hashCode();
        return n;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    public StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        stringBuffer.append(string).append((Object)this.type).append(" {").append(PolicyUtils.Text.NEW_LINE);
        if (this.type == Type.ASSERTION) {
            if (this.nodeData == null) {
                stringBuffer.append(string2).append("no assertion data set");
            } else {
                this.nodeData.toString(n + 1, stringBuffer);
            }
            stringBuffer.append(PolicyUtils.Text.NEW_LINE);
        } else if (this.type == Type.POLICY_REFERENCE) {
            if (this.referenceData == null) {
                stringBuffer.append(string2).append("no policy reference data set");
            } else {
                this.referenceData.toString(n + 1, stringBuffer);
            }
            stringBuffer.append(PolicyUtils.Text.NEW_LINE);
        } else if (this.type == Type.ASSERTION_PARAMETER_NODE) {
            if (this.nodeData == null) {
                stringBuffer.append(string2).append("no parameter data set");
            } else {
                this.nodeData.toString(n + 1, stringBuffer);
            }
            stringBuffer.append(PolicyUtils.Text.NEW_LINE);
        }
        if (this.children.size() > 0) {
            for (ModelNode modelNode : this.children) {
                modelNode.toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
            }
        } else {
            stringBuffer.append(string2).append("no child nodes").append(PolicyUtils.Text.NEW_LINE);
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }

    protected ModelNode clone() throws CloneNotSupportedException {
        ModelNode modelNode = (ModelNode)super.clone();
        if (this.nodeData != null) {
            modelNode.nodeData = this.nodeData.clone();
        }
        if (this.referencedModel != null) {
            modelNode.referencedModel = this.referencedModel.clone();
        }
        modelNode.children = new LinkedList();
        modelNode.unmodifiableViewOnContent = Collections.unmodifiableCollection(modelNode.children);
        for (ModelNode modelNode2 : this.children) {
            modelNode.addChild(modelNode2.clone());
        }
        return modelNode;
    }

    PolicyReferenceData getReferenceData() {
        return this.referenceData;
    }

    public static enum Type {
        POLICY(XmlToken.Policy),
        ALL(XmlToken.All),
        EXACTLY_ONE(XmlToken.ExactlyOne),
        POLICY_REFERENCE(XmlToken.PolicyReference),
        ASSERTION(XmlToken.UNKNOWN),
        ASSERTION_PARAMETER_NODE(XmlToken.UNKNOWN);

        private XmlToken token;

        private Type(XmlToken xmlToken) {
            this.token = xmlToken;
        }

        public XmlToken getXmlToken() {
            return this.token;
        }

        private boolean isChildTypeSupported(Type type) {
            switch (this) {
                case POLICY: 
                case ALL: 
                case EXACTLY_ONE: {
                    switch (type) {
                        case ASSERTION_PARAMETER_NODE: {
                            return false;
                        }
                    }
                    return true;
                }
                case POLICY_REFERENCE: {
                    return false;
                }
                case ASSERTION: {
                    switch (type) {
                        case ASSERTION_PARAMETER_NODE: 
                        case POLICY: 
                        case POLICY_REFERENCE: {
                            return true;
                        }
                    }
                    return false;
                }
                case ASSERTION_PARAMETER_NODE: {
                    switch (type) {
                        case ASSERTION_PARAMETER_NODE: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0060_POLICY_ELEMENT_TYPE_UNKNOWN((Object)this)));
        }
    }
}

