/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingPropertySet;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.OneWayFeature;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.message.SuppressAutomaticWSARequestHeadersFeature;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.message.RelatesToHeader;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.resources.ClientMessages;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public class AddressingUtils {
    public static void fillRequestAddressingHeaders(MessageHeaders messageHeaders, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string) {
        AddressingUtils.fillRequestAddressingHeaders(messageHeaders, packet, addressingVersion, sOAPVersion, bl, string, false);
    }

    public static void fillRequestAddressingHeaders(MessageHeaders messageHeaders, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string, boolean bl2) {
        AddressingUtils.fillCommonAddressingHeaders(messageHeaders, packet, addressingVersion, sOAPVersion, string, bl2);
        if (!bl) {
            WSEndpointReference wSEndpointReference = addressingVersion.anonymousEpr;
            if (messageHeaders.get(addressingVersion.replyToTag, false) == null) {
                messageHeaders.add(wSEndpointReference.createHeader(addressingVersion.replyToTag));
            }
            if (messageHeaders.get(addressingVersion.faultToTag, false) == null) {
                messageHeaders.add(wSEndpointReference.createHeader(addressingVersion.faultToTag));
            }
            if (packet.getMessage().getHeaders().get(addressingVersion.messageIDTag, false) == null && messageHeaders.get(addressingVersion.messageIDTag, false) == null) {
                StringHeader stringHeader = new StringHeader(addressingVersion.messageIDTag, Message.generateMessageID());
                messageHeaders.add(stringHeader);
            }
        }
    }

    public static void fillRequestAddressingHeaders(MessageHeaders messageHeaders, WSDLPort wSDLPort, WSBinding wSBinding, Packet packet) {
        Object object;
        boolean bl;
        if (wSBinding == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_BINDING());
        }
        if (wSBinding.isFeatureEnabled(SuppressAutomaticWSARequestHeadersFeature.class)) {
            return;
        }
        MessageHeaders messageHeaders2 = packet.getMessage().getHeaders();
        String string = AddressingUtils.getAction(messageHeaders2, wSBinding.getAddressingVersion(), wSBinding.getSOAPVersion());
        if (string != null) {
            return;
        }
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        WsaTubeHelper wsaTubeHelper = addressingVersion.getWsaHelper(wSDLPort, null, wSBinding);
        String string2 = wsaTubeHelper.getEffectiveInputAction(packet);
        if (string2 == null || string2.equals("") && wSBinding.getSOAPVersion() == SOAPVersion.SOAP_11) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ACTION());
        }
        boolean bl2 = bl = packet.expectReply == false;
        if (wSDLPort != null && !bl && packet.getMessage() != null && packet.getWSDLOperation() != null && (object = wSDLPort.getBinding().get(packet.getWSDLOperation())) != null && object.getAnonymous() == WSDLBoundOperation.ANONYMOUS.prohibited) {
            throw new WebServiceException(AddressingMessages.WSAW_ANONYMOUS_PROHIBITED());
        }
        object = wSBinding.getFeature(OneWayFeature.class);
        AddressingPropertySet addressingPropertySet = packet.getSatellite(AddressingPropertySet.class);
        Object object2 = object = addressingPropertySet == null ? object : new OneWayFeature(addressingPropertySet, addressingVersion);
        if (object == null || !((WebServiceFeature)object).isEnabled()) {
            AddressingUtils.fillRequestAddressingHeaders(messageHeaders, packet, addressingVersion, wSBinding.getSOAPVersion(), bl, string2, AddressingVersion.isRequired(wSBinding));
        } else {
            AddressingUtils.fillRequestAddressingHeaders(messageHeaders, packet, addressingVersion, wSBinding.getSOAPVersion(), (OneWayFeature)object, bl, string2);
        }
    }

    public static String getAction(@NotNull MessageHeaders messageHeaders, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        String string = null;
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.actionTag, true, sOAPVersion);
        if (header != null) {
            string = header.getStringContent();
        }
        return string;
    }

    public static WSEndpointReference getFaultTo(@NotNull MessageHeaders messageHeaders, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.faultToTag, true, sOAPVersion);
        WSEndpointReference wSEndpointReference = null;
        if (header != null) {
            try {
                wSEndpointReference = header.readAsEPR(addressingVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), xMLStreamException);
            }
        }
        return wSEndpointReference;
    }

    public static String getMessageID(@NotNull MessageHeaders messageHeaders, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.messageIDTag, true, sOAPVersion);
        String string = null;
        if (header != null) {
            string = header.getStringContent();
        }
        return string;
    }

    public static String getRelatesTo(@NotNull MessageHeaders messageHeaders, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.relatesToTag, true, sOAPVersion);
        String string = null;
        if (header != null) {
            string = header.getStringContent();
        }
        return string;
    }

    public static WSEndpointReference getReplyTo(@NotNull MessageHeaders messageHeaders, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        WSEndpointReference wSEndpointReference;
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.replyToTag, true, sOAPVersion);
        if (header != null) {
            try {
                wSEndpointReference = header.readAsEPR(addressingVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), xMLStreamException);
            }
        } else {
            wSEndpointReference = addressingVersion.anonymousEpr;
        }
        return wSEndpointReference;
    }

    public static String getTo(MessageHeaders messageHeaders, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = AddressingUtils.getFirstHeader(messageHeaders, addressingVersion.toTag, true, sOAPVersion);
        String string = header != null ? header.getStringContent() : addressingVersion.anonymousUri;
        return string;
    }

    public static Header getFirstHeader(MessageHeaders messageHeaders, QName qName, boolean bl, SOAPVersion sOAPVersion) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        Iterator<Header> iterator = messageHeaders.getHeaders(qName.getNamespaceURI(), qName.getLocalPart(), bl);
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getRole(sOAPVersion).equals(sOAPVersion.implicitRole)) continue;
            return header;
        }
        return null;
    }

    private static void fillRequestAddressingHeaders(@NotNull MessageHeaders messageHeaders, @NotNull Packet packet, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull OneWayFeature oneWayFeature, boolean bl, @NotNull String string) {
        if (!bl && !oneWayFeature.isUseAsyncWithSyncInvoke() && Boolean.TRUE.equals(packet.isSynchronousMEP)) {
            AddressingUtils.fillRequestAddressingHeaders(messageHeaders, packet, addressingVersion, sOAPVersion, bl, string);
        } else {
            Object object;
            Object object2;
            AddressingUtils.fillCommonAddressingHeaders(messageHeaders, packet, addressingVersion, sOAPVersion, string, false);
            boolean bl2 = false;
            if (messageHeaders.get(addressingVersion.replyToTag, false) == null && (object2 = oneWayFeature.getReplyTo()) != null) {
                messageHeaders.add(((WSEndpointReference)object2).createHeader(addressingVersion.replyToTag));
                if (packet.getMessage().getHeaders().get(addressingVersion.messageIDTag, false) == null) {
                    object = oneWayFeature.getMessageId() == null ? Message.generateMessageID() : oneWayFeature.getMessageId();
                    messageHeaders.add(new StringHeader(addressingVersion.messageIDTag, (String)object));
                    bl2 = true;
                }
            }
            object2 = oneWayFeature.getMessageId();
            if (!bl2 && object2 != null) {
                messageHeaders.add(new StringHeader(addressingVersion.messageIDTag, (String)object2));
            }
            if (messageHeaders.get(addressingVersion.faultToTag, false) == null && (object = oneWayFeature.getFaultTo()) != null) {
                messageHeaders.add(((WSEndpointReference)object).createHeader(addressingVersion.faultToTag));
                if (messageHeaders.get(addressingVersion.messageIDTag, false) == null) {
                    messageHeaders.add(new StringHeader(addressingVersion.messageIDTag, Message.generateMessageID()));
                }
            }
            if (oneWayFeature.getFrom() != null) {
                messageHeaders.addOrReplace(oneWayFeature.getFrom().createHeader(addressingVersion.fromTag));
            }
            if (oneWayFeature.getRelatesToID() != null) {
                messageHeaders.addOrReplace(new RelatesToHeader(addressingVersion.relatesToTag, oneWayFeature.getRelatesToID()));
            }
        }
    }

    private static void fillCommonAddressingHeaders(MessageHeaders messageHeaders, Packet packet, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string, boolean bl) {
        StringHeader stringHeader;
        if (packet == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_PACKET());
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        if (sOAPVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        if (string == null && !sOAPVersion.httpBindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ACTION());
        }
        if (messageHeaders.get(addressingVersion.toTag, false) == null) {
            stringHeader = new StringHeader(addressingVersion.toTag, packet.endpointAddress.toString());
            messageHeaders.add(stringHeader);
        }
        if (string != null) {
            packet.soapAction = string;
            if (messageHeaders.get(addressingVersion.actionTag, false) == null) {
                stringHeader = new StringHeader(addressingVersion.actionTag, string, sOAPVersion, bl);
                messageHeaders.add(stringHeader);
            }
        }
    }
}

