/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tileset;
import editor.Z80Factory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JPanel;
import mastersystem.OutputListener;
import mastersystem.Renderer;
import mastersystem.Z80;
import rom.RomManager;

public class EntityPanel
extends JPanel {
    private BufferedImage entityImage;
    private final Color[] colors = new Color[32];
    private int entityType;
    private int entityExtraData;
    private int entitySpriteDescriptor = 32993;
    private int entityJankenMatchDecision;
    private int entitySlot;
    private Tileset tileset;
    private Palette palette;
    private final int addressUpdateEntities;
    private boolean selected;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(EntityPanel.this.tileset) >= 256) {
                EntityPanel.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(EntityPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 >= 1) {
                    int n3 = 16;
                    while (n3 < 32) {
                        int n4 = EntityPanel.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((EntityPanel)EntityPanel.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n > 16) {
                int n8 = EntityPanel.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((EntityPanel)EntityPanel.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                EntityPanel.this.update();
            }
        }
    };

    public EntityPanel(int n, int n2, int n3, Tileset tileset, Palette palette, int n4) {
        this.addressUpdateEntities = n4;
        this.setEntityType(n, n2, n3, tileset, palette);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EntityPanel.this.fireActionPerformed();
            }
        });
    }

    public void setEntityType(int n, int n2, int n3, Tileset tileset, Palette palette) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.entityType = n;
        this.entityExtraData = n2;
        this.entitySlot = n3;
        this.tileset = tileset;
        this.palette = palette;
        int n4 = 0;
        int[] nArray = palette.getColors();
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = nArray[n6];
            int n8 = (n7 & 0x30) >> 4;
            int n9 = (n7 & 0xC) >> 2;
            int n10 = n7 & 3;
            this.colors[n4++] = new Color(n10 * 255 / 3, n9 * 255 / 3, n8 * 255 / 3);
            ++n6;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    public void setEntityJankenMatchDecision(int n) {
        this.entityJankenMatchDecision = n;
        this.update();
    }

    public void setEntitySpriteDescriptor(int n) {
        this.entitySpriteDescriptor = n;
        this.update();
    }

    public void setTileset(Tileset tileset) {
        this.tileset = tileset;
        this.update();
    }

    @Override
    public boolean isValid() {
        return this.entityImage != null;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    private void update() {
        int n;
        int n2;
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        nArray[10607] = 201;
        nArray[49400] = 1;
        if (this.entityType == 1) {
            this.entitySlot = 0;
            if (this.entityExtraData == 1) {
                nArray[49233] = 1;
            } else if (this.entityExtraData != 0) {
                nArray[49236] = 9;
            }
        }
        int n3 = 49920 + this.entitySlot * 32;
        nArray[49401] = n3 & 0xFF;
        nArray[49402] = n3 >> 8;
        nArray[n3] = this.entityType;
        nArray[n3 + 3] = this.entityExtraData;
        nArray[n3 + 7] = this.entitySpriteDescriptor & 0xFF;
        nArray[n3 + 8] = this.entitySpriteDescriptor >> 8;
        nArray[n3 + 12] = 64;
        nArray[n3 + 14] = 64;
        nArray[n3 + 23] = this.entityJankenMatchDecision;
        if (this.entityType != 79) {
            nArray[n3 + 9] = 255;
        }
        nArray[50950] = 208;
        Z80 z80 = Z80Factory.create(nArray);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >= 51008 && n < 51072) {
                    throw new ArrayIndexOutOfBoundsException("The SAT has overflown.");
                }
            }
        });
        z80.execute(this.addressUpdateEntities);
        int n4 = nArray[n3 + 8] << 8 | nArray[n3 + 7];
        if (n4 == 0) {
            this.entityImage = null;
            return;
        }
        nArray[1230] = 201;
        nArray[n3 + 9] = 0;
        z80.execute(this.addressUpdateEntities);
        int n5 = 256;
        int n6 = 0;
        int n7 = 256;
        int n8 = 0;
        int n9 = 6;
        while (n9 < 64 && nArray[50944 + n9] != 208) {
            n2 = nArray[50944 + n9] + 1;
            if (n2 >= 240) {
                n2 -= 256;
            }
            n = nArray[0xC780 | n9 << 1];
            if (n2 < n5) {
                n5 = n2;
            }
            if (n2 + 8 > n6) {
                n6 = n2 + 8;
            }
            if (n < n7) {
                n7 = n;
            }
            if (n + 8 > n8) {
                n8 = n + 8;
            }
            ++n9;
        }
        this.entityImage = null;
        if (n8 > n7 && n6 > n5 && n8 - n7 <= 64 && n6 - n5 <= 64) {
            this.entityImage = new BufferedImage(n8 - n7, n6 - n5, 1);
            Dimension dimension = this.getMaximumSize();
            n2 = this.entityImage.getWidth() * 2;
            n = this.entityImage.getHeight() * 2;
            if (n2 > dimension.width) {
                n2 = dimension.width;
            }
            if (n > dimension.height) {
                n = dimension.height;
            }
            this.setPreferredSize(new Dimension(n2, n));
            this.setSize(this.getPreferredSize());
            int[] nArray2 = this.tileset.getVRAM();
            int n10 = 6;
            while (n10 < 64 && nArray[50944 + n10] != 208) {
                int n11 = nArray[50944 + n10] + 1;
                if (n11 >= 240) {
                    n11 -= 256;
                }
                int n12 = nArray[0xC780 | n10 << 1];
                int n13 = nArray[0xC780 | n10 << 1 | 1];
                Renderer.renderSpriteCharacter(nArray2, n13, n12 - n7, n11 - n5, this.colors, this.entityImage);
                ++n10;
            }
        } else {
            this.setPreferredSize(new Dimension(16, 16));
            this.setSize(this.getPreferredSize());
        }
        this.repaint();
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.entityImage != null) {
            graphics.drawImage(this.entityImage, 0, 0, this.getWidth(), this.getHeight(), null);
            if (this.selected) {
                graphics.setColor(Color.RED);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

