/*
 * Decompiled with CFR 0.152.
 */
package editors;

import editors.EntityLabelProvider;
import editors.TextProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileEntityLabelProvider
implements EntityLabelProvider {
    private final List<String> entities = new ArrayList<String>();

    public FileEntityLabelProvider(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.isEmpty()) break;
                String[] stringArray = string.split(" ");
                int n = 1;
                while (n < stringArray.length) {
                    if (Character.isLetter(stringArray[n].charAt(0))) {
                        this.entities.add(FileEntityLabelProvider.toLabel(stringArray[n]));
                    } else {
                        this.entities.add(null);
                    }
                    ++n;
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {}
    }

    private static String toLabel(String string) {
        String string2 = TextProvider.get(string, true);
        if (string2 != null) {
            return string2;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 < n && Character.isLowerCase(string.charAt(n3))) {
                ++n3;
            }
            stringBuilder.append(string.substring(n2, n3));
            n2 = n3;
            if (n2 >= n) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getLabel(int n, int n2) {
        if (n - 1 < 0 || n - 1 >= this.entities.size()) {
            return null;
        }
        return this.entities.get(n - 1);
    }
}

