/*
 * Decompiled with CFR 0.152.
 */
package changes;

import changes.Changable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import rom.RomManager;
import transactions.TransactionObject;

public class Change {
    private final int[][] oldData;
    private final List<TransactionObject> transactionObjects;
    private final int data;

    private Change(List<TransactionObject> list, int[][] nArray, int n) {
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.transactionObjects = list;
        if (nArray == null) {
            nArray = new int[0][0];
        }
        this.oldData = nArray;
        this.data = n;
    }

    public Change(List<TransactionObject> list, int[][] nArray) {
        this(list, nArray, -1);
    }

    public Change(List<TransactionObject> list, int[] nArray) {
        this(list, Change.oldDataFromAddresses(nArray), -1);
    }

    private static int[][] oldDataFromAddresses(int[] nArray) {
        int[][] nArray2 = new int[nArray.length][2];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n][0] = nArray[n];
            nArray2[n][1] = RomManager.StaticAccess.readByte(nArray[n]);
            ++n;
        }
        return nArray2;
    }

    public Change(Changable changable, int n, int[][] nArray) {
        this(Arrays.asList(new TransactionObject(changable, n)), nArray, n);
    }

    public Change(int n) {
        this(null, null, n);
    }

    public int[][] getOldData() {
        return this.oldData;
    }

    public Changable getChangableObject() {
        if (this.getTransactionObjects().isEmpty()) {
            return null;
        }
        return this.getTransactionObjects().get(0).getObject();
    }

    public List<TransactionObject> getTransactionObjects() {
        return this.transactionObjects;
    }

    public int getData(Changable changable) {
        for (TransactionObject transactionObject : this.getTransactionObjects()) {
            if (transactionObject.getObject() != changable) continue;
            return transactionObject.getData();
        }
        if (this.getTransactionObjects().isEmpty()) {
            return this.data;
        }
        return this.getTransactionObjects().get(0).getData();
    }
}

