/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.SocketChannelImpl")
public final class SocketChannelImplRMHooks {
    @InstrumentationMethod
    public SocketAddress getLocalAddress() throws IOException {
        return this.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open socket channels", resourceRequestDeniedException);
            }
        }
        int n = 0;
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.bind(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return socketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public boolean connect(SocketAddress socketAddress) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open sockets");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open sockets", resourceRequestDeniedException);
            }
        }
        int n = 0;
        boolean bl = false;
        try {
            bl = this.connect(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_READ_GROUP.getApprover(this);
        long l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = this.read(byteBuffer);
            n2 = Math.max(n3, 0);
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.read(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_READ_GROUP.getApprover(this);
        long l = 0L;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        long l2 = 0L;
        long l3 = 0L;
        try {
            l3 = this.read(byteBufferArray, n, n2);
            l2 = Math.max(l3, 0L);
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_WRITE_GROUP.getApprover(this);
        long l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            n2 = this.write(byteBuffer);
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.write(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_WRITE_GROUP.getApprover(this);
        long l = 0L;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        long l2 = 0L;
        try {
            l2 = this.write(byteBufferArray, n, n2);
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return l2;
    }
}

