/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tileset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mastersystem.Renderer;
import panels.Scalable;
import panels.ScaleListener;
import transactions.TransactionObject;

public class TilesetComboBox
extends JComboBox<ImageIcon>
implements Scalable {
    private BufferedImage[] images;
    private BufferedImage[] scaledImages;
    private boolean[] dirty;
    private Tileset[] tilesets;
    private Palette palette;
    private final Color[] colors = new Color[32];
    private float scale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private Scalable scaleParent = this;
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilesetComboBox.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = TilesetComboBox.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((TilesetComboBox)TilesetComboBox.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = TilesetComboBox.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilesetComboBox)TilesetComboBox.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            TilesetComboBox.this.update();
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            for (TransactionObject transactionObject : change.getTransactionObjects()) {
                if (!(transactionObject.getObject() instanceof Tileset)) continue;
                TilesetComboBox.this.setDirty((Tileset)transactionObject.getObject());
            }
        }
    };

    public TilesetComboBox(Tileset[] tilesetArray, Palette palette) {
        this.setTilesets(tilesetArray, palette);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                TilesetComboBox.this.updateDirty();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public void setSelectedTileset(int n) {
        int n2 = 0;
        while (n2 < this.tilesets.length) {
            if (n == (0x8000 | this.tilesets[n2].getSource() & 0x3FFF)) {
                this.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        System.err.println("TilesetComboBox couldn't find tileset at " + Integer.toHexString(n));
    }

    @Override
    public void setSelectedIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        super.setSelectedIndex(n);
        if (this.dirty[n]) {
            this.renderTileset(n);
        }
    }

    @Override
    public int getSelectedIndex() {
        return Math.max(0, super.getSelectedIndex());
    }

    public Tileset getSelectedTileset() {
        return this.tilesets[this.getSelectedIndex()];
    }

    public void setTilesets(Tileset[] tilesetArray, Palette palette) {
        int n;
        int n2;
        if (this.tilesets != null) {
            Tileset[] tilesetArray2 = this.tilesets;
            n2 = this.tilesets.length;
            n = 0;
            while (n < n2) {
                Tileset tileset = tilesetArray2[n];
                tileset.removeChangeListener(this.tilesetChangeListener);
                ++n;
            }
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tilesets = tilesetArray;
        this.palette = palette;
        int n3 = 0;
        Object[] objectArray = palette.getColors();
        int n4 = objectArray.length;
        n2 = 0;
        while (n2 < n4) {
            n = objectArray[n2];
            int n5 = (n & 0x30) >> 4;
            int n6 = (n & 0xC) >> 2;
            int n7 = n & 3;
            this.colors[n3++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n2;
        }
        objectArray = tilesetArray;
        n4 = tilesetArray.length;
        n2 = 0;
        while (n2 < n4) {
            int n8 = objectArray[n2];
            n8.addChangeListener(this.tilesetChangeListener);
            ++n2;
        }
        palette.addChangeListener(this.paletteChangeListener);
        this.updateImages();
    }

    private void updateImages() {
        int n;
        this.images = new BufferedImage[this.tilesets.length];
        this.scaledImages = new BufferedImage[this.images.length];
        this.dirty = new boolean[this.images.length];
        int n2 = 0;
        while (n2 < this.tilesets.length) {
            n = this.tilesets[n2].getLength();
            this.images[n2] = new BufferedImage(Math.min(256, n / 32 * 8), ((n / 32 - 1) / 32 + 1) * 8, 2);
            this.scaledImages[n2] = new BufferedImage((int)((float)this.images[n2].getWidth() * this.scale), (int)((float)this.images[n2].getHeight() * this.scale), this.images[n2].getType());
            ++n2;
        }
        ImageIcon[] imageIconArray = new ImageIcon[this.tilesets.length];
        n = 0;
        while (n < this.scaledImages.length) {
            imageIconArray[n] = new ImageIcon(this.scaledImages[n]);
            ++n;
        }
        if (this.getItemCount() > 0) {
            ActionListener actionListener;
            ActionListener[] actionListenerArray;
            n = this.getSelectedIndex();
            ActionListener[] actionListenerArray2 = actionListenerArray = this.getActionListeners();
            int n3 = actionListenerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                actionListener = actionListenerArray2[n4];
                this.removeActionListener(actionListener);
                ++n4;
            }
            this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
            this.setSelectedIndex(n);
            actionListenerArray2 = actionListenerArray;
            n3 = actionListenerArray.length;
            n4 = 0;
            while (n4 < n3) {
                actionListener = actionListenerArray2[n4];
                this.addActionListener(actionListener);
                ++n4;
            }
        } else {
            this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
        }
        this.update();
    }

    private void ensureImageDimensions(int n) {
        int n2 = this.tilesets[n].getLength();
        int n3 = Math.min(256, n2 / 32 * 8);
        int n4 = ((n2 / 32 - 1) / 32 + 1) * 8;
        if (this.images[n].getWidth() != n3 || this.images[n].getHeight() != n4) {
            this.images[n] = new BufferedImage(n3, n4, 2);
            this.scaledImages[n] = new BufferedImage((int)((float)this.images[n].getWidth() * this.scale), (int)((float)this.images[n].getHeight() * this.scale), this.images[n].getType());
            ImageIcon[] imageIconArray = new ImageIcon[this.tilesets.length];
            int n5 = 0;
            while (n5 < this.scaledImages.length) {
                imageIconArray[n5] = new ImageIcon(this.scaledImages[n5]);
                ++n5;
            }
            if (this.getItemCount() > 0) {
                ActionListener actionListener;
                ActionListener[] actionListenerArray;
                n5 = this.getSelectedIndex();
                ActionListener[] actionListenerArray2 = actionListenerArray = this.getActionListeners();
                int n6 = actionListenerArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    actionListener = actionListenerArray2[n7];
                    this.removeActionListener(actionListener);
                    ++n7;
                }
                this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
                this.setSelectedIndex(n5);
                actionListenerArray2 = actionListenerArray;
                n6 = actionListenerArray.length;
                n7 = 0;
                while (n7 < n6) {
                    actionListener = actionListenerArray2[n7];
                    this.addActionListener(actionListener);
                    ++n7;
                }
            } else {
                this.setModel(new JComboBox<ImageIcon>(imageIconArray).getModel());
            }
        }
    }

    private void setDirty(Tileset tileset) {
        int n = 0;
        while (n < this.tilesets.length) {
            if (this.tilesets[n] == tileset) {
                if (n == this.getSelectedIndex()) {
                    this.renderTileset(n);
                    this.revalidate();
                    this.repaint();
                } else {
                    this.dirty[n] = true;
                }
                return;
            }
            ++n;
        }
    }

    private void updateDirty() {
        int n = 0;
        while (n < this.dirty.length) {
            if (this.dirty[n]) {
                this.renderTileset(n);
                this.dirty[n] = false;
            }
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    private void renderTileset(int n) {
        if (n >= this.tilesets.length) {
            return;
        }
        this.ensureImageDimensions(n);
        this.clearImage(n);
        int[] nArray = this.tilesets[n].getVRAM();
        int n2 = 0;
        int[] nArray2 = this.tilesets[n].getCharCodes();
        int n3 = nArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            Renderer.renderSpriteCharacter(nArray, n5, n2 % 32 * 8, n2 / 32 * 8, this.colors, this.images[n]);
            ++n2;
            ++n4;
        }
        Graphics2D graphics2D = this.scaledImages[n].createGraphics();
        graphics2D.drawImage(this.images[n], 0, 0, this.scaledImages[n].getWidth(), this.scaledImages[n].getHeight(), null);
        graphics2D.dispose();
    }

    private void clearImage(int n) {
        TilesetComboBox.clearImage(this.images[n]);
        TilesetComboBox.clearImage(this.scaledImages[n]);
    }

    private static void clearImage(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    private void update() {
        int n = 0;
        while (n < this.tilesets.length) {
            this.setDirty(this.tilesets[n]);
            ++n;
        }
    }

    @Override
    public void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setIntegerScaling(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getPreferredScale() {
        return this.scale;
    }

    @Override
    public boolean isIntegerScaling() {
        return false;
    }

    @Override
    public void setPreferredScale(float f) {
        float f2 = this.scale;
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.scale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        if (Math.abs(this.scale - f2) > 0.01f) {
            this.updateImages();
        }
    }

    @Override
    public void addScaleListener(ScaleListener scaleListener) {
    }

    @Override
    public void removeScaleListener(ScaleListener scaleListener) {
    }
}

