/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.SpriteContainer;
import data.Tileset;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import mastersystem.Renderer;
import panels.Scalable;
import panels.ScaleListener;

public class SpriteList
extends JScrollPane
implements Scalable {
    private final JList<JPanel> list = new JList();
    private Color[] colors = new Color[32];
    private Palette palette;
    private Tileset tileset;
    private SpriteContainer sprite;
    private float scale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private Scalable scaleParent = this;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(SpriteList.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 >= 1) {
                    int n3 = 16;
                    while (n3 < 32) {
                        int n4 = SpriteList.this.palette.getColors()[n3];
                        int n5 = (n4 & 0x30) >> 4;
                        int n6 = (n4 & 0xC) >> 2;
                        int n7 = n4 & 3;
                        ((SpriteList)SpriteList.this).colors[n3] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
                        ++n3;
                    }
                }
            } else if (n > 16) {
                int n8 = SpriteList.this.palette.getColors()[n];
                int n9 = (n8 & 0x30) >> 4;
                int n10 = (n8 & 0xC) >> 2;
                int n11 = n8 & 3;
                ((SpriteList)SpriteList.this).colors[n] = new Color(n11 * 255 / 3, n10 * 255 / 3, n9 * 255 / 3);
                SpriteList.this.update();
            }
        }
    };
    private final ChangeListener spriteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteList.this.update();
        }
    };
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SpriteList.this.update();
        }
    };

    public SpriteList(SpriteContainer spriteContainer, Palette palette, Tileset tileset) {
        super(20, 31);
        this.setViewportView(this.list);
        this.list.setCellRenderer(new ListCellRenderer<JPanel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends JPanel> jList, JPanel jPanel, int n, boolean bl, boolean bl2) {
                if (bl) {
                    jPanel.setBackground(jList.getSelectionBackground());
                } else {
                    jPanel.setBackground(jList.getBackground());
                }
                return jPanel;
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                jList.setSelectedIndex(jList.locationToIndex(mouseEvent.getPoint()));
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SpriteList.this.fireActionPerformed();
                }
            }
        });
        this.list.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void clearSelection() {
            }
        });
        this.setFocusable(false);
        this.setSprite(spriteContainer, palette, tileset);
        this.list.setSelectedIndex(0);
    }

    public void setSprite(SpriteContainer spriteContainer, Palette palette, Tileset tileset) {
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        if (this.sprite != null && this.sprite != spriteContainer) {
            this.sprite.removeChangeListener(this.spriteChangeListener);
        }
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        this.palette = palette;
        this.sprite = spriteContainer;
        this.tileset = tileset;
        int n = 0;
        int[] nArray = palette.getColors();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        palette.addChangeListener(this.paletteChangeListener);
        spriteContainer.addChangeListener(this.spriteChangeListener);
        tileset.addChangeListener(this.tilesetChangeListener);
        this.update();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    private void update() {
        Vector<JPanel> vector = new Vector<JPanel>();
        int n = 256;
        int n2 = 0;
        int n3 = 256;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.sprite.getSpriteCount()) {
            int n6;
            int n7;
            int[] nArray = this.sprite.getVRAM(n5, this.tileset);
            int[] nArray2 = this.sprite.getSAT(n5);
            int n8 = 0;
            while (n8 < 64 && nArray2[n8] != 208) {
                n7 = nArray2[n8] + 1;
                if (n7 >= 240) {
                    n7 -= 256;
                }
                n6 = nArray2[0x80 | n8 << 1];
                if (n7 < n) {
                    n = n7;
                }
                if (n7 + 8 > n2) {
                    n2 = n7 + 8;
                }
                if (n6 < n3) {
                    n3 = n6;
                }
                if (n6 + 8 > n4) {
                    n4 = n6 + 8;
                }
                ++n8;
            }
            BufferedImage bufferedImage = new BufferedImage(n4 - n3, n2 - n, 2);
            n7 = 0;
            while (n7 < 64 && nArray2[n7] != 208) {
                n6 = nArray2[n7] + 1;
                if (n6 >= 240) {
                    n6 -= 256;
                }
                int n9 = nArray2[0x80 | n7 << 1];
                int n10 = nArray2[0x80 | n7 << 1 | 1];
                Renderer.renderSpriteCharacter(nArray, n10, n9 - n3, n6 - n, this.colors, bufferedImage);
                ++n7;
            }
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(new ImageIcon(bufferedImage.getScaledInstance((int)((float)bufferedImage.getWidth() * this.scale), (int)((float)bufferedImage.getHeight() * this.scale), 0))));
            vector.add(jPanel);
            ++n5;
        }
        this.list.setListData(vector);
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    public void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setBackground(Color color) {
        if (this.list != null) {
            this.list.setBackground(color);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public float getPreferredScale() {
        return this.scale;
    }

    @Override
    public boolean isIntegerScaling() {
        return false;
    }

    @Override
    public void setPreferredScale(float f) {
        float f2 = this.scale;
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.scale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        if (Math.abs(this.scale - f2) > 0.01f) {
            this.update();
        }
    }

    @Override
    public void setIntegerScaling(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addScaleListener(ScaleListener scaleListener) {
    }

    @Override
    public void removeScaleListener(ScaleListener scaleListener) {
    }
}

