/*
 * Decompiled with CFR 0.152.
 */
package util.string;

import util.string.SubCharSequence;

public class ConcatenatedCharSequence
implements CharSequence {
    private final CharSequence sequence1;
    private final CharSequence sequence2;
    private final int length;

    public ConcatenatedCharSequence(CharSequence charSequence, CharSequence charSequence2) {
        this.sequence1 = charSequence;
        this.sequence2 = charSequence2;
        this.length = charSequence.length() + charSequence2.length();
    }

    @Override
    public char charAt(int n) {
        if (n >= this.sequence1.length()) {
            return this.sequence2.charAt(n - this.sequence1.length());
        }
        return this.sequence1.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n >= this.sequence1.length() && n2 >= this.sequence1.length()) {
            return this.sequence2.subSequence(n - this.sequence1.length(), n2 - this.sequence1.length());
        }
        if (n < this.sequence1.length() && n2 < this.sequence1.length()) {
            return this.sequence1.subSequence(n, n2);
        }
        return new SubCharSequence(this.toString(), n, n2);
    }

    private StringBuilder buildString(StringBuilder stringBuilder) {
        if (this.sequence1 instanceof ConcatenatedCharSequence) {
            ((ConcatenatedCharSequence)this.sequence1).buildString(stringBuilder);
        } else {
            stringBuilder.append(this.sequence1.toString());
        }
        if (this.sequence2 instanceof ConcatenatedCharSequence) {
            ((ConcatenatedCharSequence)this.sequence2).buildString(stringBuilder);
        } else {
            stringBuilder.append(this.sequence2.toString());
        }
        return stringBuilder;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String toString() {
        return this.buildString(new StringBuilder()).toString();
    }
}

