/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.NameTable;
import data.Palette;
import data.Shop;
import data.Tiles;
import data.Tileset;
import editors.ItemEditor;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import panels.ShopPanel;

public class ShopEditor
extends JDialog {
    private static ShopEditor editor;
    private final JFrame owner;
    private Shop shop;
    private Tileset tileset;
    private Palette palette;
    private final JComboBox<String> shopSelection;
    private final ShopPanel shopPanel;

    private ShopEditor(JFrame jFrame, Shop shop, Tileset tileset, Palette palette, NameTable nameTable, Tiles tiles) {
        this.setTitle(TextProvider.get("TitleShop"));
        this.owner = jFrame;
        this.shop = shop;
        this.tileset = tileset;
        this.palette = palette;
        this.setLayout(new BorderLayout());
        LinkedList<Shop.ShopHandle> linkedList = shop.getShopHandles();
        String[] stringArray = new String[linkedList.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(TextProvider.get("Shop")) + " " + (n + 1);
            ++n;
        }
        this.shopSelection = new JComboBox<String>(stringArray);
        this.shopSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                ShopEditor.this.shopPanel.setShop(jComboBox.getSelectedIndex());
            }
        });
        this.shopSelection.setFocusable(false);
        this.add(this.shopSelection, "North");
        this.shopPanel = new ShopPanel(shop, tileset, palette, nameTable, tiles);
        this.add((Component)this.shopPanel, "Center");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        ShopEditor.this.shopPanel.selectPrevItem();
                        break;
                    }
                    case 39: {
                        ShopEditor.this.shopPanel.selectNextItem();
                        break;
                    }
                    case 38: {
                        ShopEditor.this.shopPanel.nextItem();
                        break;
                    }
                    case 40: {
                        ShopEditor.this.shopPanel.prevItem();
                    }
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(ShopEditor.this.shopPanel.getScale() + 1.5f));
                        ShopEditor.this.shopPanel.setPreferredScale(f);
                        ShopEditor.this.pack();
                    } else {
                        ShopEditor.this.shopPanel.nextItem();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(ShopEditor.this.shopPanel.getScale() - 0.5f));
                        ShopEditor.this.shopPanel.setPreferredScale(f);
                        ShopEditor.this.pack();
                    } else {
                        ShopEditor.this.shopPanel.prevItem();
                    }
                }
                mouseWheelEvent.consume();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ItemEditor.close();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(ShopEditor.this.shop);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(ShopEditor.this.shop);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("MenuItem"), 105);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemEditor.open(ShopEditor.this.owner, ShopEditor.this.shop, ShopEditor.this.tileset, ShopEditor.this.palette, ShopEditor.this.shopPanel.getVRAM());
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(ShopEditor.this.shop));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(ShopEditor.this.shop));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public static void open(JFrame jFrame, Shop shop, Tileset tileset, Palette palette, NameTable nameTable, Tiles tiles, Properties properties) {
        if (editor == null) {
            editor = new ShopEditor(jFrame, shop, tileset, palette, nameTable, tiles);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            ShopEditor.editor.shopPanel.setShop(shop, tileset, palette, nameTable, tiles);
            ShopEditor.editor.shopPanel.setShop(ShopEditor.editor.shopSelection.getSelectedIndex());
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        ShopEditor.editor.shopPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
        ItemEditor.close();
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
        ItemEditor.destroy();
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

