/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.BonusLevel;
import editor.Z80Factory;
import editors.KiddEd;
import editors.TextProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.Z80;
import miracleworld.MiracleWorldDataModel;
import miracleworld.MiracleWorldEditorModel;
import miracleworld.data.MiracleWorldMetaTileset;
import rom.RomManager;
import transactions.TransactionManager;
import util.set.IntHashSet;

public class Level
implements Changable {
    private static final int SIZE_SCREEN = 195;
    protected static final int MAX_RUN_LENGTH = 126;
    public static final int SIZE_DESCRIPTOR = 12;
    public static final int CASTLE_MAX_HEIGHT = 6;
    protected final int level;
    private BonusLevel bonusLevel;
    private boolean[][] validScreens;
    private final int[] entityData = new int[960];
    private int[] entitySources;
    private int[] entityPointers;
    private int entityOctopusTentacle;
    private int entitiesBank;
    private boolean moving;
    private boolean movingEntityData;
    private boolean writingPointers;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Level(int n) {
        this.level = n;
    }

    protected Level(Level level) {
        this(level.level);
        this.bonusLevel = level.bonusLevel;
    }

    protected boolean[][] getValidScreens() {
        if (this.validScreens != null) {
            return this.validScreens;
        }
        int n = this.getMaxHorizontalScreenNumber() + 1;
        int n2 = this.getMaxVerticalScreenNumber() + 1;
        this.validScreens = new boolean[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n - 1) {
                int n5 = this.getLayoutPointer();
                if ((n5 += n3 * 2) < this.getLayoutPointer2() && (n5 = this.READ_WORD(n5)) >= 32768 && n5 < 49152) {
                    n5 += n4 * 2;
                    if ((n5 = this.READ_WORD(n5)) >= 32768) {
                        this.validScreens[n3][n4] = true;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return this.validScreens;
    }

    public boolean isValidScreen(int n, int n2) {
        boolean[][] blArray = this.getValidScreens();
        return n2 < blArray.length && n < blArray[n2].length && blArray[n2][n];
    }

    public void updateValidScreens() {
        this.validScreens = null;
    }

    public void printPointers(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getScreenAddress(n, n2);
        int n6 = 0;
        while (true) {
            int n7;
            n4 = this.getLayoutPointer();
            n4 += n6 * 2;
            if ((n4 = this.READ_WORD(n4)) < 32768 || n4 >= 49152) break;
            n3 = 0;
            while ((n7 = this.READ_WORD(n4 += n3 * 2)) >= 32768 && n7 < 49152) {
                System.out.print(String.valueOf(Integer.toHexString(this.RESOLVE_ADDRESS(this.getLayoutPointer() + n6 * 2)).toUpperCase()) + " -> " + Integer.toHexString(this.RESOLVE_ADDRESS(n4)).toUpperCase() + " ->");
                int n8 = 0;
                while (true) {
                    n7 = n4 + n8 * 2;
                    if ((n7 = this.READ_WORD(n7)) < 32768 || n7 >= 49152) break;
                    System.out.print(" ");
                    if (n7 == n5) {
                        System.out.print("_");
                    }
                    System.out.print(Integer.toHexString(this.RESOLVE_ADDRESS(n7)).toUpperCase());
                    if (n7 == n5) {
                        System.out.print("_");
                    }
                    ++n8;
                }
                System.out.println();
                ++n3;
            }
            ++n6;
        }
        System.out.println();
        int[] nArray = this.getScreenAddresses();
        n3 = nArray.length;
        n4 = 0;
        while (n4 < n3) {
            n6 = nArray[n4];
            System.out.print(" ");
            if (n6 == n5) {
                System.out.print("_");
            }
            System.out.print(Integer.toHexString(this.RESOLVE_ADDRESS(n6)));
            if (n6 == n5) {
                System.out.print("_");
            }
            ++n4;
        }
        System.out.println();
    }

    public void printLevelData() {
        int n;
        int n2 = 0;
        IntHashSet intHashSet = new IntHashSet();
        int n3 = 0;
        int n4 = 65536;
        int[] nArray = this.getScreenAddresses();
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            n = nArray[n6];
            if (n > n3) {
                n3 = n;
            }
            if (n < n4) {
                n4 = n;
            }
            intHashSet.add(n);
            ++n6;
        }
        n = MiracleWorldDataModel.hasMetaTilesetsPerLevel() ? 0 : 1;
        n6 = 0;
        n5 = this.isEntitiesLevelBank() ? 0 : 1;
        int n7 = -1;
        boolean bl = true;
        int n8 = Math.min(n == 0 ? this.getMetaTilesetPointer() : 65536, Math.min(n4, this.getLayoutPointer()));
        while ((n8 + 1 & 0x3FFF) > (n8 & 0x3FFF)) {
            int n9;
            if (bl && n8 >= n3 + 195 && n6 != 0 && n != 0 && n5 != 0) break;
            if (n8 == this.getLayoutPointer()) {
                n2 = 0;
                if (!bl) {
                    System.out.println();
                    System.out.println();
                }
                System.out.println(String.valueOf(Integer.toHexString(n8)) + ":");
                n9 = this.READ_WORD(n8);
                while (n9 >= 32768 && n9 < 49152 && n8 != this.getEntityDataAddress()) {
                    System.out.print(" " + Integer.toHexString(n9));
                    if (++n2 >= 8) {
                        n2 = 0;
                        System.out.println();
                    }
                    n9 = this.READ_WORD(n8 += 2);
                }
                System.out.println();
                System.out.println();
                bl = true;
                n6 = 1;
                n2 = 0;
            }
            if (this.isEntitiesLevelBank() && n8 == this.getEntityDataAddress()) {
                n2 = 0;
                if (!bl) {
                    System.out.println();
                    System.out.println();
                }
                System.out.println(String.valueOf(Integer.toHexString(n8)) + " Entities:");
                n9 = this.getEntityScreenAddresses().length;
                int n10 = 0;
                while (n10 < n9) {
                    System.out.print(" " + Integer.toHexString(this.READ_WORD(n8)));
                    if (++n2 >= 8) {
                        n2 = 0;
                        System.out.println();
                    }
                    ++n10;
                    n8 += 2;
                }
                System.out.println();
                System.out.println();
                bl = true;
                n5 = 1;
                n2 = 0;
            }
            if (MiracleWorldDataModel.hasMetaTilesetsPerLevel() && n8 == this.getMetaTilesetPointer()) {
                if (!bl) {
                    System.out.println();
                    System.out.println();
                }
                System.out.println(String.valueOf(Integer.toHexString(n8)) + " Metatileset:");
                n2 = 0;
                n7 = 2560;
                n = 1;
            } else if (intHashSet.contains(n8)) {
                if (!bl) {
                    System.out.println();
                    System.out.println();
                }
                System.out.println(String.valueOf(Integer.toHexString(n8)) + ":");
                n2 = 0;
                n7 = 195;
            }
            bl = false;
            System.out.print(" ");
            System.out.print(String.format("%02X", this.READ_BYTE(n8++)));
            if (--n7 == 0) {
                System.out.println();
                System.out.println();
                bl = true;
                n2 = 0;
            }
            if (++n2 < 16) continue;
            n2 = 0;
            System.out.println();
        }
        System.out.println();
    }

    public void printEntityData(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = n5 = this.resolveEntityScreenAddress(n, n2);
        int n7 = RomManager.StaticAccess.readByte(n6);
        String string = "$" + Integer.toHexString(this.resolveEntityScreenAddressPointer(n, n2)).toUpperCase() + " -> $" + Integer.toHexString(n6).toUpperCase() + ": $" + Integer.toHexString(n7).toUpperCase();
        while ((n7 & 0x80) != 0) {
            if ((n7 & 5) != 0) {
                n4 = 0;
                while (n4 < 4) {
                    string = String.valueOf(string) + " $" + Integer.toHexString(RomManager.StaticAccess.readByte(n6 + 1 + n4)).toUpperCase();
                    ++n4;
                }
                n7 = RomManager.StaticAccess.readByte(n6 += 5);
                string = String.valueOf(string) + "\t$" + Integer.toHexString(n7).toUpperCase();
                continue;
            }
            if ((n7 & 2) != 0) {
                string = String.valueOf(string) + " $" + Integer.toHexString(RomManager.StaticAccess.readByte(n6 + 1));
                n7 = RomManager.StaticAccess.readByte(n6 += 2);
                string = String.valueOf(string) + "\t$" + Integer.toHexString(n7).toUpperCase();
                continue;
            }
            int n8 = ++n6;
            ++n6;
            n7 = RomManager.StaticAccess.readByte(n8);
            string = String.valueOf(string) + " $" + Integer.toHexString(n7).toUpperCase();
            n4 = 0;
            while (n4 < n7) {
                string = String.valueOf(string) + " $" + Integer.toHexString(RomManager.StaticAccess.readByte(n6 + n4)).toUpperCase();
                ++n4;
            }
            n6 += n7;
            n7 = RomManager.StaticAccess.readByte(n6);
            string = String.valueOf(string) + "\t$" + Integer.toHexString(n7).toUpperCase();
        }
        n4 = 0;
        while (n4 < n7) {
            n3 = 0;
            while (n3 < 4) {
                string = String.valueOf(string) + " $" + Integer.toHexString(RomManager.StaticAccess.readByte(n6 + 1 + n4 * 4 + n3)).toUpperCase();
                ++n3;
            }
            ++n4;
        }
        System.out.println(string);
        int[] nArray = this.getEntityScreenAddresses();
        System.out.print(nArray.length);
        n3 = 0;
        while (n3 < nArray.length) {
            System.out.print(" ");
            if (nArray[n3] == n5) {
                System.out.print("_");
            }
            System.out.print(Integer.toHexString(nArray[n3]));
            if (nArray[n3] == n5) {
                System.out.print("_");
            }
            ++n3;
        }
        System.out.println();
    }

    public boolean canConvertToScrollability(int n) {
        if (this.bonusLevel != null && n == 128) {
            return false;
        }
        if (this.level == 16 && n == 128) {
            return false;
        }
        if (n == 128) {
            return (this.getScrollability() & 4) == 0;
        }
        if (n == 129) {
            return this.calcScreenCount() > 2;
        }
        if (n == 72) {
            return this.calcScreenCount() > 4 && this.calcScreenCount() <= 20;
        }
        if (n == 40) {
            return this.calcScreenCount() > 2;
        }
        if (n == 8) {
            return true;
        }
        if (n == 4) {
            return true;
        }
        return n == 1;
    }

    public static void applyScrollabilityHacks() {
        if (RomManager.StaticAccess.isChanged(26139, 26145) || RomManager.StaticAccess.isChanged(26184, 26192) || RomManager.StaticAccess.isChanged(26213, 26215) || RomManager.StaticAccess.isChanged(26267, 26326)) {
            return;
        }
        RomManager.StaticAccess.writeByte(26139, 58);
        RomManager.StaticAccess.writeByte(26140, 128);
        RomManager.StaticAccess.writeByte(26141, 192);
        RomManager.StaticAccess.writeByte(26142, 203);
        RomManager.StaticAccess.writeByte(26143, 71);
        RomManager.StaticAccess.writeByte(26144, 40);
        RomManager.StaticAccess.writeByte(26184, 203);
        RomManager.StaticAccess.writeByte(26185, 87);
        RomManager.StaticAccess.writeByte(26186, 0);
        RomManager.StaticAccess.writeByte(26187, 0);
        RomManager.StaticAccess.writeByte(26188, 58);
        RomManager.StaticAccess.writeByte(26189, 182);
        RomManager.StaticAccess.writeByte(26190, 192);
        RomManager.StaticAccess.writeByte(26191, 32);
        RomManager.StaticAccess.writeByte(26213, 0);
        RomManager.StaticAccess.writeByte(26214, 0);
        RomManager.StaticAccess.writeByte(26267, 33);
        RomManager.StaticAccess.writeByte(26268, 141);
        RomManager.StaticAccess.writeByte(26269, 192);
        RomManager.StaticAccess.writeByte(26270, 56);
        RomManager.StaticAccess.writeByte(26271, 51);
        RomManager.StaticAccess.writeByte(26272, 7);
        RomManager.StaticAccess.writeByte(26273, 58);
        RomManager.StaticAccess.writeByte(26274, 160);
        RomManager.StaticAccess.writeByte(26275, 192);
        RomManager.StaticAccess.writeByte(26276, 60);
        RomManager.StaticAccess.writeByte(26277, 95);
        RomManager.StaticAccess.writeByte(26278, 56);
        RomManager.StaticAccess.writeByte(26279, 3);
        RomManager.StaticAccess.writeByte(26280, 175);
        RomManager.StaticAccess.writeByte(26281, 24);
        RomManager.StaticAccess.writeByte(26282, 7);
        RomManager.StaticAccess.writeByte(26283, 58);
        RomManager.StaticAccess.writeByte(26284, 182);
        RomManager.StaticAccess.writeByte(26285, 192);
        RomManager.StaticAccess.writeByte(26286, 15);
        RomManager.StaticAccess.writeByte(26287, 15);
        RomManager.StaticAccess.writeByte(26288, 230);
        RomManager.StaticAccess.writeByte(26289, 63);
        RomManager.StaticAccess.writeByte(26290, 50);
        RomManager.StaticAccess.writeByte(26291, 182);
        RomManager.StaticAccess.writeByte(26292, 192);
        RomManager.StaticAccess.writeByte(26293, 131);
        RomManager.StaticAccess.writeByte(26294, 119);
        RomManager.StaticAccess.writeByte(26295, 58);
        RomManager.StaticAccess.writeByte(26296, 176);
        RomManager.StaticAccess.writeByte(26297, 192);
        RomManager.StaticAccess.writeByte(26298, 50);
        RomManager.StaticAccess.writeByte(26299, 145);
        RomManager.StaticAccess.writeByte(26300, 192);
        RomManager.StaticAccess.writeByte(26301, 0);
        RomManager.StaticAccess.writeByte(26302, 0);
        RomManager.StaticAccess.writeByte(26303, 0);
        RomManager.StaticAccess.writeByte(26304, 0);
        RomManager.StaticAccess.writeByte(26305, 0);
        RomManager.StaticAccess.writeByte(26306, 0);
        RomManager.StaticAccess.writeByte(26307, 203);
        RomManager.StaticAccess.writeByte(26308, 254);
        RomManager.StaticAccess.writeByte(26309, 62);
        RomManager.StaticAccess.writeByte(26310, 16);
        RomManager.StaticAccess.writeByte(26311, 50);
        RomManager.StaticAccess.writeByte(26312, 166);
        RomManager.StaticAccess.writeByte(26313, 192);
        RomManager.StaticAccess.writeByte(26314, 205);
        RomManager.StaticAccess.writeByte(26315, 115);
        RomManager.StaticAccess.writeByte(26316, 106);
        RomManager.StaticAccess.writeByte(26317, 62);
        RomManager.StaticAccess.writeByte(26318, 130);
        RomManager.StaticAccess.writeByte(26319, 50);
        RomManager.StaticAccess.writeByte(26320, 255);
        RomManager.StaticAccess.writeByte(26321, 255);
        RomManager.StaticAccess.writeByte(26322, 201);
        RomManager.StaticAccess.writeByte(26323, 52);
        RomManager.StaticAccess.writeByte(26324, 24);
        RomManager.StaticAccess.writeByte(26325, 237);
        Level.applyRespawnHacks();
    }

    private static void applyRespawnHacks() {
        if (RomManager.StaticAccess.isChanged(27784, 27794) || RomManager.StaticAccess.isChanged(27837, 27857)) {
            return;
        }
        RomManager.StaticAccess.writeByte(27921, 168);
        RomManager.StaticAccess.writeByte(27784, 203);
        RomManager.StaticAccess.writeByte(27785, 87);
        RomManager.StaticAccess.writeByte(27786, 194);
        RomManager.StaticAccess.writeByte(27787, 38);
        RomManager.StaticAccess.writeByte(27788, 109);
        RomManager.StaticAccess.writeByte(27789, 0);
        RomManager.StaticAccess.writeByte(27790, 0);
        RomManager.StaticAccess.writeByte(27791, 0);
        RomManager.StaticAccess.writeByte(27792, 254);
        RomManager.StaticAccess.writeByte(27793, 128);
        RomManager.StaticAccess.writeByte(27794, 194);
        RomManager.StaticAccess.writeByte(27837, 58);
        RomManager.StaticAccess.writeByte(27838, 128);
        RomManager.StaticAccess.writeByte(27839, 192);
        RomManager.StaticAccess.writeByte(27840, 230);
        RomManager.StaticAccess.writeByte(27841, 96);
        RomManager.StaticAccess.writeByte(27842, 194);
        RomManager.StaticAccess.writeByte(27843, 212);
        RomManager.StaticAccess.writeByte(27844, 108);
        RomManager.StaticAccess.writeByte(27845, 58);
        RomManager.StaticAccess.writeByte(27846, 35);
        RomManager.StaticAccess.writeByte(27847, 192);
        RomManager.StaticAccess.writeByte(27848, 33);
        RomManager.StaticAccess.writeByte(27849, 30);
        RomManager.StaticAccess.writeByte(27850, 14);
        RomManager.StaticAccess.writeByte(27851, 79);
        RomManager.StaticAccess.writeByte(27852, 6);
        RomManager.StaticAccess.writeByte(27853, 0);
        RomManager.StaticAccess.writeByte(27854, 9);
        RomManager.StaticAccess.writeByte(27855, 126);
        RomManager.StaticAccess.writeByte(27856, 183);
        RomManager.StaticAccess.writeByte(27857, 194);
        RomManager.StaticAccess.writeByte(27858, 38);
        RomManager.StaticAccess.writeByte(27859, 109);
    }

    private static void applyFallIntoWaterHack() {
        RomManager.StaticAccess.writeByte(14592, 195);
    }

    public void convertToScrollability(int n, int n2, int n3) {
        this.convertToScrollability(n, n2, n3, false);
    }

    private void convertToScrollability(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.canConvertToScrollability(n)) {
            return;
        }
        int[] nArray = this.getScreenAddresses();
        int[] nArray2 = this.bonusLevel == null ? null : this.bonusLevel.getScreenAddresses();
        int[][] nArray3 = null;
        int[][][] nArray4 = null;
        TransactionManager.getInstance().addTransactionObject(this, -3);
        if (this.bonusLevel != null) {
            TransactionManager.getInstance().addTransactionObject(this.bonusLevel, -3);
        }
        if (n == 128) {
            n8 = MiracleWorldDataModel.isCastleBreakablesDisabled() ? 16 : 6;
            int n9 = n7 = MiracleWorldDataModel.isCastleBreakablesDisabled() ? 16 : 8;
            if (n3 > n8) {
                n2 = Math.min(n7, n2 + n3 - n8);
                n3 = n8;
            }
            if (n2 > n7) {
                n3 = Math.min(n8, n3 + n2 - n7);
                n2 = n7;
            }
        }
        if (!bl) {
            n8 = 0;
            if (n == 128) {
                n7 = n3;
                n6 = (n7 + n2 * n3) * 2;
                int[] nArray5 = this.getEntityScreenAddresses();
                int n10 = nArray5.length;
                n5 = 0;
                while (n5 < n10) {
                    n4 = nArray5[n5];
                    n6 += this.getEntityScreenData(n4).length;
                    ++n5;
                }
                n8 += n6;
            }
            n7 = this.calcPointersSize(n, n2, n3, null);
            n8 += n7 - this.calcPointersSize();
            int[] nArray6 = nArray;
            n5 = nArray.length;
            n4 = 0;
            while (n4 < n5) {
                n6 = nArray6[n4];
                if (n6 >= this.getLayoutPointer() && n6 < this.getLayoutPointer() + n7) {
                    n8 += 195;
                }
                ++n4;
            }
            if (n8 > 0 && KiddEd.findFreeBlock(n8, this.getBank()) < 0) {
                this.relocate(n8);
                this.convertToScrollability(n, n2, n3, true);
                return;
            }
        }
        this.getValidScreens();
        Level.applyScrollabilityHacks();
        this.clearPointers();
        if (n == 4 ^ this.getScrollability() == 4) {
            this.invertEntityScreens();
        }
        if (this.getScrollability() == 128 && n != 128) {
            this.removeUnusedCastleLayoutEntities();
        }
        if (n == 128) {
            n8 = this.getScrollability() == 128 ? this.calcEntityDataIndex(1, 0) : 0;
            n7 = this.calcScreenCount() + n8;
            n6 = this.getMaxHorizontalScreenNumber() + 1;
            this.setMaxHorizontalScreenNumber(n2 - 1);
            this.setMaxVerticalScreenNumber(n3 - 1);
            nArray3 = new int[n3][n2];
            n4 = 0;
            while (n4 < nArray3.length) {
                Arrays.fill(nArray3[n4], -1);
                ++n4;
            }
            n4 = 0;
            if (this.getScrollability() == 128) {
                n5 = 0;
                while (n5 < n3) {
                    int n11 = 0;
                    while (n11 < n2) {
                        if (this.isValidScreen(n11, n5)) {
                            nArray3[n5][n11] = n4++;
                        }
                        ++n11;
                    }
                    ++n5;
                }
            } else if (this.getScrollability() == 129) {
                n5 = 0;
                while (n5 < n3) {
                    nArray3[n5][0] = n4++;
                    ++n5;
                }
                n5 = 1;
                while (n5 < n2) {
                    nArray3[n3 - 1][n5] = n4++;
                    ++n5;
                }
                this.setStartVerticalScreenNumber(this.getStartVerticalScreenNumber() - 1);
            } else if (this.getScrollability() == 72) {
                n5 = Math.max(1, n6 / n2);
                int n12 = 0;
                while (n12 < n2) {
                    int n13 = 0;
                    while (n13 < n5) {
                        nArray3[n13][n12] = n4++;
                        ++n13;
                    }
                    ++n12;
                }
                if (n5 < nArray3.length) {
                    n12 = 0;
                    while (n12 < n2) {
                        nArray3[n5][n12] = n4++;
                        n12 += (n2 - 1) / 4 + 1;
                    }
                }
            } else if (this.getScrollability() == 40) {
                n5 = 0;
                while (n5 < n2) {
                    nArray3[0][n5] = n4++;
                    ++n5;
                }
                n5 = 0;
                while (n5 < 2 + (n3 - 2) && n5 < n2) {
                    nArray3[1][n5] = n4++;
                    ++n5;
                }
            } else if (this.getScrollability() == 1) {
                n5 = 0;
                while (n5 < n2 && n4 < nArray.length) {
                    int n14 = 0;
                    while (n14 < n3 && n4 < nArray.length) {
                        nArray3[n14][n5] = n4++;
                        ++n14;
                    }
                    ++n5;
                }
            } else {
                n5 = 0;
                while (n5 < n3 && n4 < nArray.length) {
                    int n15 = 0;
                    while (n15 < n2 && n4 < nArray.length) {
                        nArray3[n5][n15] = n4++;
                        ++n15;
                    }
                    ++n5;
                }
            }
            nArray4 = new int[n3][n2][];
            n5 = 0;
            while (n5 < nArray4.length) {
                int n16 = 0;
                while (n16 < nArray4[n5].length) {
                    if (nArray3[n5][n16] >= 0) {
                        nArray4[n5][n16] = this.getEntityScreenData(this.resolveEntityScreenAddress(nArray3[n5][n16] + n8));
                    }
                    ++n16;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n7) {
                int n17 = this.resolveEntityScreenAddress(n5);
                int n18 = Level.calcEntityScreenSize(n17);
                if (n18 > 0) {
                    RomManager.StaticAccess.fill(n17, n17 + n18, 255);
                }
                ++n5;
            }
            RomManager.StaticAccess.fill(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()), RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()) + n7 * 2, 255);
            if (this.getMaxVerticalScreenNumber() > 0) {
                this.setMaxVerticalScreenNumber(this.getMaxVerticalScreenNumber() + 1);
            }
            this.setMaxHorizontalScreenNumber(this.getMaxHorizontalScreenNumber() + 1);
        } else if (n == 129) {
            if (n3 > nArray.length) {
                n3 = nArray.length;
            }
            this.setStartVerticalScreenNumber(1);
            this.setMaxVerticalScreenNumber(n3 - 1);
            this.setMaxHorizontalScreenNumber(nArray.length - n3);
        } else if (n == 72) {
            this.setMaxVerticalScreenNumber(1);
            this.setMaxHorizontalScreenNumber(nArray.length - 5);
            this.setStartVerticalScreenNumber(0);
        } else if (n == 40) {
            this.setMaxVerticalScreenNumber(1);
            this.setMaxHorizontalScreenNumber(nArray.length - 3);
            this.setStartVerticalScreenNumber(0);
        } else if (n == 8) {
            this.setMaxVerticalScreenNumber(0);
            this.setMaxHorizontalScreenNumber(nArray.length - 1);
            this.setStartVerticalScreenNumber(0);
        } else if (n == 4) {
            this.setMaxVerticalScreenNumber(0);
            this.setMaxHorizontalScreenNumber(255);
            this.setStartVerticalScreenNumber(0);
        } else if (n == 1) {
            this.setMaxVerticalScreenNumber(nArray.length - 1);
            this.setMaxHorizontalScreenNumber(0);
            this.setStartVerticalScreenNumber(0);
        }
        if (n == 4 ^ this.getScrollability() == 4) {
            this.setStartHorizontalScreenNumber(nArray.length - this.getStartHorizontalScreenNumber() + 1);
            n8 = 0;
            while (n8 < nArray.length - 1 - n8) {
                n7 = nArray[n8];
                nArray[n8] = nArray[nArray.length - 1 - n8];
                nArray[nArray.length - 1 - n8] = n7;
                ++n8;
            }
        }
        if (this.getMaxHorizontalScreenNumber() == 0) {
            n &= 0xFFFFFFF7;
        }
        this.setScrollability(n);
        if (nArray2 != null) {
            int[] nArray7 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray7, 0, nArray.length);
            n7 = 0;
            while (n7 < nArray2.length) {
                nArray7[nArray.length + n7] = nArray2[n7];
                ++n7;
            }
            nArray = nArray7;
        }
        this.writePointers(nArray, nArray3);
        this.setStartScreen(this.getStartHorizontalScreenNumber() - 1, this.getStartVerticalScreenNumber(), false);
        if (nArray4 != null) {
            this.mapEntityScreensToCastleLayout(nArray4);
        }
        RomManager.StaticAccess.writeWord(16186 + this.level * 2, Level.getScrollabilityLevelUpdateEntityAlexAddress(n));
        RomManager.StaticAccess.writeWord(3338 + this.level * 2, Level.getScrollabilityUpdateScrollFlagsAddress(n));
        RomManager.StaticAccess.writeWord(3406 + this.level * 2, Level.getScrollabilityUpdateLevelEntitiesAddress(n));
        RomManager.StaticAccess.writeByte(14596 + this.level, (n & 0x40) >> 6);
        if (!this.isValid()) {
            throw new IllegalStateException("Level became invalid by converting its scrollability.");
        }
    }

    private static int getScrollabilityLevelUpdateEntityAlexAddress(int n) {
        if ((n & 1) != 0) {
            return 16220;
        }
        if (n == 4) {
            return 16237;
        }
        if ((n & 0x40) != 0) {
            return 16337;
        }
        if (n == 128) {
            return 16421;
        }
        return 16245;
    }

    private static int getScrollabilityUpdateScrollFlagsAddress(int n) {
        if ((n & 0x20) != 0) {
            return 25979;
        }
        if ((n & 0x40) != 0) {
            return 25913;
        }
        if (n == 128) {
            return 25725;
        }
        return 25698;
    }

    private static int getScrollabilityUpdateLevelEntitiesAddress(int n) {
        if (n == 128) {
            return 28804;
        }
        return 28488;
    }

    public boolean canRemoveScreen(int n, int n2) {
        if (n > this.getMaxHorizontalScreenNumber() || n2 > this.getMaxVerticalScreenNumber()) {
            return false;
        }
        if (this.getScrollability() == 128) {
            return false;
        }
        if ((this.getScrollability() & 0x60) != 0 && n2 != 0) {
            return false;
        }
        if (this.isStartScreen(n, n2)) {
            return false;
        }
        if (this.getScrollability() == 129) {
            return n == 0 && n2 < this.getMaxVerticalScreenNumber() || this.getMaxHorizontalScreenNumber() > 1;
        }
        return this.calcScreenCount() > 2;
    }

    public boolean removeScreen(int n, int n2) {
        if (!this.canRemoveScreen(n, n2)) {
            return false;
        }
        int[] nArray = this.getScreenAddresses();
        if (this.bonusLevel != null) {
            int[] nArray2 = this.bonusLevel.getScreenAddresses();
            int[] nArray3 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            int n3 = 0;
            while (n3 < nArray2.length) {
                nArray3[nArray.length + n3] = nArray2[n3];
                ++n3;
            }
            nArray = nArray3;
        }
        int n4 = this.getScreenAddress(n, n2);
        int n5 = this.countScreenReferences(n4);
        int[] nArray4 = new int[nArray.length - 1];
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        while (n7 < nArray.length) {
            if (n4 != nArray[n7] || n5 != 1 && n7 != n + n2) {
                nArray4[n6++] = nArray[n7];
            } else {
                if (bl) {
                    return false;
                }
                bl = true;
            }
            ++n7;
        }
        n7 = this.calcPointersSize();
        if (this.getScrollability() == 40 && this.isCompressed()) {
            n7 += 4;
        } else if (this.bonusLevel != null) {
            n7 += this.bonusLevel.calcScreenCount() * 2;
        }
        int n8 = this.calcScreenSize(n4);
        TransactionManager.getInstance().addTransactionObject(this, -1);
        if (n5 == 1) {
            RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(n4), this.RESOLVE_ADDRESS(n4 + n8), 255);
        }
        this.removeEntityScreen(n, n2);
        if ((this.getScrollability() & 1) != 0 && n == 0 && n2 < this.getMaxVerticalScreenNumber()) {
            this.setMaxVerticalScreenNumber(this.getMaxVerticalScreenNumber() - 1);
        } else if (this.getScrollability() == 4) {
            this.setStartHorizontalScreenNumber(this.getStartHorizontalScreenNumber() - 1);
        } else {
            this.setMaxHorizontalScreenNumber(this.getMaxHorizontalScreenNumber() - 1);
            if (this.getMaxHorizontalScreenNumber() == 0) {
                this.setScrollability(this.getScrollability() & 0xFFFFFFF7);
            }
        }
        this.setPointers(nArray4);
        int n9 = this.calcPointersSize();
        if (this.bonusLevel != null) {
            n9 += this.bonusLevel.calcScreenCount() * 2;
        }
        if (n9 < n7) {
            int n10 = this.RESOLVE_ADDRESS(this.getLayoutPointer());
            RomManager.StaticAccess.fill(n10 + n9, n10 + n7, 255);
        }
        Level.applyScrollabilityHacks();
        if (!this.isValid()) {
            throw new IllegalStateException("Removing this screen invalidated the level");
        }
        return true;
    }

    public boolean canAddScreen(int n, int n2) {
        if (this.getScrollability() == 128) {
            return false;
        }
        if ((this.getScrollability() & 0x60) != 0 && n2 != 0) {
            return false;
        }
        if ((this.getScrollability() & 0x40) != 0) {
            return this.getMaxHorizontalScreenNumber() < 15;
        }
        if (this.getScrollability() == 4) {
            return true;
        }
        return !this.isStartScreen(n, n2);
    }

    public boolean ensureEntityScreens(int n) {
        if (this.bonusLevel != null) {
            return this.ensureEntityScreens(n + this.bonusLevel.calcScreenCount(), 1);
        }
        return this.ensureEntityScreens(n, 1);
    }

    public boolean ensureEntityScreens(int n, int n2) {
        int n3;
        if (n2 >= 4) {
            throw new IllegalStateException("Failed to allocate enough screens for the bonus levels.");
        }
        try {
            this.getSAT(this.getStartHorizontalScreenNumber() - 1, this.getScrollability() == 129 ? this.getStartVerticalScreenNumber() - 1 : this.getStartVerticalScreenNumber());
        }
        catch (Exception exception) {}
        int n4 = n3 = this.getNumberOfEntityScreens();
        while (n4 < n) {
            try {
                if (RomManager.StaticAccess.readByte(this.resolveEntityScreenAddress(n4)) != 0 || Math.abs(this.resolveEntityScreenAddress(n4) - this.resolveEntityScreenAddress(n4 - 1)) > 1) break;
                n3 = n4++;
            }
            catch (Exception exception) {
                break;
            }
        }
        if (n3 >= n) {
            return false;
        }
        n4 = this.bonusLevel.calcScreenCount();
        int n5 = n3 - n4;
        if (n5 < this.calcScreenCount()) {
            return false;
        }
        int n6 = 0;
        int n7 = n3;
        while (n7 < n) {
            if (RomManager.StaticAccess.readWord(this.resolveEntityScreenAddressPointer(n3)) != 65535) {
                n6 = n * 2;
                break;
            }
            ++n7;
        }
        int n8 = n7 = RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank());
        if (n6 > 0) {
            n8 = KiddEd.findFreeBlock(n6, this.getEntitiesBank());
            if (n8 < 0) {
                if (!(this.relocateEntityData() || (this.getEntitiesBank() == this.getBank() || MiracleWorldEditorModel.moveEntityData()) && this.relocate())) {
                    throw new IllegalStateException("Failed to allocate enough screens for the bonus levels.");
                }
                return this.ensureEntityScreens(n, n2 + 1);
            }
            RomManager.StaticAccess.copyBytes(n7, n8, n3 * 2);
            this.setEntityDataAddress(0x8000 | n8 & 0x3FFF);
            RomManager.StaticAccess.fill(n7, n7 + n3 * 2, 255);
        }
        int n9 = n4 - 1;
        while (n9 >= 0) {
            RomManager.StaticAccess.writeWord(n8 + (n5 + n9 + n - n3) * 2, RomManager.StaticAccess.readWord(n8 + (n5 + n9) * 2));
            --n9;
        }
        return true;
    }

    public boolean addScreen(int n, int n2) {
        return this.addScreen(n, n2, null, null);
    }

    public boolean addScreen(int n, int n2, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[192];
        }
        if (nArray2 == null) {
            nArray2 = new int[1];
        }
        return this.addScreen(n, n2, nArray, nArray2, 1);
    }

    private boolean addScreen(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        int[] nArray3;
        int[] nArray4;
        int n4;
        int n5;
        int[] nArray5;
        if (n3 >= 4 || nArray.length != 192 || !this.canAddScreen(n, n2)) {
            return false;
        }
        if (this.getScrollability() == 1) {
            n = 0;
        }
        int n6 = 0;
        int n7 = nArray2[n6++];
        int n8 = 0;
        while ((n7 & 0x80) != 0) {
            if ((n7 & 0xFFFFFF70) != 0) {
                return false;
            }
            if ((n7 & 5) != 0) {
                n6 += 4;
            } else if ((n7 & 2) != 0) {
                ++n6;
                if ((n8 += 8) > 10) {
                    return false;
                }
            } else if (n6 < nArray2.length) {
                n6 += nArray2[n6] + 1;
            }
            if (n6 >= nArray2.length) {
                return false;
            }
            n7 = nArray2[n6++];
        }
        if ((n8 += n7) > 10) {
            return false;
        }
        int n9 = this.calcPointersSize();
        if (this.bonusLevel != null && !this.isCompressed()) {
            n9 += 2 * this.bonusLevel.calcScreenCount();
        }
        int n10 = 65536;
        Object object = this.getScreenAddresses();
        if (this.bonusLevel != null) {
            nArray5 = this.bonusLevel.getScreenAddresses();
            int[] nArray6 = new int[((int[])object).length + nArray5.length];
            System.arraycopy(object, 0, nArray6, 0, ((int[])object).length);
            n5 = 0;
            while (n5 < nArray5.length) {
                nArray6[((int[])object).length + n5] = nArray5[n5];
                ++n5;
            }
            object = nArray6;
        }
        int[] nArray7 = object;
        n5 = ((int[])object).length;
        int n11 = 0;
        while (n11 < n5) {
            int n12 = nArray7[n11];
            if (n12 < n10 && n12 >= this.getLayoutPointer()) {
                n10 = n12;
            }
            ++n11;
        }
        nArray5 = this.getEntityScreenAddresses();
        n11 = 0;
        while (n11 < nArray5.length) {
            if (nArray5[n11] >= this.RESOLVE_ADDRESS(this.getLayoutPointer()) && nArray5[n11] < this.RESOLVE_ADDRESS(this.getLayoutPointer() + n9 + 2)) {
                int n13;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                int n14 = 0;
                while (n14 < n9 + 2) {
                    n4 = RomManager.RESOLVE_ADDRESS(this.getLayoutPointer() + n14, this.getBank());
                    if (RomManager.StaticAccess.readByte(n4) == 255) {
                        RomManager.StaticAccess.writeByte(n4, 0);
                        hashSet.add(n4);
                    }
                    ++n14;
                }
                n14 = Level.calcEntityScreenSize(nArray5[n11]);
                n4 = KiddEd.findFreeBlock(n14, this.getEntitiesBank());
                if (n4 < 0) {
                    return false;
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    n13 = (Integer)iterator.next();
                    RomManager.StaticAccess.writeByte(n13, 255);
                }
                RomManager.StaticAccess.copyBytes(nArray5[n11], n4, n14);
                RomManager.StaticAccess.fill(nArray5[n11], nArray5[n11] + n14, 0);
                n13 = this.resolveEntityScreenAddressPointer(n11);
                RomManager.StaticAccess.writeByte(n13, n4 & 0xFF);
                RomManager.StaticAccess.writeByte(n13 + 1, 0x80 | n4 >> 8 & 0x3F);
            }
            ++n11;
        }
        int n15 = n11 = n10 >= this.getLayoutPointer() + n9 && n10 < this.getLayoutPointer() + n9 + 2 ? 195 : 0;
        if (n10 >= 49152 || n11 == 0 && this.READ_WORD(this.getLayoutPointer() + n9) != 0) {
            if (!this.relocate()) {
                return false;
            }
            return this.addScreen(n, n2, nArray, nArray2, n3 + 1);
        }
        int n16 = this.getNumberOfEntityScreens();
        int n17 = -1;
        if (this.bonusLevel != null && (n4 = this.calcScreenCount()) < this.getNumberOfEntityScreens() - this.bonusLevel.calcScreenCount()) {
            n16 = n4;
            n17 = RomManager.StaticAccess.readWord(this.resolveEntityScreenAddressPointer(n16));
            RomManager.StaticAccess.writeWord(this.resolveEntityScreenAddressPointer(n16), 65535);
        }
        int n18 = n4 = RomManager.StaticAccess.readWord(this.resolveEntityScreenAddressPointer(n16)) != 65535 ? (n16 + 1) * 2 : 0;
        if (n4 == 0) {
            RomManager.StaticAccess.writeWord(this.resolveEntityScreenAddressPointer(n16), 0);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n19 = 0;
        while (n19 < 2) {
            if (this.READ_BYTE(this.getLayoutPointer() + n9 + n19) == 255) {
                hashSet.add(this.RESOLVE_ADDRESS(this.getLayoutPointer() + n9 + n19));
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(this.getLayoutPointer() + n9 + n19), 0);
            }
            ++n19;
        }
        if (this.isEntitiesLevelBank()) {
            nArray4 = KiddEd.findFreeBlocks(new int[]{195, nArray2.length, n11, n4}, this.getBank());
        } else {
            int[] nArray8 = new int[4];
            nArray8[0] = 195;
            nArray8[2] = n11;
            nArray4 = KiddEd.findFreeBlocks(nArray8, this.getBank());
            if (nArray4 != null) {
                nArray3 = KiddEd.findFreeBlocks(new int[]{nArray2.length, n4}, this.getEntitiesBank());
                if (nArray3 != null) {
                    nArray4[1] = nArray3[0];
                    nArray4[3] = nArray3[1];
                } else {
                    nArray4 = null;
                }
            }
        }
        Object object2 = hashSet.iterator();
        while (object2.hasNext()) {
            int n20 = (Integer)object2.next();
            RomManager.StaticAccess.writeByte(n20, 255);
        }
        if (n4 == 0) {
            RomManager.StaticAccess.writeWord(this.resolveEntityScreenAddressPointer(n16), 65535);
        }
        if (nArray4 == null) {
            if (n17 >= 0) {
                RomManager.StaticAccess.writeWord(this.resolveEntityScreenAddressPointer(n16), n17);
            }
            if (!this.relocate()) {
                return false;
            }
            return this.addScreen(n, n2, nArray, nArray2, n3 + 1);
        }
        TransactionManager.getInstance().addTransactionObject(this, -1);
        if (n11 > 0) {
            this.moveScreenLayout(n10, nArray4[2]);
        }
        object = this.getScreenAddresses();
        if (this.bonusLevel != null) {
            nArray3 = this.bonusLevel.getScreenAddresses();
            object2 = new int[((int[])object).length + nArray3.length];
            System.arraycopy(object, 0, object2, 0, ((int[])object).length);
            int n21 = 0;
            while (n21 < nArray3.length) {
                object2[((int[])object).length + n21] = nArray3[n21];
                ++n21;
            }
            object = object2;
        }
        int n22 = this.getScreenAddress(n, n2);
        int n23 = this.countScreenReferences(n22);
        int[] nArray9 = new int[((int[])object).length + 1];
        int n24 = 0;
        int n25 = 0;
        while (n25 < ((int[])object).length) {
            if (n22 == object[n25] && (n23 == 1 || n25 == n + n2)) {
                if (n25 != n24) {
                    return false;
                }
                nArray9[n24++] = 0x8000 | nArray4[0] & 0x3FFF;
            }
            nArray9[n24++] = object[n25];
            ++n25;
        }
        int n26 = nArray4[0];
        nArray4[0] = n26 + 1;
        RomManager.StaticAccess.writeByte(n26, 254);
        RomManager.StaticAccess.copyToROM(nArray, 0, nArray4[0], 126);
        nArray4[0] = nArray4[0] + 126;
        int n27 = nArray4[0];
        nArray4[0] = n27 + 1;
        RomManager.StaticAccess.writeByte(n27, 0x80 | nArray.length - 126);
        RomManager.StaticAccess.copyToROM(nArray, 126, nArray4[0], nArray.length - 126);
        nArray4[0] = nArray4[0] + (nArray.length - 126);
        int n28 = nArray4[0];
        nArray4[0] = n28 + 1;
        RomManager.StaticAccess.writeByte(n28, 0);
        RomManager.StaticAccess.writeBytes(nArray2, nArray4[1]);
        if (n4 > 0) {
            RomManager.StaticAccess.copyBytes(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()), nArray4[3], n16 * 2);
            RomManager.StaticAccess.fill(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()), RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()) + n16 * 2, 255);
            this.setEntityDataAddress(0x8000 | nArray4[3] & 0x3FFF);
        }
        n25 = this.resolveEntityScreenAddressPointer(n16);
        int n29 = n25 + 2;
        int n30 = n16 - 1;
        while (n30 >= this.calcEntityIndex(n, n2)) {
            RomManager.StaticAccess.writeByte(--n29, RomManager.StaticAccess.readByte(--n25));
            RomManager.StaticAccess.writeByte(--n29, RomManager.StaticAccess.readByte(--n25));
            --n30;
        }
        RomManager.StaticAccess.writeByte(--n29, 0x80 | nArray4[1] >> 8 & 0x3F);
        RomManager.StaticAccess.writeByte(--n29, nArray4[1] & 0xFF);
        if ((this.getScrollability() & 1) != 0 && (this.getScrollability() & 0x80) == 0 || n == 0 && n2 < this.getMaxVerticalScreenNumber()) {
            this.setMaxVerticalScreenNumber(this.getMaxVerticalScreenNumber() + 1);
        } else if (this.getScrollability() == 4) {
            this.setStartHorizontalScreenNumber(this.getStartHorizontalScreenNumber() + 1);
        } else {
            this.setMaxHorizontalScreenNumber(this.getMaxHorizontalScreenNumber() + 1);
            if (this.getMaxHorizontalScreenNumber() > 0 && (this.getScrollability() & 0x88) == 0) {
                this.setScrollability(this.getScrollability() | 8);
            }
        }
        this.setPointers(nArray9);
        return true;
    }

    public int calcScreenSize(int n) {
        int[] nArray = new int[1];
        this.getLayout(n, nArray);
        return nArray[0];
    }

    public int[] getLayout(int n) {
        return this.getLayout(n, null);
    }

    private int[] getLayout(int n, final int[] nArray) {
        if (n < 32768) {
            throw new IllegalArgumentException("Screen Address must be greater or equal to $8000: $" + Integer.toHexString(n));
        }
        if (n >= 49152) {
            throw new IllegalArgumentException("Screen Address must not be located in RAM. $" + Integer.toHexString(n));
        }
        final int[] nArray2 = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray2, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray2, this.getBank());
        final Z80 z80 = Z80Factory.create(nArray2);
        final int[] nArray3 = new int[1];
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 55040) {
                    nArray3[0] = z80.getHL() - 1;
                } else if (n == 55231 && nArray != null) {
                    nArray[0] = z80.getHL() + 1 - nArray3[0] + 1;
                } else {
                    if (n == 55232) {
                        if (Level.this instanceof BonusLevel) {
                            throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + Integer.toHexString(nArray3[0]) + " of the bonuslevel.");
                        }
                        throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + Integer.toHexString(nArray3[0]) + " of level " + (Level.this.level + 1) + ".");
                    }
                    if (n == 65535) {
                        RomManager.StaticAccess.loadBank2(nArray2, n2);
                    }
                }
            }
        });
        z80.setHL(n);
        z80.setDE(55040);
        z80.execute(27631);
        int[] nArray4 = new int[192];
        System.arraycopy(nArray2, 55040, nArray4, 0, nArray4.length);
        return nArray4;
    }

    public int getScreenSize(int n, int n2) {
        int[] nArray = new int[1];
        this.getLayout(n, n2, nArray);
        return nArray[0];
    }

    public int[] getLayout(int n, int n2) {
        return this.getLayout(n, n2, null);
    }

    public int[] getLayout(int n, int n2, final int[] nArray) {
        if (n2 == this.getMaxVerticalScreenNumber() && n != this.getStartHorizontalScreenNumber() - 1 && (this.getScrollability() & 0x60) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && ((this.getScrollability() & 0x40) != 0 || this.getScrollability() == 128 && n2 != this.getStartVerticalScreenNumber())) {
            int[] nArray2;
            block4: {
                nArray2 = new int[65536];
                RomManager.StaticAccess.copyFromROM(0, nArray2, 0, 32768);
                RomManager.StaticAccess.loadBank2(nArray2, this.getBank());
                final Z80 z80 = Z80Factory.create(nArray2);
                final int[] nArray3 = new int[1];
                final int n3 = this.calcEntityIndex(n, n2);
                z80.addOutputListener(new OutputListener(){

                    @Override
                    public void outputAvailable(int n, int n2, int n32) {
                        if (n == 55040) {
                            nArray3[0] = z80.getHL() - 1;
                        } else if (n == 55231 && nArray != null) {
                            nArray[0] = z80.getHL() + 1 - nArray3[0] + 1;
                        } else {
                            if (n == 55232) {
                                if (Level.this instanceof BonusLevel) {
                                    throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + n3 + " of the bonuslevel.");
                                }
                                throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + n3 + " of level " + (Level.this.level + 1) + ".");
                            }
                            if (n == 65535) {
                                RomManager.StaticAccess.loadBank2(nArray2, n2);
                            }
                        }
                    }
                });
                nArray2[49348] = n2 - 1;
                nArray2[49334] = n;
                nArray2[49281] = this.getBank();
                nArray2[49320] = RomManager.StaticAccess.readByte(this.getAddress() + 3);
                nArray2[49321] = RomManager.StaticAccess.readByte(this.getAddress() + 4);
                try {
                    z80.execute(27425);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!(exception instanceof ArrayIndexOutOfBoundsException) || this.getScrollability() != 128) break block4;
                    this.setPointers(this.getScreenAddresses());
                    System.out.println("Pointers fixed.");
                }
            }
            int[] nArray4 = new int[192];
            System.arraycopy(nArray2, 55040, nArray4, 0, nArray4.length);
            return nArray4;
        }
        return this.getLayout(this.getScreenAddress(n, n2), nArray);
    }

    public boolean hasOctopusTentacle() {
        return this.entityOctopusTentacle >= 0;
    }

    public int[][] getSAT(int n, int n2) {
        if (this.isMoving() || this.isMovingEntityData() || MiracleWorldDataModel.isMovingEntityData()) {
            throw new IllegalStateException("Cannot get SAT while moving");
        }
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray, 2);
        this.entitiesBank = 0;
        nArray[49187] = this.level + 1;
        nArray[49249] = this.getEntityDataAddress() & 0xFF;
        nArray[49250] = this.getEntityDataAddress() >> 8;
        nArray[49253] = this.calcEntityDataIndex(n, n2);
        if (this.getScrollability() == 128) {
            nArray[49263] = RomManager.StaticAccess.readByte(26202);
        }
        nArray[49281] = this.getBank();
        nArray[49289] = this.getAddressUpdateLevelEntities() & 0xFF;
        nArray[49290] = this.getAddressUpdateLevelEntities() >> 8;
        nArray[49293] = this.calcScreenNumber(n, n2);
        final Z80 z80 = Z80Factory.create(nArray);
        this.entitySources = new int[30];
        this.entityOctopusTentacle = Integer.MIN_VALUE;
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65533) {
                    System.err.println("Bank 0 mapping is forbidden because it's unsupported by the Everdrive!");
                    z80.reset();
                } else if (n == 65534) {
                    RomManager.StaticAccess.loadBank1(nArray, n2);
                } else if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                    if (Level.this.entitiesBank == 0) {
                        Level.this.entitiesBank = nArray[65535];
                    }
                } else if (n >= 49920 && n < 49920 + Level.this.entityData.length && (n & 0x1F) == 0 && Level.this.entitySources[(z80.getIX() - 49920) / 32] == 0) {
                    if (z80.getHL() >= 32768 && z80.getHL() < 49152) {
                        Level.this.entitiesBank = nArray[65535];
                        ((Level)Level.this).entitySources[(z80.getIX() - 49920) / 32] = RomManager.RESOLVE_ADDRESS(z80.getHL(), Level.this.entitiesBank);
                    } else if (n2 == 36 && Level.this.entityOctopusTentacle < 0) {
                        Level.this.entitiesBank = nArray[65535];
                        Level.this.entityOctopusTentacle = (z80.getIX() - 49920) / 32;
                        ((Level)Level.this).entitySources[(z80.getIX() - 49920) / 32] = RomManager.RESOLVE_ADDRESS(z80.getHLex(), Level.this.entitiesBank);
                    }
                }
            }
        });
        z80.execute(RomManager.StaticAccess.readWord(2706));
        if (this.entitiesBank == 0) {
            this.entitiesBank = 2;
        }
        nArray[49401] = 0;
        nArray[49402] = 195;
        nArray[49400] = this.entitySources.length;
        this.entityPointers = new int[64];
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >= 50944 && n < 51008 && n2 != 208) {
                    ((Level)Level.this).entityPointers[n & 0x3F] = z80.getIX() - 49920;
                } else if (n >= 51008 && n < 51072) {
                    throw new ArrayIndexOutOfBoundsException("The SAT has overflown in Screen " + nArray[49293] + " of Level " + (Level.this.level + 1) + ".");
                }
            }
        });
        if (z80.execute(9876)) {
            nArray[1230] = 201;
            z80.execute(9876);
            int n3 = 0;
            while (n3 < this.entitySources.length) {
                nArray[49920 + n3 * 32 + 9] = 0;
                nArray[49920 + n3 * 32 + 10] = 0;
                ++n3;
            }
            z80.execute(9876);
        }
        if (this.isStartScreen(n, n2)) {
            Arrays.fill(nArray, 10682, 10690, 0);
            if (this.getAddressStartVehicle() > 0) {
                if (RomManager.StaticAccess.readByte(this.getAddressStartVehicle()) == 1) {
                    nArray[49233] = 1;
                } else if (RomManager.StaticAccess.readByte(this.getAddressStartVehicle()) != 0) {
                    nArray[49236] = 9;
                }
            }
            nArray[10607] = 201;
            nArray[49920] = 1;
            nArray[49932] = RomManager.StaticAccess.readByte(this.getAddressStartPositionHpos());
            nArray[49934] = RomManager.StaticAccess.readByte(this.getAddressStartPositionVpos());
        }
        z80.execute(9876);
        System.arraycopy(nArray, 49920, this.entityData, 0, this.entityData.length);
        int[] nArray2 = new int[256];
        System.arraycopy(nArray, 50944, nArray2, 0, nArray2.length);
        int n4 = Math.min(nArray[55456], 31);
        int[] nArray3 = new int[n4 * 2];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[55457 + n5 * 3 + 1] << 8 | nArray[55457 + n5 * 3];
            nArray3[n5 * 2] = (n6 - 51200) / 4;
            nArray3[n5 * 2 + 1] = nArray[55457 + n5 * 3 + 2];
            ++n5;
        }
        return new int[][]{nArray2, nArray3};
    }

    public boolean setLayout(int n, int n2, int[] nArray) {
        if (nArray.length < 0 || nArray.length > 192) {
            throw new IllegalArgumentException("Illegal layout size: " + nArray.length);
        }
        if (this.isCompressed()) {
            return false;
        }
        if (this.countScreenReferences(this.getScreenAddress(n, n2)) > 1 && !this.copyScreen(n, n2)) {
            return false;
        }
        int n3 = this.RESOLVE_ADDRESS(this.getScreenAddress(n, n2));
        if (RomManager.StaticAccess.readByte(n3) != 254) {
            return true;
        }
        ++n3;
        TransactionManager.getInstance().addTransactionObject(this, -1);
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n4 == 126) {
                // empty if block
            }
            int n6 = ++n3;
            ++n3;
            RomManager.StaticAccess.writeByte(n6, n5);
            ++n4;
        }
        Level.applyRespawnHacks();
        Level.applyFallIntoWaterHack();
        return true;
    }

    public boolean setMetaTile(int n, int n2, int n3, int n4) {
        if (this.isCompressed()) {
            return false;
        }
        if (this.countScreenReferences(this.getScreenAddress(n, n2)) > 1 && !this.copyScreen(n, n2)) {
            return false;
        }
        int n5 = this.RESOLVE_ADDRESS(this.getScreenAddress(n, n2));
        if (RomManager.StaticAccess.readByte(n5) != 254) {
            return true;
        }
        ++n5;
        n5 += n3;
        if (n3 >= 126) {
            ++n5;
        }
        if (RomManager.StaticAccess.readByte(n5) != n4) {
            TransactionManager.getInstance().addTransactionObject(this, n3);
            RomManager.StaticAccess.writeByte(n5, n4);
        }
        Level.applyRespawnHacks();
        Level.applyFallIntoWaterHack();
        return true;
    }

    private void updateHiddenTilesStartVerticalScreenNumber(int n) {
        int n2 = this.getMaxHorizontalScreenNumber() + 1;
        int n3 = this.getMaxVerticalScreenNumber() + 1;
        if ((this.getScrollability() & 4) != 0) {
            n2 = this.getStartHorizontalScreenNumber();
        }
        if (this.getScrollability() == 1) {
            n2 = 1;
        }
        if (this.getScrollability() == 128) {
            int n4;
            n3 = 0;
            n2 = 1;
            int n5 = 0;
            while (n5 < this.getValidScreens().length) {
                n4 = n2 - 1;
                while (n4 < this.getValidScreens()[n5].length) {
                    if (this.isValidScreen(n4, n5)) {
                        if (n5 + 1 > n3) {
                            n3 = n5 + 1;
                        }
                        if (n4 + 1 > n2) {
                            n2 = n4 + 1;
                        }
                    }
                    ++n4;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n3) {
                n4 = 0;
                while (n4 < n2) {
                    if (this.isValidScreen(n4, n5)) {
                        this.updateHiddenTilesStartVerticalScreenNumber(n4, n5, n);
                    }
                    ++n4;
                }
                ++n5;
            }
        } else if ((this.getScrollability() & 1) != 0) {
            int n6;
            if ((this.getScrollability() & 0x80) != 0) {
                n6 = 0;
                while (n6 < n2) {
                    this.updateHiddenTilesStartVerticalScreenNumber(n6, 0, n);
                    ++n6;
                }
            }
            n6 = 0;
            while (n6 < n3) {
                if ((this.getScrollability() & 0x80) == 0 || n6 != 0) {
                    this.updateHiddenTilesStartVerticalScreenNumber(0, n6, n);
                }
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n3) {
                if ((this.getScrollability() & 0x40) != 0 && n7 > 0) {
                    n2 = 4;
                } else if ((this.getScrollability() & 0x20) != 0 && n7 > 0) {
                    n2 = 2;
                }
                int n8 = 0;
                while (n8 < n2) {
                    this.updateHiddenTilesStartVerticalScreenNumber(n8, n7, n);
                    ++n8;
                }
                ++n7;
            }
        }
    }

    private void updateHiddenTilesStartVerticalScreenNumber(int n, int n2, int n3) {
        int n4 = this.findHiddenTiles(n, n2);
        if (n4 >= 0) {
            int n5 = RomManager.StaticAccess.readByte(n4);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n4 + 1 + 3 * n6;
                int n8 = (RomManager.StaticAccess.readWord(n7) - 51200) / 4;
                int n9 = n8 / 32;
                n9 = this.getScrollability() == 129 && n > 0 ? (n9 += (this.getMaxVerticalScreenNumber() - n3 + 1) * 2) : (n9 += (n2 - n3) * 2);
                if (n9 < 0) {
                    n9 += 14;
                }
                this.setHiddenTilePosition(n, n2, n6, n8 % 16, n9);
                ++n6;
            }
        }
    }

    private int findHiddenTiles(int n, int n2) {
        int n3;
        int n4 = n3 = this.resolveEntityScreenAddress(n, n2);
        int n5 = RomManager.StaticAccess.readByte(n4++);
        while ((n5 & 0x80) != 0) {
            if ((n5 & 0xFFFFFF70) != 0) {
                return -1;
            }
            if ((n5 & 5) != 0) {
                n4 += 4;
            } else if ((n5 & 2) == 0) {
                return n4 + 1;
            }
            int n6 = ++n4;
            ++n4;
            n5 = RomManager.StaticAccess.readByte(n6);
        }
        return -1;
    }

    public boolean canAddHiddenTile(int n, int n2) {
        if ((this.calcScreenNumber(n, n2) & 0x80) == 0) {
            return false;
        }
        int n3 = this.findHiddenTiles(n, n2);
        return n3 < 0 || RomManager.StaticAccess.readByte(n3) + 1 <= 31;
    }

    public int addHiddenTile(int n, int n2, int n3, int n4, int n5) {
        return this.addHiddenTile(n, n2, n3, n4, n5, 1);
    }

    private int addHiddenTile(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n6 >= 4) {
            return -1;
        }
        if (!this.canAddHiddenTile(n, n2)) {
            return -1;
        }
        int n8 = this.findHiddenTiles(n, n2);
        boolean bl = n8 >= 0;
        int n9 = this.resolveEntityScreenAddress(n, n2);
        int n10 = Level.calcEntityScreenSize(n9);
        int n11 = n9 + n10;
        int n12 = bl ? RomManager.StaticAccess.readByte(n8) : 0;
        int n13 = bl ? 3 : 6;
        int n14 = n9;
        boolean bl2 = false;
        int n15 = 0;
        while (n15 < n13) {
            if (RomManager.StaticAccess.readByte(n11 + n15) != 255) {
                n7 = KiddEd.findFreeBlock(n10 + n13, n9 / 16384);
                if (n7 < 0) {
                    if (!(this.relocateEntityData() || (this.isEntitiesLevelBank() || MiracleWorldEditorModel.moveEntityData()) && this.relocate())) {
                        return -1;
                    }
                    return this.addHiddenTile(n, n2, n3, n4, n5, n6 + 1);
                }
                if (this.countEntityScreenReferences(n9) == 1) {
                    bl2 = true;
                }
                n11 = n7 + n10;
                n9 = n7;
                break;
            }
            ++n15;
        }
        if (RomManager.StaticAccess.readByte(n11) == 255 && RomManager.StaticAccess.readByte(n11 + 1) == 255 && RomManager.StaticAccess.readByte(n11 + 2) == 255 && (bl || RomManager.StaticAccess.readByte(n11 + 3) == 255 && RomManager.StaticAccess.readByte(n11 + 4) == 255 && RomManager.StaticAccess.readByte(n11 + 5) == 255)) {
            TransactionManager.getInstance().addTransactionObject(this, n12);
            if (n9 != n14) {
                RomManager.StaticAccess.copyBytes(n14, n9, n10);
                if (bl2) {
                    RomManager.StaticAccess.fill(n14, n14 + n10, 255);
                }
            }
            n15 = this.resolveEntityScreenAddressPointer(n, n2);
            RomManager.StaticAccess.writeByte(n15, n9 & 0xFF);
            RomManager.StaticAccess.writeByte(n15 + 1, 0x80 | n9 >> 8 & 0x3F);
            if (!bl) {
                RomManager.StaticAccess.copyBytes(n9, n9 + 6, n10);
                n8 = n9;
                RomManager.StaticAccess.writeByte(n8++, 136);
                RomManager.StaticAccess.writeByte(n8++, 4);
                RomManager.StaticAccess.writeByte(n8++, 1);
            } else {
                n8 = this.findHiddenTiles(n, n2);
                RomManager.StaticAccess.addToByte(n8 - 1, 3);
                RomManager.StaticAccess.incByte(n8);
                RomManager.StaticAccess.copyBytes(n8 += 1 + 3 * n12, n8 + 3, n11 - n8);
            }
            n4 = this.getScrollability() == 129 ? (n4 - ((n > 0 ? this.getMaxVerticalScreenNumber() : n2) - this.getStartVerticalScreenNumber() + 1) * 2) % 14 : (n4 - (n2 - this.getStartVerticalScreenNumber()) * 2) % 14;
            if (n4 < 0) {
                n4 += 14;
            }
            n7 = 51200 + 4 * (n4 * 32 + n3);
            RomManager.StaticAccess.writeByte(n8++, n7 & 0xFF);
            RomManager.StaticAccess.writeByte(n8++, n7 >> 8);
            RomManager.StaticAccess.writeByte(n8++, n5);
        }
        return n12;
    }

    public boolean removeHiddenTile(int n, int n2, int n3) {
        if ((this.calcScreenNumber(n, n2) & 0x80) == 0) {
            return false;
        }
        int n4 = this.findHiddenTiles(n, n2);
        if (n4 < 0 || n3 >= RomManager.StaticAccess.readByte(n4)) {
            return false;
        }
        int n5 = this.resolveEntityScreenAddress(n, n2);
        int n6 = n5 + Level.calcEntityScreenSize(n5);
        int n7 = RomManager.StaticAccess.readByte(n4);
        --n4;
        TransactionManager.getInstance().addTransactionObject(this, n3);
        if (n7 > 1) {
            RomManager.StaticAccess.addToByte(n4++, -3);
            RomManager.StaticAccess.decByte(n4++);
            RomManager.StaticAccess.copyBytes((n4 += n3 * 3) + 3, n4, n6 - (n4 + 3));
            RomManager.StaticAccess.fill(n6 - 3, n6, 255);
        } else {
            RomManager.StaticAccess.copyBytes(--n4 + 6, n4, n6 - (n4 + 6));
            RomManager.StaticAccess.fill(n6 - 6, n6, 255);
        }
        return true;
    }

    private boolean setHiddenTilePosition(int n, int n2, int n3, int n4, int n5) {
        if ((this.calcScreenNumber(n, n2) & 0x80) == 0) {
            return false;
        }
        int n6 = this.findHiddenTiles(n, n2);
        if (n6 < 0 || n3 >= RomManager.StaticAccess.readByte(n6++)) {
            return false;
        }
        n6 += n3 * 3;
        n5 = this.getScrollability() == 129 ? (n5 - ((n > 0 ? this.getMaxVerticalScreenNumber() : n2) - this.getStartVerticalScreenNumber() + 1) * 2) % 14 : (n5 - (n2 - this.getStartVerticalScreenNumber()) * 2) % 14;
        if (n5 < 0) {
            n5 += 14;
        }
        int n7 = 51200 + 4 * (n5 * 32 + n4);
        RomManager.StaticAccess.writeByte(n6, n7 & 0xFF);
        RomManager.StaticAccess.writeByte(n6 + 1, n7 >> 8);
        return true;
    }

    public boolean canAddEntity(int n, int n2, int n3) {
        int n4;
        if ((this.calcScreenNumber(n, n2) & 0x80) == 0 && !(this instanceof BonusLevel)) {
            return false;
        }
        int n5 = n4 = this.resolveEntityScreenAddress(n, n2);
        int n6 = RomManager.StaticAccess.readByte(n5++);
        int n7 = 0;
        int n8 = 0;
        while ((n6 & 0x80) != 0) {
            if ((n6 & 0xFFFFFF70) != 0) {
                return false;
            }
            if ((n6 & 5) != 0) {
                if (n3 == 5 && (n6 & 5) == 4) {
                    return false;
                }
                if ((n6 & 5) == 1 && ++n8 > 2) {
                    return false;
                }
                n5 += 4;
            } else if ((n6 & 2) != 0) {
                ++n5;
                if ((n7 += 8) >= 10) {
                    return false;
                }
            } else {
                n5 += RomManager.StaticAccess.readByte(n5) + 1;
            }
            n6 = RomManager.StaticAccess.readByte(n5++);
        }
        return n3 != 6 || (n7 += n6) < 10;
    }

    public int addEntity(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.addEntity(n, n2, n3, n4, n5, n6, n7, 1);
    }

    private int addEntity(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        if (n8 >= 4) {
            return -1;
        }
        if (!this.canAddEntity(n, n2, n3)) {
            return -1;
        }
        int n11 = n10 = this.resolveEntityScreenAddress(n, n2);
        int n12 = RomManager.StaticAccess.readByte(n11++);
        int n13 = 0;
        int n14 = 0;
        while ((n12 & 0x80) != 0) {
            if ((n12 & 0xFFFFFF70) != 0) {
                return -1;
            }
            if ((n12 & 5) != 0) {
                if (n3 == 5 && (n12 & 5) == 4) {
                    return -1;
                }
                if ((n12 & 5) == 1 && ++n14 > 2) {
                    return -1;
                }
                n11 += 4;
            } else if ((n12 & 2) != 0) {
                ++n11;
                if ((n13 += 8) >= 10) {
                    return -1;
                }
            } else {
                n11 += RomManager.StaticAccess.readByte(n11) + 1;
            }
            n12 = RomManager.StaticAccess.readByte(n11++);
        }
        n13 += n12;
        if (n4 == 36) {
            n13 += 7;
        }
        if (n3 == 6 && n13 >= 10) {
            return -1;
        }
        int n15 = n11 - 1;
        int n16 = (n11 += 4 * n12) - n10;
        int n17 = n10;
        boolean bl = false;
        if (this.countEntityScreenReferences(n10) == 1) {
            bl = true;
        }
        if (!bl || RomManager.StaticAccess.readByte(n11) != 255 || RomManager.StaticAccess.readByte(n11 + 1) != 255 || RomManager.StaticAccess.readByte(n11 + 2) != 255 || RomManager.StaticAccess.readByte(n11 + 3) != 255 || n3 != 6 && RomManager.StaticAccess.readByte(n11 + 4) != 255) {
            n9 = KiddEd.findFreeBlock(n16 + (n3 != 6 ? 5 : 4), n10 / 16384);
            if (n9 < 0) {
                if (!(this.relocateEntityData() || (this.isEntitiesLevelBank() || MiracleWorldEditorModel.moveEntityData()) && this.relocate())) {
                    return -1;
                }
                return this.addEntity(n, n2, n3, n4, n5, n6, n7, n8 + 1);
            }
            n15 += n9 - n10;
            n11 = n9 + n16;
            n10 = n9;
        }
        if (RomManager.StaticAccess.readByte(n11) == 255 && RomManager.StaticAccess.readByte(n11 + 1) == 255 && RomManager.StaticAccess.readByte(n11 + 2) == 255 && RomManager.StaticAccess.readByte(n11 + 3) == 255 && (n3 == 6 || RomManager.StaticAccess.readByte(n11 + 4) == 255)) {
            TransactionManager.getInstance().addTransactionObject(this, n12);
            if (n10 != n17) {
                RomManager.StaticAccess.copyBytes(n17, n10, n16);
                if (bl) {
                    RomManager.StaticAccess.fill(n17, n17 + n16, 255);
                }
            }
            n9 = this.resolveEntityScreenAddressPointer(n, n2);
            RomManager.StaticAccess.writeByte(n9, n10 & 0xFF);
            RomManager.StaticAccess.writeByte(n9 + 1, 0x80 | n10 >> 8 & 0x3F);
            int n18 = n11;
            if (n4 == 36) {
                RomManager.StaticAccess.copyBytes(n10, n10 + 2, n16);
                n18 = n10;
                RomManager.StaticAccess.writeByte(n18++, 130);
                RomManager.StaticAccess.writeByte(n18++, n7);
                return n3;
            }
            if (n3 == 5) {
                RomManager.StaticAccess.copyBytes(n10, n10 + 5, n16);
                n18 = n10;
                RomManager.StaticAccess.writeByte(n18++, 132);
            } else if (n3 == Level.getTopPrioritySlot()) {
                RomManager.StaticAccess.copyBytes(n10, n10 + 5, n16);
                n18 = n10;
                RomManager.StaticAccess.writeByte(n18++, 129);
            } else if (n3 == Level.getTopPrioritySlot() + 1) {
                if (n14 < 1) {
                    throw new IllegalArgumentException("Cannot add entity with Top B priority if there is no entity with Top A priority.");
                }
                n11 = n10;
                n12 = RomManager.StaticAccess.readByte(n11++);
                while ((n12 & 0x80) != 0) {
                    if ((n12 & 5) != 0) {
                        n11 += 4;
                        if ((n12 & 1) != 0) {
                            break;
                        }
                    } else if ((n12 & 2) == 0) {
                        n11 += RomManager.StaticAccess.readByte(n11) + 1;
                    }
                    int n19 = ++n11;
                    ++n11;
                    n12 = RomManager.StaticAccess.readByte(n19);
                }
                n10 = n11;
                RomManager.StaticAccess.copyBytes(n10, n10 + 5, n16);
                n18 = n10;
                RomManager.StaticAccess.writeByte(n18++, 129);
            } else {
                RomManager.StaticAccess.incByte(n15);
            }
            RomManager.StaticAccess.writeByte(n18++, n4);
            RomManager.StaticAccess.writeByte(n18++, n5);
            RomManager.StaticAccess.writeByte(n18++, n6);
            RomManager.StaticAccess.writeByte(n18++, n7);
        }
        if (n3 != 6) {
            return n3;
        }
        return 6 + n13;
    }

    private int countEntityScreenReferences(int n) {
        int[] nArray = this.getEntityScreenAddresses();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                ++n2;
            }
            ++n3;
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid screen address!: " + Integer.toHexString(n).toUpperCase());
        }
        return n2;
    }

    public boolean isEntityValid(int n) {
        return n == 0 || n >= 0 && this.entitySources[n] > 0;
    }

    public int getEntityIndex(int n) {
        int n2 = this.entityPointers[n & 0x3F] / 32;
        if (n2 >= this.entityOctopusTentacle && n2 < this.entityOctopusTentacle + 8) {
            return this.entityOctopusTentacle;
        }
        return n2;
    }

    public int[] getEntityData(int n) {
        int[] nArray = new int[4];
        if (this.isEntityValid(n)) {
            if (n == 0) {
                nArray[0] = 1;
                nArray[1] = RomManager.StaticAccess.readByte(this.getAddressStartPositionVpos());
                nArray[2] = RomManager.StaticAccess.readByte(this.getAddressStartPositionHpos());
                if (this.getAddressStartVehicle() > 0) {
                    nArray[3] = RomManager.StaticAccess.readByte(this.getAddressStartVehicle());
                }
            } else if (this.entitySources[n] > 0) {
                if (n == this.entityOctopusTentacle) {
                    nArray[0] = 36;
                    int n2 = RomManager.StaticAccess.readWord(28930 + (RomManager.StaticAccess.readByte(this.entitySources[n]) - 1) * 2) + 2;
                    nArray[1] = RomManager.StaticAccess.readByte(n2 + 1);
                    nArray[2] = RomManager.StaticAccess.readByte(n2 + 2);
                    nArray[3] = RomManager.StaticAccess.readByte(this.entitySources[n]);
                } else {
                    RomManager.StaticAccess.readBytes(nArray, this.entitySources[n]);
                }
            }
        }
        return nArray;
    }

    public int[] getEntityScreenData(int n, int n2) {
        return this.getEntityScreenData(this.resolveEntityScreenAddress(n, n2));
    }

    public int[] getEntityScreenData(int n) {
        return RomManager.StaticAccess.readBytes(new int[Level.calcEntityScreenSize(n)], n);
    }

    public void setEntityData(int n, int[] nArray) {
        if (n == 0) {
            if (RomManager.StaticAccess.readByte(this.getAddressStartPositionHpos()) != nArray[2] || RomManager.StaticAccess.readByte(this.getAddressStartPositionVpos()) != nArray[1] || this.getAddressStartVehicle() > 0 && RomManager.StaticAccess.readByte(this.getAddressStartVehicle()) != nArray[3]) {
                TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                RomManager.StaticAccess.writeByte(this.getAddressStartPositionHpos(), nArray[2]);
                RomManager.StaticAccess.writeByte(this.getAddressStartPositionVpos(), nArray[1]);
                if (this.getAddressStartVehicle() > 0) {
                    RomManager.StaticAccess.writeByte(this.getAddressStartVehicle(), nArray[3]);
                }
            }
        } else if (this.entitySources[n] > 0) {
            if (n == this.entityOctopusTentacle) {
                int n2 = RomManager.StaticAccess.readByte(this.entitySources[n]);
                int n3 = RomManager.StaticAccess.readWord(28930 + (n2 - 1) * 2);
                if (n2 != nArray[3] || RomManager.StaticAccess.readByte(n3 + 1) != nArray[1] || RomManager.StaticAccess.readByte(n3 + 2) != nArray[2]) {
                    TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                    RomManager.StaticAccess.writeByte(this.entitySources[n], nArray[3]);
                    this.setEntityPosition(n, nArray[1], nArray[2]);
                }
            } else {
                boolean bl = false;
                int n4 = 0;
                while (n4 < nArray.length && !bl) {
                    if (RomManager.StaticAccess.readByte(this.entitySources[n] + n4) != nArray[n4]) {
                        bl = true;
                    }
                    ++n4;
                }
                if (bl) {
                    TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                    RomManager.StaticAccess.writeBytes(nArray, this.entitySources[n]);
                }
            }
        }
    }

    public void setEntitySlot(int n, int n2, int n3, int n4) {
        if (n3 == this.entityOctopusTentacle || this.entitySources[n3] == 0) {
            return;
        }
        if (n3 != n4) {
            if (this.entitySources[n4] > 0) {
                TransactionManager.getInstance().addTransactionObject(this, n4);
                int[] nArray = RomManager.StaticAccess.readBytes(new int[4], this.entitySources[n4]);
                RomManager.StaticAccess.copyBytes(this.entitySources[n3], this.entitySources[n4], nArray.length);
                RomManager.StaticAccess.writeBytes(nArray, this.entitySources[n3]);
            } else {
                int[] nArray = this.getEntityData(n3);
                this.removeEntity(n3);
                if (this.addEntity(n, n2, n4, nArray[0], nArray[1], nArray[2], nArray[3]) < 0) {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public void removeEntity(int n) {
        if (this.entitySources[n] == 0) {
            return;
        }
        if (n == this.entityOctopusTentacle) {
            int n2 = RomManager.StaticAccess.readByte(this.entitySources[n] - 1);
            if (n2 == 130) {
                int n3 = Level.calcEntityScreenSize(this.entitySources[n] + 1);
                TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                RomManager.StaticAccess.copyBytes(this.entitySources[n] + 1, this.entitySources[n] - 1, n3);
                RomManager.StaticAccess.fill(this.entitySources[n] - 1 + n3, this.entitySources[n] - 1 + n3 + 2, 255);
            }
        } else if (n == 5) {
            int n4 = RomManager.StaticAccess.readByte(this.entitySources[n] - 1);
            if (n4 == 132) {
                int n5 = Level.calcEntityScreenSize(this.entitySources[n] + 4);
                TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                RomManager.StaticAccess.copyBytes(this.entitySources[n] + 4, this.entitySources[n] - 1, n5);
                RomManager.StaticAccess.fill(this.entitySources[n] - 1 + n5, this.entitySources[n] - 1 + n5 + 5, 255);
            }
        } else if (n >= (this.READ_WORD(28688) - 49920) / 32) {
            int n6 = this.entitySources[n] - 1;
            int n7 = Level.calcEntityScreenSize(n6);
            int n8 = n6 + n7;
            TransactionManager.getInstance().addTransactionObject(this, 192 + n);
            RomManager.StaticAccess.copyBytes(n6 + 5, n6, n7 - 5);
            RomManager.StaticAccess.fill(n8 - 5, n8, 255);
        } else {
            int n9 = (this.entityOctopusTentacle == 6 ? this.entitySources[this.entityOctopusTentacle + 8] : this.entitySources[6]) - 1;
            int n10 = 7;
            while (n9 < 32768 && n10 <= n) {
                n9 = this.entitySources[n10] - 1;
                ++n10;
            }
            n10 = RomManager.StaticAccess.readByte(n9);
            int n11 = (this.entitySources[n] - n9 + 1) / 4;
            if (this.entitySources[n] > n9) {
                TransactionManager.getInstance().addTransactionObject(this, 192 + n);
                if (n11 < n10 - 1) {
                    RomManager.StaticAccess.copyBytes(this.entitySources[n] + 4, this.entitySources[n], (n10 - 1 - n11) * 4);
                }
                RomManager.StaticAccess.fill(this.entitySources[n] + (n10 - 1 - n11) * 4, this.entitySources[n] + (n10 - n11) * 4, 255);
                RomManager.StaticAccess.decByte(n9);
            }
        }
    }

    private void removeEntityScreen(int n, int n2) {
        int n3;
        int n4 = this.calcEntityIndex(n, n2);
        int n5 = this.getNumberOfEntityScreens();
        if (this.getAddressUpdateLevelEntities() != 28488) {
            return;
        }
        int n6 = 65535;
        if (this.bonusLevel != null && (n3 = this.calcScreenCount()) < this.getNumberOfEntityScreens() - this.bonusLevel.calcScreenCount()) {
            n5 = n3;
            n6 = RomManager.StaticAccess.readWord(this.resolveEntityScreenAddressPointer(0));
        }
        if (this.countEntityScreenReferences(n3 = this.resolveEntityScreenAddress(n, n2)) == 1) {
            RomManager.StaticAccess.fill(n3, n3 + Level.calcEntityScreenSize(n3), 255);
        }
        int n7 = this.resolveEntityScreenAddressPointer(n4);
        int n8 = n7 + 2;
        int n9 = n4;
        while (n9 < n5 - 1) {
            RomManager.StaticAccess.writeByte(n7++, RomManager.StaticAccess.readByte(n8++));
            RomManager.StaticAccess.writeByte(n7++, RomManager.StaticAccess.readByte(n8++));
            ++n9;
        }
        RomManager.StaticAccess.writeWord(n7, n6);
    }

    private void mapEntityScreensToCastleLayout(int[][][] nArray) {
        int n;
        int n2 = this.calcEntityDataIndex(1, 0);
        int n3 = n2 * 2;
        int n4 = 0;
        while (n4 < nArray.length) {
            n = 0;
            while (n < nArray[n4].length) {
                n3 = nArray[n4][n] != null ? (n3 += 2 + nArray[n4][n].length) : (n3 += 2);
                ++n;
            }
            ++n4;
        }
        n4 = KiddEd.findFreeBlock(n3, this.getEntitiesBank());
        if (n4 < 0) {
            throw new IllegalStateException("Not enough space to map entity screens to castle layout.");
        }
        n = n4;
        int n5 = n + (nArray.length * nArray[0].length + n2) * 2;
        while (n2-- > 0) {
            RomManager.StaticAccess.writeWord(n, 0x8000 | n5 & 0x3FFF);
            n += 2;
        }
        int n6 = n5;
        int n7 = 0;
        while (n7 < nArray.length) {
            int n8 = 0;
            while (n8 < nArray[n7].length) {
                if (nArray[n7][n8] != null) {
                    RomManager.StaticAccess.writeWord(n, 0x8000 | n5 & 0x3FFF);
                    n += 2;
                    RomManager.StaticAccess.writeBytes(nArray[n7][n8], n5);
                    n6 = n5;
                    n5 += nArray[n7][n8].length;
                } else {
                    RomManager.StaticAccess.writeWord(n, 0x8000 | n6 & 0x3FFF);
                    n += 2;
                }
                ++n8;
            }
            ++n7;
        }
        this.setEntityDataAddress(0x8000 | n4 & 0x3FFF);
    }

    private void removeUnusedCastleLayoutEntities() {
        int n = this.calcEntityDataIndex(1, 0);
        int n2 = this.getEntityDataAddress();
        int n3 = RomManager.RESOLVE_ADDRESS(this.READ_WORD(n2), this.getEntitiesBank());
        if (this.countEntityScreenReferences(n3) <= n) {
            RomManager.StaticAccess.writeByte(RomManager.RESOLVE_ADDRESS(n3, this.getEntitiesBank()), 255);
        }
        while (n-- > 0) {
            RomManager.StaticAccess.writeWord(RomManager.RESOLVE_ADDRESS(n2, this.getEntitiesBank()), 65535);
            n2 += 2;
        }
        this.setEntityDataAddress(0x8000 | n2 & 0x3FFF);
    }

    public boolean canSetStartScreen() {
        return this.getScrollability() == 128;
    }

    public void setStartScreen(int n, int n2) {
        this.setStartScreen(n, n2, true);
    }

    private void setStartScreen(int n, int n2, boolean bl) {
        int n3;
        if (!this.canSetStartScreen()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, -3);
        int n4 = this.getStartVerticalScreenNumber();
        int n5 = this.calcEntityDataIndex(1, 0);
        this.setStartHorizontalScreenNumber(n + 1);
        this.setStartVerticalScreenNumber(n2);
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        while (n8 < this.getValidScreens().length) {
            n3 = n7 - 1;
            while (n3 < this.getValidScreens()[n8].length) {
                if (this.isValidScreen(n3, n8)) {
                    if (n8 + 1 > n6) {
                        n6 = n8 + 1;
                    }
                    if (n3 + 1 > n7) {
                        n7 = n3 + 1;
                    }
                }
                ++n3;
            }
            ++n8;
        }
        this.setMaxVerticalScreenNumber(Math.max(n6, n2 * this.getMaxHorizontalScreenNumber() + n));
        if (bl) {
            int n9;
            int[][][] nArray = new int[n6][n7][];
            n3 = 0;
            while (n3 < nArray.length) {
                n9 = 0;
                while (n9 < nArray[n3].length) {
                    if (this.isValidScreen(n9, n3)) {
                        nArray[n3][n9] = this.getEntityScreenData(this.resolveEntityScreenAddress(n3 * n7 + n9 + n5));
                    }
                    ++n9;
                }
                ++n3;
            }
            n3 = this.calcScreenCount() + n5;
            n9 = 0;
            while (n9 < n3) {
                int n10 = this.resolveEntityScreenAddress(n9);
                int n11 = Level.calcEntityScreenSize(n10);
                if (n11 > 0) {
                    RomManager.StaticAccess.fill(n10, n10 + n11, 255);
                }
                ++n9;
            }
            RomManager.StaticAccess.fill(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()), RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()) + n3 * 2, 255);
            this.mapEntityScreensToCastleLayout(nArray);
        }
        if (n2 != n4) {
            this.updateHiddenTilesStartVerticalScreenNumber(n4);
        }
        this.updateValidScreens();
    }

    private void invertEntityScreens() {
        if (this.getAddressUpdateLevelEntities() != 28488) {
            return;
        }
        int n = this.calcScreenCount();
        if (this instanceof BonusLevel) {
            n += this.calcScreenNumber(this.getStartHorizontalScreenNumber() - 1, 0);
        }
        int n2 = 0;
        while (n2 < n - 1 - n2) {
            this.swapEntityScreens(n2, n - 1 - n2);
            ++n2;
        }
    }

    private void swapEntityScreens(int n, int n2) {
        if (this.getAddressUpdateLevelEntities() != 28488) {
            return;
        }
        n = this.resolveEntityScreenAddressPointer(n);
        n2 = this.resolveEntityScreenAddressPointer(n2);
        int n3 = RomManager.StaticAccess.readByte(n);
        RomManager.StaticAccess.writeByte(n, RomManager.StaticAccess.readByte(n2));
        RomManager.StaticAccess.writeByte(n2, n3);
        n3 = RomManager.StaticAccess.readByte(n + 1);
        RomManager.StaticAccess.writeByte(n + 1, RomManager.StaticAccess.readByte(n2 + 1));
        RomManager.StaticAccess.writeByte(n2 + 1, n3);
    }

    protected static int calcEntityScreenSize(int n) {
        int n2 = n;
        int n3 = RomManager.StaticAccess.readByte(n2++);
        int n4 = 0;
        while ((n3 & 0x80) != 0) {
            if ((n3 & 0xFFFFFF70) != 0) {
                return 0;
            }
            if ((n3 & 5) != 0) {
                n2 += 4;
            } else if ((n3 & 2) != 0) {
                ++n2;
                if ((n4 += 8) > 10) {
                    return 0;
                }
            } else {
                n2 += RomManager.StaticAccess.readByte(n2) + 1;
            }
            n3 = RomManager.StaticAccess.readByte(n2++);
        }
        n2 += 4 * n3;
        if ((n4 += n3) > 10) {
            return 0;
        }
        return n2 - n;
    }

    public static int getTopPrioritySlot() {
        return (RomManager.getInstance().READ_WORD(28688, 1) - 49920) / 32;
    }

    protected int getNumberOfEntityScreens() {
        int n = this.getScrollability() == 128 ? this.calcEntityDataIndex(1, 0) : 0;
        int n2 = this.calcScreenCount() + n;
        if (this.bonusLevel != null) {
            int n3 = this.bonusLevel.getNumberOfEntityScreens();
            if (n3 < n2) {
                throw new IllegalStateException("The number of entity screens with the bonus level must be greater or equal to the number of entity screens without it.");
            }
            return n3;
        }
        return n2;
    }

    protected int[] getEntityScreenAddresses() {
        int n = this.getNumberOfEntityScreens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            try {
                nArray[n2] = this.resolveEntityScreenAddress(n2);
            }
            catch (Exception exception) {
                if (n2 > 0 || !(exception instanceof RuntimeException)) {
                    return Arrays.copyOf(nArray, n2);
                }
                throw (RuntimeException)exception;
            }
            ++n2;
        }
        return nArray;
    }

    private void clearLayout() {
        int n9;
        int n22;
        int n3;
        int[] nArray;
        int[] nArray2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[] nArray3 = this.getScreenPointers();
        if (this.getScrollability() == 129) {
            nArray2 = new int[nArray3.length + 1];
            System.arraycopy(nArray3, 0, nArray2, 1, nArray3.length);
            nArray3 = nArray2;
            nArray3[0] = this.READ_WORD(this.getLayoutPointer());
        }
        if (this.bonusLevel != null && !this.isCompressed()) {
            nArray2 = this.bonusLevel.getScreenPointers();
            nArray = nArray3;
            nArray3 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        }
        int n4 = 65536;
        nArray = this.getEntityScreenAddresses();
        int n5 = 0;
        while (n5 < nArray3.length) {
            if (nArray3[n5] >= 0 && (n3 = this.READ_WORD(nArray3[n5])) >= 32768 && n3 < 49152) {
                if (n3 < n4 && n3 > this.getLayoutPointer()) {
                    n4 = n3;
                }
                hashSet.add(n3);
                n22 = this.calcScreenSize(n3);
                if (n5 + 1 < nArray3.length && nArray3[n5 + 1] >= 0 && this.READ_WORD(nArray3[n5 + 1]) == n3 + n22 + 1) {
                    ++n22;
                }
                int[] nArray4 = nArray;
                int n6 = nArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    n9 = nArray4[n7];
                    if (n9 >= this.RESOLVE_ADDRESS(n3) && n9 < this.RESOLVE_ADDRESS(n3) + n22) {
                        this.relocateEntityData();
                    }
                    ++n7;
                }
                RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(n3), this.RESOLVE_ADDRESS(n3) + n22, 255);
                n9 = n5;
                while (n9 < nArray3.length) {
                    if (nArray3[n9] >= 0 && this.READ_WORD(nArray3[n9]) == n3) {
                        RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(nArray3[n9]), 65535);
                    }
                    ++n9;
                }
            }
            ++n5;
        }
        n5 = this.getLayoutPointer();
        while (this.READ_WORD(n5) >= 32768 && this.READ_WORD(n5) < 49152) {
            n3 = 1;
            n22 = 0;
            while (n22 < nArray3.length - (n5 - this.getLayoutPointer()) / 2) {
                n9 = this.READ_WORD(n5) + n22 * 2;
                if (this.isEntitiesLevelBank() && n9 >= this.getEntityDataAddress() && n9 < this.getEntityDataAddress() + nArray.length * 2) break;
                if (hashSet.contains(this.READ_WORD(n9))) {
                    RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n9), 65535);
                } else if (this.READ_WORD(n9) != 65535) {
                    if (this.READ_WORD(n9) < 32768 || this.READ_WORD(n9) >= 49152 || n22 > this.getMaxHorizontalScreenNumber() && n22 > this.getMaxVerticalScreenNumber()) break;
                    n3 = 0;
                }
                ++n22;
            }
            if (n3 != 0) {
                RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n5), 65535);
            }
            n5 += 2;
        }
        int n8 = n5 = MiracleWorldDataModel.hasMetaTilesetsPerLevel() && this.getMetaTilesetPointer() >= this.getLayoutPointer() + nArray3.length * 2 && this.getMetaTilesetPointer() < n4 ? 1 : 0;
        if (n4 < 65536 && n4 > this.getLayoutPointer() + nArray3.length * 2) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            n22 = this.getLayoutPointer() + nArray3.length * 2;
            while (n22 < n4) {
                if (n5 != 0 && n22 == this.getMetaTilesetPointer()) {
                    n22 += MiracleWorldMetaTileset.getSize();
                }
                if ((this.READ_WORD(n22 - 2) == 65535 || this.READ_WORD(n22 - 2) == 0) && hashSet.contains(this.READ_WORD(n22))) {
                    RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n22), 65535);
                }
                if (this.READ_BYTE(n22) == 255) {
                    if (this.READ_BYTE(n22 + 128) == 193 && this.READ_BYTE(n22 + 128 + 66) == 0) {
                        n22 += 194;
                    } else {
                        RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n22), 0);
                        hashSet2.add(n22);
                    }
                }
                ++n22;
            }
            MiracleWorldEditorModel.relocateDataInRange(this.RESOLVE_ADDRESS(this.getLayoutPointer() + nArray3.length * 2), this.RESOLVE_ADDRESS(n4), hashSet2);
            n22 = this.getLayoutPointer() + nArray3.length * 2;
            while (n22 + 1 < n4 && (this.READ_WORD(n22) >= 32768 && this.READ_WORD(n22) < 49152 || this.READ_WORD(n22) == 0)) {
                if (this.READ_WORD(n22) > 0 && this.READ_WORD(this.READ_WORD(n22)) == 65535) {
                    RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n22), 0);
                    hashSet2.add(n22);
                    hashSet2.add(n22 + 1);
                }
                n22 += 2;
            }
            n22 = this.getLayoutPointer() + nArray3.length * 2;
            while (n22 < n4) {
                if (n5 != 0 && n22 == this.getMetaTilesetPointer()) {
                    n22 += MiracleWorldMetaTileset.getSize();
                }
                if (this.READ_BYTE(n22) != 0 && this.READ_BYTE(n22) != 255) {
                    for (int n9 : hashSet2) {
                        RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n9), 255);
                    }
                    return;
                }
                ++n22;
            }
            if (n5 != 0) {
                RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(this.getLayoutPointer() + nArray3.length * 2), this.RESOLVE_ADDRESS(this.getMetaTilesetPointer()), 255);
                RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(this.getMetaTilesetPointer() + MiracleWorldMetaTileset.getSize()), this.RESOLVE_ADDRESS(n4), 255);
            } else {
                RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(this.getLayoutPointer() + nArray3.length * 2), this.RESOLVE_ADDRESS(n4), 255);
            }
            for (int n22 : hashSet2) {
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n22), 255);
            }
        }
    }

    public boolean relocate() {
        return this.relocate(0);
    }

    public boolean relocate(int n) {
        int n2 = KiddEd.findFreeBlock(Math.min(16384, this.calcRequiredSize() + n));
        if (n2 < 0) {
            return false;
        }
        return this.moveTo(n2, n);
    }

    public boolean copyScreen(int n, int n2) {
        int n3 = this.getScreenAddress(n, n2);
        int n4 = this.calcScreenSize(n3);
        int n5 = KiddEd.findFreeBlock(n4, this.getBank());
        if (n5 < 0) {
            return this.relocate();
        }
        RomManager.StaticAccess.copyBytes(this.RESOLVE_ADDRESS(n3), n5, n4);
        this.setScreenAddress(n, n2, 0x8000 | n5 & 0x3FFF);
        return true;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isMovingEntityData() {
        return this.movingEntityData;
    }

    public void relocateOverlappingScreenLayouts() {
        int[] nArray = this.getScreenAddresses();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 + 128 + 66 + 128 + 66 < 49152 && this.READ_BYTE(n3 + 128 + 66) == 0 && this.READ_BYTE(n3 + 128 + 66 + 128) == 193 && this.READ_BYTE(n3 + 128 + 66 + 128 + 66) == 0) {
                this.relocateScreenLayout(n3);
            }
            ++n2;
        }
    }

    public void rewriteLayout() {
        int[] nArray = this.getScreenAddresses();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (this.READ_BYTE(n3) == 255 && this.READ_BYTE(n3 + 128) == 193 && this.READ_BYTE(n3 + 128 + 66) == 0) {
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n3), 254);
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n3 + 128), this.READ_BYTE(n3 + 127));
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n3 + 127), 194);
            }
            ++n2;
        }
    }

    public boolean moveTo(int n) {
        return this.moveTo(n, 0);
    }

    public boolean moveTo(int n, int n2) {
        int n3 = this.calcRequiredSize();
        if (!this.isMoving() && !this.isMovingEntityData() && n3 > 0 && (n & 0x3FFF) + n3 + n2 <= 16384) {
            int n4 = 0;
            while (n4 < n3) {
                if (RomManager.StaticAccess.readByte(n + n4) != 255) {
                    throw new RuntimeException("moveTo: " + Integer.toHexString(n + n4) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n + n4)));
                }
                ++n4;
            }
            RomManager.StaticAccess.fill(n, n + n3 + n2, 0);
            try {
                this.moving = true;
                if (this.bonusLevel == null && MiracleWorldEditorModel.isBonusLevelCompressed()) {
                    MiracleWorldEditorModel.relocateBonusLevel();
                }
                n4 = this.calcEntityDataSize();
                int[][] nArray = this.decompressLayout();
                int[] nArray2 = nArray[0];
                int[] nArray3 = nArray[1];
                int n5 = 0x8000 | n & 0x3FFF;
                int[] nArray4 = null;
                int n6 = n + this.calcPointersSize();
                if (this.bonusLevel != null) {
                    int[][] nArray5 = this.bonusLevel.decompressLayout();
                    this.clearLayout();
                    nArray4 = nArray5[1];
                    RomManager.StaticAccess.writeBytes(nArray5[0], (n6 += nArray4.length * 2) + nArray2.length);
                    int[] nArray6 = new int[nArray3.length + nArray4.length];
                    System.arraycopy(nArray3, 0, nArray6, 0, nArray3.length);
                    int n7 = 0;
                    while (n7 < nArray4.length) {
                        nArray6[nArray3.length + n7] = nArray4[n7] + nArray2.length;
                        ++n7;
                    }
                    nArray3 = nArray6;
                } else {
                    this.clearLayout();
                }
                int n8 = 0;
                while (n8 < nArray3.length) {
                    int n9 = n8++;
                    nArray3[n9] = nArray3[n9] + (n6 & 0x3FFF);
                }
                RomManager.StaticAccess.writeBytes(nArray2, n6);
                this.setLayoutPointer(n5);
                this.setBank(n / 16384);
                this.writePointers(nArray3);
                MiracleWorldEditorModel.moveMetaTileset(this.level, n + n3 - MiracleWorldMetaTileset.getSize());
                if (this.calcEntityDataSize() != n4) {
                    throw new IllegalStateException("Size of entity data changed from " + n4 + " to " + this.calcEntityDataSize() + " while moving level " + (this.level + 1) + " to " + Integer.toHexString(n) + ".");
                }
                this.moveEntityData(n + n3 - (this.calcEntityDataSize() + MiracleWorldMetaTileset.getSize()));
                if (n2 > 0 && RomManager.StaticAccess.readByte(n + n3) == 0) {
                    RomManager.StaticAccess.fill(n + n3, n + n3 + n2, 255);
                }
                return true;
            }
            finally {
                this.moving = false;
            }
        }
        return false;
    }

    protected boolean moveEntityData(int n) {
        if (this.isMovingEntityData()) {
            return false;
        }
        try {
            int n2;
            int n3;
            this.movingEntityData = true;
            int n4 = this.getNumberOfEntityScreens();
            int n5 = n + n4 * 2;
            int[][] nArrayArray = new int[n4][];
            int n6 = 0;
            while (n6 < nArrayArray.length) {
                try {
                    n3 = this.resolveEntityScreenAddress(n6);
                    n2 = Level.calcEntityScreenSize(n3);
                    nArrayArray[n6] = n2 > 0 ? RomManager.StaticAccess.readBytes(new int[n2], n3) : new int[1];
                }
                catch (Exception exception) {
                    nArrayArray[n6] = new int[1];
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < nArrayArray.length) {
                try {
                    n3 = this.resolveEntityScreenAddress(n6);
                    n2 = Level.calcEntityScreenSize(n3);
                    if (n2 > 0) {
                        RomManager.StaticAccess.fill(n3, n3 + n2, 255);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n6;
            }
            RomManager.StaticAccess.fill(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()), RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress(), this.getEntitiesBank()) + n4 * 2, 255);
            n6 = RomManager.StaticAccess.readByte(n5);
            n3 = 0;
            while (n3 < nArrayArray.length) {
                n2 = 0;
                while (n2 < nArrayArray[n3].length) {
                    if (RomManager.StaticAccess.readByte(n5 + n2) != n6) {
                        throw new IllegalArgumentException("moveEntityData: " + Integer.toHexString(n5 + n2) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n5 + n2)) + " expected: " + Integer.toHexString(n6));
                    }
                    ++n2;
                }
                RomManager.StaticAccess.writeBytes(nArrayArray[n3], n5);
                RomManager.StaticAccess.writeByte(n + 2 * n3, n5 & 0xFF);
                RomManager.StaticAccess.writeByte(n + 2 * n3 + 1, 0x80 | n5 >> 8 & 0x3F);
                n5 += nArrayArray[n3].length;
                ++n3;
            }
            this.setEntityDataAddress(0x8000 | n & 0x3FFF);
            this.entitiesBank = n / 16384;
            boolean bl = MiracleWorldEditorModel.moveEntityData();
            return bl;
        }
        finally {
            this.movingEntityData = false;
        }
    }

    public void relocateDataInRange(int n, int n2, HashSet<Integer> hashSet) {
        int n3;
        int n4;
        int n5;
        int[] nArray;
        if (!this.isMoving()) {
            nArray = this.getScreenAddresses();
            n5 = 0;
            while (n5 < nArray.length) {
                if (this.RESOLVE_ADDRESS(nArray[n5]) >= n && this.RESOLVE_ADDRESS(nArray[n5]) < n2) {
                    n4 = this.calcScreenSize(nArray[n5]);
                    if (this.relocateScreenLayout(nArray[n5])) {
                        n3 = 0;
                        while (n3 < n4) {
                            RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(nArray[n5] + n3), 0);
                            hashSet.add(nArray[n5] + n3);
                            ++n3;
                        }
                    }
                }
                ++n5;
            }
        }
        if (!this.isMovingEntityData()) {
            int n6;
            int n7;
            nArray = this.getEntityScreenAddresses();
            n5 = this.RESOLVE_ADDRESS(this.getEntityDataAddress());
            int n8 = n4 = n5 + nArray.length * 2 > n && n5 < n2 ? 1 : 0;
            if (n4 == 0) {
                int[] nArray2 = nArray;
                n7 = nArray.length;
                n6 = 0;
                while (n6 < n7) {
                    n3 = nArray2[n6];
                    if (n3 >= n && n3 < n2) {
                        n4 = 1;
                        break;
                    }
                    ++n6;
                }
            }
            if (n4 != 0) {
                int[] nArray3 = new int[nArray.length];
                n6 = 0;
                while (n6 < nArray3.length) {
                    nArray3[n6] = Level.calcEntityScreenSize(nArray[n6]);
                    ++n6;
                }
                if (this.relocateEntityData()) {
                    n6 = 0;
                    while (n6 < nArray.length * 2) {
                        hashSet.add(n5 + n6);
                        ++n6;
                    }
                    RomManager.StaticAccess.fill(n5, n5 + nArray.length * 2, 0);
                    n6 = 0;
                    while (n6 < nArray.length) {
                        RomManager.StaticAccess.fill(nArray[n6], nArray[n6] + nArray3[n6], 0);
                        n7 = 0;
                        while (n7 < nArray3[n6]) {
                            hashSet.add(nArray[n6] + n7);
                            ++n7;
                        }
                        ++n6;
                    }
                }
            }
        }
    }

    public boolean relocateEntityData() {
        int n = KiddEd.findFreeBlock(this.calcEntityDataSize(), this.getBank());
        if (n < 0) {
            return false;
        }
        return this.moveEntityData(n);
    }

    public boolean relocateMetaTileset() {
        int n = KiddEd.findFreeBlock(MiracleWorldMetaTileset.getSize(), this.getBank());
        if (n < 0) {
            return false;
        }
        return MiracleWorldEditorModel.moveMetaTileset(this.level, n);
    }

    public void setEntityPosition(int n, int n2, int n3) {
        if (n < 0 || !this.isEntityValid(n)) {
            return;
        }
        if (this.entityData[n * 32] == 1) {
            if (RomManager.StaticAccess.readByte(this.getAddressStartPositionHpos()) != (n3 & 0xFF) || RomManager.StaticAccess.readByte(this.getAddressStartPositionVpos()) != (n2 & 0xFF)) {
                RomManager.StaticAccess.writeByte(this.getAddressStartPositionHpos(), n3 & 0xFF);
                RomManager.StaticAccess.writeByte(this.getAddressStartPositionVpos(), n2 & 0xFF);
            }
        } else if (this.entitySources[n] > 0) {
            if (n == this.entityOctopusTentacle) {
                int n4 = RomManager.StaticAccess.readWord(28930 + (RomManager.StaticAccess.readByte(this.entitySources[n]) - 1) * 2) + 2;
                if (RomManager.StaticAccess.readByte(n4 + 1) != (n2 & 0xFF) || RomManager.StaticAccess.readByte(n4 + 2) != (n3 & 0xFF)) {
                    int n5 = 0;
                    while (n5 < 8) {
                        RomManager.StaticAccess.writeByte(n4 + 4 * n5 + 1, n2 & 0xFF);
                        RomManager.StaticAccess.writeByte(n4 + 4 * n5 + 2, n3 + 8 * n5 & 0xFF);
                        ++n5;
                    }
                }
            } else if (RomManager.StaticAccess.readByte(this.entitySources[n] + 1) != (n2 & 0xFF) || RomManager.StaticAccess.readByte(this.entitySources[n] + 2) != (n3 & 0xFF)) {
                RomManager.StaticAccess.writeByte(this.entitySources[n] + 1, n2 & 0xFF);
                RomManager.StaticAccess.writeByte(this.entitySources[n] + 2, n3 & 0xFF);
            }
        }
    }

    public void startMovingEntity(int n) {
        TransactionManager.getInstance().addTransactionObject(this, 192 + n);
    }

    private int resolveEntityScreenAddressPointer(int n) {
        return RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress() + n * 2, this.getEntitiesBank());
    }

    private int resolveEntityScreenAddressPointer(int n, int n2) {
        return this.resolveEntityScreenAddressPointer(this.calcEntityIndex(n, n2));
    }

    private int resolveEntityScreenAddress(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("entityDataIndex must not be negative: " + n);
        }
        int n2 = RomManager.getInstance().READ_WORD(this.getEntityDataAddress() + n * 2, this.getEntitiesBank());
        if (n2 < 32768) {
            throw new IllegalArgumentException("Entity Screen Address (" + n + ") at $" + Integer.toHexString(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress() + n * 2, this.getEntitiesBank())) + " must be greater or equal to $8000: $" + Integer.toHexString(n2));
        }
        if (n2 >= 49152) {
            throw new IllegalArgumentException("Entity Screen Address (" + n + ") at $" + Integer.toHexString(RomManager.RESOLVE_ADDRESS(this.getEntityDataAddress() + n * 2, this.getEntitiesBank())) + " must not be located in RAM. $" + Integer.toHexString(n2));
        }
        return RomManager.RESOLVE_ADDRESS(n2, this.getEntitiesBank());
    }

    private int resolveEntityScreenAddress(int n, int n2) {
        return this.resolveEntityScreenAddress(this.calcEntityIndex(n, n2));
    }

    protected int calcEntityDataIndex(int n, int n2) {
        return this.getMaxVerticalScreenNumber() + (n2 - this.getStartVerticalScreenNumber()) * this.getMaxHorizontalScreenNumber() + n - this.getStartHorizontalScreenNumber();
    }

    private boolean isStartScreen(int n, int n2) {
        if (this.getScrollability() == 129 ? n2 != this.getStartVerticalScreenNumber() - 1 : n2 != this.getStartVerticalScreenNumber()) {
            return false;
        }
        return n == this.getStartHorizontalScreenNumber() - 1;
    }

    public int calcEntityIndex(int n, int n2) {
        if (this.getAddressUpdateLevelEntities() == 28488) {
            return this.calcScreenNumber(n, n2) & 0x7F;
        }
        return this.calcEntityDataIndex(n, n2) + 1;
    }

    protected int calcScreenNumber(int n, int n2) {
        int n3 = n + n2;
        if (this.getScrollability() == 129 && n > 0) {
            n3 += this.getMaxVerticalScreenNumber() - n2;
        }
        if ((this.getScrollability() & 0x40) != 0) {
            n3 += n2 * this.getMaxHorizontalScreenNumber();
        }
        if ((this.getScrollability() & 0x20) != 0 && n2 > 0) {
            n3 = this.getMaxHorizontalScreenNumber() + 1 + n;
        }
        if (!this.isStartScreen(n, n2) || this.getScrollability() == 128) {
            n3 |= 0x80;
        }
        return n3;
    }

    protected int calcPointersSize() {
        return this.calcPointersSize(this.getScrollability(), this.getMaxHorizontalScreenNumber() + 1, this.getMaxVerticalScreenNumber() + 1);
    }

    protected int calcPointersSize(int n, int n2, int n3) {
        return this.calcPointersSize(n, n2, n3, this.getValidScreens());
    }

    private int calcPointersSize(int n, int n2, int n3, boolean[][] blArray) {
        if (n == 128) {
            if (blArray != null) {
                n3 = 0;
                n2 = 1;
                int n4 = 0;
                while (n4 < blArray.length) {
                    int n5 = 0;
                    while (n5 < blArray[n4].length) {
                        if (blArray[n4][n5]) {
                            if (n4 + 1 > n3) {
                                n3 = n4 + 1;
                            }
                            if (n5 + 1 > n2) {
                                n2 = n5 + 1;
                            }
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            return n3 * n2 * 2 * 2 + (n3 + n2 + 1) * 2;
        }
        if (n == 129) {
            return (n2 + n3) * 2 + 4;
        }
        if ((n & 0x40) != 0) {
            return (n2 + 4) * 2 + (n3 + 4) * 2;
        }
        if ((n & 0x20) != 0) {
            return (n2 + 2) * 2 + (n3 + 1) * 2;
        }
        return this.calcScreenCount(n, n2, n3) * 2 + 2;
    }

    private boolean relocateScreenLayout(int n) {
        int n2 = KiddEd.findFreeBlock(this.calcScreenSize(n), this.getBank());
        if (n2 < 0) {
            return false;
        }
        return this.moveScreenLayout(n, n2);
    }

    private boolean moveScreenLayout(int n, int n2) {
        int n3 = this.calcScreenSize(n);
        int n4 = 0;
        while (n4 < n3) {
            if (RomManager.StaticAccess.readByte(n2 + n4) != 255 && (n2 + n4 < this.RESOLVE_ADDRESS(n) || n2 + n4 >= this.RESOLVE_ADDRESS(n) + n3)) {
                System.err.println("moveScreenLayout: " + Integer.toHexString(n2 + n4) + " isn't free: " + Integer.toHexString(RomManager.StaticAccess.readByte(n2 + n4)));
                return false;
            }
            ++n4;
        }
        int[] nArray = RomManager.StaticAccess.readBytes(new int[n3], this.RESOLVE_ADDRESS(n));
        RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(n), this.RESOLVE_ADDRESS(n) + n3, 255);
        RomManager.StaticAccess.writeBytes(nArray, n2);
        int[] nArray2 = this.getScreenPointers();
        int n5 = 0;
        while (n5 < nArray2.length) {
            if (nArray2[n5] >= 0 && this.READ_WORD(nArray2[n5]) == n) {
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(nArray2[n5]), n2 & 0xFF);
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(nArray2[n5] + 1), 0x80 | n2 >> 8 & 0x3F);
            }
            ++n5;
        }
        return true;
    }

    private void setPointers(int[] nArray) {
        this.clearPointers();
        this.writePointers(nArray);
    }

    private void clearPointers() {
        int n;
        int n2;
        int[] nArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[] nArray2 = this.getScreenPointers();
        if (this.getScrollability() == 129) {
            nArray = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray, 1, nArray2.length);
            nArray2 = nArray;
            nArray2[0] = this.READ_WORD(this.getLayoutPointer());
        }
        if (this.bonusLevel != null && !this.isCompressed()) {
            nArray = this.bonusLevel.getScreenPointers();
            int[] nArray3 = nArray2;
            nArray2 = new int[nArray3.length + nArray.length];
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            System.arraycopy(nArray, 0, nArray2, nArray3.length, nArray.length);
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            int n4;
            if (nArray2[n3] >= 0 && (n4 = this.READ_WORD(nArray2[n3])) >= 32768 && n4 < 49152) {
                hashSet.add(n4);
                n2 = n3;
                while (n2 < nArray2.length) {
                    if (nArray2[n2] >= 0 && this.READ_WORD(nArray2[n2]) == n4) {
                        RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(nArray2[n2]), 65535);
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = this.getLayoutPointer();
        while (this.READ_WORD(n3) >= 32768 && this.READ_WORD(n3) < 49152) {
            boolean bl = true;
            n2 = 0;
            while (n2 < nArray2.length - (n3 - this.getLayoutPointer()) / 2) {
                n = this.READ_WORD(n3) + n2 * 2;
                if (hashSet.contains(this.READ_WORD(n))) {
                    RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n), 65535);
                } else if (this.READ_WORD(n) != 65535) {
                    bl = false;
                    if (this.READ_WORD(n) < 32768 || this.READ_WORD(n) >= 49152) break;
                }
                ++n2;
            }
            if (bl) {
                RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n3), 65535);
            }
            n3 += 2;
        }
        n3 = 0;
        int[] nArray4 = nArray2;
        n = nArray2.length;
        n2 = 0;
        while (n2 < n) {
            int n5 = nArray4[n2];
            if (n5 > n3) {
                n3 = n5;
            }
            ++n2;
        }
        RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(this.getLayoutPointer()), this.RESOLVE_ADDRESS(n3 + 2), 255);
    }

    private void writePointers(int[] nArray) {
        this.writePointers(nArray, null);
    }

    private void writePointers(int[] nArray, int[][] nArray2) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.writingPointers) {
                throw new IllegalStateException("writePointers failed because an attempt to write pointers has already been started before.");
            }
            this.writingPointers = true;
            boolean[][] blArray = nArray2 == null ? this.getValidScreens() : null;
            int n9 = nArray2 == null ? this.getMaxHorizontalScreenNumber() + 1 : nArray2[0].length;
            int n10 = n8 = nArray2 == null ? this.getMaxVerticalScreenNumber() + 1 : nArray2.length;
            if ((this.getScrollability() & 4) != 0) {
                n9 = this.getStartHorizontalScreenNumber();
            }
            if (this.getScrollability() == 1) {
                n9 = 1;
            }
            int n11 = this.calcPointersSize(this.getScrollability(), n9, n8, blArray);
            if (this.getLayoutPointer() + n11 > 35554 && this.getLayoutPointer() + n11 <= 35560 && MiracleWorldEditorModel.isBonusLevelCompressed() && !MiracleWorldEditorModel.relocateBonusLevel()) {
                throw new IllegalStateException("writePointers failed because Bonus Level couldn't be relocated");
            }
            if (this.bonusLevel != null) {
                n11 += 2 * this.bonusLevel.calcScreenCount();
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n12 = 0;
            while (n12 < n11) {
                if (this.READ_BYTE(this.getLayoutPointer() + n12) != 255) break;
                RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(this.getLayoutPointer() + n12), 0);
                hashSet.add(this.RESOLVE_ADDRESS(this.getLayoutPointer() + n12));
                ++n12;
            }
            n12 = 65536;
            int[] nArray3 = nArray;
            int n13 = nArray.length;
            int n14 = 0;
            while (n14 < n13) {
                n7 = nArray3[n14];
                if (n7 >= this.getLayoutPointer() && n7 < n12) {
                    n12 = n7;
                }
                if (n7 >= this.getLayoutPointer() && n7 < this.getLayoutPointer() + n11) {
                    n6 = this.calcScreenSize(n7);
                    n5 = KiddEd.findFreeBlock(n6, this.getBank());
                    if (n5 < 0 || !this.moveScreenLayout(n7, n5)) break;
                    n4 = 0;
                    while (n4 < nArray.length) {
                        if (nArray[n4] == n7) {
                            nArray[n4] = 0x8000 | n5 & 0x3FFF;
                        }
                        ++n4;
                    }
                    RomManager.StaticAccess.fill(this.RESOLVE_ADDRESS(n7), this.RESOLVE_ADDRESS(n7) + n6, 0);
                    n4 = 0;
                    while (n4 < n6) {
                        hashSet.add(this.RESOLVE_ADDRESS(n7) + n4);
                        ++n4;
                    }
                }
                ++n14;
            }
            if (n12 < 49152) {
                n7 = n12 - 1;
                while (n7 >= this.getLayoutPointer()) {
                    if (this.READ_BYTE(n7) != 0) break;
                    RomManager.StaticAccess.writeByte(this.RESOLVE_ADDRESS(n7), 255);
                    --n7;
                }
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                n7 = (Integer)iterator.next();
                RomManager.StaticAccess.writeByte(n7, 255);
            }
            n7 = this.READ_BYTE(this.getLayoutPointer());
            int n15 = 0;
            while (n15 < n11) {
                if (this.READ_BYTE(this.getLayoutPointer() + n15) != n7) {
                    n13 = KiddEd.findFreeBlock(n11, this.getBank());
                    if (n13 < 0) break;
                    this.setLayoutPointer(0x8000 | n13 & 0x3FFF);
                    break;
                }
                ++n15;
            }
            n15 = 0;
            while (n15 < n11) {
                if (this.READ_BYTE(this.getLayoutPointer() + n15) != n7) {
                    throw new IllegalStateException("writePointers failed because there was other data in the pointers range.");
                }
                ++n15;
            }
            n15 = this.getLayoutPointer() & 0x3FFF;
            int[] nArray4 = new int[n11];
            int n16 = 0;
            n4 = 0;
            if (this.getScrollability() == 128) {
                int n17;
                int n18;
                n4 = -1;
                if (nArray2 != null) {
                    n8 = nArray2.length;
                    n9 = nArray2[0].length;
                } else {
                    n8 = 0;
                    n9 = 1;
                    if (blArray != null) {
                        n3 = 0;
                        while (n3 < blArray.length) {
                            n2 = 0;
                            while (n2 < blArray[n3].length) {
                                if (blArray[n3][n2]) {
                                    if (n3 + 1 > n8) {
                                        n8 = n3 + 1;
                                    }
                                    if (n2 + 1 > n9) {
                                        n9 = n2 + 1;
                                    }
                                }
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    if (n8 <= 0 || n9 <= 0) {
                        throw new IllegalStateException("Failed to write pointers for castle layout because there are no valid screens.");
                    }
                }
                n6 = n8 * 2;
                n3 = (n9 + n8) * 2;
                n5 = 0x8000 | n6 + n15;
                n2 = -1;
                n = 0;
                while (n < n8) {
                    nArray4[n16++] = n3 + n15 & 0xFF;
                    nArray4[n16++] = 0x80 | (n3 + n15 & 0x3FFF) >> 8;
                    n18 = 0;
                    while (n18 < n9) {
                        if (nArray2 != null && nArray2[n][n18] >= 0) {
                            n4 = nArray2[n][n18];
                        } else if (blArray != null && blArray[n][n18]) {
                            ++n4;
                        }
                        if (n4 >= nArray.length) {
                            n4 = nArray.length - 1;
                        }
                        n17 = nArray[Math.max(n4, 0)];
                        nArray4[n3++] = n17 & 0xFF;
                        nArray4[n3++] = 0x80 | (n17 & 0x3FFF) >> 8;
                        ++n18;
                    }
                    if (n == 0 && this.bonusLevel != null) {
                        n2 = n3;
                        n3 += this.bonusLevel.calcScreenCount() * 2;
                    }
                    ++n;
                }
                n = 0;
                while (n < n9) {
                    nArray4[n6++] = n3 + n15 & 0xFF;
                    nArray4[n6++] = 0x80 | (n3 + n15 & 0x3FFF) >> 8;
                    n18 = 0;
                    while (n18 < n8) {
                        n17 = ((nArray4[n18 * 2] | nArray4[n18 * 2 + 1] << 8) + 2 * n & 0x3FFF) - n15;
                        nArray4[n3++] = nArray4[n17];
                        nArray4[n3++] = 0x80 | nArray4[n17 + 1];
                        ++n18;
                    }
                    ++n;
                }
                n = ((nArray4[0] | nArray4[1] << 8) & 0x3FFF) - n15;
                nArray4[n3++] = nArray4[n];
                nArray4[n3++] = 0x80 | nArray4[n + 1];
                if (n2 >= 0) {
                    n16 = n6;
                    n6 = n2;
                }
            } else if ((this.getScrollability() & 1) != 0) {
                n6 = 2;
                if ((this.getScrollability() & 0x80) != 0) {
                    n6 += 2;
                }
                n5 = 0x8000 | n16 + n15;
                nArray4[n16++] = n6 + n15 & 0xFF;
                nArray4[n16++] = 0x80 | (n6 + n15 & 0x3FFF) >> 8;
                if ((this.getScrollability() & 0x80) != 0) {
                    n3 = 0;
                    while (n3 < n9) {
                        n2 = nArray[n3 > 0 ? n8 + n3 - 1 : n4++];
                        nArray4[n6++] = n2 & 0xFF;
                        nArray4[n6++] = 0x80 | (n2 & 0x3FFF) >> 8;
                        ++n3;
                    }
                    n5 = 0x8000 | n16 + n15;
                    nArray4[n16++] = n6 + n15 & 0xFF;
                    nArray4[n16++] = 0x80 | (n6 + n15 & 0x3FFF) >> 8;
                    nArray4[n6++] = nArray4[4];
                    nArray4[n6++] = nArray4[5];
                }
                n3 = 0;
                while (n3 < n8) {
                    if ((this.getScrollability() & 0x80) == 0 || n3 != 0) {
                        n2 = nArray[n4++];
                        nArray4[n6++] = n2 & 0xFF;
                        nArray4[n6++] = 0x80 | (n2 & 0x3FFF) >> 8;
                    }
                    ++n3;
                }
            } else {
                n6 = n8 * 2;
                if ((this.getScrollability() & 0x40) != 0) {
                    n6 += 8;
                } else if ((this.getScrollability() & 0x20) != 0) {
                    n6 += 2;
                }
                n5 = 0x8000 | n16 + n15;
                n3 = 0;
                while (n3 < n8) {
                    nArray4[n16++] = n6 + n15 & 0xFF;
                    nArray4[n16++] = 0x80 | (n6 + n15 & 0x3FFF) >> 8;
                    if ((this.getScrollability() & 0x40) != 0 && n3 > 0) {
                        n5 = 0x8000 | n16 + n15;
                        nArray4[n16++] = n6 + n15 - 2 & 0xFF;
                        nArray4[n16++] = 0x80 | (n6 + n15 - 2 & 0x3FFF) >> 8;
                        nArray4[n16++] = n6 + n15 & 0xFF;
                        nArray4[n16++] = 0x80 | (n6 + n15 & 0x3FFF) >> 8;
                        nArray4[n16++] = n6 + n15 + 2 & 0xFF;
                        nArray4[n16++] = 0x80 | (n6 + n15 + 2 & 0x3FFF) >> 8;
                        nArray4[n16++] = n6 + n15 + 4 & 0xFF;
                        nArray4[n16++] = 0x80 | (n6 + n15 + 4 & 0x3FFF) >> 8;
                        n9 = 4;
                    } else if ((this.getScrollability() & 0x20) != 0 && n3 > 0) {
                        n5 = 0x8000 | n16 + n15;
                        nArray4[n16++] = n6 + n15 - 2 & 0xFF;
                        nArray4[n16++] = 0x80 | (n6 + n15 - 2 & 0x3FFF) >> 8;
                        n9 = 2;
                    }
                    n2 = 0;
                    while (n2 < n9) {
                        n = nArray[n4++];
                        nArray4[n6++] = n & 0xFF;
                        nArray4[n6++] = 0x80 | (n & 0x3FFF) >> 8;
                        ++n2;
                    }
                    ++n3;
                }
            }
            this.setLayoutPointer2(n5);
            if (this.bonusLevel != null) {
                n3 = (n6 - n16) / 2;
                n2 = 0;
                while (n2 < this.bonusLevel.calcScreenCount() && nArray.length - this.bonusLevel.calcScreenCount() + n2 >= 0) {
                    n = nArray[nArray.length - this.bonusLevel.calcScreenCount() + n2];
                    nArray4[n6++] = n & 0xFF;
                    nArray4[n6++] = 0x80 | (n & 0x3FFF) >> 8;
                    ++n2;
                }
                this.bonusLevel.setMaxHorizontalScreenNumber(n3 + this.bonusLevel.calcScreenCount() - 1);
                this.bonusLevel.setStartHorizontalScreenNumber(n3 + 1);
                this.bonusLevel.setLayoutPointer(this.getLayoutPointer());
                MiracleWorldEditorModel.fixBonusLevelEntities();
            }
            n3 = 0;
            while (n3 * 2 < nArray4.length && (nArray4[n3 * 2] != 0 || nArray4[n3 * 2 + 1] != 0)) {
                ++n3;
            }
            RomManager.StaticAccess.copyToROM(nArray4, 0, this.RESOLVE_ADDRESS(this.getLayoutPointer()), n3 * 2);
        }
        finally {
            this.writingPointers = false;
            this.updateValidScreens();
        }
    }

    public int calcRequiredSize() {
        return this.calcDecompressedSize() + this.calcEntityDataSize() + MiracleWorldMetaTileset.getSize();
    }

    private int calcDecompressedSize() {
        int n = this.calcScreenCount() * 195 + this.calcPointersSize();
        if (this.bonusLevel != null) {
            n += this.bonusLevel.calcScreenCount() * 197;
        }
        return n;
    }

    private int calcEntityDataSize() {
        int n = this.getNumberOfEntityScreens();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                n2 += Math.max(1, Level.calcEntityScreenSize(this.resolveEntityScreenAddress(n3))) + 2;
            }
            catch (Exception exception) {
                n2 += 3;
            }
            ++n3;
        }
        return n2;
    }

    protected int getScreenPointer(int n, int n2) {
        int n3;
        if (this.getScrollability() == 129 && n > 0) {
            n2 = 0;
        }
        if ((this.getScrollability() & 1) != 0 && (n2 != 0 || n == 0)) {
            n3 = this.getLayoutPointer2();
            if (n3 < 32768 || n3 >= 49152) {
                return -1;
            }
            n3 += n * 2;
            if ((n3 = this.READ_WORD(n3)) < 32768 || n3 >= 49152) {
                return -1;
            }
            n3 += n2 * 2;
        } else {
            n3 = this.getLayoutPointer();
            if (n3 < 32768 || n3 >= 49152) {
                return -1;
            }
            n3 += n2 * 2;
            if ((n3 = this.READ_WORD(n3)) < 32768 || n3 >= 49152) {
                return -1;
            }
            n3 += n * 2;
        }
        return n3;
    }

    protected int getScreenAddress(int n, int n2) {
        return this.READ_WORD(this.getScreenPointer(n, n2));
    }

    private void setScreenAddress(int n, int n2, int n3) {
        if (this.getScrollability() == 128) {
            int n4 = this.getLayoutPointer2();
            if (n4 < 32768 || n4 >= 49152) {
                return;
            }
            n4 += n * 2;
            if ((n4 = this.READ_WORD(n4)) < 32768 || n4 >= 49152) {
                return;
            }
            RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n4 += n2 * 2), n3);
            n4 = this.getLayoutPointer();
            if (n4 < 32768 || n4 >= 49152) {
                return;
            }
            n4 += n2 * 2;
            if ((n4 = this.READ_WORD(n4)) < 32768 || n4 >= 49152) {
                return;
            }
            RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(n4 += n * 2), n3);
        } else {
            RomManager.StaticAccess.writeWord(this.RESOLVE_ADDRESS(this.getScreenPointer(n, n2)), n3);
        }
    }

    private int countScreenReferences(int n) {
        int[] nArray = this.getScreenAddresses();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                ++n2;
            }
            ++n3;
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid screen address!: " + Integer.toHexString(n).toUpperCase());
        }
        return n2;
    }

    protected int[] getScreenAddresses() {
        int[] nArray = this.getScreenPointers();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.READ_WORD(nArray[n]);
            ++n;
        }
        return nArray;
    }

    protected int[] getScreenPointers() {
        int[] nArray = new int[this.calcScreenCount()];
        int n = this.getMaxHorizontalScreenNumber() + 1;
        int n2 = this.getMaxVerticalScreenNumber() + 1;
        if ((this.getScrollability() & 4) != 0) {
            n = this.getStartHorizontalScreenNumber();
        }
        if (this.getScrollability() == 1) {
            n = 0;
        }
        int n3 = 0;
        if (this.getScrollability() == 128) {
            int n4 = 0;
            while (n4 < this.getValidScreens().length) {
                int n5 = 0;
                while (n5 < this.getValidScreens()[n4].length) {
                    if (this.isValidScreen(n5, n4)) {
                        nArray[n3++] = this.getScreenPointer(n5, n4);
                    }
                    ++n5;
                }
                ++n4;
            }
        } else if ((this.getScrollability() & 1) != 0) {
            int n6 = 0;
            while (n6 < n2) {
                nArray[n3++] = this.getScreenPointer(0, n6);
                ++n6;
            }
            n6 = 1;
            while (n6 < n) {
                nArray[n3++] = this.getScreenPointer(n6, 0);
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n2) {
                if ((this.getScrollability() & 0x40) != 0 && n7 > 0) {
                    n = 4;
                } else if ((this.getScrollability() & 0x20) != 0 && n7 > 0) {
                    n = 2;
                }
                int n8 = 0;
                while (n8 < n) {
                    nArray[n3++] = this.getScreenPointer(n8, n7);
                    ++n8;
                }
                ++n7;
            }
        }
        return nArray;
    }

    public int calcScreenCount() {
        return this.calcScreenCount(this.getScrollability(), this.getMaxHorizontalScreenNumber() + 1, this.getMaxVerticalScreenNumber() + 1);
    }

    protected int calcScreenCount(int n, int n2, int n3) {
        if ((n & 4) != 0) {
            n2 = this.getStartHorizontalScreenNumber();
        }
        if (n == 128) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.getValidScreens().length) {
                int n6 = 0;
                while (n6 < this.getValidScreens()[n5].length) {
                    if (this.isValidScreen(n6, n5)) {
                        ++n4;
                    }
                    ++n6;
                }
                ++n5;
            }
            return n4;
        }
        if (n == 129) {
            return n2 + n3 - 1;
        }
        if ((n & 1) != 0) {
            return n3;
        }
        if ((n & 0x40) != 0) {
            return n2 + 4;
        }
        if ((n & 0x20) != 0) {
            return n2 + 2;
        }
        return n2 * n3;
    }

    public void setBonusLevel(BonusLevel bonusLevel) {
        this.bonusLevel = bonusLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        if (this.isMoving()) return true;
        if (this.isMovingEntityData()) {
            return true;
        }
        try {
            int n;
            int[] nArray = this.getScreenAddresses();
            int[] nArray2 = this.getEntityScreenAddresses();
            if (nArray2.length < nArray.length) {
                throw new IllegalArgumentException("The number of entity screens (" + nArray2.length + ") is less than the number of screens (" + nArray.length + ").");
            }
            int[] nArray3 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                n = nArray3[n3];
                if (n < 32768) {
                    throw new IllegalArgumentException("Screen Address must be greater or equal to $8000: $" + Integer.toHexString(n));
                }
                if (n >= 49152) {
                    throw new IllegalArgumentException("Screen Address must not be located in RAM. $" + Integer.toHexString(n));
                }
                int n4 = this.RESOLVE_ADDRESS(n);
                int n5 = 0;
                while (RomManager.StaticAccess.readByte(n4) > 0) {
                    int n6 = RomManager.StaticAccess.readByte(n4) & 0x7F;
                    n4 = (RomManager.StaticAccess.readByte(n4) & 0x80) != 0 ? (n4 += n6) : ++n4;
                    ++n4;
                    if ((n5 += n6) <= 192) continue;
                    if (!(this instanceof BonusLevel)) throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + Integer.toHexString(n) + " of level " + this.level + ".");
                    throw new ArrayIndexOutOfBoundsException("The layout is too long in screen " + Integer.toHexString(n) + " of the bonuslevel.");
                }
                if (n5 == 0) {
                    if (!(this instanceof BonusLevel)) throw new ArrayIndexOutOfBoundsException("The layout is empty in screen " + Integer.toHexString(n) + " of level " + this.level + ".");
                    throw new ArrayIndexOutOfBoundsException("The layout is empty in screen " + Integer.toHexString(n) + " of the bonuslevel.");
                }
                ++n3;
            }
            if (this.getScrollability() == 128) {
                this.updateValidScreens();
                n = 1;
                boolean[][] blArray = this.getValidScreens();
                n2 = 0;
                while (n2 < blArray.length && n != 0) {
                    int n7 = 0;
                    while (n7 < blArray[n2].length && n != 0) {
                        if (blArray[n2][n7]) {
                            n = 0;
                        }
                        ++n7;
                    }
                    ++n2;
                }
                if (n != 0) {
                    return false;
                }
            }
            nArray3 = nArray2;
            n2 = nArray2.length;
            int n8 = 0;
            while (n8 < n2) {
                n = nArray3[n8];
                if (Level.calcEntityScreenSize(n) <= 0) {
                    return false;
                }
                ++n8;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isCompressed() {
        if (this.getBank() != 6 || this.isMoving()) {
            return false;
        }
        int n = this.getStartHorizontalScreenNumber() - 1;
        int n2 = this.getStartVerticalScreenNumber();
        if (this.getScrollability() == 129) {
            --n2;
        }
        return this.getScreenSize(n, n2) < 195;
    }

    protected int[][] decompressLayout() {
        int n = this.getMaxHorizontalScreenNumber() + 1;
        int n2 = this.getMaxVerticalScreenNumber() + 1;
        if ((this.getScrollability() & 4) != 0) {
            n = this.getStartHorizontalScreenNumber();
        }
        if (this.getScrollability() == 1) {
            n = 1;
        }
        int n3 = this.calcScreenCount(this.getScrollability(), n, n2);
        int n4 = n3 * 195;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n3];
        int n5 = 0;
        int n6 = 0;
        if (this.getScrollability() == 128) {
            int n7;
            n2 = 0;
            n = 1;
            int n8 = 0;
            while (n8 < this.getValidScreens().length) {
                n7 = n - 1;
                while (n7 < this.getValidScreens()[n8].length) {
                    if (this.isValidScreen(n7, n8)) {
                        if (n8 + 1 > n2) {
                            n2 = n8 + 1;
                        }
                        if (n7 + 1 > n) {
                            n = n7 + 1;
                        }
                    }
                    ++n7;
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < n2) {
                n7 = 0;
                while (n7 < n) {
                    if (this.isValidScreen(n7, n8)) {
                        nArray2[n6++] = 0x8000 | n5 & 0x3FFF;
                        int[] nArray3 = this.getLayout(n7, n8);
                        nArray[n5++] = 254;
                        System.arraycopy(nArray3, 0, nArray, n5, 126);
                        n5 += 126;
                        nArray[n5++] = 0x80 | nArray3.length - 126;
                        System.arraycopy(nArray3, 126, nArray, n5, nArray3.length - 126);
                        n5 += nArray3.length - 126;
                        nArray[n5++] = 0;
                    }
                    ++n7;
                }
                ++n8;
            }
        } else if ((this.getScrollability() & 1) != 0) {
            int[] nArray4;
            int n9;
            if ((this.getScrollability() & 0x80) != 0) {
                n9 = 0;
                while (n9 < n) {
                    nArray2[n9 > 0 ? n2 + n9 - 1 : n6++] = 0x8000 | n5 & 0x3FFF;
                    nArray4 = this.getLayout(n9, 0);
                    nArray[n5++] = 254;
                    System.arraycopy(nArray4, 0, nArray, n5, 126);
                    n5 += 126;
                    nArray[n5++] = 0x80 | nArray4.length - 126;
                    System.arraycopy(nArray4, 126, nArray, n5, nArray4.length - 126);
                    n5 += nArray4.length - 126;
                    nArray[n5++] = 0;
                    ++n9;
                }
            }
            n9 = 0;
            while (n9 < n2) {
                if ((this.getScrollability() & 0x80) == 0 || n9 != 0) {
                    nArray2[n6++] = 0x8000 | n5 & 0x3FFF;
                    nArray4 = this.getLayout(0, n9);
                    nArray[n5++] = 254;
                    System.arraycopy(nArray4, 0, nArray, n5, 126);
                    n5 += 126;
                    nArray[n5++] = 0x80 | nArray4.length - 126;
                    System.arraycopy(nArray4, 126, nArray, n5, nArray4.length - 126);
                    n5 += nArray4.length - 126;
                    nArray[n5++] = 0;
                }
                ++n9;
            }
        } else {
            int n10 = 0;
            while (n10 < n2) {
                if ((this.getScrollability() & 0x40) != 0 && n10 > 0) {
                    n = 4;
                } else if ((this.getScrollability() & 0x20) != 0 && n10 > 0) {
                    n = 2;
                }
                int n11 = 0;
                while (n11 < n) {
                    nArray2[n6++] = 0x8000 | n5 & 0x3FFF;
                    int[] nArray5 = this.getLayout(n11, n10);
                    nArray[n5++] = 254;
                    System.arraycopy(nArray5, 0, nArray, n5, 126);
                    n5 += 126;
                    nArray[n5++] = 0x80 | nArray5.length - 126;
                    System.arraycopy(nArray5, 126, nArray, n5, nArray5.length - 126);
                    n5 += nArray5.length - 126;
                    nArray[n5++] = 0;
                    ++n11;
                }
                ++n10;
            }
        }
        return new int[][]{nArray, nArray2};
    }

    public boolean isEntitiesLevelBank() {
        return this.getEntitiesBank() == this.getBank();
    }

    protected int getEntitiesBank() {
        if (!MiracleWorldDataModel.hasEntitiesInLevelBank()) {
            this.entitiesBank = 2;
        } else if (this.entitiesBank != this.getBank()) {
            try {
                this.getSAT(this.getStartHorizontalScreenNumber() - 1, this.getScrollability() == 129 ? this.getStartVerticalScreenNumber() - 1 : this.getStartVerticalScreenNumber());
            }
            catch (Exception exception) {}
        }
        return this.entitiesBank;
    }

    protected int getAddress() {
        return RomManager.StaticAccess.readWord(26326 + this.level * 2);
    }

    public int getBankAddress() {
        return this.getAddress();
    }

    public int getBank() {
        return RomManager.StaticAccess.readByte(this.getBankAddress()) & 0x7F;
    }

    public int getLayoutPointer() {
        return RomManager.StaticAccess.readWord(this.getAddress() + 1);
    }

    public int getLayoutPointer2() {
        return RomManager.StaticAccess.readWord(this.getAddress() + 3);
    }

    public int getStartHorizontalScreenNumber() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 5);
    }

    public int getStartVerticalScreenNumber() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 6);
    }

    public int getMaxHorizontalScreenNumber() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 7);
    }

    public int getMaxVerticalScreenNumber() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 8);
    }

    public int getScrollability() {
        return RomManager.StaticAccess.readByte(this.getAddress() + 9);
    }

    public int getMetaTilesetPointerAddress() {
        return this.getAddress() + 10;
    }

    public int getMetaTilesetPointer() {
        return RomManager.StaticAccess.readWord(this.getMetaTilesetPointerAddress());
    }

    public int getShopEntranceHpos() {
        return RomManager.StaticAccess.readByte(3440 + this.level * 3);
    }

    public int getShopEntranceNameTablePos() {
        return RomManager.StaticAccess.readWord(3440 + this.level * 3 + 1) - 51200;
    }

    public int getUpdateColorsCodeAddress() {
        return RomManager.StaticAccess.readWord(3372 + this.level * 2);
    }

    public int getUpdateLevelTilesCodeAddress() {
        return RomManager.StaticAccess.readWord(5485 + this.level * 2);
    }

    public int getShopDataAddress() {
        return RomManager.StaticAccess.readWord(8107 + this.level * 2);
    }

    public int getSoundControlValue() {
        return RomManager.StaticAccess.readByte(3525 + this.level);
    }

    private final int getAddressUpdateLevelEntities() {
        return RomManager.getInstance().READ_WORD(3406 + this.level * 2, 2);
    }

    protected int getAddressStartVehicle() {
        return 3615 + this.level;
    }

    protected int getAddressStartPositionHpos() {
        return 3491 + this.level * 2;
    }

    protected int getAddressStartPositionVpos() {
        return 3491 + this.level * 2 + 1;
    }

    private final int getEntityDataAddress() {
        return RomManager.getInstance().READ_WORD(46341 + this.level * 2, 2);
    }

    private void setEntityDataAddress(int n) {
        RomManager.StaticAccess.writeWord(46341 + this.level * 2, n);
    }

    public void setShopEntrancePos(int n, int n2) {
        if (n2 >= 24) {
            int n3 = 3440 + this.level * 3;
            int n4 = 51200 + n / 8 * 64 + (n2 / 8 - 2) * 2;
            if (RomManager.StaticAccess.readByte(n3) != (n2 & 0xF8) || RomManager.StaticAccess.readByte(n3 + 1) != (n4 & 0xFF) || RomManager.StaticAccess.readByte(n3 + 2) != n4 >> 8) {
                RomManager.StaticAccess.writeByte(n3, n2 & 0xF8);
                RomManager.StaticAccess.writeByte(n3 + 1, n4 & 0xFF);
                RomManager.StaticAccess.writeByte(n3 + 2, n4 >> 8);
            }
        }
    }

    public void setJarEntrancePos(int n, int n2) {
        int n3 = 3440 + this.level * 3;
        int n4 = 51200 + n / 8 * 64 + n2 / 8 * 2;
        if (RomManager.StaticAccess.readByte(n3) != (n2 & 0xFF) || RomManager.StaticAccess.readByte(n3 + 1) != (n4 & 0xFF) || RomManager.StaticAccess.readByte(n3 + 2) != n4 >> 8) {
            RomManager.StaticAccess.writeByte(n3, n2 & 0xFF);
            RomManager.StaticAccess.writeByte(n3 + 1, n4 & 0xFF);
            RomManager.StaticAccess.writeByte(n3 + 2, n4 >> 8);
        }
    }

    public void setUpdateColorsCodeAddress(int n) {
        int n2 = 3372 + this.level * 2;
        if (RomManager.StaticAccess.readByte(n2) != (n & 0xFF) || RomManager.StaticAccess.readByte(n2 + 1) != n >> 8) {
            TransactionManager.getInstance().addTransactionObject(this, -5);
            RomManager.StaticAccess.writeByte(n2, n & 0xFF);
            RomManager.StaticAccess.writeByte(n2 + 1, n >> 8);
        }
    }

    public void setUpdateLevelTilesCodeAddress(int n) {
        int n2 = 5485 + this.level * 2;
        if (RomManager.StaticAccess.readByte(n2) != (n & 0xFF) || RomManager.StaticAccess.readByte(n2 + 1) != n >> 8) {
            TransactionManager.getInstance().addTransactionObject(this, -4);
            RomManager.StaticAccess.writeByte(n2, n & 0xFF);
            RomManager.StaticAccess.writeByte(n2 + 1, n >> 8);
        }
    }

    public void setShopDataAddresses(int n, int n2) {
        int n3 = 8107 + this.level * 2;
        if (RomManager.StaticAccess.readByte(n3) != (n & 0xFF) || RomManager.StaticAccess.readByte(n3 + 1) != n >> 8 || RomManager.StaticAccess.readByte(n3 - 34) != (n2 & 0xFF) || RomManager.StaticAccess.readByte(n3 - 34 + 1) != n2 >> 8) {
            TransactionManager.getInstance().addTransactionObject(this, -5);
            RomManager.StaticAccess.writeByte(n3, n & 0xFF);
            RomManager.StaticAccess.writeByte(n3 + 1, n >> 8);
            RomManager.StaticAccess.writeByte(n3 - 34, n2 & 0xFF);
            RomManager.StaticAccess.writeByte(n3 - 34 + 1, n2 >> 8);
        }
    }

    public void setSoundControlValue(int n) {
        if (RomManager.StaticAccess.readByte(3525 + this.level) != (0x80 | n)) {
            TransactionManager.getInstance().addTransactionObject(this, -5);
            RomManager.StaticAccess.writeByte(3525 + this.level, 0x80 | n);
        }
    }

    protected void setBank(int n) {
        RomManager.StaticAccess.writeByte(this.getBankAddress(), 0x80 | n);
    }

    protected void setLayoutPointer(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 1, n & 0xFF);
        RomManager.StaticAccess.writeByte(this.getAddress() + 2, n >> 8);
    }

    protected void setLayoutPointer2(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 3, n & 0xFF);
        RomManager.StaticAccess.writeByte(this.getAddress() + 4, n >> 8);
    }

    protected void setStartHorizontalScreenNumber(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 5, n);
    }

    protected void setStartVerticalScreenNumber(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 6, n);
    }

    protected void setMaxHorizontalScreenNumber(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 7, n);
    }

    protected void setMaxVerticalScreenNumber(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 8, n);
    }

    protected void setScrollability(int n) {
        RomManager.StaticAccess.writeByte(this.getAddress() + 9, n);
    }

    protected final int RESOLVE_ADDRESS(int n) {
        return RomManager.RESOLVE_ADDRESS(n, this.getBank());
    }

    private final int READ_BYTE(int n) {
        return RomManager.getInstance().READ_BYTE(n, this.getBank());
    }

    protected final int READ_WORD(int n) {
        return RomManager.getInstance().READ_WORD(n, this.getBank());
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeLevel");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        if (change.getData(this) == -3) {
            this.updateValidScreens();
        }
        for (ChangeListener changeListener : new LinkedList<ChangeListener>(this.listeners)) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return "Address: " + Integer.toHexString(this.getAddress()).toUpperCase() + "\n" + "Bank: " + Integer.toHexString(this.getBank()).toUpperCase() + "\n" + "Layout Pointer: " + Integer.toHexString(this.getLayoutPointer()).toUpperCase() + " (" + Integer.toHexString(this.RESOLVE_ADDRESS(this.getLayoutPointer())) + ")\n" + "Layout Pointer2: " + Integer.toHexString(this.getLayoutPointer2()).toUpperCase() + " (" + Integer.toHexString(this.RESOLVE_ADDRESS(this.getLayoutPointer2())) + ")\n" + "Start Horizontal Screen Number: " + this.getStartHorizontalScreenNumber() + "\n" + "Start Vertical Screen Number: " + this.getStartVerticalScreenNumber() + "\n" + "Max Horizontal Screen Number: " + this.getMaxHorizontalScreenNumber() + "\n" + "Max Vertical Screen Number: " + this.getMaxVerticalScreenNumber() + "\n" + "Scrollability: " + Integer.toHexString(this.getScrollability()).toUpperCase() + "\n" + "Metatiles: " + Integer.toHexString(this.getMetaTilesetPointer()).toUpperCase() + "\n" + "Compressed?: " + this.isCompressed() + "\n" + "Valid?: " + this.isValid();
    }
}

