/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.NameTable;
import editor.Z80Factory;
import mastersystem.OutputListener;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class CompressedNameTable
extends NameTable {
    private final NameTableDecompressor decompressor;
    private final int[] vram = new int[16384];

    public CompressedNameTable(int n, int n2, NameTableDecompressor nameTableDecompressor) {
        super(n, n2);
        this.decompressor = nameTableDecompressor;
    }

    private void decompress() {
        if (this.decompressor != null && this.isCompressed()) {
            this.decompressor.decompress(this);
        }
    }

    public boolean isCompressed() {
        int n = this.getSource();
        int n2 = 0;
        while (n2 < this.getLength() && (RomManager.StaticAccess.readByte(n) & 0x80) != 0) {
            int n3 = RomManager.StaticAccess.readByte(n) & 0x7F;
            n2 += n3 * 2;
            n += n3 + 1;
        }
        return n2 != this.getLength();
    }

    @Override
    public boolean isValid() {
        int n;
        int n2 = this.getSource();
        int n3 = 0;
        while (RomManager.StaticAccess.readByte(n2) > 0) {
            n = RomManager.StaticAccess.readByte(n2) & 0x7F;
            n3 += n;
            n2 = (RomManager.StaticAccess.readByte(n2) & 0x80) != 0 ? (n2 += n) : ++n2;
            if ((++n2 & 0xFFFFC000) == (this.getSource() & 0xFFFFC000)) continue;
            return false;
        }
        ++n2;
        n = n3;
        n3 = 0;
        while (n3 <= n && n2 < RomManager.StaticAccess.getRomLength() && RomManager.StaticAccess.readByte(n2) > 0) {
            int n4 = RomManager.StaticAccess.readByte(n2) & 0x7F;
            n3 += n4;
            n2 = (RomManager.StaticAccess.readByte(n2) & 0x80) != 0 ? (n2 += n4) : ++n2;
            if ((++n2 & 0xFFFFC000) == (this.getSource() & 0xFFFFC000)) continue;
            return false;
        }
        if (n3 != n) {
            return false;
        }
        return n3 > 0 && n3 <= 16384;
    }

    private int getTileAddress(int n) {
        return this.getSource() + n + n / 127 + 1;
    }

    private int getFlagsAddress(int n) {
        return this.getTileAddress(n) + this.getLength() / 2 + (this.getLength() / 2 / 127 + (this.getLength() / 2 % 127 > 0 ? 1 : 0) + 1);
    }

    @Override
    public int[] getTile(int n) {
        return new int[]{this.vram[this.getDestination() + n * 2], this.vram[this.getDestination() + n * 2 + 1]};
    }

    @Override
    public void setTile(int n, int n2) {
        if (((this.vram[this.getDestination() + n * 2 + 1] & 1) << 8 | this.vram[this.getDestination() + n * 2]) != n2 && n2 >= 0 && n2 < 256) {
            this.decompress();
            if (this.isCompressed()) {
                return;
            }
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getTileAddress(n), n2 & 0xFF);
            this.writeByte(this.getFlagsAddress(n), this.vram[this.getDestination() + n * 2 + 1] & 0xFFFFFFFE | n2 >> 8 & 1);
        }
    }

    @Override
    public void setTiles(int[][] nArray) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, 0);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                this.writeByte(this.getTileAddress(n * this.getWidth() + n2), nArray[n][n2] & 0xFF);
                this.writeByte(this.getFlagsAddress(n * this.getWidth() + n2), RomManager.StaticAccess.readByte(this.getFlagsAddress(n * this.getWidth() + n2)) & 0xE0 | nArray[n][n2] >> 8);
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void setFlags(int n, int n2) {
        if ((this.vram[this.getDestination() + n * 2 + 1] & 0xE0) != n2) {
            this.decompress();
            if (this.isCompressed()) {
                return;
            }
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFF1F | n2);
        }
    }

    @Override
    public void setPalette(int n, int n2) {
        if ((this.vram[this.getDestination() + n * 2 + 1] & 8) != n2 * 8) {
            this.decompress();
            if (this.isCompressed()) {
                return;
            }
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFFF7 | n2 * 8);
        }
    }

    @Override
    public void setPriority(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 16;
        }
        if ((this.vram[this.getDestination() + n * 2 + 1] & 0x10) != n2) {
            this.decompress();
            if (this.isCompressed()) {
                return;
            }
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.writeByte(this.getFlagsAddress(n), RomManager.StaticAccess.readByte(this.getFlagsAddress(n)) & 0xFFFFFFEF | n2);
        }
    }

    @Override
    public void flipH(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, n);
        RomManager.StaticAccess.flipBitInByte(this.getFlagsAddress(n), 1);
    }

    @Override
    public void flipV(int n) {
        this.decompress();
        if (this.isCompressed()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, n);
        RomManager.StaticAccess.flipBitInByte(this.getFlagsAddress(n), 2);
    }

    @Override
    public int[] getVRAM() {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray, this.getBank());
        Z80 z80 = Z80Factory.create(nArray);
        final int[] nArray2 = this.vram;
        int n = this.getSource();
        if (n >= 32768) {
            n = 0x8000 | n & 0x3FFF;
        }
        z80.setHL(n);
        z80.setDE(51200);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n >= 51200 && n < 51200 + CompressedNameTable.this.getLength()) {
                    nArray2[n - 36864] = n2;
                }
            }
        });
        z80.execute(this.addressLoadNameTable);
        this.end = (this.getSource() & 0xFC000 | z80.getHL() & 0x3FFF) - 1;
        return nArray2;
    }

    @Override
    public int getDestination() {
        return 14336;
    }

    @Override
    public int getWidth() {
        return 32;
    }

    @Override
    public int getHeight() {
        return this.getLength() / 2 / this.getWidth();
    }

    @Override
    public int getLength() {
        int n = 0;
        int n2 = this.getSource();
        while (RomManager.StaticAccess.readByte(n2) > 0) {
            int n3 = RomManager.StaticAccess.readByte(n2) & 0x7F;
            n += n3;
            n2 = (RomManager.StaticAccess.readByte(n2) & 0x80) != 0 ? (n2 += n3) : ++n2;
            if ((++n2 & 0xFFFFC000) == (this.getSource() & 0xFFFFC000)) continue;
            return 0;
        }
        return n * 2;
    }

    @Override
    public int getSize() {
        return super.getSize() + 2 * (this.getLength() / 2 / 127 + (this.getLength() / 2 % 127 > 0 ? 1 : 0) + 1);
    }

    @Override
    public void moveTo(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "#" + super.toString();
    }

    public static interface NameTableDecompressor {
        public void decompress(CompressedNameTable var1);
    }
}

