/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import sun.security.ssl.ProtocolVersion;

final class ProtocolList {
    private final ArrayList<ProtocolVersion> protocols;
    private String[] protocolNames;
    final ProtocolVersion min;
    final ProtocolVersion max;
    final ProtocolVersion helloVersion;

    ProtocolList(String[] stringArray) {
        this(ProtocolList.convert(stringArray));
    }

    ProtocolList(ArrayList<ProtocolVersion> arrayList) {
        this.protocols = arrayList;
        if (this.protocols.size() == 1 && this.protocols.contains(ProtocolVersion.SSL20Hello)) {
            throw new IllegalArgumentException("SSLv2Hello cannot be enabled unless at least one other supported version is also enabled.");
        }
        if (this.protocols.size() != 0) {
            Collections.sort(this.protocols);
            this.min = this.protocols.get(0);
            this.max = this.protocols.get(this.protocols.size() - 1);
            this.helloVersion = this.protocols.get(0);
        } else {
            this.min = ProtocolVersion.NONE;
            this.max = ProtocolVersion.NONE;
            this.helloVersion = ProtocolVersion.NONE;
        }
    }

    private static ArrayList<ProtocolVersion> convert(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Protocols may not be null");
        }
        ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(stringArray[i]);
            if (arrayList.contains(protocolVersion)) continue;
            arrayList.add(protocolVersion);
        }
        return arrayList;
    }

    boolean contains(ProtocolVersion protocolVersion) {
        if (protocolVersion == ProtocolVersion.SSL20Hello) {
            return false;
        }
        return this.protocols.contains(protocolVersion);
    }

    Collection<ProtocolVersion> collection() {
        return this.protocols;
    }

    ProtocolVersion selectProtocolVersion(ProtocolVersion protocolVersion) {
        ProtocolVersion protocolVersion2 = null;
        for (ProtocolVersion protocolVersion3 : this.protocols) {
            if (protocolVersion3.v > protocolVersion.v) break;
            protocolVersion2 = protocolVersion3;
        }
        return protocolVersion2;
    }

    synchronized String[] toStringArray() {
        if (this.protocolNames == null) {
            this.protocolNames = new String[this.protocols.size()];
            int n = 0;
            for (ProtocolVersion protocolVersion : this.protocols) {
                this.protocolNames[n++] = protocolVersion.name;
            }
        }
        return (String[])this.protocolNames.clone();
    }

    public String toString() {
        return this.protocols.toString();
    }
}

