/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.SocketChannelImpl;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile int timeout = 0;
    private InputStream socketInputStream = null;

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) throws SocketException {
        super((SocketImpl)null);
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        try {
            return new SocketAdaptor(socketChannelImpl);
        }
        catch (SocketException socketException) {
            throw new InternalError("Should not reach here");
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.sc;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            block19: {
                if (!this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    if (n == 0) {
                        this.sc.connect(socketAddress);
                        return;
                    }
                    this.sc.configureBlocking(false);
                    try {
                        long l;
                        if (this.sc.connect(socketAddress)) {
                            return;
                        }
                        long l2 = n;
                        do {
                            if (!this.sc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            l = System.currentTimeMillis();
                            int n2 = this.sc.poll(Net.POLLCONN, l2);
                            if (n2 <= 0 || !this.sc.finishConnect()) continue;
                            break block19;
                        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                        try {
                            this.sc.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    finally {
                        if (this.sc.isOpen()) {
                            this.sc.configureBlocking(true);
                        }
                    }
                }
                catch (Exception exception) {
                    Net.translateException(exception, true);
                }
            }
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        SocketAddress socketAddress = this.sc.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.sc.isOpen() && (inetSocketAddress = this.sc.localAddress()) != null) {
            return Net.getRevealedLocalAddress(inetSocketAddress).getAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    @Override
    public int getPort() {
        SocketAddress socketAddress = this.sc.remoteAddress();
        if (socketAddress == null) {
            return 0;
        }
        return ((InetSocketAddress)socketAddress).getPort();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.sc.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.sc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.sc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.TCP_NODELAY, bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.TCP_NODELAY);
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (!bl) {
            n = -1;
        }
        this.setIntOption(StandardSocketOptions.SO_LINGER, n);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_LINGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUrgentData(int n) throws IOException {
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            int n2 = this.sc.sendOutOfBandData((byte)n);
            assert (n2 == 1);
        }
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        this.setBooleanOption(ExtendedSocketOption.SO_OOBINLINE, bl);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.getBooleanOption(ExtendedSocketOption.SO_OOBINLINE);
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_KEEPALIVE, bl);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_KEEPALIVE);
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.sc.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.sc.localAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    private class SocketInputStream
    extends ChannelInputStream {
        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = SocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!SocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (SocketAdaptor.this.timeout == 0) {
                    return SocketAdaptor.this.sc.read(byteBuffer);
                }
                SocketAdaptor.this.sc.configureBlocking(false);
                try {
                    long l;
                    int n = SocketAdaptor.this.sc.read(byteBuffer);
                    if (n != 0) {
                        int n2 = n;
                        return n2;
                    }
                    long l2 = SocketAdaptor.this.timeout;
                    do {
                        if (!SocketAdaptor.this.sc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n3 = SocketAdaptor.this.sc.poll(Net.POLLIN, l2);
                        if (n3 <= 0 || (n = SocketAdaptor.this.sc.read(byteBuffer)) == 0) continue;
                        int n4 = n;
                        return n4;
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (SocketAdaptor.this.sc.isOpen()) {
                        SocketAdaptor.this.sc.configureBlocking(true);
                    }
                }
            }
        }
    }
}

