/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.NestedPolicy;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.CompactModelGenerator;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.NormalizedModelGenerator;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import java.util.Iterator;

public abstract class PolicyModelGenerator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyModelGenerator.class);

    protected PolicyModelGenerator() {
    }

    public static PolicyModelGenerator getGenerator() {
        return PolicyModelGenerator.getNormalizedGenerator(new PolicySourceModelCreator());
    }

    protected static PolicyModelGenerator getCompactGenerator(PolicySourceModelCreator policySourceModelCreator) {
        return new CompactModelGenerator(policySourceModelCreator);
    }

    protected static PolicyModelGenerator getNormalizedGenerator(PolicySourceModelCreator policySourceModelCreator) {
        return new NormalizedModelGenerator(policySourceModelCreator);
    }

    public abstract PolicySourceModel translate(Policy var1) throws PolicyException;

    protected abstract ModelNode translate(ModelNode var1, NestedPolicy var2);

    protected void translate(ModelNode modelNode, AssertionSet assertionSet) {
        for (PolicyAssertion policyAssertion : assertionSet) {
            AssertionData assertionData = AssertionData.createAssertionData(policyAssertion.getName(), policyAssertion.getValue(), policyAssertion.getAttributes(), policyAssertion.isOptional(), policyAssertion.isIgnorable());
            ModelNode modelNode2 = modelNode.createChildAssertionNode(assertionData);
            if (policyAssertion.hasNestedPolicy()) {
                this.translate(modelNode2, policyAssertion.getNestedPolicy());
            }
            if (!policyAssertion.hasParameters()) continue;
            this.translate(modelNode2, policyAssertion.getParametersIterator());
        }
    }

    protected void translate(ModelNode modelNode, Iterator<PolicyAssertion> iterator) {
        while (iterator.hasNext()) {
            PolicyAssertion policyAssertion = iterator.next();
            AssertionData assertionData = AssertionData.createAssertionParameterData(policyAssertion.getName(), policyAssertion.getValue(), policyAssertion.getAttributes());
            ModelNode modelNode2 = modelNode.createChildAssertionParameterNode(assertionData);
            if (policyAssertion.hasNestedPolicy()) {
                throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0005_UNEXPECTED_POLICY_ELEMENT_FOUND_IN_ASSERTION_PARAM(policyAssertion)));
            }
            if (!policyAssertion.hasNestedAssertions()) continue;
            this.translate(modelNode2, policyAssertion.getNestedAssertionsIterator());
        }
    }

    protected static class PolicySourceModelCreator {
        protected PolicySourceModelCreator() {
        }

        protected PolicySourceModel create(Policy policy) {
            return PolicySourceModel.createPolicySourceModel(policy.getNamespaceVersion(), policy.getId(), policy.getName());
        }
    }
}

