/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.InternetHeaders;
import java.nio.ByteBuffer;

abstract class MIMEEvent {
    static final StartMessage START_MESSAGE = new StartMessage();
    static final StartPart START_PART = new StartPart();
    static final EndPart END_PART = new EndPart();
    static final EndMessage END_MESSAGE = new EndMessage();

    MIMEEvent() {
    }

    abstract EVENT_TYPE getEventType();

    static final class Content
    extends MIMEEvent {
        private final ByteBuffer buf;

        Content(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.CONTENT;
        }

        ByteBuffer getData() {
            return this.buf;
        }
    }

    static enum EVENT_TYPE {
        START_MESSAGE,
        START_PART,
        HEADERS,
        CONTENT,
        END_PART,
        END_MESSAGE;

    }

    static final class EndMessage
    extends MIMEEvent {
        EndMessage() {
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.END_MESSAGE;
        }
    }

    static final class EndPart
    extends MIMEEvent {
        EndPart() {
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.END_PART;
        }
    }

    static final class Headers
    extends MIMEEvent {
        InternetHeaders ih;

        Headers(InternetHeaders internetHeaders) {
            this.ih = internetHeaders;
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.HEADERS;
        }

        InternetHeaders getHeaders() {
            return this.ih;
        }
    }

    static final class StartMessage
    extends MIMEEvent {
        StartMessage() {
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.START_MESSAGE;
        }
    }

    static final class StartPart
    extends MIMEEvent {
        StartPart() {
        }

        @Override
        EVENT_TYPE getEventType() {
            return EVENT_TYPE.START_PART;
        }
    }
}

