/*
 * Decompiled with CFR 0.152.
 */
package hacks;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import rom.RomManager;

public class Hack {
    private final String name;
    protected final int[][] data;

    public Hack(String string, int[][] nArray) {
        this.name = "Hack" + string;
        this.data = nArray;
    }

    public boolean isApplied() {
        int n = 0;
        while (n < this.data.length) {
            if (RomManager.StaticAccess.readByte(this.data[n][0]) != this.data[n][1]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void apply() {
        if (this.isApplied()) {
            throw new IllegalStateException("Hack " + this + " is already applied.");
        }
        int n = 0;
        while (n < this.data.length) {
            RomManager.StaticAccess.writeByte(this.data[n][0], this.data[n][1]);
            ++n;
        }
    }

    public void unapply() {
        if (!this.isApplied()) {
            throw new IllegalStateException("Hack " + this + " hasn't been applied.");
        }
        int n = 0;
        while (n < this.data.length) {
            RomManager.StaticAccess.restoreByte(this.data[n][0]);
            ++n;
        }
    }

    public Changable getChangable() {
        return new Changable(){

            @Override
            public void removeChangeListener(ChangeListener changeListener) {
            }

            @Override
            public String getChangeName() {
                return Hack.this.toString();
            }

            @Override
            public void fireChangeOccurred(Change change) {
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
            }
        };
    }

    public String toString() {
        return TextProvider.get(this.name);
    }
}

