/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.ComponentWrapper;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.NameTable;
import data.Palette;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import miracleworld.MiracleWorldEditorModel;
import panels.NameTablePanel;
import panels.TilesetPanel;

public class NameTableEditor
extends JDialog {
    private static NameTableEditor editor;
    private NameTable[] nameTables;
    private Tileset[] tilesets;
    private Palette[] palettes;
    private final NameTablePanel nameTable;
    private final JComboBox<String> nameTableSelection;
    private final TilesetPanel tileset;
    private final int[] TILESETS;

    private NameTableEditor(NameTable[] nameTableArray, Tileset[] tilesetArray, Palette[] paletteArray, String[] stringArray) {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        this.TILESETS = nArray;
        this.setTitle(TextProvider.get("TitleNameTable"));
        this.nameTables = nameTableArray;
        this.tilesets = tilesetArray;
        this.palettes = paletteArray;
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.nameTableSelection = new JComboBox<String>(stringArray);
        this.nameTable = new NameTablePanel(nameTableArray[0], tilesetArray[0], paletteArray[0]);
        this.nameTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tileset = new TilesetPanel(tilesetArray[0], paletteArray[0]);
        this.tileset.setMatchParentWidth(true);
        this.nameTable.setScaleParent(this.tileset);
        this.tileset.setSelectionEnabled(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NameTableEditor.this.nameTableSelection.getSelectedIndex() < NameTableEditor.this.nameTables.length) {
                    try {
                        int n = Math.max(0, NameTableEditor.this.nameTableSelection.getSelectedIndex() - MiracleWorldEditorModel.getNumTitleScreenNameTables() + 1);
                        NameTableEditor.this.nameTable.setNameTable(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()], NameTableEditor.this.tilesets[NameTableEditor.this.TILESETS[n]], NameTableEditor.this.palettes[NameTableEditor.this.TILESETS[n]]);
                        NameTableEditor.this.nameTable.setSelectedTile(0);
                        NameTableEditor.this.tileset.setTileset(NameTableEditor.this.tilesets[NameTableEditor.this.TILESETS[n]], NameTableEditor.this.palettes[NameTableEditor.this.TILESETS[n]]);
                        NameTableEditor.this.pack();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (NameTableEditor.this.nameTableSelection.getSelectedIndex() > 0) {
                            NameTableEditor.this.nameTableSelection.setSelectedIndex(NameTableEditor.this.nameTableSelection.getSelectedIndex() - 1);
                        } else {
                            NameTableEditor.this.nameTableSelection.setSelectedIndex(1);
                        }
                        this.actionPerformed(actionEvent);
                    }
                }
            }
        };
        this.tileset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.setTile(NameTableEditor.this.tileset.getSelectedTile());
            }
        });
        this.nameTableSelection.addActionListener(actionListener);
        this.nameTableSelection.setVisible(tilesetArray.length > 1);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        jPanel.add(this.nameTableSelection, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jPanel3), "South");
        JButton jButton = new JButton(TextProvider.get("FlipH"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.flipH();
            }
        });
        JButton jButton2 = new JButton(TextProvider.get("FlipV"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.flipV();
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(jPanel5);
        final JRadioButton jRadioButton = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 0");
        final JRadioButton jRadioButton2 = new JRadioButton(String.valueOf(TextProvider.get("Palette")) + " 1");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jPanel5.add(jRadioButton);
        jPanel5.add(jRadioButton2);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.setPalette(0);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.setPalette(1);
            }
        });
        final JCheckBox jCheckBox = new JCheckBox(TextProvider.get("Foreground"));
        jPanel3.add(jCheckBox);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.setPriority(jCheckBox.isSelected());
            }
        });
        JPanel jPanel6 = new JPanel();
        String[] stringArray2 = new String[8];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = TextProvider.get("Attribute" + n);
            ++n;
        }
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jPanel6.add(jComboBox);
        jPanel3.add(jPanel6);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.setFlags(jComboBox.getSelectedIndex() << 5);
            }
        });
        jPanel.add((Component)ComponentWrapper.wrapComponent(this.nameTable), "Center");
        this.add((Component)this.tileset, "Center");
        this.add((Component)jPanel2, "South");
        this.nameTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = NameTableEditor.this.nameTable.getSelectedTile();
                if ((nArray[1] & 8) != 0) {
                    jRadioButton2.setSelected(true);
                } else {
                    jRadioButton.setSelected(true);
                }
                jCheckBox.setSelected((nArray[1] & 0x10) != 0);
                jComboBox.setSelectedIndex(nArray[1] >> 5);
                NameTableEditor.this.tileset.setSelectedTile(nArray[0]);
            }
        });
        this.nameTable.setSelectedTile(0);
        this.nameTableSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 80) {
                    System.out.println(Integer.toHexString(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()].getSource()));
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(NameTableEditor.this.tileset.getScale() + 1.5f));
                        NameTableEditor.this.tileset.setPreferredScale(f);
                        NameTableEditor.this.tileset.setMatchParentWidth(false);
                        NameTableEditor.this.pack();
                        NameTableEditor.this.tileset.setMatchParentWidth(true);
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(NameTableEditor.this.tileset.getScale() - 0.5f));
                    NameTableEditor.this.tileset.setPreferredScale(f);
                    NameTableEditor.this.tileset.setMatchParentWidth(false);
                    NameTableEditor.this.pack();
                    NameTableEditor.this.tileset.setMatchParentWidth(true);
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("CopyNameTable"), 99);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.copyToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("PasteNameTable"), 112);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTableEditor.this.nameTable.pasteFromClipboard();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(NameTableEditor.this.nameTables[NameTableEditor.this.nameTableSelection.getSelectedIndex()]));
                menuItem4.setEnabled(NameTableEditor.this.nameTable.canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem4.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public static void open(JFrame jFrame, NameTable[] nameTableArray, Tileset[] tilesetArray, Palette[] paletteArray, String[] stringArray, Properties properties) {
        if (editor == null) {
            editor = new NameTableEditor(nameTableArray, tilesetArray, paletteArray, stringArray);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            NameTableEditor.editor.tilesets = tilesetArray;
            NameTableEditor.editor.palettes = paletteArray;
            NameTableEditor.editor.nameTables = nameTableArray;
            NameTableEditor.editor.nameTableSelection.setSelectedIndex(0);
            NameTableEditor.editor.nameTableSelection.setVisible(tilesetArray.length > 1);
            editor.pack();
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        NameTableEditor.editor.nameTable.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        NameTableEditor.editor.tileset.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

