/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.TextProvider;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class TitleScreen
implements Changable {
    private final int address;
    private int[] vram;
    private final int[] sat = new int[256];
    private final int[] entityData = new int[960];
    private final int[] entityPointers = new int[64];
    private final int[] entitySources = new int[30];
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public TitleScreen(int n) {
        this.address = n;
    }

    public int getNumberOfScreens() {
        return RomManager.StaticAccess.readByte(2124);
    }

    public int[] getVRAM(int n) {
        if (n > this.getNumberOfScreens()) {
            return this.vram;
        }
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        nArray[758] = 201;
        nArray[785] = 201;
        nArray[1950] = 0;
        nArray[1949] = 0;
        nArray[2032] = 0;
        nArray[2031] = 0;
        nArray[2030] = 0;
        nArray[49401] = 0;
        nArray[49402] = 195;
        nArray[49400] = this.entitySources.length;
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        this.vram = tMS9918A.getVRAM();
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n == 65534) {
                    RomManager.StaticAccess.loadBank1(nArray, n2);
                } else if (n >= 50944 && n < 51008 && n2 != 208) {
                    ((TitleScreen)TitleScreen.this).entityPointers[n & 0x3F] = z80.getIX() - 49920;
                } else if (z80.getIX() == n && n >= 49920 && n < 49920 + TitleScreen.this.entityData.length && (n & 0x1F) == 0) {
                    ((TitleScreen)TitleScreen.this).entitySources[(z80.getIX() - 49920) / 32] = z80.getPC();
                } else {
                    if (n >= 51008 && n < 51072) {
                        throw new ArrayIndexOutOfBoundsException("The SAT has overflown.");
                    }
                    if (n >> 6 == 2) {
                        if (n2 < 0) {
                            z80.setInput(tMS9918A.readByte(n & 1, n3));
                        } else {
                            tMS9918A.processInput(n & 1, n2, n3);
                        }
                    }
                }
            }
        });
        tMS9918A.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 3 && (n2 & 0x3FFF) < 8192 || n == 2) {
                    z80.ret();
                }
            }
        });
        z80.execute(this.address);
        int n2 = 0;
        while (n2 < n) {
            z80.setAF(n2 << 8);
            z80.execute(2150);
            System.arraycopy(nArray, 49920, this.entityData, 0, this.entityData.length);
            RomManager.StaticAccess.loadBank2(nArray, 2);
            z80.execute(9876);
            ++n2;
        }
        System.arraycopy(nArray, 50944, this.sat, 0, this.sat.length);
        return this.vram;
    }

    public int[] getSAT() {
        return this.sat;
    }

    public void setEntityPosition(int n, int n2, int n3) {
        if (this.entityData[n * 32] > 0 && (RomManager.StaticAccess.readByte(this.entitySources[n] + 9) != (n3 & 0xFF) || RomManager.StaticAccess.readByte(this.entitySources[n] + 13) != (n2 & 0xFF))) {
            RomManager.StaticAccess.writeByte(this.entitySources[n] + 9, n3 & 0xFF);
            RomManager.StaticAccess.writeByte(this.entitySources[n] + 13, n2 & 0xFF);
        }
    }

    public void removeEntity(int n) {
        if (this.entitySources[n] > 0) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.fill(this.entitySources[n] - 8, this.entitySources[n] + 14, 0);
        }
    }

    public void startMoving(int n) {
        if (this.entityData[n * 32] > 0) {
            TransactionManager.getInstance().addTransactionObject(this, n);
        }
    }

    public int getEntityIndex(int n) {
        return this.entityPointers[n & 0x3F] / 32;
    }

    public int[] getEntityData(int n) {
        int[] nArray = new int[]{this.entityData[n * 32], this.entityData[n * 32 + 14], this.entityData[n * 32 + 12]};
        return nArray;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeTitleScreen");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

