/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import data.Tileset;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;
import transactions.TransactionManager;

public abstract class MetaTileset
implements Changable {
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public abstract int getMetaTileWidth();

    public abstract int getMetaTileHeight();

    public abstract int getNumberOfMetaTiles();

    public abstract int getSource();

    protected int getNumberOfTilesPerMetaTile() {
        return this.getMetaTileWidth() / 8 * this.getMetaTileHeight() / 8;
    }

    protected int getSizeOfMetaTile() {
        return this.getNumberOfTilesPerMetaTile() * 2;
    }

    public void setMetaTiles(int[][] nArray) {
        if (nArray.length == this.getNumberOfMetaTiles() && nArray[0].length == this.getSizeOfMetaTile() && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, -1);
            int n = 0;
            while (n < nArray.length) {
                if (this.isValid(n)) {
                    RomManager.StaticAccess.writeBytes(nArray[n], this.getMetaTileAddress(n));
                }
                ++n;
            }
        }
    }

    public int[][] getMetaTiles() {
        int[][] nArray = new int[this.getNumberOfMetaTiles()][this.getSizeOfMetaTile()];
        int n = 0;
        while (n < nArray.length) {
            if (this.isValid(n)) {
                RomManager.StaticAccess.readBytes(nArray[n], this.getMetaTileAddress(n));
            }
            ++n;
        }
        return nArray;
    }

    public void setMetaTile(int n, int[] nArray) {
        if (nArray.length == this.getSizeOfMetaTile() && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            if (this.isValid(n)) {
                RomManager.StaticAccess.writeBytes(nArray, this.getMetaTileAddress(n));
            }
        }
    }

    public int[] getMetaTile(int n) {
        return RomManager.StaticAccess.readBytes(new int[this.getSizeOfMetaTile()], this.getMetaTileAddress(n));
    }

    protected abstract int getMetaTileAddress(int var1);

    protected abstract int getMetaTileSubTileAddress(int var1, int var2);

    protected abstract int getMetaTileSubTileFlagsAddress(int var1, int var2);

    public abstract boolean isValid(int var1);

    public abstract boolean isUsable(int var1, Tileset var2);

    private boolean isAnyFlagDifferent(int n, int n2, int n3) {
        int n4 = this.getNumberOfTilesPerMetaTile() - 1;
        while (n4 >= 0) {
            if ((RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n4)) & n2) != n3) {
                return true;
            }
            --n4;
        }
        return false;
    }

    private void setAllFlagValue(int n, int n2, int n3) {
        int n4 = this.getNumberOfTilesPerMetaTile() - 1;
        while (n4 >= 0) {
            int n5 = this.getMetaTileSubTileFlagsAddress(n, n4);
            RomManager.StaticAccess.writeByte(n5, RomManager.StaticAccess.readByte(n5) & ~n2 | n3);
            --n4;
        }
    }

    public void setSubTile(int n, int n2, int n3) {
        if (n3 < 0) {
            return;
        }
        if (RomManager.StaticAccess.readByte(this.getMetaTileSubTileAddress(n, n2)) != (n3 & 0xFF) && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeByte(this.getMetaTileSubTileAddress(n, n2), n3 & 0xFF);
        }
    }

    public void setFlags(int n, int n2, int n3) {
        n3 &= 0xFF;
        if (n2 >= 0) {
            if ((RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 0xE0) != n3 && this.ensureModifiable()) {
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(this.getMetaTileSubTileFlagsAddress(n, n2), RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 0xFFFFFF1F | n3);
            }
        } else if (this.isAnyFlagDifferent(n, 224, n3) && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.setAllFlagValue(n, 224, n3);
        }
    }

    public void setPalette(int n, int n2, int n3) {
        n3 &= 0xFF;
        if (n2 >= 0) {
            if ((RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 8) != n3 * 8 && this.ensureModifiable()) {
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(this.getMetaTileSubTileFlagsAddress(n, n2), RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 0xFFFFFFF7 | n3 * 8);
            }
        } else if (this.isAnyFlagDifferent(n, 8, n3 * 8) && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.setAllFlagValue(n, 8, n3 * 8);
        }
    }

    public void setPriority(int n, int n2, boolean bl) {
        int n3 = 0;
        if (bl) {
            n3 = 16;
        }
        if (n2 >= 0) {
            if ((RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 0x10) != n3 && this.ensureModifiable()) {
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(this.getMetaTileSubTileFlagsAddress(n, n2), RomManager.StaticAccess.readByte(this.getMetaTileSubTileFlagsAddress(n, n2)) & 0xFFFFFFEF | n3);
            }
        } else if (this.isAnyFlagDifferent(n, 16, n3) && this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            this.setAllFlagValue(n, 16, n3);
        }
    }

    public void flipH(int n, int n2) {
        if (this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            if (n2 >= 0) {
                RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n2), 1);
            } else {
                int n3 = this.getMetaTileWidth() / 8;
                int n4 = this.getMetaTileHeight() / 8;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = 0;
                    while (n6 < n3 / 2) {
                        int n7 = n5 * n3 + n6;
                        int n8 = n5 * n3 + n3 - n6 - 1;
                        RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n7), 1);
                        RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n8), 1);
                        int n9 = RomManager.StaticAccess.readByte(this.getMetaTileSubTileAddress(n, n7));
                        RomManager.StaticAccess.writeByte(this.getMetaTileSubTileAddress(n, n7), RomManager.StaticAccess.readByte(this.getMetaTileSubTileAddress(n, n8)));
                        RomManager.StaticAccess.writeByte(this.getMetaTileSubTileAddress(n, n8), n9);
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
    }

    public void flipV(int n, int n2) {
        if (this.ensureModifiable()) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            if (n2 >= 0) {
                RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n2), 2);
            } else {
                int n3 = this.getMetaTileWidth() / 8;
                int n4 = this.getMetaTileHeight() / 8;
                int n5 = 0;
                while (n5 < n4 / 2) {
                    int n6 = 0;
                    while (n6 < n3) {
                        int n7 = n5 * n3 + n6;
                        int n8 = (n4 - n5 - 1) * n3 + n6;
                        RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n7), 2);
                        RomManager.StaticAccess.flipBitInByte(this.getMetaTileSubTileFlagsAddress(n, n8), 2);
                        int n9 = RomManager.StaticAccess.readByte(this.getMetaTileSubTileAddress(n, n7));
                        RomManager.StaticAccess.writeByte(this.getMetaTileSubTileAddress(n, n7), RomManager.StaticAccess.readByte(this.getMetaTileSubTileAddress(n, n8)));
                        RomManager.StaticAccess.writeByte(this.getMetaTileSubTileAddress(n, n8), n9);
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
    }

    protected abstract boolean ensureModifiable();

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeMetatileset");
    }

    @Override
    public void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return "Meta Tileset @" + Integer.toHexString(this.getMetaTileAddress(0)).toUpperCase();
    }
}

