/*
 * Decompiled with CFR 0.152.
 */
package rom;

import java.util.Arrays;
import transactions.TransactionManager;

public class RomManager {
    private static RomManager instance;
    private int[][] rom;

    private RomManager() {
    }

    public static RomManager getInstance() {
        if (instance == null) {
            instance = new RomManager();
        }
        return instance;
    }

    public void setRom(int[][] nArray) {
        this.rom = nArray;
    }

    public int getRomLength() {
        return this.rom[0].length;
    }

    public int[] readBytes(int[] nArray, int n) {
        this.copyFromROM(n, nArray, 0, nArray.length);
        return nArray;
    }

    public void copyFromROM(int n, int[] nArray, int n2, int n3) {
        System.arraycopy(this.rom[0], n, nArray, n2, n3);
    }

    public void copyToROM(int[] nArray, int n, int n2, int n3) {
        TransactionManager.getInstance().addToTransaction(n2, n3);
        System.arraycopy(nArray, n, this.rom[0], n2, n3);
    }

    public void copyBytes(int n, int n2, int n3) {
        TransactionManager.getInstance().addToTransaction(n2, n3);
        System.arraycopy(this.rom[0], n, this.rom[0], n2, n3);
    }

    public void writeBytes(int[] nArray, int n) {
        this.copyToROM(nArray, 0, n, nArray.length);
    }

    public int writeByte(int n, int n2) {
        if (n2 >= 256 || n2 < 0) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n2)) + " doesn't fit into a byte.");
        }
        TransactionManager.getInstance().addToTransaction(n);
        int n3 = n2;
        this.rom[0][n] = n3;
        return n3;
    }

    public int writeWord(int n, int n2) {
        if (n2 >= 65536 || n2 < 0) {
            throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n2)) + " doesn't fit into a word.");
        }
        return this.writeByte(n + 1, n2 >> 8) << 8 | this.writeByte(n, n2 & 0xFF);
    }

    public int addToByte(int n, int n2) {
        return this.writeByte(n, this.readByte(n) + n2);
    }

    public int incByte(int n) {
        return this.addToByte(n, 1);
    }

    public int decByte(int n) {
        return this.addToByte(n, -1);
    }

    public int flipBitInByte(int n, int n2) {
        return this.writeByte(n, this.readByte(n) ^ 1 << n2);
    }

    public int orByteWith(int n, int n2) {
        return this.writeByte(n, this.readByte(n) | n2);
    }

    public int shiftByteRight(int n, int n2) {
        return this.writeByte(n, this.readByte(n) >> n2);
    }

    public int readByte(int n) {
        return this.rom[0][n];
    }

    public boolean isChanged(int n, int n2) {
        while (n < n2) {
            if (!this.isChanged(n++)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(int n) {
        return n < this.rom[0].length && n < this.rom[1].length && this.rom[0][n] != this.rom[1][n];
    }

    public int readWord(int n) {
        return this.readByte(n + 1) << 8 | this.readByte(n);
    }

    public void restoreByte(int n) {
        TransactionManager.getInstance().addToTransaction(n);
        this.rom[0][n] = this.rom[1][n];
    }

    public void restoreBytes(int n, int n2) {
        TransactionManager.getInstance().addToTransaction(n, n2);
        System.arraycopy(this.rom[1], n, this.rom[0], n, n2);
    }

    public void fill(int n, int n2, int n3) {
        TransactionManager.getInstance().addToTransaction(n, n2 - n);
        Arrays.fill(this.rom[0], n, n2, n3);
    }

    public void swapTableEntries(int n, int n2, int n3, int n4) {
        this.swapBytes(n + n2 * n4, n + n3 * n4, n4);
    }

    public void swapBytes(int n, int n2, int n3) {
        while (n3-- > 0) {
            int n4 = this.readByte(n);
            this.writeByte(n++, this.readByte(n2));
            this.writeByte(n2++, n4);
        }
    }

    public void loadBank2(int[] nArray, int n) {
        if (nArray[65535] != n) {
            nArray[65535] = n;
            this.copyFromROM((n & 0x3F) * 16384, nArray, 32768, 16384);
        }
    }

    public void loadBank1(int[] nArray, int n) {
        if (n == 0) {
            System.err.println("Loaded bank 0 into slot 1.");
        }
        if (nArray[65534] != n) {
            nArray[65534] = n;
            this.copyFromROM((n & 0x3F) * 16384, nArray, 16384, 16384);
        }
    }

    public final int READ_BYTE(int n, int n2) {
        if (n > 0 && n < 49152) {
            return this.readByte(RomManager.RESOLVE_ADDRESS(n, n2));
        }
        throw new IllegalArgumentException(String.valueOf(Integer.toHexString(n)) + " is out of ROM space.");
    }

    public final int READ_WORD(int n, int n2) {
        return this.READ_BYTE(n, n2) | this.READ_BYTE(n + 1, n2) << 8;
    }

    public void addBanks(int n) {
        if (n > 0) {
            n = Math.min(64, this.rom[0].length / 16384 + n);
            this.expandTo(n);
        }
    }

    public boolean canExpand() {
        return this.rom[0].length / 16384 < 64;
    }

    public void expandTo(int n) {
        if (n <= 64 && n > this.rom[0].length / 16384) {
            int[] nArray = this.rom[0];
            this.rom[0] = new int[nArray.length + 16384 * (n - nArray.length / 16384)];
            System.arraycopy(nArray, 0, this.rom[0], 0, nArray.length);
            Arrays.fill(this.rom[0], nArray.length, this.rom[0].length, 255);
        }
    }

    public void expandToNextPowerOf2() {
        int n = 1;
        while (n <= this.rom[0].length / 16384 && n < 64) {
            n <<= 1;
        }
        this.expandTo(n);
    }

    public static final int RESOLVE_ADDRESS(int n, int n2) {
        if (n >= 32768 && n < 49152) {
            return (n & 0x3FFF) + (n2 & 0x3F) * 16384;
        }
        return n;
    }

    public static final int RESOLVE_ADDRESS1(int n, int n2) {
        if (n >= 16384 && n < 32768) {
            return (n & 0x3FFF) + (n2 & 0x3F) * 16384;
        }
        return n;
    }

    public static class StaticAccess {
        public static void setRom(int[][] nArray) {
            RomManager.getInstance().setRom(nArray);
        }

        public static int getRomLength() {
            return RomManager.getInstance().getRomLength();
        }

        public static int[] readBytes(int[] nArray, int n) {
            return RomManager.getInstance().readBytes(nArray, n);
        }

        public static void copyFromROM(int n, int[] nArray, int n2, int n3) {
            RomManager.getInstance().copyFromROM(n, nArray, n2, n3);
        }

        public static void copyToROM(int[] nArray, int n, int n2, int n3) {
            RomManager.getInstance().copyToROM(nArray, n, n2, n3);
        }

        public static void copyBytes(int n, int n2, int n3) {
            RomManager.getInstance().copyBytes(n, n2, n3);
        }

        public static void writeBytes(int[] nArray, int n) {
            RomManager.getInstance().writeBytes(nArray, n);
        }

        public static int writeByte(int n, int n2) {
            return RomManager.getInstance().writeByte(n, n2);
        }

        public static int writeWord(int n, int n2) {
            return RomManager.getInstance().writeWord(n, n2);
        }

        public static int addToByte(int n, int n2) {
            return RomManager.getInstance().addToByte(n, n2);
        }

        public static int incByte(int n) {
            return RomManager.getInstance().incByte(n);
        }

        public static int decByte(int n) {
            return RomManager.getInstance().decByte(n);
        }

        public static int flipBitInByte(int n, int n2) {
            return RomManager.getInstance().flipBitInByte(n, n2);
        }

        public static int orByteWith(int n, int n2) {
            return RomManager.getInstance().orByteWith(n, n2);
        }

        public static int shiftByteRight(int n, int n2) {
            return RomManager.getInstance().shiftByteRight(n, n2);
        }

        public static int readByte(int n) {
            return RomManager.getInstance().readByte(n);
        }

        public static boolean isChanged(int n, int n2) {
            return RomManager.getInstance().isChanged(n, n2);
        }

        public static boolean isChanged(int n) {
            return RomManager.getInstance().isChanged(n);
        }

        public static int readWord(int n) {
            return RomManager.getInstance().readWord(n);
        }

        public static void restoreByte(int n) {
            RomManager.getInstance().restoreByte(n);
        }

        public static void restoreBytes(int n, int n2) {
            RomManager.getInstance().restoreBytes(n, n2);
        }

        public static void fill(int n, int n2, int n3) {
            RomManager.getInstance().fill(n, n2, n3);
        }

        public static void loadBank2(int[] nArray, int n) {
            RomManager.getInstance().loadBank2(nArray, n);
        }

        public static void loadBank1(int[] nArray, int n) {
            RomManager.getInstance().loadBank1(nArray, n);
        }

        public static final int READ_BYTE(int n, int n2) {
            return RomManager.getInstance().READ_BYTE(n, n2);
        }

        public static final int READ_WORD(int n, int n2) {
            return RomManager.getInstance().READ_WORD(n, n2);
        }

        public static void addBanks(int n) {
            RomManager.getInstance().addBanks(n);
        }

        public static boolean canExpand() {
            return RomManager.getInstance().canExpand();
        }

        public static void expandTo(int n) {
            RomManager.getInstance().expandTo(n);
        }

        public static void expandToNextPowerOf2() {
            RomManager.getInstance().expandToNextPowerOf2();
        }

        public static void swapTableEntries(int n, int n2, int n3, int n4) {
            RomManager.getInstance().swapTableEntries(n, n2, n3, n4);
        }

        public static void swapBytes(int n, int n2, int n3) {
            RomManager.getInstance().swapBytes(n, n2, n3);
        }
    }
}

