/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import changes.UndoRedoManager;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.Palette;
import data.TextData;
import data.Tiles;
import data.Tileset;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import panels.TextPanel;
import transactions.TransactionManager;

public class TextEditor
extends JDialog {
    private static TextEditor editor;
    private final JComboBox<TextData.TextHandle> textSelection;
    private final TextPanel textPanel;
    private final JTextArea rawTextArea = new JTextArea();
    private final JLabel rawTextInfo = new JLabel();
    private final Color defaultForegroundRawTextInfo = this.rawTextInfo.getForeground();
    private boolean dontUpdateRawText;
    private boolean dontUpdateRawTextArea;
    private TextData textData;
    private Vector<TextData.TextHandle> textHandles;
    private final ChangeListener textDataChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            ((TextData.TextHandle)TextEditor.this.textSelection.getSelectedItem()).updateName();
            TextEditor.this.textSelection.repaint();
        }
    };

    private TextEditor(final TextData textData, Tileset tileset, Palette palette, Tiles tiles) {
        this.setTitle(TextProvider.get("TitleText"));
        this.textData = textData;
        textData.addChangeListener(this.textDataChangeListener);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.textHandles = textData.getTextHandles();
        this.textSelection = new JComboBox<TextData.TextHandle>(this.textHandles);
        this.textSelection.setFocusable(false);
        this.textSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.textPanel.setMessageToShow((TextData.TextHandle)TextEditor.this.textSelection.getSelectedItem());
                TextEditor.this.dontUpdateRawText = true;
                String string = textData.getRawText((TextData.TextHandle)TextEditor.this.textSelection.getSelectedItem());
                TextEditor.this.rawTextArea.setText(string);
                TextEditor.this.rawTextArea.setEnabled(string != null);
                TextEditor.this.rawTextArea.setEditable(string != null);
                TextEditor.this.dontUpdateRawText = false;
            }
        });
        textData.addChangeListener(new ChangeListener(){

            @Override
            public void changeOccurred(Change change) {
                if (TextEditor.this.dontUpdateRawTextArea) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = textData.getRawText((TextData.TextHandle)TextEditor.this.textSelection.getSelectedItem());
                        if (!TextEditor.this.rawTextArea.getText().equals(string)) {
                            TextEditor.this.dontUpdateRawText = true;
                            TextEditor.this.rawTextArea.setText(string);
                            TextEditor.this.dontUpdateRawText = false;
                        }
                    }
                });
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.textSelection, "North");
        this.textPanel = new TextPanel(textData, tileset, palette, tiles);
        jPanel.add((Component)this.textPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.rawTextArea);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)this.rawTextInfo, "South");
        final JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        this.add(jSplitPane);
        this.rawTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                String string2 = "[^A-Za-z0-9 \\n!\"#$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@" + (TextEditor.this.textPanel.supportsControlCodes() ? "\\\\" : "") + "]";
                string = string.replaceAll(string2, "");
                char[] cArray = new char[string.length()];
                string.getChars(0, string.length(), cArray, 0);
                boolean bl = n > 0 && this.getText(n - 1, 1).charAt(0) == '\\';
                int n2 = 0;
                while (n2 < cArray.length) {
                    cArray[n2] = bl ? Character.toLowerCase(cArray[n2]) : Character.toUpperCase(cArray[n2]);
                    bl = cArray[n2] == '\\';
                    ++n2;
                }
                super.insertString(n, new String(cArray), attributeSet);
            }
        });
        this.rawTextArea.setText(textData.getRawText((TextData.TextHandle)this.textSelection.getSelectedItem()));
        this.rawTextInfo.setText(" ");
        this.rawTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateText();
            }

            private void updateText() {
                final TextData.TextHandle textHandle = (TextData.TextHandle)TextEditor.this.textSelection.getSelectedItem();
                TextEditor.this.rawTextInfo.setText(" ");
                if (TextEditor.this.dontUpdateRawText) {
                    return;
                }
                TextEditor.this.dontUpdateRawTextArea = true;
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            textData.setRawText(textHandle, TextEditor.this.rawTextArea.getText());
                            TextEditor.this.rawTextInfo.setForeground(TextEditor.this.defaultForegroundRawTextInfo);
                            TextEditor.this.rawTextInfo.setText(" ");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            TextEditor.this.rawTextInfo.setForeground(Color.RED);
                            TextEditor.this.rawTextInfo.setText("Error: " + illegalArgumentException.getMessage());
                        }
                    }
                });
                TextEditor.this.dontUpdateRawTextArea = false;
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(TextEditor.this.textPanel.getScale() + 1.5f));
                        TextEditor.this.textPanel.setPreferredScale(f);
                        jSplitPane.setDividerLocation(0.8);
                        TextEditor.this.pack();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(TextEditor.this.textPanel.getScale() - 0.5f));
                    TextEditor.this.textPanel.setPreferredScale(f);
                    jSplitPane.setDividerLocation(0.8);
                    TextEditor.this.pack();
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"));
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(TextEditor.this.textData);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"));
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(TextEditor.this.textData);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("Copy"));
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.textPanel.copyToClipboard();
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("Paste"));
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextEditor.this.textPanel.pasteFromClipboard();
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(TextEditor.this.textData));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(TextEditor.this.textData));
                menuItem4.setEnabled(TextEditor.this.textPanel.canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem4.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public static void open(JFrame jFrame, TextData textData, Tileset tileset, Palette palette, Tiles tiles, Properties properties) {
        if (editor == null) {
            editor = new TextEditor(textData, tileset, palette, tiles);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            if (TextEditor.editor.textData != null && TextEditor.editor.textData != textData) {
                TextEditor.editor.textData.removeChangeListener(TextEditor.editor.textDataChangeListener);
            }
            TextEditor.editor.textData = textData;
            textData.addChangeListener(TextEditor.editor.textDataChangeListener);
            TextEditor.editor.textHandles.clear();
            TextEditor.editor.textHandles.addAll(textData.getTextHandles());
            TextEditor.editor.textSelection.setSelectedIndex(0);
            TextEditor.editor.textPanel.setTextData(textData, tileset, palette, tiles);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        TextEditor.editor.textPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

