/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeListener;
import common.ComponentWrapper;
import common.Properties;
import common.ScreenUtilities;
import data.Sound;
import editor.Z80Factory;
import editors.Icons;
import editors.KiddEd;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mastersystem.OutputListener;
import mastersystem.SN76489;
import mastersystem.SoundPlayer;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class SoundEditor
extends JDialog {
    private static final int PSGLIB_BANK_PSG = 49432;
    private static final int PSGLIB_BANK_PSG_SFX = 49433;
    private static final int PSGLIB_TEMPO_ADJUSTMENT = 49434;
    private static final int PSGLIB_PSG_MUSIC_STATUS = 49435;
    private static final int PSGLIB_PSG_SFX_STATUS = 49458;
    private static SoundEditor editor;
    private Sound sound;
    private final int addressUpdateSound;
    private final JComboBox<String> soundSelection;
    private final JComboBox<String> engine = new JComboBox<String>(new String[]{TextProvider.get("SoundEngineOriginal"), TextProvider.get("SoundEnginePSGlib")});
    private final JButton buttonImport = new JButton(TextProvider.get("ButtonSoundImport"));
    private final JButton buttonRemove = new JButton(TextProvider.get("ButtonSoundRemove"));
    private final JButton buttonRestore = new JButton(TextProvider.get("ButtonSoundRestore"));
    private final SoundPlayer soundPlayer = new SoundPlayer(44100, 200);
    private volatile boolean playing;
    private final ChangeListener soundChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            SoundEditor.this.updateSoundNames();
        }
    };
    private final JButton play = new JButton(new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getForeground());
            if (SoundEditor.this.playerThread == null) {
                graphics.fillPolygon(new int[]{n + 2, n + 2, n + 14}, new int[]{n2 + 2, n2 + 14, n2 + 8}, 3);
            } else {
                graphics.fillRect(n + 2, n2 + 2, 12, 12);
            }
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    });
    private final JButton add = new JButton(new Icons.AddIcon(true));
    private Thread playerThread;
    private Runnable player = new Runnable(){
        private int shutdownCounter;

        @Override
        public void run() {
            final int[] nArray = new int[65536];
            RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
            nArray[49432] = 1;
            nArray[49433] = 1;
            nArray[49424] = SoundEditor.this.soundSelection.getSelectedIndex() >= 48 ? 0x80 | SoundEditor.this.soundSelection.getSelectedIndex() + 3 + 1 : 0x80 | SoundEditor.this.soundSelection.getSelectedIndex() + 1;
            if (SoundEditor.this.sound.canAdjustTempo()) {
                nArray[49434] = 128;
            }
            Z80 z80 = Z80Factory.create(nArray);
            final SN76489 sN76489 = new SN76489(3579545, 60);
            sN76489.reset();
            SoundEditor.this.soundPlayer.setPSG(sN76489);
            SoundEditor.this.soundPlayer.setSoundEnabled(true);
            z80.addOutputListener(new OutputListener(){

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    int n4;
                    int n5 = n4 = SoundEditor.this.sound.canAdjustTempo() ? 0 : 1;
                    if (n == 65534) {
                        RomManager.StaticAccess.loadBank1(nArray, n2);
                    } else if (n == 65535) {
                        RomManager.StaticAccess.loadBank2(nArray, n2);
                    } else if (n + n4 == 49435 || n + n4 == 49458) {
                        if (n2 == 0 && !SoundEditor.this.sound.isNativeEngine()) {
                            SoundEditor.this.playing = false;
                            shutdownCounter = 30;
                        }
                    } else if (n >> 6 == 1 && n2 >= 0) {
                        sN76489.processInput(n, n2, n3);
                    }
                }
            });
            SoundEditor.this.playing = true;
            while (SoundEditor.this.playing || --this.shutdownCounter > 0) {
                try {
                    z80.execute(SoundEditor.this.addressUpdateSound);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SoundEditor.this.playing = false;
                }
                SoundEditor.this.soundPlayer.finishFrame();
            }
            SoundEditor.this.soundPlayer.setSoundEnabled(false);
            SoundEditor.this.playerThread = null;
            SoundEditor.this.play.repaint();
        }
    };

    private SoundEditor(Sound sound, int n) {
        this.setTitle(TextProvider.get("TitleSound"));
        this.sound = sound;
        this.addressUpdateSound = n;
        this.setLayout(new BorderLayout());
        final JButton jButton = new JButton(TextProvider.get("ButtonApply"));
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox(TextProvider.get("SoundRepeat"));
        final JPanel jPanel4 = new JPanel();
        Integer[] integerArray = sound.getPriorities();
        Integer[] integerArray2 = new Integer[integerArray.length];
        int n2 = 0;
        while (n2 < integerArray.length) {
            integerArray2[n2] = integerArray[integerArray.length - 1 - n2];
            ++n2;
        }
        final JComboBox<Integer> jComboBox = new JComboBox<Integer>(integerArray2);
        final JCheckBox jCheckBox2 = new JCheckBox(TextProvider.get("AdjustTempoOnPAL"), sound.isAdjustTempo());
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundEditor.this.sound.setAdjustTempo(jCheckBox2.isSelected());
            }
        });
        final JPanel jPanel5 = ComponentWrapper.wrapComponent(jCheckBox2);
        jPanel.add(jPanel2);
        this.engine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(SoundEditor.this.sound.isNativeEngine() ^ SoundEditor.this.engine.getSelectedIndex() == 0);
                if (SoundEditor.this.engine.getSelectedIndex() != 0 && SoundEditor.this.sound.canUpgradePSGlibEngine()) {
                    jButton.setText(TextProvider.get("ButtonUpgrade"));
                    jButton.setEnabled(true);
                } else {
                    jButton.setText(TextProvider.get("ButtonApply"));
                }
                SoundEditor.this.buttonImport.setEnabled(!SoundEditor.this.sound.isNativeEngine());
                SoundEditor.this.buttonRemove.setEnabled(SoundEditor.this.buttonImport.isEnabled());
            }
        });
        jPanel2.add(this.engine);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SoundEditor.this.sound.isNativeEngine()) {
                    try {
                        SoundEditor.this.sound.replaceNativeEngineByPSGlib();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(SoundEditor.this, String.valueOf(TextProvider.get("MessageErrorLoadFile")) + "\n" + iOException.getMessage(), TextProvider.get("TitleErrorLoadFile"), 0);
                        return;
                    }
                } else if (SoundEditor.this.engine.getSelectedIndex() == 0) {
                    if (JOptionPane.showConfirmDialog(SoundEditor.this, TextProvider.get("MessageWarningSoundReplace"), TextProvider.get("TitleWarning"), 0, 2) == 0) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                SoundEditor.this.sound.replacePSGlibByNativeEngine();
                            }
                        });
                    }
                } else {
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SoundEditor.this.sound.upgradePSGlibEngine();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(SoundEditor.this, String.valueOf(TextProvider.get("MessageErrorLoadFile")) + "\n" + iOException.getMessage(), TextProvider.get("TitleErrorLoadFile"), 0);
                                throw new RuntimeException(iOException);
                            }
                        }
                    });
                    if (SoundEditor.this.sound.canUpgradePSGlibEngine()) {
                        JOptionPane.showMessageDialog(SoundEditor.this, TextProvider.get("MessageErrorUpgradePSGlib"), TextProvider.get("TitleError"), 0);
                        return;
                    }
                    jButton.setText(TextProvider.get("ButtonApply"));
                }
                jButton.setEnabled(SoundEditor.this.sound.isNativeEngine() ^ SoundEditor.this.engine.getSelectedIndex() == 0 || SoundEditor.this.engine.getSelectedIndex() != 0 && SoundEditor.this.sound.canUpgradePSGlibEngine());
                SoundEditor.this.buttonImport.setEnabled(!SoundEditor.this.sound.isNativeEngine());
                SoundEditor.this.add.setEnabled(SoundEditor.this.sound.canAddSound());
                SoundEditor.this.buttonRemove.setEnabled(SoundEditor.this.buttonImport.isEnabled());
                jCheckBox.setVisible(!SoundEditor.this.sound.isNativeEngine());
                jPanel4.setVisible(SoundEditor.this.sound.hasPriority(SoundEditor.this.soundSelection.getSelectedIndex()));
                if (jPanel4.isVisible()) {
                    jComboBox.setSelectedItem(SoundEditor.this.sound.getPriority(SoundEditor.this.soundSelection.getSelectedIndex()));
                }
                if (jCheckBox.isVisible()) {
                    jCheckBox.setSelected(SoundEditor.this.sound.isRepeat(SoundEditor.this.soundSelection.getSelectedIndex()));
                }
                jPanel5.setVisible(SoundEditor.this.sound.canAdjustTempo());
                if (jPanel5.isVisible()) {
                    jCheckBox2.setSelected(SoundEditor.this.sound.isAdjustTempo());
                }
                SoundEditor.this.buttonRestore.setEnabled(SoundEditor.this.sound.canRestoreSound(SoundEditor.this.soundSelection.getSelectedIndex()));
                SoundEditor.this.pack();
            }
        });
        jPanel2.add(jButton);
        JPanel jPanel6 = new JPanel();
        this.soundSelection = new JComboBox();
        this.updateSoundNames();
        this.soundSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SoundEditor.this.playerThread != null) {
                    SoundEditor.this.playing = false;
                }
                SoundEditor.this.buttonRestore.setEnabled(SoundEditor.this.sound.canRestoreSound(SoundEditor.this.soundSelection.getSelectedIndex()));
                jCheckBox.setVisible(!SoundEditor.this.sound.isNativeEngine());
                jPanel4.setVisible(SoundEditor.this.sound.hasPriority(SoundEditor.this.soundSelection.getSelectedIndex()));
                if (jPanel4.isVisible()) {
                    jComboBox.setSelectedItem(SoundEditor.this.sound.getPriority(SoundEditor.this.soundSelection.getSelectedIndex()));
                }
                if (jCheckBox.isVisible()) {
                    jCheckBox.setSelected(SoundEditor.this.sound.isRepeat(SoundEditor.this.soundSelection.getSelectedIndex()));
                }
                SoundEditor.this.pack();
            }
        });
        jPanel6.add(this.soundSelection);
        jPanel6.add(this.add);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        SoundEditor.this.sound.addSound();
                    }
                });
                SoundEditor.this.soundSelection.setSelectedIndex(SoundEditor.this.soundSelection.getItemCount() - 1);
            }
        });
        this.add.setDisabledIcon(new Icons.AddIcon(false));
        jPanel4.add(new JLabel(TextProvider.get("Priority")));
        jPanel4.add(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        SoundEditor.this.sound.setPriority(SoundEditor.this.soundSelection.getSelectedIndex(), (Integer)jComboBox.getSelectedItem());
                    }
                });
            }
        });
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        this.add((Component)jPanel, "North");
        jPanel3.add(jCheckBox);
        jPanel3.add(jPanel4);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundEditor.this.sound.setRepeat(SoundEditor.this.soundSelection.getSelectedIndex(), jCheckBox.isSelected());
            }
        });
        JPanel jPanel7 = new JPanel();
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SoundEditor.this.playerThread == null) {
                    SoundEditor.this.playerThread = new Thread(SoundEditor.this.player, "Sound Player");
                    SoundEditor.this.playerThread.start();
                } else {
                    SoundEditor.this.playing = false;
                }
                SoundEditor.this.play.repaint();
            }
        });
        jPanel7.add(this.play);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel3, "North");
        jPanel8.add((Component)jPanel7, "Center");
        this.add((Component)jPanel8, "Center");
        JPanel jPanel9 = new JPanel(new GridLayout(2, 2));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundEditor.this.playing = false;
                final File file = KiddEd.showImportSoundChooser(SoundEditor.this);
                if (file != null) {
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!SoundEditor.this.sound.replaceSound(SoundEditor.this.soundSelection.getSelectedIndex(), file)) {
                                    JOptionPane.showMessageDialog(SoundEditor.this, TextProvider.get("MessageErrorLoadFile"), TextProvider.get("TitleErrorLoadFile"), 0);
                                }
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(SoundEditor.this, String.valueOf(TextProvider.get("MessageErrorLoadFile")) + "\n" + iOException.getMessage(), TextProvider.get("TitleErrorLoadFile"), 0);
                            }
                        }
                    });
                }
            }
        });
        jPanel9.add(this.buttonImport);
        JButton jButton2 = new JButton(TextProvider.get("ButtonSoundExport"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = KiddEd.showExportSoundChooser(SoundEditor.this, new File(String.valueOf(SoundEditor.this.soundSelection.getSelectedItem().toString().replaceAll("\\s", "_")) + ".psg"));
                if (file != null) {
                    SoundEditor.this.sound.exportSound(SoundEditor.this.soundSelection.getSelectedIndex(), file);
                }
            }
        });
        jPanel9.add(jButton2);
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (SoundEditor.this.playerThread != null) {
                    SoundEditor.this.playing = false;
                }
                if ((n = SoundEditor.this.soundSelection.getSelectedIndex()) >= 48) {
                    n += 3;
                }
                SoundEditor.this.sound.removeSound(n);
            }
        });
        jPanel9.add(this.buttonRemove);
        this.buttonRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SoundEditor.this.playerThread != null) {
                    SoundEditor.this.playing = false;
                }
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        SoundEditor.this.sound.restoreSound(SoundEditor.this.soundSelection.getSelectedIndex());
                    }
                });
            }
        });
        jPanel9.add(this.buttonRestore);
        this.add((Component)jPanel9, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (SoundEditor.this.playerThread != null) {
                    SoundEditor.this.playing = false;
                }
            }
        });
        jCheckBox.setVisible(!sound.isNativeEngine());
        jPanel4.setVisible(sound.hasPriority(this.soundSelection.getSelectedIndex()));
        jPanel5.setVisible(sound.canAdjustTempo());
        this.setResizable(false);
    }

    private void updateSoundNames() {
        int n = this.soundSelection.getItemCount();
        if (this.sound.getSoundCount() != n) {
            String[] stringArray = new String[this.sound.getSoundCount()];
            int n2 = 0;
            while (n2 < n && n2 < stringArray.length) {
                stringArray[n2] = this.soundSelection.getItemAt(n2);
                ++n2;
            }
            n2 = 0;
            int n3 = n;
            while (n3 < stringArray.length) {
                String string;
                if (n3 >= 48) {
                    string = String.valueOf(TextProvider.get("AdditionalMusic")) + " " + (n3 - 48 + 1);
                } else {
                    string = TextProvider.get("SoundName" + n3, true);
                    if (string == null) {
                        string = String.valueOf(TextProvider.get("UnusedSoundEffect")) + " " + ++n2;
                    }
                }
                stringArray[n3] = n3 >= 48 ? String.format("%02X %s", 0x80 | n3 + 3 + 1, string) : String.format("%02X %s", 0x80 | n3 + 1, string);
                ++n3;
            }
            n3 = this.soundSelection.getSelectedIndex();
            this.soundSelection.setModel(new JComboBox<String>(stringArray).getModel());
            if (n3 < 0 || n3 >= this.soundSelection.getItemCount()) {
                n3 = 0;
            }
            this.soundSelection.setSelectedIndex(n3);
        }
    }

    public static void open(JFrame jFrame, Sound sound, int n, Properties properties) {
        if (editor == null) {
            editor = new SoundEditor(sound, n);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        if (SoundEditor.editor.sound != null && SoundEditor.editor.sound != sound) {
            SoundEditor.editor.sound.removeChangeListener(SoundEditor.editor.soundChangeListener);
        }
        SoundEditor.editor.sound = sound;
        SoundEditor.editor.sound.addChangeListener(SoundEditor.editor.soundChangeListener);
        editor.updateSoundNames();
        SoundEditor.editor.engine.setSelectedIndex(sound.isNativeEngine() ? 0 : 1);
        SoundEditor.editor.buttonImport.setEnabled(!SoundEditor.editor.sound.isNativeEngine());
        SoundEditor.editor.add.setEnabled(SoundEditor.editor.sound.canAddSound());
        SoundEditor.editor.buttonRemove.setEnabled(SoundEditor.editor.buttonImport.isEnabled());
        SoundEditor.editor.buttonRestore.setEnabled(sound.canRestoreSound(SoundEditor.editor.soundSelection.getSelectedIndex()));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            if (SoundEditor.editor.playerThread != null) {
                SoundEditor.editor.playing = false;
            }
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            if (SoundEditor.editor.playerThread != null) {
                SoundEditor.editor.playing = false;
            }
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

