/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.Palette;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import panels.PalettePanel;

public class PaletteEditor
extends JDialog {
    private static PaletteEditor editor;
    private Palette[] palettes;
    private final JComboBox<String> paletteSelection;
    private final PalettePanel palettePanel;

    private PaletteEditor(Palette[] paletteArray, int n, String[] stringArray) {
        this.setTitle(TextProvider.get("TitlePalette"));
        this.palettes = paletteArray;
        this.setLayout(new BorderLayout());
        this.paletteSelection = new JComboBox<String>(stringArray);
        this.paletteSelection.setSelectedIndex(n);
        this.palettePanel = new PalettePanel(paletteArray[n]);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.palettePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PaletteEditor.this.palettePanel.getSelectedColorIndex() >= 0) {
                    ColorChooser colorChooser = new ColorChooser(PaletteEditor.this, PaletteEditor.this.palettePanel.getSelectedColor());
                    int n = colorChooser.getColor();
                    if (n >= 0) {
                        PaletteEditor.this.palettePanel.setColor(PaletteEditor.this.palettePanel.getSelectedColorIndex(), n);
                    }
                    PaletteEditor.this.palettePanel.setSelectedColorIndex(-1);
                }
            }
        });
        this.paletteSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                PaletteEditor.this.palettePanel.setPalette(PaletteEditor.this.palettes[jComboBox.getSelectedIndex()]);
            }
        });
        this.add(this.paletteSelection, "North");
        this.add((Component)this.palettePanel, "Center");
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(16, (int)(PaletteEditor.this.palettePanel.getScale() + 16.0f));
                        PaletteEditor.this.palettePanel.setPreferredScale(f);
                        PaletteEditor.this.pack();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(16, (int)(PaletteEditor.this.palettePanel.getScale() - 16.0f));
                    PaletteEditor.this.palettePanel.setPreferredScale(f);
                    PaletteEditor.this.pack();
                }
                mouseWheelEvent.consume();
            }
        });
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(PaletteEditor.this.palettes[PaletteEditor.this.paletteSelection.getSelectedIndex()]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(PaletteEditor.this.palettes[PaletteEditor.this.paletteSelection.getSelectedIndex()]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("CopyPalette0"), 111);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.copyToClipboard(0);
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem3 = new MenuItem(TextProvider.get("CopyPalette1"), 121);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.copyToClipboard(1);
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        menuItem3 = new MenuItem(TextProvider.get("CopyBothPalettes"), 99);
        jMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.copyToClipboard(2);
            }
        });
        menuItem3.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        final MenuItem menuItem4 = new MenuItem(TextProvider.get("PastePalette0"), 97);
        jMenu.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.pasteFromClipboard(0);
            }
        });
        menuItem4.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem5 = new MenuItem(TextProvider.get("PastePalette1"), 115);
        jMenu.add(menuItem5);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.pasteFromClipboard(1);
            }
        });
        menuItem5.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        final MenuItem menuItem6 = new MenuItem(TextProvider.get("PasteBothPalettes"), 112);
        jMenu.add(menuItem6);
        menuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaletteEditor.this.palettePanel.pasteFromClipboard(2);
            }
        });
        menuItem6.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(PaletteEditor.this.palettes[PaletteEditor.this.paletteSelection.getSelectedIndex()]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(PaletteEditor.this.palettes[PaletteEditor.this.paletteSelection.getSelectedIndex()]));
                menuItem4.setEnabled(PaletteEditor.this.palettePanel.canPasteFromClipboard());
                menuItem5.setEnabled(PaletteEditor.this.palettePanel.canPasteFromClipboard());
                menuItem6.setEnabled(PaletteEditor.this.palettePanel.canPasteFromClipboard());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
                menuItem4.setEnabled(true);
                menuItem5.setEnabled(true);
                menuItem6.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    public static void open(JFrame jFrame, Palette[] paletteArray, int n, String[] stringArray, Properties properties) {
        if (editor == null) {
            editor = new PaletteEditor(paletteArray, n, stringArray);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            PaletteEditor.editor.palettes = paletteArray;
            PaletteEditor.editor.paletteSelection.setSelectedIndex(n);
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }

    private class ColorChooser
    extends JDialog {
        private int color;

        public ColorChooser(JDialog jDialog, final int n) {
            super((Dialog)jDialog, true);
            this.color = n;
            this.setTitle(TextProvider.get("TitleColorChooser"));
            this.setCursor(Cursor.getPredefinedCursor(12));
            final JPanel jPanel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension((int)(16.0f * PaletteEditor.this.palettePanel.getScale()), (int)(4.0f * PaletteEditor.this.palettePanel.getScale()));
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    float f = (float)this.getWidth() / 16.0f;
                    float f2 = (float)this.getHeight() / 4.0f;
                    int n7 = 0;
                    while (n7 < 4) {
                        int n2 = 0;
                        while (n2 < 16) {
                            int n3 = n7 * 16 + n2;
                            int n4 = (n3 & 0x30) >> 4;
                            int n5 = (n3 & 0xC) >> 2;
                            int n6 = n3 & 3;
                            graphics.setColor(new Color(n6 * 255 / 3, n5 * 255 / 3, n4 * 255 / 3));
                            graphics.fillRect((int)((float)n2 * f), (int)((float)n7 * f2), (int)(f + 0.5f), (int)(f2 + 0.5f));
                            ++n2;
                        }
                        ++n7;
                    }
                    graphics.setColor(Color.WHITE);
                    graphics.drawRect((int)((float)(n % 16) * f), (int)((float)(n / 16) * f2), (int)(f + 0.5f), (int)(f2 + 0.5f));
                }
            };
            jPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = jPanel.getWidth() / 16;
                    int n2 = jPanel.getHeight() / 4;
                    ColorChooser.this.color = mouseEvent.getY() / n2 * 16 + mouseEvent.getX() / n;
                    ColorChooser.this.setVisible(false);
                }
            });
            this.add((Component)jPanel, "North");
            this.pack();
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
            this.getRootPane().getActionMap().put("Close", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorChooser.this.dispose();
                }
            });
            this.setResizable(false);
            this.setLocation(jDialog.getLocation().x, jDialog.getLocation().y + jDialog.getHeight());
            this.setVisible(true);
        }

        public int getColor() {
            return this.color;
        }
    }
}

