/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.Change;
import changes.ChangeStateListener;
import changes.ChangeWatcher;
import changes.UndoRedoManager;
import common.MacUtilities;
import common.MenuItem;
import common.Properties;
import common.RecentFilesList;
import common.RestartRunnable;
import common.ScreenUtilities;
import common.SourceUtilities;
import common.UpdatableApplication;
import data.CompressedTiles;
import data.TextData;
import data.Tiles;
import editor.Z80Factory;
import editormodels.GameDataModel;
import editormodels.GameEditorModel;
import editormodels.GameEditorModelManager;
import editors.CheckUpdatesDialog;
import editors.EntityLabelProvider;
import editors.FileChooser;
import editors.FileEntityLabelProvider;
import editors.TextProvider;
import hacks.Hack;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import mastersystem.OutputListener;
import mastersystem.Z80;
import patching.IPS;
import rom.RomManager;
import transactions.Transaction;
import transactions.TransactionListener;
import transactions.TransactionManager;
import util.io.IOUtilities;

public class KiddEd
extends JFrame
implements UpdatableApplication {
    public static final String TITLE = KiddEd.class.getSimpleName();
    public static final String VERSION = "0.4";
    public static final int CYCLES_PER_SECOND = 3579545;
    public static final int FRAMES_PER_SECOND = 60;
    private static String[] args;
    private static RecentFilesList recentFiles;
    private static File gameFile;
    private static File romFile;
    private static RandomAccessFile romRAF;
    private static FileLock romLock;
    private int[][] rom = new int[2][];
    protected GameEditorModel gameEditorModel;
    protected GameDataModel gameDataModel;
    protected static KiddEd window;
    protected static boolean expandAlways;
    private static final EntityLabelProvider entityLabelProvider;
    private static boolean shouldHideChanges;
    protected HashSet<Integer> blockedBanks = new HashSet();
    private final JToolBar toolBar;
    private final JMenu menuFile;
    private final JMenu menuEdit;
    private JMenu menuRunInEmulator;
    private static final Thread shutdownHook;
    private static final Runnable RESTART_RUNNABLE;
    protected static final ChangeWatcher changeWatcher;
    private static Thread updateThread;
    private static Runnable updater;
    protected static final Properties properties;

    static {
        recentFiles = new RecentFilesList("Recent", 10, new RecentFilesList.MenuItemActions(){

            @Override
            public boolean isSelected(File file) {
                return false;
            }

            @Override
            public void actionPerformed(File file) {
                window.openFile(file);
            }
        });
        entityLabelProvider = new FileEntityLabelProvider(new File(KiddEd.getHomeDirectory(), "Entities.txt"));
        shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                if (window != null && changeWatcher.hasChanges()) {
                    try {
                        window.saveIPS(new File(KiddEd.getHomeDirectory(), "shutdown.ips"));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                KiddEd.saveSettings();
            }
        });
        RESTART_RUNNABLE = new RestartRunnable(){

            @Override
            protected File getJARFile() {
                File file = KiddEd.getJARfile();
                if (file == null) {
                    file = new File(String.valueOf(TITLE) + ".jar");
                }
                return file;
            }

            @Override
            protected String[] getArgs() {
                return args;
            }
        };
        changeWatcher = new ChangeWatcher(64);
        Properties properties = new Properties();
        properties.setProperty("RomFile", "." + File.separator + "doesnotexist");
        properties.setProperty("PatchDir", ".");
        properties.setProperty("SoundDir", ".");
        properties.setProperty("Animations", "true");
        properties.setProperty("ShowTileAttributes", "false");
        properties.setProperty("ExpandToPowerOf2", "true");
        properties.setProperty("OpenMostRecentOnStartup", "true");
        properties.setProperty("CompressPSG", "true");
        properties.setProperty("Update", "-1");
        properties.setProperty("PhysicsUnit", "0");
        KiddEd.properties = new Properties(properties);
        changeWatcher.addChangeStateListener(new ChangeStateListener(){

            @Override
            public void changeStateChanged() {
                KiddEd.updateTitle();
            }
        });
        UndoRedoManager.getInstance().setChangeWatcher(changeWatcher);
        TransactionManager.getInstance().addTransactionListener(new TransactionListener(){

            @Override
            public void transactionStarted() {
                shouldHideChanges = false;
            }

            @Override
            public void transactionRolledBack(Exception exception) {
                exception.printStackTrace();
            }

            @Override
            public void transactionCommitted(Transaction transaction, boolean bl) {
                if (bl) {
                    changeWatcher.addChange((Change)transaction.getFirst());
                    int[][] nArray = ((Change)transaction.getFirst()).getOldData();
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = nArray[n][0];
                        if (n2 < 360 && (n2 < 59 || n2 > 60) || n2 == 27631) {
                            throw new IllegalArgumentException("Address " + Integer.toHexString(n2) + " is write protected.");
                        }
                        if (n2 >= 34281 && n2 < 34321) {
                            throw new IllegalArgumentException("Address " + Integer.toHexString(n2) + " is write protected.");
                        }
                        if (n2 >= 65536 && n2 < 65632) {
                            throw new IllegalArgumentException("Address " + Integer.toHexString(n2) + " is write protected.");
                        }
                        ++n;
                    }
                }
                if (shouldHideChanges) {
                    changeWatcher.hideChanges();
                }
                shouldHideChanges = false;
            }
        });
    }

    protected KiddEd() {
        super(TextProvider.get("Title"));
        this.setDefaultCloseOperation(0);
        RomManager.StaticAccess.setRom(this.rom);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.menuFile = KiddEd.makeMenuFile();
        jMenuBar.add(this.menuFile);
        this.menuEdit = KiddEd.makeMenuEdit();
        jMenuBar.add(this.menuEdit);
        jMenuBar.add(this.makeMenuView());
        jMenuBar.add(this.makeMenuEditors());
        jMenuBar.add(this.makeMenuSettings());
        jMenuBar.add(KiddEd.makeMenuHacks());
        jMenuBar.add(KiddEd.makeMenuHelp());
        this.toolBar = KiddEd.makeToolBar();
        this.add((Component)this.toolBar, "First");
        this.addWindowListener(new WindowAdapter(){
            private final HashMap<Window, Boolean> visible = new HashMap();

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                KiddEd.exit();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Window[] windowArray = KiddEd.getOwnerlessWindows();
                int n = windowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Window window = windowArray[n2];
                    Window[] windowArray2 = window.getOwnedWindows();
                    int n3 = windowArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Window window2 = windowArray2[n4];
                        if (window2 instanceof JDialog) {
                            this.visible.put(window2, window2.isVisible());
                            window2.setVisible(false);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                Window[] windowArray = KiddEd.getOwnerlessWindows();
                int n = windowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Window window = windowArray[n2];
                    Window[] windowArray2 = window.getOwnedWindows();
                    int n3 = windowArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Window window2 = windowArray2[n4];
                        if (window2 instanceof JDialog) {
                            window2.setVisible(this.visible.containsKey(window2) && this.visible.get(window2) != false);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                this.visible.clear();
                KiddEd.this.toFront();
                KiddEd.this.requestFocus();
            }
        });
        this.addFocusListener(new FocusListener(){
            private boolean toFront;

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (this.toFront && focusEvent.getOppositeComponent() != null) {
                    KiddEd.this.toFront();
                    KiddEd.this.requestFocus();
                }
                this.toFront = false;
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                boolean bl = this.toFront = (KiddEd.this.getExtendedState() & 6) == 0 && focusEvent.getOppositeComponent() == null;
                if (this.toFront) {
                    Window[] windowArray = KiddEd.getOwnerlessWindows();
                    int n = windowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Window window = windowArray[n2];
                        Window[] windowArray2 = window.getOwnedWindows();
                        int n3 = windowArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Window window2 = windowArray2[n4];
                            if (window2 instanceof JDialog && window2.isVisible()) {
                                window2.toFront();
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 67: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        try {
                            System.out.println(new IPS(KiddEd.this.rom[0], romFile));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        break;
                    }
                    case 80: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown() || !keyEvent.isShiftDown()) break;
                        KiddEd.this.parseData();
                        break;
                    }
                    case 82: {
                        KiddEd.this.gameDataModel.printResources();
                        break;
                    }
                    case 87: {
                        if (!keyEvent.isControlDown() || !keyEvent.isAltDown()) break;
                        if (keyEvent.isShiftDown()) {
                            TextProvider.writeEnglishLanguageFile();
                            break;
                        }
                        TextProvider.writeMissingTranslationsFile();
                    }
                }
            }
        });
        this.setFocusable(true);
        try {
            this.setLocation(properties.getInt("WindowX"), properties.getInt("WindowY"));
        }
        catch (NumberFormatException numberFormatException) {}
        if (ScreenUtilities.getScreen(this) == null) {
            this.setLocationByPlatform(true);
        }
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return transferSupport.isDrop() && transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                List list;
                block5: {
                    if (!this.canImport(transferSupport)) {
                        return false;
                    }
                    Transferable transferable = transferSupport.getTransferable();
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (list != null && !list.isEmpty()) break block5;
                    return false;
                }
                try {
                    KiddEd.this.openFile((File)list.get(0));
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return false;
            }
        });
    }

    private static JToolBar makeToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private void updateToolBar() {
        this.toolBar.removeAll();
        this.gameEditorModel.installToolBarButtons(this.toolBar);
    }

    private static JMenu makeMenuFile() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuFile"));
        jMenu.setMnemonic('f');
        return jMenu;
    }

    private void updateMenuFile() {
        MenuItem menuItem3;
        this.menuFile.removeAll();
        MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuNew"), 110);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.this.openROM(romFile, false, true);
            }
        });
        this.menuFile.addSeparator();
        menuItem2 = new MenuItem(String.valueOf(TextProvider.get("MenuOpen")) + "...", 111);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.this.showOpenGameFileChooser(window);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuFile.add(KiddEd.makeMenuOpenRecent());
        menuItem2 = new MenuItem(String.valueOf(TextProvider.get("MenuApplyPatch")) + "...", 112);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.this.showPatchFileChooser(window);
            }
        });
        this.menuFile.addSeparator();
        menuItem2 = new MenuItem(TextProvider.get("MenuSave"), 115);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (gameFile == null) {
                        KiddEd.this.showSaveGameFileChooser(window);
                    } else if (gameFile.getName().toLowerCase().endsWith(".ips")) {
                        KiddEd.this.saveIPS(gameFile);
                    } else {
                        KiddEd.this.saveROM(gameFile, false);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                }
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem2 = new MenuItem(String.valueOf(TextProvider.get("MenuSaveAs")) + "...", 97);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    KiddEd.this.showSaveGameFileChooser(window);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                }
            }
        });
        this.menuFile.addSeparator();
        List<MenuItem> list = this.gameEditorModel.getImportExportMenuItems();
        if (!list.isEmpty()) {
            for (final MenuItem menuItem3 : list) {
                this.menuFile.add(menuItem3);
            }
            this.menuFile.addSeparator();
        }
        menuItem3 = new MenuItem(String.valueOf(TextProvider.get("MenuExpand")) + " 256K");
        this.menuFile.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RomManager.StaticAccess.expandTo(16);
            }
        });
        final MenuItem menuItem4 = new MenuItem(String.valueOf(TextProvider.get("MenuExpand")) + " 512K");
        this.menuFile.add(menuItem4);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RomManager.StaticAccess.expandTo(32);
            }
        });
        final MenuItem menuItem5 = new MenuItem(String.valueOf(TextProvider.get("MenuExpand")) + " 1M");
        this.menuFile.add(menuItem5);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RomManager.StaticAccess.expandTo(64);
            }
        });
        this.menuFile.addSeparator();
        this.menuRunInEmulator = KiddEd.makeMenuRunInEmulator();
        this.menuFile.add(this.menuRunInEmulator);
        this.menuFile.addSeparator();
        menuItem2 = new MenuItem(String.valueOf(TextProvider.get("MenuSelectROM")) + "...");
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.this.showROMFileChooser(window);
            }
        });
        this.menuFile.addSeparator();
        menuItem2 = new MenuItem(TextProvider.get("MenuExit"), 120);
        this.menuFile.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.exit();
            }
        });
        this.menuFile.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                int n = RomManager.StaticAccess.getRomLength();
                menuItem3.setEnabled(n / 16384 < 16);
                menuItem4.setEnabled(n / 16384 < 32);
                menuItem5.setEnabled(n / 16384 < 64);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem3.setEnabled(true);
                menuItem4.setEnabled(true);
                menuItem5.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private static JMenu makeMenuOpenRecent() {
        final JMenu jMenu = new JMenu(TextProvider.get("MenuOpenRecent"));
        jMenu.setMnemonic('r');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                for (JRadioButtonMenuItem jMenuItem2 : recentFiles.generateMenuItems()) {
                    jMenu.add(jMenuItem2);
                }
                jMenu.addSeparator();
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TextProvider.get("MenuOpenMostRecentOnStartup"), Boolean.parseBoolean(properties.getProperty("OpenMostRecentOnStartup")));
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        properties.setProperty("OpenMostRecentOnStartup", "" + jCheckBoxMenuItem.isSelected());
                    }
                });
                jMenu.add(jCheckBoxMenuItem);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        if (recentFiles.isEmpty()) {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    private static JMenu makeMenuRunInEmulator() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuRunInEmulator"));
        jMenu.setMnemonic('e');
        return jMenu;
    }

    private void updateMenuRunInEmulator() {
        this.menuRunInEmulator.removeAll();
        MenuItem menuItem = new MenuItem(TextProvider.get("MenuRunROMinEmulator"));
        this.menuRunInEmulator.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.this.runInEmulator();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        for (MenuItem menuItem2 : this.gameEditorModel.getRunInEmulatorMenuItems()) {
            this.menuRunInEmulator.add(menuItem2);
        }
        this.menuRunInEmulator.addSeparator();
        menuItem = new MenuItem(String.valueOf(TextProvider.get("MenuSelectEmulator")) + "...");
        this.menuRunInEmulator.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KiddEd.showEmulatorFileChooser();
            }
        });
    }

    private static JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        return jMenu;
    }

    private void updateMenuEdit() {
        this.menuEdit.removeAll();
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        this.menuEdit.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                changeWatcher.undo();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        this.menuEdit.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                changeWatcher.redo();
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuEdit.addSeparator();
        this.gameEditorModel.installEditMenuItems(this.menuEdit);
        this.menuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(changeWatcher.canUndo());
                menuItem2.setEnabled(changeWatcher.canRedo());
                if (menuItem.isEnabled()) {
                    menuItem.setText(String.valueOf(TextProvider.get("MenuUndo")) + " " + changeWatcher.getUndoChangeName());
                }
                if (menuItem2.isEnabled()) {
                    menuItem2.setText(String.valueOf(TextProvider.get("MenuRedo")) + " " + changeWatcher.getRedoChangeName());
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuView"));
        jMenu.setMnemonic('v');
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TextProvider.get("MenuAnimations"), Boolean.parseBoolean(properties.getProperty("Animations")));
        jCheckBoxMenuItem.setMnemonic('a');
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("Animations", "" + jCheckBoxMenuItem.isSelected());
                if (jCheckBoxMenuItem.isSelected()) {
                    if (updateThread != null) {
                        updateThread.interrupt();
                    }
                    KiddEd.startAnimationUpdater();
                } else {
                    updateThread.interrupt();
                }
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem2 = this.makeSettingsMenuItem("ShowTileAttributes", 't');
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        jMenu.add(this.makeSettingsMenuItem("IntegerScaling", 'i'));
        return jMenu;
    }

    private JMenu makeMenuEditors() {
        final JMenu jMenu = new JMenu(TextProvider.get("MenuEditors"));
        jMenu.setMnemonic('t');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                for (MenuItem menuItem : KiddEd.this.gameEditorModel.getEditorMenuItems()) {
                    jMenu.add(menuItem);
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JMenu makeMenuSettings() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuSettings"));
        jMenu.setMnemonic('s');
        jMenu.add(KiddEd.makeMenuLanguage());
        jMenu.add(this.makeSettingsMenuItem("ExpandToPowerOf2", 'e'));
        return jMenu;
    }

    private JCheckBoxMenuItem makeSettingsMenuItem(final String string, char c) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TextProvider.get("Settings" + string), Boolean.parseBoolean(properties.getProperty(string)));
        jCheckBoxMenuItem.setMnemonic(c);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty(string, "" + jCheckBoxMenuItem.isSelected());
                KiddEd.this.settingChanged(string, Boolean.parseBoolean(properties.getProperty(string)));
            }
        });
        return jCheckBoxMenuItem;
    }

    private void settingChanged(String string, boolean bl) {
        this.gameEditorModel.settingChanged(string, bl);
    }

    private static JMenu makeMenuLanguage() {
        final JMenu jMenu = new JMenu(TextProvider.get("MenuLanguage"));
        jMenu.setMnemonic('l');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add("en");
                String object = TextProvider.get("MenuLanguageSystem");
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(object, properties.getProperty("Language") == null);
                jMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        properties.remove("Language");
                        int n = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageLanguageRestart"), TextProvider.get("TitleLanguageRestart"), 0);
                        if (n == 0) {
                            KiddEd.restart();
                        }
                    }
                });
                File file = new File(KiddEd.getHomeDirectory(), "lang");
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File object2 = fileArray[n2];
                        if (object2.getName().toLowerCase().endsWith(".ini")) {
                            linkedHashSet.add(object2.getName().substring(0, object2.getName().lastIndexOf(46)));
                        }
                        ++n2;
                    }
                }
                for (final String string : linkedHashSet) {
                    object = TextProvider.get("MenuLanguage" + Character.toUpperCase(string.charAt(0)) + string.substring(1));
                    if (object == null) {
                        object = string;
                    }
                    jCheckBoxMenuItem = new JCheckBoxMenuItem(object, string.equals(properties.getProperty("Language")));
                    jMenu.add(jCheckBoxMenuItem);
                    jCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            properties.setProperty("Language", string);
                            int n = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageLanguageRestart"), TextProvider.get("TitleLanguageRestart"), 0);
                            if (n == 0) {
                                KiddEd.restart();
                            }
                        }
                    });
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private static JMenu makeMenuHacks() {
        final JMenu jMenu = new JMenu(TextProvider.get("MenuHacks"));
        jMenu.setMnemonic('a');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                Hack[] hackArray;
                jMenu.removeAll();
                Hack[] hackArray2 = hackArray = KiddEd.window.gameDataModel.getHacks();
                int n = hackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final Hack hack = hackArray2[n2];
                    final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(hack.toString());
                    jCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TransactionManager.getInstance().runTransaction(new Runnable(){

                                @Override
                                public void run() {
                                    TransactionManager.getInstance().addTransactionObject(hack.getChangable(), 0);
                                    if (jCheckBoxMenuItem.isSelected()) {
                                        hack.apply();
                                    } else {
                                        hack.unapply();
                                    }
                                }
                            });
                        }
                    });
                    jMenu.add(jCheckBoxMenuItem);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < hackArray.length) {
                    jMenu.getItem(n3).setSelected(hackArray[n3].isApplied());
                    ++n3;
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private static JMenu makeMenuHelp() {
        MenuItem menuItem;
        JMenu jMenu = new JMenu(TextProvider.get("MenuHelp"));
        jMenu.setMnemonic('h');
        if (Desktop.isDesktopSupported()) {
            final Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                menuItem = new MenuItem(TextProvider.get("MenuVisitHomepage"), 104);
                jMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            desktop.browse(new URL("https://kidded.emulicious.net").toURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menuItem = new MenuItem(TextProvider.get("MenuJoinCommunity"), 99);
                jMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            desktop.browse(new URL("https://discord.gg/DTVx5Da").toURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                menuItem = new MenuItem(TextProvider.get("MenuContactAuthor"), 97);
                jMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            desktop.browse(new URL("https://emulicious.net/?page_id=129").toURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                menuItem = new MenuItem(TextProvider.get("MenuReportBug"), 98);
                jMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            desktop.mail(new URI("mailto", "kidded@emulicious.net?BODY=Operating System(choose one, delete others): Windows/Linux/Mac OS(X)\nEditor the bug occurred with:\nBug description:", null));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        menuItem = new MenuItem(String.valueOf(TextProvider.get("MenuConfigureUpdates")) + "...", 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckUpdatesDialog checkUpdatesDialog = new CheckUpdatesDialog(window, window, properties.getInt("Update"));
                int n = checkUpdatesDialog.getResult();
                properties.setProperty("Update", "" + n);
            }
        });
        return jMenu;
    }

    public static File showImportSoundChooser(Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(properties.getProperty("SoundDir")));
        jFileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleSelectSound")) + "...");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterSoundAllSupported")) + " (*.vgm;*.vgz;*.psg;*.psgc)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".vgm") || file.getName().toLowerCase().endsWith(".vgz") || file.getName().toLowerCase().endsWith(".psg") || file.getName().toLowerCase().endsWith(".psgc") || file.isDirectory();
            }
        });
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterPSG")) + " (*.psg;*.psgc)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".psg") || file.getName().toLowerCase().endsWith(".psgc") || file.isDirectory();
            }
        });
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterVGM")) + " (*.vgm;*.vgz)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".vgm") || file.getName().toLowerCase().endsWith(".vgz") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            properties.setProperty("SoundDir", jFileChooser.getSelectedFile().getParent());
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File showExportSoundChooser(Component component, File file) {
        FileChooser fileChooser = new FileChooser(new File(properties.getProperty("SoundDir")));
        fileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleExportSoundAs")) + "...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterPSG")) + " (*.psg)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".psg") || file.isDirectory();
            }
        });
        fileChooser.setSelectedFile(file);
        if (fileChooser.showSaveDialog(component) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private boolean showROMFileChooser(Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(properties.getProperty("RomFile")).getParentFile());
        jFileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleSelectROM")) + "...");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterROM")) + " (*.sms)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sms") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            return this.openROM(jFileChooser.getSelectedFile(), true, true);
        }
        return false;
    }

    private void showSaveGameFileChooser(Component component) throws IOException {
        File file = romFile.getParentFile();
        if (gameFile != null) {
            file = gameFile.getParentFile();
        }
        if (!recentFiles.isEmpty()) {
            file = recentFiles.iterator().next().getParentFile();
        }
        FileChooser fileChooser = new FileChooser(file);
        fileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleSaveGameAs")) + "...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterAllSupported")) + " (*.sms;*.ips)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sms") || file.getName().toLowerCase().endsWith(".ips") || file.isDirectory();
            }
        });
        if (gameFile != null) {
            fileChooser.setSelectedFile(gameFile);
        } else {
            fileChooser.setSelectedFile(new File("Untitled.ips"));
        }
        if (fileChooser.showSaveDialog(component) == 0) {
            File file2;
            File file3 = fileChooser.getSelectedFile();
            String string = file3.getName();
            File file4 = file2 = !file3.exists() && string.indexOf(46) < 0 ? new File(file3.getParentFile(), String.valueOf(string) + ".ips") : file3;
            if (file2.getName().toLowerCase().endsWith(".ips")) {
                this.saveIPS(file2);
            } else {
                this.saveROM(file2, false);
            }
        }
    }

    private void showOpenGameFileChooser(Component component) {
        File file = romFile.getParentFile();
        if (!recentFiles.isEmpty()) {
            file = recentFiles.iterator().next().getParentFile();
        }
        if (gameFile != null) {
            file = gameFile.getParentFile();
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleOpenGame")) + "...");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterAllSupported")) + " (*.sms;*.ips)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sms") || file.getName().toLowerCase().endsWith(".ips") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            this.openFile(jFileChooser.getSelectedFile());
        }
    }

    private void showPatchFileChooser(Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(properties.getProperty("PatchDir")));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterIPS")) + " (*.ips)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".ips") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(component) == 0) {
            properties.setProperty("PatchDir", jFileChooser.getSelectedFile().getParent());
            this.applyPatch(jFileChooser.getSelectedFile());
        }
    }

    private static File showEmulatorFileChooser() {
        String string = properties.getProperty("Emulator");
        File file = new File(".");
        if (string != null) {
            file = new File(string).getParentFile();
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(String.valueOf(TextProvider.get("TitleSelectEmulator")) + "...");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return String.valueOf(TextProvider.get("FilterExecutable")) + " (*.jar;*.exe;*.app)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".exe") || file.getName().toLowerCase().endsWith(".app") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(window) == 0) {
            properties.setProperty("Emulator", jFileChooser.getSelectedFile().getPath());
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private static void exit() {
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {}
        if (changeWatcher.hasChanges()) {
            int n = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageUnsavedChanges"));
            if (n == 2) {
                return;
            }
            if (n == 0) {
                try {
                    if (gameFile == null) {
                        window.showSaveGameFileChooser(window);
                    } else if (gameFile.getName().toLowerCase().endsWith(".ips")) {
                        window.saveIPS(gameFile);
                    } else {
                        window.saveROM(gameFile, false);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                    return;
                }
            }
        }
        File file = new File(KiddEd.getHomeDirectory(), "temp.sms");
        file.delete();
        KiddEd.saveSettings();
        try {
            if (romRAF != null) {
                romLock.release();
                romRAF.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void saveSettings() {
        if (!window.isVisible()) {
            return;
        }
        try {
            recentFiles.save(properties);
            properties.setProperty("WindowWidth", "" + window.getWidth());
            properties.setProperty("WindowHeight", "" + window.getHeight());
            properties.setProperty("WindowX", "" + window.getX());
            properties.setProperty("WindowY", "" + window.getY());
            properties.setProperty("WindowExtendedState", "" + window.getExtendedState());
            if (KiddEd.window.gameEditorModel != null) {
                KiddEd.window.gameEditorModel.saveEditorStates();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(KiddEd.getConfigFile());
            properties.store(fileOutputStream, String.valueOf(TITLE) + " settings file");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void loadSettings() {
        try {
            FileInputStream fileInputStream = new FileInputStream(KiddEd.getConfigFile());
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        recentFiles.load(properties);
        TextProvider.setLanguage(properties.getProperty("Language"));
    }

    @Override
    public String getApplicationTitle() {
        return TITLE;
    }

    @Override
    public void checkUpdates(final boolean bl, final boolean bl2) {
        final ProgressMonitor progressMonitor = new ProgressMonitor(window, String.valueOf(TextProvider.get("MonitorUpdating")) + " " + TITLE + "...", "", 0, 100);
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){
            private boolean update;

            @Override
            protected Boolean doInBackground() throws Exception {
                Boolean bl3 = Boolean.FALSE;
                this.setProgress(0);
                if (KiddEd.this.isUpdateAvailable()) {
                    this.update = !bl ? JOptionPane.showConfirmDialog(window, TextProvider.get("MessageUpdateAvailable").replace("{}", TITLE), String.valueOf(TITLE) + " " + TextProvider.get("TitleUpdateAvailable"), 0) == 0 : true;
                } else {
                    properties.remove("UpdateVersion");
                }
                if (this.update) {
                    if (bl2 && KiddEd.VERSION.equals(properties.getProperty("UpdateVersion"))) {
                        return Boolean.FALSE;
                    }
                    File file = KiddEd.getJARfile();
                    if (file == null || !file.exists()) {
                        return Boolean.FALSE;
                    }
                    properties.setProperty("UpdateVersion", KiddEd.VERSION);
                    this.setProgress(1);
                    try {
                        if (KiddEd.this.gameEditorModel != null) {
                            KiddEd.this.gameEditorModel.closeEditors();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        byte[] byArray = new byte[8192];
                        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new URL("http://emulicious.net/?wpdmact=process&did=NS5ob3RsaW5r").openStream()));
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            File file2 = new File(KiddEd.getHomeDirectory(), zipEntry.getName());
                            if (file2.getParentFile() != null) {
                                file2.getParentFile().mkdirs();
                            }
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            long l = zipEntry.getSize();
                            int n = 0;
                            int n2 = zipInputStream.read(byArray);
                            while (n2 > 0) {
                                fileOutputStream.write(byArray, 0, n2);
                                if (l > (long)byArray.length) {
                                    this.setProgress(1 + (int)((long)((n += n2) * 99) / l));
                                }
                                n2 = zipInputStream.read(byArray);
                            }
                            fileOutputStream.close();
                            zipEntry = zipInputStream.getNextEntry();
                        }
                        zipInputStream.close();
                        bl3 = Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return bl3;
            }

            @Override
            protected void done() {
                if (!this.update) {
                    return;
                }
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        JOptionPane.showMessageDialog(window, TextProvider.get("MessageUpdateSuccessful"));
                        KiddEd.restart();
                    } else {
                        progressMonitor.close();
                        JOptionPane.showMessageDialog(window, TextProvider.get("MessageUpdateFailed").replace("{}", TITLE), String.valueOf(TITLE) + " " + TextProvider.get("TitleUpdateFailed"), 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    progressMonitor.setProgress(n);
                    progressMonitor.setNote(String.valueOf(TextProvider.get("MonitorCompleted")) + " " + n + "%");
                }
            }
        });
        swingWorker.execute();
    }

    @Override
    public boolean isUpdateAvailable() throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("http://www.emulicious.net/update-kidded.php?version=0.4").openConnection();
        httpURLConnection.setRequestMethod("GET");
        if (httpURLConnection.getResponseCode() == 410) {
            return true;
        }
        if (httpURLConnection.getResponseCode() == 200) {
            return false;
        }
        throw new RuntimeException("Failed to connect to update server: " + httpURLConnection.getResponseMessage());
    }

    public static boolean shouldCompressPSG() {
        return Boolean.parseBoolean(properties.getProperty("CompressPSG"));
    }

    protected boolean openROM(File file, boolean bl, boolean bl2) {
        int[] nArray;
        block27: {
            int n;
            byte[] byArray;
            block25: {
                block26: {
                    if (bl2 && changeWatcher.hasChanges()) {
                        int n2 = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageUnsavedChanges"));
                        if (n2 == 2) {
                            return false;
                        }
                        if (n2 == 0) {
                            try {
                                if (gameFile == null) {
                                    this.showSaveGameFileChooser(window);
                                } else if (gameFile.getName().toLowerCase().endsWith(".ips")) {
                                    this.saveIPS(gameFile);
                                } else {
                                    this.saveROM(gameFile, false);
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                                return false;
                            }
                        }
                    }
                    if (file == null) {
                        file = new File(properties.getProperty("RomFile"));
                    }
                    if (!file.exists()) {
                        return false;
                    }
                    nArray = null;
                    if (this.rom[0] != null) {
                        nArray = RomManager.StaticAccess.readBytes(new int[this.rom[0].length], 0);
                    }
                    byArray = IOUtilities.toByteArray(new FileInputStream(file));
                    this.gameEditorModel = GameEditorModelManager.createGameEditorModel(byArray, window);
                    this.gameDataModel = this.gameEditorModel.getDataModel();
                    if (!bl || this.gameDataModel != null) break block25;
                    n = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageWarningLoadROM"), TextProvider.get("TitleWarningLoadROM"), 0);
                    if (n == 0) {
                        return this.showROMFileChooser(window);
                    }
                    if (n != 2) break block26;
                    return false;
                }
                if (n != 1) break block25;
                return false;
            }
            this.updateMenuFile();
            this.updateMenuEdit();
            this.updateMenuRunInEmulator();
            this.updateToolBar();
            this.rom[0] = new int[byArray.length];
            n = 0;
            while (n < byArray.length) {
                this.rom[0][n] = byArray[n] & 0xFF;
                ++n;
            }
            this.rom[1] = Arrays.copyOf(this.rom[0], this.rom[0].length);
            romFile = file;
            try {
                if (romRAF != null) {
                    romLock.release();
                    romRAF.close();
                }
                romRAF = new RandomAccessFile(file, "r");
                romLock = romRAF.getChannel().lock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl2) break block27;
            return true;
        }
        try {
            this.parseData();
            gameFile = null;
            KiddEd.updateTitle();
            properties.setProperty("RomFile", file.getAbsolutePath());
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.rom[0] = nArray;
            if (this.rom[0] == null) {
                this.rom[1] = null;
            } else {
                this.rom[1] = Arrays.copyOf(this.rom[0], this.rom[0].length);
                this.parseData();
            }
            exception.printStackTrace();
            JOptionPane.showMessageDialog(window, TextProvider.get("MessageErrorLoadROM"), TextProvider.get("TitleErrorLoadROM"), 0);
        }
        return false;
    }

    protected boolean openFile(File file) {
        return this.openFile(file, true);
    }

    private boolean openFile(File file, boolean bl) {
        if (changeWatcher.hasChanges()) {
            int n = JOptionPane.showConfirmDialog(window, TextProvider.get("MessageUnsavedChanges"));
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                try {
                    if (gameFile == null) {
                        this.showSaveGameFileChooser(window);
                    } else if (gameFile.getName().toLowerCase().endsWith(".ips")) {
                        this.saveIPS(gameFile);
                    } else {
                        this.saveROM(gameFile, false);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                    return false;
                }
            }
        }
        int[] nArray = null;
        if (this.rom[0] != null) {
            nArray = RomManager.StaticAccess.readBytes(new int[this.rom[0].length], 0);
        }
        try {
            String string = file.getAbsolutePath();
            if (string.toLowerCase().endsWith(".ips")) {
                this.openROM(romFile, false, false);
                IPS iPS = new IPS(file);
                this.rom[0] = iPS.apply(this.rom[0]);
            } else {
                byte[] byArray = IOUtilities.toByteArray(new FileInputStream(file));
                this.rom[0] = new int[byArray.length];
                int n = 0;
                while (n < byArray.length) {
                    this.rom[0][n] = byArray[n] & 0xFF;
                    ++n;
                }
            }
            this.parseData();
            if (bl) {
                recentFiles.add(file);
                gameFile = file;
                KiddEd.updateTitle();
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rom[0] = nArray;
            this.parseData();
            JOptionPane.showMessageDialog(window, TextProvider.get("MessageErrorLoadFile"), TextProvider.get("TitleErrorLoadFile"), 0);
        }
        return false;
    }

    private void applyPatch(File file) {
        try {
            IPS iPS = new IPS(file);
            if (iPS.calculateSize() > 2048 && JOptionPane.showConfirmDialog(window, TextProvider.get("MessageWarningBigPatch"), TextProvider.get("TitleWarningBigPatch"), 0) == 1) {
                return;
            }
            int[] nArray = KiddEd.window.rom[0];
            KiddEd.applyPatch(iPS);
            try {
                this.parseData();
                changeWatcher.hideChanges();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                KiddEd.window.rom[0] = nArray;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorLoadFile")) + ":\n" + iOException.getMessage(), TextProvider.get("TitleErrorLoadFile"), 0);
        }
    }

    public static void applyPatch(IPS iPS) {
        KiddEd.window.rom[0] = iPS.apply(KiddEd.window.rom[0]);
        changeWatcher.hideChanges();
    }

    public static void runWithOriginalROM(Runnable runnable) {
        boolean bl = KiddEd.stopAnimationUpdater();
        int[] nArray = KiddEd.window.rom[0];
        KiddEd.window.rom[0] = KiddEd.window.rom[1];
        try {
            runnable.run();
        }
        finally {
            KiddEd.window.rom[0] = nArray;
            if (bl) {
                KiddEd.startAnimationUpdater();
            }
        }
    }

    private void prepareSave() {
        boolean bl = changeWatcher.hasChanges();
        this.gameDataModel.prepareSave();
        try {
            RomManager.StaticAccess.writeWord(32762, KiddEd.calcSEGAchecksum());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!bl) {
            changeWatcher.clearChangesFlag();
        }
    }

    private void saveROM(File file, boolean bl) throws IOException {
        this.prepareSave();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[RomManager.StaticAccess.getRomLength()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)RomManager.StaticAccess.readByte(n);
            ++n;
        }
        ((OutputStream)fileOutputStream).write(byArray);
        ((OutputStream)fileOutputStream).close();
        if (!bl) {
            recentFiles.add(file);
            gameFile = file;
            changeWatcher.clearChangesFlag();
            KiddEd.updateTitle();
        }
    }

    private void saveIPS(File file) throws IOException {
        this.prepareSave();
        IPS iPS = new IPS(this.rom[0], romFile);
        iPS.writeToFile(file);
        recentFiles.add(file);
        gameFile = file;
        changeWatcher.clearChangesFlag();
        KiddEd.updateTitle();
    }

    private static int calcSEGAchecksum() throws IOException {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 32768);
        RomManager.StaticAccess.loadBank2(nArray, 2);
        Z80 z80 = Z80Factory.create(nArray);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                }
            }
        });
        byte[] byArray = IOUtilities.toByteArray(Thread.currentThread().getContextClassLoader().getResourceAsStream("checksum.sms"));
        int n = 0;
        while (n < byArray.length) {
            nArray[50944 + n] = byArray[n] & 0xFF;
            ++n;
        }
        z80.execute(50944);
        if (nArray[49152] > 0) {
            return nArray[49681] << 8 | nArray[49680];
        }
        throw new IOException("Failed to detect ROM Header.");
    }

    private void parseData() {
        KiddEd.stopAnimationUpdater();
        this.gameDataModel.parseData();
        TransactionManager.getInstance().reset();
        changeWatcher.reset();
        this.blockedBanks.clear();
        this.updateUIcomponents();
        this.destroyEditors();
        this.createAnimationUpdater();
        this.reopenEditors();
    }

    protected void updateUIcomponents() {
        this.gameEditorModel.updateUIcomponents();
    }

    protected void createAnimationUpdater() {
        final Runnable runnable = this.gameEditorModel.createAnimationUpdater();
        updater = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                updateThread = null;
            }
        };
        if (Boolean.parseBoolean(properties.getProperty("Animations"))) {
            KiddEd.startAnimationUpdater();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean stopAnimationUpdater() {
        if (KiddEd.updateThread != null) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            var0.interrupt();
lbl4:
            // 2 sources

            ** while ((var0 = KiddEd.updateThread) != null)
        }
lbl5:
        // 1 sources

        return true;
    }

    public static void startAnimationUpdater() {
        updateThread = new Thread(updater, "Updater");
        updateThread.start();
    }

    protected void reopenEditors() {
        if (this.gameEditorModel != null) {
            this.gameEditorModel.reopenEditors();
        }
    }

    protected void destroyEditors() {
        if (this.gameEditorModel != null) {
            this.gameEditorModel.destroyEditors();
            System.gc();
        }
    }

    public static void runWithBlockedBank(int n, Runnable runnable) {
        boolean bl = KiddEd.window.blockedBanks.add(n);
        try {
            runnable.run();
        }
        finally {
            if (bl) {
                KiddEd.window.blockedBanks.remove(n);
            }
        }
    }

    public static int findRLEpattern(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = 0;
            while ((RomManager.StaticAccess.readByte(n3 + n4) & 0x80) != 0 && (n3 + n4 & 0x3FFF) >= (n3 & 0x3FFF)) {
                n4 += (RomManager.StaticAccess.readByte(n3 + n4) & 0x7F) + 1;
            }
            if (n4 > 0 && n3 + n4 < n2 && RomManager.StaticAccess.readByte(n3 + n4) == 0) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int getRLElength(int n) {
        int n2 = 0;
        int n3 = n;
        while (n2 < 16384 && RomManager.StaticAccess.readByte(n3) > 0) {
            int n4 = RomManager.StaticAccess.readByte(n3) & 0x7F;
            n2 += n4;
            n3 = (RomManager.StaticAccess.readByte(n3) & 0x80) != 0 ? (n3 += n4) : ++n3;
            ++n3;
        }
        return n2;
    }

    public static int getRunLengthAt(int n) {
        return KiddEd.getRunLength(RomManager.StaticAccess.readByte(n));
    }

    public static int getRunLength(int n) {
        return (n - 1 & 0x7F) + 1;
    }

    private static void expand() {
        if (Boolean.parseBoolean(properties.getProperty("ExpandToPowerOf2"))) {
            RomManager.StaticAccess.expandToNextPowerOf2();
        } else {
            RomManager.StaticAccess.addBanks(1);
        }
    }

    public static int findFreeBlock(int n) {
        int n2 = KiddEd.findFreeBlock(n, false);
        if (n2 < 0 && RomManager.StaticAccess.canExpand() && (expandAlways || JOptionPane.showConfirmDialog(window, TextProvider.get("MessageExpand"), TextProvider.get("TitleExpand"), 0) == 0)) {
            return KiddEd.findFreeBlock(n, true);
        }
        return n2;
    }

    public static int findFreeBlock(int n, int n2) {
        return KiddEd.findFreeBlock(n, n2, false);
    }

    public static int findFreeBlock(int n, boolean bl) {
        return KiddEd.findFreeBlock(n, 0, bl);
    }

    public static int findFreeBlock(int n, int n2, boolean bl) {
        if (n <= 0 || n > 16384) {
            throw new IllegalArgumentException("Size must be greater than 0 and at most the size of a bank but was: " + n);
        }
        int n3 = 0;
        int n4 = RomManager.StaticAccess.getRomLength();
        if (n2 >= 1) {
            n3 = n2 * 16384;
            n4 = n3 + 16384;
            bl = false;
        }
        if (n3 < 360) {
            n3 = 360;
        }
        if (n < 4) {
            n = 4;
        }
        TextData textData = KiddEd.window.gameDataModel.getTextData();
        Tiles[] tilesArray = KiddEd.window.gameDataModel.getTiles();
        int n5 = textData.getLastByteOfEndingSequence();
        int n6 = -1;
        int n7 = n3;
        int n8 = 0;
        while (bl || n7 + n <= n4) {
            if (bl && n7 + n >= n4) {
                KiddEd.expand();
                if (RomManager.StaticAccess.getRomLength() == n4) {
                    return -1;
                }
                n4 = RomManager.StaticAccess.getRomLength();
            }
            if (n7 + n <= n4 && RomManager.StaticAccess.readByte(n7 + n - 1) != 255) {
                n7 += n;
            }
            if (n7 == n5) {
                ++n7;
            }
            int n9 = n7 / 16384;
            while (n7 + n <= n4 && ((n7 & 0x3FFF) + n > 16384 || n9 != n6 && KiddEd.window.blockedBanks.contains(n9))) {
                n7 = (n7 & 0xFFFFC000) + 16384;
                ++n9;
            }
            n6 = n9;
            while (n7 + n <= n4 && RomManager.StaticAccess.readByte(n7 + n8) == 255 && RomManager.StaticAccess.readByte(n7 + n - 1 - n8) == 255 && (n7 & 0x3FFF) + n <= 16384) {
                if (n8 >= (n - 1) / 2 + 1) {
                    n8 *= 2;
                    break;
                }
                ++n8;
            }
            if (n8 >= n) {
                if (tilesArray != null) {
                    Tiles[] tilesArray2 = tilesArray;
                    int n10 = tilesArray.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        Tiles tiles = tilesArray2[n11];
                        if (n7 / 16384 == tiles.getSource() / 16384) {
                            if (tiles instanceof CompressedTiles) {
                                int n12 = KiddEd.getRLElength(tiles.getSource());
                                int n13 = (n12 + (n12 - 1) / 127 + 1 + 1) * tiles.getBPP();
                                if (tiles.getSource() < n7 + n8 && (tiles.getSource() >= n7 || tiles.getSource() + n13 > n7)) {
                                    n7 = tiles.getSource() + n13 - 1;
                                    n8 = 0;
                                    break;
                                }
                            } else if (tiles.getSource() < n7 + n8 && (tiles.getSource() >= n7 || tiles.getSource() + tiles.getSize() > n7)) {
                                n7 = tiles.getSource() + tiles.getSize() - 1;
                                n8 = 0;
                                break;
                            }
                        }
                        ++n11;
                    }
                }
                if (n8 >= n) {
                    return n7;
                }
            }
            n7 += Math.max(1, n8);
            n8 = 0;
        }
        if (n2 >= 1) {
            return KiddEd.window.gameDataModel.makeSpace(n, n2);
        }
        return -1;
    }

    public static int[] findFreeBlocks(int[] nArray) {
        int[] nArray2 = KiddEd.findFreeBlocks(nArray, false);
        if (nArray2 == null && RomManager.StaticAccess.canExpand() && JOptionPane.showConfirmDialog(window, TextProvider.get("MessageExpand"), TextProvider.get("TitleExpand"), 0) == 0) {
            return KiddEd.findFreeBlocks(nArray, true);
        }
        return nArray2;
    }

    public static int[] findFreeBlocks(int[] nArray, boolean bl) {
        int n = 0;
        while (bl || n < RomManager.StaticAccess.getRomLength() / 16384) {
            int[] nArray2;
            if (bl && n >= KiddEd.window.rom[0].length / 16384) {
                int n2 = KiddEd.window.rom[0].length;
                KiddEd.expand();
                if (KiddEd.window.rom[0].length == n2) {
                    return null;
                }
            }
            if ((nArray2 = KiddEd.findFreeBlocks(nArray, n)) != null) {
                return nArray2;
            }
            ++n;
        }
        return null;
    }

    public static int[] findFreeBlocks(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        Arrays.fill(nArray2, -1);
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray[n2] > 0) {
                nArray2[n2] = KiddEd.findFreeBlock(nArray[n2], n, false);
                if (nArray2[n2] < 0) break;
                RomManager.StaticAccess.fill(nArray2[n2], nArray2[n2] + nArray[n2], 0);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray2[n2] >= 0) {
                RomManager.StaticAccess.fill(nArray2[n2], nArray2[n2] + nArray[n2], 255);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray[n2] > 0 && nArray2[n2] < 0) {
                return null;
            }
            ++n2;
        }
        return nArray2;
    }

    public static boolean ensureFreeBlocks(int[] nArray) {
        int[] nArray2 = KiddEd.findFreeBlocks(nArray, -1);
        if (nArray2 == null && RomManager.StaticAccess.canExpand() && (expandAlways || JOptionPane.showConfirmDialog(window, TextProvider.get("MessageExpand"), TextProvider.get("TitleExpand"), 0) == 0)) {
            KiddEd.expand();
            return true;
        }
        return nArray2 != null;
    }

    public static void clearChanges() {
        shouldHideChanges = true;
    }

    public static void runInEmulator(int[][] nArray) {
        int[] nArray2 = KiddEd.window.rom[0];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray3.length) {
            int n2 = nArray[n][0];
            int n3 = nArray[n][1];
            nArray3[n] = RomManager.StaticAccess.readByte(n2);
            nArray2[n2] = n3;
            ++n;
        }
        window.runInEmulator();
        n = 0;
        while (n < nArray3.length) {
            nArray2[nArray[n][0]] = nArray3[n];
            ++n;
        }
    }

    private void runInEmulator() {
        File file;
        File file2 = null;
        String string = properties.getProperty("Emulator");
        if (string != null) {
            file2 = new File(string);
        }
        if (file2 == null || !file2.exists()) {
            file2 = KiddEd.showEmulatorFileChooser();
        }
        if (file2 == null) {
            return;
        }
        File file3 = new File(KiddEd.getHomeDirectory(), "temp.sms");
        Process process = null;
        if (file2.getName().endsWith(".jar")) {
            file = new File(new File(System.getProperty("java.home")), "bin");
            if (file.exists()) {
                try {
                    this.saveROM(file3, true);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage().replace("{}", exception.getMessage()), TextProvider.get("TitleErrorSave"), 0);
                    return;
                }
                String[] stringArray = new String[4];
                stringArray[0] = new File(file, "java").getPath();
                stringArray[1] = "-jar";
                stringArray[3] = file3.getAbsolutePath();
                try {
                    stringArray[2] = file2.getPath();
                    process = Runtime.getRuntime().exec(stringArray, null, file2.getParentFile());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            try {
                this.saveROM(file3, true);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(window, String.valueOf(TextProvider.get("MessageErrorSave")) + ":\n" + exception.getMessage(), TextProvider.get("TitleErrorSave"), 0);
                return;
            }
            boolean bl = file2.getName().endsWith(".app");
            String[] stringArray = new String[bl ? 4 : 2];
            if (bl) {
                stringArray[0] = "open";
                stringArray[1] = "-a";
            }
            stringArray[stringArray.length - 2] = file2.getPath();
            stringArray[stringArray.length - 1] = file3.getAbsolutePath();
            try {
                process = Runtime.getRuntime().exec(stringArray, null, file2.getParentFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl) {
                process = null;
            }
        }
        if (process != null) {
            file = process;
            new Thread(new Runnable((Process)((Object)file), file3){
                private final /* synthetic */ Process val$proc;
                private final /* synthetic */ File val$tempFile;
                {
                    this.val$proc = process;
                    this.val$tempFile = file;
                }

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.val$proc.getInputStream()));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            System.out.println(string);
                        }
                        bufferedReader.close();
                        this.val$tempFile.delete();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }, "Emulator Output Reader").start();
            new Thread(new Runnable((Process)((Object)file)){
                private final /* synthetic */ Process val$proc;
                {
                    this.val$proc = process;
                }

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.val$proc.getErrorStream()));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            System.err.println(string);
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }, "Emulator Error Reader").start();
        }
    }

    private static void restart() {
        Thread thread = new Thread(RESTART_RUNNABLE);
        Runtime.getRuntime().addShutdownHook(thread);
        KiddEd.exit();
        Runtime.getRuntime().removeShutdownHook(thread);
    }

    protected int[][] getROM() {
        return KiddEd.window.rom;
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        try {
            MacUtilities.setDockIconImage(image);
        }
        catch (Exception exception) {}
    }

    public static File getHomeDirectory() {
        File file = KiddEd.getJARfile();
        if (file != null && file.exists()) {
            return file.getParentFile();
        }
        return new File(".");
    }

    private static File getJARfile() {
        File file = new File(String.valueOf(TITLE) + ".jar");
        if (file.exists()) {
            return file;
        }
        file = SourceUtilities.getLocation(KiddEd.class);
        if (file.getName().endsWith(".jar")) {
            return file;
        }
        return null;
    }

    private static File getConfigFile() {
        File file = new File(String.valueOf(TITLE) + ".ini");
        if (file.exists()) {
            return file;
        }
        return new File(KiddEd.getHomeDirectory(), String.valueOf(TITLE) + ".ini");
    }

    public static File getRomFile() {
        return romFile;
    }

    public static File getGameFile() {
        return gameFile;
    }

    public static File getMostRecentFile() {
        if (recentFiles.isEmpty()) {
            return null;
        }
        return recentFiles.iterator().next();
    }

    private static boolean openShutdownFileIfAvailable() {
        File file = new File(KiddEd.getHomeDirectory(), "shutdown.ips");
        boolean bl = false;
        if (file.exists()) {
            bl = window.openFile(file, false);
            file.delete();
            changeWatcher.hideChanges();
        }
        return bl;
    }

    private static void installQuitHandlerOnMacOS() {
        try {
            String string = System.getProperty("os.name");
            if (!"Mac OS X".equals(string)) {
                return;
            }
            MacUtilities.setQuitHandler(new Runnable(){

                @Override
                public void run() {
                    KiddEd.exit();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(final String[] stringArray) {
        args = stringArray;
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
            KiddEd.installQuitHandlerOnMacOS();
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", TITLE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (!window.isFocused()) {
                    return false;
                }
                if (keyEvent.getKeyCode() == 18) {
                    if (keyEvent.getID() == 402) {
                        return true;
                    }
                    MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                    menuSelectionManager.clearSelectedPath();
                }
                return false;
            }
        });
        KiddEd.loadSettings();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Serializable serializable2;
                window = new KiddEd();
                TextProvider.cleanUpOldLanguageFiles();
                int n = properties.getInt("Update");
                if (n < 0) {
                    serializable2 = new CheckUpdatesDialog(window, window);
                    n = ((CheckUpdatesDialog)serializable2).getResult();
                    properties.setProperty("Update", "" + n);
                }
                if (!KiddEd.VERSION.equals(properties.getProperty("UpdateVersion"))) {
                    properties.remove("UpdateVersion");
                }
                if (n >= 1) {
                    window.checkUpdates(n >= 2, true);
                }
                if (stringArray.length > 0 && window.openROM(new File(properties.getProperty("RomFile")), true, false) && ((File)(serializable2 = new File(stringArray[0]))).exists() && window.openFile((File)serializable2)) {
                    window.setVisible(true);
                    return;
                }
                if (Boolean.parseBoolean(properties.getProperty("OpenMostRecentOnStartup")) && window.openROM(new File(properties.getProperty("RomFile")), true, false)) {
                    for (Serializable serializable2 : recentFiles) {
                        if (!((File)serializable2).exists() || !window.openFile((File)serializable2)) continue;
                        KiddEd.openShutdownFileIfAvailable();
                        window.setVisible(true);
                        return;
                    }
                }
                if (!window.openROM(new File(properties.getProperty("RomFile")), true, true)) {
                    window.showROMFileChooser(window);
                }
                if (window.rom[0] == null) {
                    System.exit(0);
                }
                KiddEd.openShutdownFileIfAvailable();
                window.setVisible(true);
            }
        });
    }

    private static final void updateTitle() {
        if (window == null) {
            return;
        }
        String string = "Untitled.ips";
        if (gameFile != null) {
            string = gameFile.getName();
        }
        window.setTitle(String.valueOf(changeWatcher.hasChanges() ? "*" : "") + string + " - " + TITLE);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static EntityLabelProvider getEntityLabelProvider() {
        return entityLabelProvider;
    }
}

