/*
 * Decompiled with CFR 0.152.
 */
package editors;

import common.Properties;
import common.ScreenUtilities;
import data.LevelSpriteTileset;
import data.Palette;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import panels.EntityPanel;
import rom.RomManager;
import widgets.HexTextField;

public class BoxContentEditor
extends JDialog {
    private static BoxContentEditor editor;
    private final HexTextField[] textFields = new HexTextField[72];
    private final EntityPanel[] entityPanels = new EntityPanel[72];
    private int selectedBox;
    private LevelSpriteTileset tileset;
    private Palette palette;
    private final JComboBox<String> levelSelection;

    private BoxContentEditor(final int n, final int n2, int n3, LevelSpriteTileset levelSpriteTileset, Palette palette, int n4) {
        JComponent jComponent;
        JComponent jComponent2;
        final HexTextField[] hexTextFieldArray = this.textFields;
        final EntityPanel[] entityPanelArray = this.entityPanels;
        this.setTitle(TextProvider.get("TitleBoxContent"));
        this.tileset = levelSpriteTileset;
        this.palette = palette;
        this.setLayout(new BorderLayout());
        String[] stringArray = new String[17];
        int n5 = 0;
        while (n5 < stringArray.length) {
            stringArray[n5] = TextProvider.get("BoxIndex").replace("{}", Integer.toHexString(n5 + 1).toUpperCase());
            ++n5;
        }
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        this.levelSelection = jComboBox;
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                entityPanelArray[BoxContentEditor.this.selectedBox].setSelected(false);
                BoxContentEditor.this.selectedBox = RomManager.StaticAccess.readByte(n2 + jComboBox.getSelectedIndex());
                entityPanelArray[BoxContentEditor.this.selectedBox].setSelected(true);
            }
        });
        this.add(jComboBox, "North");
        JPanel jPanel = new JPanel(new GridLayout(6, 12, 4, 4));
        this.add((Component)jPanel, "Center");
        int n6 = 0;
        while (n6 < hexTextFieldArray.length) {
            jComponent2 = new JPanel(new BorderLayout());
            jComponent = new EntityPanel(RomManager.StaticAccess.readByte(n + n6), 0, 20, levelSpriteTileset, palette, n3);
            jComponent.setMaximumSize(new Dimension(32, 32));
            final int n7 = n6;
            entityPanelArray[n7] = jComponent;
            ((EntityPanel)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    entityPanelArray[BoxContentEditor.this.selectedBox].setSelected(false);
                    RomManager.StaticAccess.writeByte(n2 + jComboBox.getSelectedIndex(), n7);
                    BoxContentEditor.this.selectedBox = n7;
                    entityPanelArray[BoxContentEditor.this.selectedBox].setSelected(true);
                }
            });
            jComponent2.add((Component)jComponent, "Center");
            hexTextFieldArray[n6] = BoxContentEditor.createHexTextField(1, RomManager.StaticAccess.readByte(n + n6), new ActionListener((EntityPanel)jComponent){
                private final /* synthetic */ EntityPanel val$entityPanel;
                {
                    this.val$entityPanel = entityPanel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HexTextField hexTextField = (HexTextField)actionEvent.getSource();
                    this.val$entityPanel.setEntityType(hexTextField.getValue(), 0, 20, BoxContentEditor.this.tileset, BoxContentEditor.this.palette);
                }
            });
            jComponent2.add((Component)hexTextFieldArray[n6], "South");
            hexTextFieldArray[n6].registerKeyboardAction(new ActionListener((EntityPanel)jComponent){
                private final /* synthetic */ EntityPanel val$entityPanel;
                {
                    this.val$entityPanel = entityPanel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = hexTextFieldArray[n7].getValue();
                    if (n < 99) {
                        do {
                            hexTextFieldArray[n7].setText(Integer.toHexString(++n));
                        } while (n < 99 && !this.val$entityPanel.isValid());
                    }
                }
            }, KeyStroke.getKeyStroke(38, 0), 0);
            hexTextFieldArray[n6].registerKeyboardAction(new ActionListener((EntityPanel)jComponent){
                private final /* synthetic */ EntityPanel val$entityPanel;
                {
                    this.val$entityPanel = entityPanel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = hexTextFieldArray[n7].getValue();
                    if (n > 16) {
                        do {
                            hexTextFieldArray[n7].setText(Integer.toHexString(--n));
                        } while (n > 16 && !this.val$entityPanel.isValid());
                    }
                }
            }, KeyStroke.getKeyStroke(40, 0), 0);
            jComponent2.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add(jComponent2);
            ++n6;
        }
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jComponent2 = new JButton(TextProvider.get("ButtonOK"));
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = 0;
                while (n2 < hexTextFieldArray.length) {
                    RomManager.StaticAccess.writeByte(n + n2, hexTextFieldArray[n2].getValue());
                    ++n2;
                }
                BoxContentEditor.this.setVisible(false);
            }
        });
        jComponent = new JButton(TextProvider.get("ButtonCancel"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoxContentEditor.this.setVisible(false);
            }
        });
        jPanel2.add(jComponent2);
        jPanel2.add(jComponent);
        this.add((Component)jPanel2, "South");
        this.setResizable(false);
    }

    private static HexTextField createHexTextField(final int n, int n2, ActionListener actionListener) {
        HexTextField hexTextField = new HexTextField(n, n2, actionListener);
        hexTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                HexTextField hexTextField = (HexTextField)focusEvent.getComponent();
                int n2 = hexTextField.getValue();
                if (n2 < 2) {
                    n2 = 2;
                } else if (n2 > 99) {
                    n2 = 99;
                }
                hexTextField.setText(String.format("%0" + n * 2 + "X", n2));
            }
        });
        return hexTextField;
    }

    public static void open(JFrame jFrame, int n, int n2, int n3, LevelSpriteTileset levelSpriteTileset, Palette palette, int n4, Properties properties) {
        if (editor == null) {
            editor = new BoxContentEditor(n, n2, n3, levelSpriteTileset, palette, n4);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            BoxContentEditor.editor.tileset = levelSpriteTileset;
            BoxContentEditor.editor.palette = palette;
            int n5 = 0;
            while (n5 < BoxContentEditor.editor.entityPanels.length) {
                BoxContentEditor.editor.textFields[n5].setValue(RomManager.StaticAccess.readByte(n + n5));
                ++n5;
            }
        }
        BoxContentEditor.editor.levelSelection.setSelectedIndex(n4);
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

