/*
 * Decompiled with CFR 0.152.
 */
package editormodels;

import editor.GameEditorModels;
import editormodels.GameDataModel;
import editormodels.GameEditorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.swing.JFrame;

public final class GameEditorModelManager {
    private static final Map<Long, GameEditorModel> editors = new HashMap<Long, GameEditorModel>();
    private static GameEditorModelManager instance;
    private GameEditorModel gameEditorModel;

    private GameEditorModelManager() {
    }

    private static GameEditorModelManager getInstance() {
        if (instance == null) {
            instance = new GameEditorModelManager();
        }
        return instance;
    }

    public static GameEditorModel createGameEditorModel(byte[] byArray, JFrame jFrame) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        long l = cRC32.getValue();
        GameEditorModel gameEditorModel = editors.get(l);
        if (gameEditorModel == null) {
            gameEditorModel = GameEditorModels.create(l, jFrame);
            editors.put(l, gameEditorModel);
        }
        if (gameEditorModel != null) {
            gameEditorModel.createDataModel();
        }
        GameEditorModelManager.getInstance().gameEditorModel = gameEditorModel;
        return GameEditorModelManager.getInstance().gameEditorModel;
    }

    public static GameEditorModel getGameEditorModel() {
        return GameEditorModelManager.getInstance().gameEditorModel;
    }

    public static GameDataModel getGameDataModel() {
        return GameEditorModelManager.getGameEditorModel().getDataModel();
    }
}

