/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.TextProvider;
import java.util.LinkedList;
import mastersystem.OutputListener;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class Sprite
implements Changable {
    private final int address;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Sprite(int n) {
        this.address = n;
    }

    public int getAlexFrame() {
        if (this.isAlexSprite()) {
            return RomManager.StaticAccess.readByte(this.address) & 0x7F;
        }
        throw new UnsupportedOperationException("getAlexFrame can only be called for alex frames");
    }

    public boolean isAlexSprite() {
        return (RomManager.StaticAccess.readByte(this.address) & 0x80) != 0;
    }

    public int getSpriteCount() {
        if (this.isAlexSprite()) {
            return RomManager.StaticAccess.readByte(this.address + 1);
        }
        return RomManager.StaticAccess.readByte(this.address);
    }

    public int getHitboxIndex() {
        if (this.isAlexSprite()) {
            return RomManager.StaticAccess.readByte(this.address + 2);
        }
        return RomManager.StaticAccess.readByte(this.address + 1);
    }

    public int getWeaponHitboxIndex() {
        if (!this.isAlexSprite() || this.address != 36305 && this.address != 36329 && this.address != 36425 && this.address != 36446) {
            return 0;
        }
        return this.getHitboxIndex() + 4;
    }

    public void setHitboxIndex(int n) {
        if (n == this.getHitboxIndex()) {
            return;
        }
        TransactionManager.getInstance().addTransactionObject(this, -2);
        if (this.isAlexSprite()) {
            RomManager.StaticAccess.writeByte(this.address + 2, n);
        } else {
            RomManager.StaticAccess.writeByte(this.address + 1, n);
        }
    }

    public byte getHitboxX() {
        return (byte)RomManager.StaticAccess.readByte(37328 + this.getHitboxIndex());
    }

    public int getHitboxWidth() {
        return RomManager.StaticAccess.readByte(37328 + this.getHitboxIndex() + 1);
    }

    public byte getHitboxY() {
        return (byte)RomManager.StaticAccess.readByte(37328 + this.getHitboxIndex() + 2);
    }

    public int getHitboxHeight() {
        return RomManager.StaticAccess.readByte(37328 + this.getHitboxIndex() + 3);
    }

    public byte getWeaponHitboxX() {
        if (this.getWeaponHitboxIndex() == 0) {
            return 0;
        }
        return (byte)RomManager.StaticAccess.readByte(37328 + this.getWeaponHitboxIndex());
    }

    public int getWeaponHitboxWidth() {
        if (this.getWeaponHitboxIndex() == 0) {
            return 0;
        }
        return RomManager.StaticAccess.readByte(37328 + this.getWeaponHitboxIndex() + 1);
    }

    public byte getWeaponHitboxY() {
        if (this.getWeaponHitboxIndex() == 0) {
            return 0;
        }
        return (byte)RomManager.StaticAccess.readByte(37328 + this.getWeaponHitboxIndex() + 2);
    }

    public int getWeaponHitboxHeight() {
        if (this.getWeaponHitboxIndex() == 0) {
            return 0;
        }
        return RomManager.StaticAccess.readByte(37328 + this.getWeaponHitboxIndex() + 3);
    }

    public byte getSpriteY(int n) {
        if (this.isAlexSprite()) {
            return (byte)RomManager.StaticAccess.readByte(this.address + 3 + n);
        }
        return (byte)RomManager.StaticAccess.readByte(this.address + 2 + n);
    }

    public byte getSpriteX(int n) {
        if (this.isAlexSprite()) {
            return (byte)RomManager.StaticAccess.readByte(this.address + 3 + this.getSpriteCount() + n * 2);
        }
        return (byte)RomManager.StaticAccess.readByte(this.address + 2 + this.getSpriteCount() + n * 2);
    }

    public int getSpriteCharCode(int n) {
        if (this.isAlexSprite()) {
            return this.getAlexSpriteCharCode(n);
        }
        return RomManager.StaticAccess.readByte(this.address + 2 + this.getSpriteCount() + n * 2 + 1);
    }

    private int getAlexSpriteCharCode(int n) {
        int n2;
        int n3 = RomManager.StaticAccess.readByte(this.address + 3 + this.getSpriteCount() + n * 2 + 1);
        int n4 = RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(65536 + 2 * this.getAlexFrame()), 4);
        if (n3 >= (n2 = RomManager.StaticAccess.readByte(n4++))) {
            return 0;
        }
        int n5 = RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(n4 + 2 * n3), 4);
        return (n5 - 66369) / 24;
    }

    public void setSpriteCharCode(int n, int n2) {
        if (this.isAlexSprite()) {
            this.setAlexSpriteCharCode(n, n2);
        } else {
            int n3 = this.address + 2 + this.getSpriteCount() + n * 2 + 1;
            if (n2 != RomManager.StaticAccess.readByte(n3)) {
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(n3, n2);
            }
        }
    }

    private void setAlexSpriteCharCode(int n, int n2) {
        int n3;
        int n4;
        int n5 = RomManager.StaticAccess.readByte(this.address + 3 + this.getSpriteCount() + n * 2 + 1);
        if (n5 >= (n4 = RomManager.StaticAccess.readByte(n3 = RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(65536 + 2 * this.getAlexFrame()), 4)))) {
            return;
        }
        int n6 = RomManager.RESOLVE_ADDRESS(RomManager.StaticAccess.readWord(n3 + 1 + 2 * n5), 4);
        if (n2 != (n6 - 66369) / 24) {
            TransactionManager.getInstance().addTransactionObject(this, n);
            RomManager.StaticAccess.writeWord(n3 + 1 + 2 * n5, 0x8000 | 66369 + n2 * 24 & 0x3FFF);
        }
    }

    public int getHpos() {
        return 128;
    }

    public int getVpos() {
        return 96;
    }

    public int[] getSAT() {
        int[] nArray = new int[65536];
        Z80 z80 = Z80Factory.create(nArray);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n >= 51008 && n < 51072) {
                    throw new ArrayIndexOutOfBoundsException("The SAT has overflown in Sprite@" + Sprite.this + ".");
                }
            }
        });
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        nArray[49161] = 0;
        nArray[49162] = 199;
        nArray[49920] = 1;
        if (this.isAlexSprite()) {
            nArray[49927] = this.address + 1 & 0xFF;
            nArray[49928] = this.address + 1 >> 8;
        } else {
            nArray[49927] = this.address & 0xFF;
            nArray[49928] = this.address >> 8;
        }
        nArray[49932] = this.getHpos();
        nArray[49934] = this.getVpos();
        z80.setIX(49920);
        z80.execute(9943);
        nArray[nArray[49162] << 8 | nArray[49161]] = 208;
        int[] nArray2 = new int[256];
        System.arraycopy(nArray, 50944, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public int getHeight() {
        byte by;
        int by2 = 256;
        int n = 0;
        int n2 = 0;
        while (n2 < this.getSpriteCount()) {
            byte by3 = this.getSpriteY(n2);
            if (by3 < by) {
                by = by3;
            }
            if (by3 + 8 > n) {
                n = by3 + 8;
            }
            ++n2;
        }
        return n - by;
    }

    public int getLength() {
        if (this.isAlexSprite()) {
            return 3 + this.getSpriteCount() * 3;
        }
        return 2 + this.getSpriteCount() * 3;
    }

    public void alignX(int n) {
        TransactionManager.getInstance().addTransactionObject(this, -1);
        int n2 = 0;
        while (n2 < this.getSpriteCount()) {
            if (this.isAlexSprite()) {
                RomManager.StaticAccess.writeByte(this.address + 3 + this.getSpriteCount() + n2 * 2, this.getSpriteX(n2) + 4 & 0xF8);
            } else {
                RomManager.StaticAccess.writeByte(this.address + 2 + this.getSpriteCount() + n2 * 2, this.getSpriteX(n2) + 4 & 0xF8);
            }
            ++n2;
        }
    }

    public void startMoving(int n) {
        TransactionManager.getInstance().addTransactionObject(this, n);
    }

    public void setSpritePosition(int n, int n2, int n3) {
        if (this.isAlexSprite()) {
            RomManager.StaticAccess.writeByte(this.address + 3 + n, n3 & 0xFF);
            RomManager.StaticAccess.writeByte(this.address + 3 + this.getSpriteCount() + n * 2, n2 & 0xFF);
        } else {
            RomManager.StaticAccess.writeByte(this.address + 2 + n, n3 & 0xFF);
            RomManager.StaticAccess.writeByte(this.address + 2 + this.getSpriteCount() + n * 2, n2 & 0xFF);
        }
    }

    public boolean contains(int n, byte by, byte by2) {
        return by >= this.getSpriteX(n) && by < this.getSpriteX(n) + 8 && by2 >= this.getSpriteY(n) && by2 < this.getSpriteY(n) + 8;
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeSprite");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String toString() {
        return Integer.toHexString(this.address);
    }
}

