/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.CompressedTiles;
import data.Tiles;
import data.Tileset;
import java.util.ArrayList;
import java.util.Arrays;
import miracleworld.MiracleWorldDataModel;
import miracleworld.MiracleWorldEditorModel;
import rom.RomManager;
import transactions.TransactionManager;

public class LevelTileset
extends Tileset {
    private Tiles mainTileset;
    private Tiles[] additionalTilesets;

    public LevelTileset(int n, Tiles[] tilesArray, Tiles[] tilesArray2) {
        super(3692, n);
        this.updateAdditionalTilesets(tilesArray, tilesArray2);
        this.updateLevelTilesImmediately();
    }

    public void setMainTileset(Tiles tiles) {
        if (tiles != null) {
            if (this.mainTileset != null) {
                if (tiles != this.mainTileset) {
                    this.removeTilesListener(this.mainTileset);
                }
                int n = 50304 + this.level * 2;
                int n2 = 0x8000 | tiles.getSource() & 0x3FFF;
                if (RomManager.StaticAccess.readByte(n) != (n2 & 0xFF) || RomManager.StaticAccess.readByte(n + 1) != n2 >> 8) {
                    TransactionManager.getInstance().addTransactionObject(this, tiles.getDestination() / 32);
                    RomManager.StaticAccess.writeByte(n, n2 & 0xFF);
                    RomManager.StaticAccess.writeByte(n + 1, n2 >> 8);
                    this.memory[0x8000 | n & 0x3FFF] = RomManager.StaticAccess.readByte(n);
                    this.memory[0x8000 | n + 1 & 0x3FFF] = RomManager.StaticAccess.readByte(n + 1);
                    Arrays.fill(this.vram, this.mainTileset.getDestination(), this.mainTileset.getDestination() + this.mainTileset.getLength(), 0);
                    Arrays.fill(this.tileSources, this.mainTileset.getDestination() / 32, (this.mainTileset.getDestination() + this.mainTileset.getLength()) / 32, Integer.MAX_VALUE);
                    n = this.getPointerToMainTilesetDestination();
                    if (n >= 0) {
                        RomManager.StaticAccess.writeWord(n, 0x4000 | tiles.getDestination());
                        this.memory[n] = RomManager.StaticAccess.readByte(n);
                        this.memory[n + 1] = RomManager.StaticAccess.readByte(n + 1);
                    }
                    this.memoryDirty = true;
                }
            }
            this.mainTileset = tiles;
            this.addTilesListener(tiles);
        }
    }

    public void setAdditionalTileset(int n, Tiles tiles) {
        if (tiles != null) {
            Tiles tiles2 = this.additionalTilesets[n];
            if (tiles2 != null) {
                if (tiles != tiles2) {
                    this.removeTilesListener(tiles2);
                }
                int n2 = this.getPointersToAdditionalTilesetAddresses()[n];
                int n3 = 0x8000 | tiles.getSource() & 0x3FFF;
                if (!(RomManager.StaticAccess.readByte(n2) == (n3 & 0xFF) && RomManager.StaticAccess.readByte(n2 + 1) == n3 >> 8 || !(tiles instanceof CompressedTiles) && RomManager.StaticAccess.readByte(n2 + 5) != 205 && RomManager.StaticAccess.readByte(n2 + 7) != 247)) {
                    TransactionManager.getInstance().addTransactionObject(this, tiles.getDestination() / 32);
                    RomManager.StaticAccess.writeByte(n2, n3 & 0xFF);
                    RomManager.StaticAccess.writeByte(n2 + 1, n3 >> 8);
                    RomManager.StaticAccess.writeWord(n2 + 3, 0x4000 | tiles.getDestination());
                    if (tiles instanceof CompressedTiles) {
                        RomManager.StaticAccess.writeByte(n2 + 5, n < this.additionalTilesets.length - 1 || RomManager.StaticAccess.readByte(n2 + 8) == 58 && RomManager.StaticAccess.readWord(n2 + 9) == 49187 ? 205 : 195);
                        if (MiracleWorldEditorModel.isLevelMainTileset(tiles)) {
                            RomManager.StaticAccess.writeWord(n2 + 6, 4206);
                        } else {
                            RomManager.StaticAccess.writeWord(n2 + 6, 659);
                        }
                    } else {
                        RomManager.StaticAccess.writeByte(n2 + 5, 6);
                        RomManager.StaticAccess.writeByte(n2 + 6, tiles.getLength());
                        RomManager.StaticAccess.writeByte(n2 + 7, 247);
                    }
                    RomManager.StaticAccess.copyFromROM(n2, this.memory, n2, 8);
                    this.memoryDirty = true;
                }
            }
            this.additionalTilesets[n] = tiles;
            this.addTilesListener(tiles);
        }
    }

    @Override
    public boolean canSetTilesDestination(Tiles tiles) {
        if (tiles == this.mainTileset) {
            return this.getPointerToMainTilesetDestination() >= 0;
        }
        int n = 0;
        while (n < this.additionalTilesets.length) {
            if (tiles == this.additionalTilesets[n]) {
                return this.getPointersToAdditionalTilesetAddresses()[n] >= 0;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void setTilesDestination(Tiles tiles, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n + tiles.getLength() > 8192) {
            n = 8192 - tiles.getLength();
        }
        if (tiles == this.mainTileset) {
            int n2 = this.getPointerToMainTilesetDestination();
            if (n2 >= 0 && RomManager.StaticAccess.readWord(n2) != (0x4000 | n)) {
                TransactionManager.getInstance().addTransactionObject(this, 0);
                RomManager.StaticAccess.writeWord(n2, 0x4000 | n);
                this.memory[n2] = RomManager.StaticAccess.readByte(n2);
                this.memory[n2 + 1] = RomManager.StaticAccess.readByte(n2 + 1);
                this.memoryDirty = true;
            }
        } else {
            int n3 = 0;
            while (n3 < this.additionalTilesets.length) {
                int n4;
                Tiles tiles2 = this.additionalTilesets[n3];
                if (tiles == tiles2 && (n4 = this.getPointersToAdditionalTilesetAddresses()[n3].intValue()) >= 0 && RomManager.StaticAccess.readWord(n4 + 3) != (0x4000 | n)) {
                    TransactionManager.getInstance().addTransactionObject(this, 0);
                    RomManager.StaticAccess.writeWord(n4 + 3, 0x4000 | n);
                    this.memory[n4 + 3] = RomManager.StaticAccess.readByte(n4 + 3);
                    this.memory[n4 + 4] = RomManager.StaticAccess.readByte(n4 + 4);
                    this.memoryDirty = true;
                }
                ++n3;
            }
        }
    }

    @Override
    public int getTilesDestination(Tiles tiles) {
        if (tiles == this.mainTileset) {
            int n = this.getPointerToMainTilesetDestination();
            if (n >= 0) {
                return RomManager.StaticAccess.readWord(n) & 0x3FFF;
            }
        } else {
            int n = 0;
            while (n < this.additionalTilesets.length) {
                int n2;
                Tiles tiles2 = this.additionalTilesets[n];
                if (tiles == tiles2 && (n2 = this.getPointersToAdditionalTilesetAddresses()[n].intValue()) >= 0) {
                    return RomManager.StaticAccess.readWord(n2 + 3) & 0x3FFF;
                }
                ++n;
            }
        }
        return super.getTilesDestination(tiles);
    }

    @Override
    public Tiles getTilesAt(int n) {
        int n2 = this.additionalTilesets.length - 1;
        while (n2 >= 0) {
            Tiles tiles = this.additionalTilesets[n2];
            if (tiles != null && n >= this.getTilesDestination(tiles) && n < this.getTilesDestination(tiles) + tiles.getLength()) {
                return tiles;
            }
            --n2;
        }
        if (this.mainTileset != null && n >= this.getTilesDestination(this.mainTileset) && n < this.getTilesDestination(this.mainTileset) + this.mainTileset.getLength()) {
            return this.mainTileset;
        }
        return super.getTilesAt(n);
    }

    @Override
    public void updateMemory() {
        super.updateMemory();
        RomManager.StaticAccess.loadBank2(this.memory, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVRAM() {
        if (this.memoryDirty) {
            LevelTileset levelTileset = this;
            synchronized (levelTileset) {
                int[] nArray = super.getVRAM();
                this.updateLevelTilesImmediately();
                return nArray;
            }
        }
        return super.getVRAM();
    }

    @Override
    public boolean contains(int n) {
        return n == 0 || super.contains(n);
    }

    @Override
    protected boolean contains(Tiles tiles) {
        if (this.mainTileset == tiles) {
            return true;
        }
        Tiles[] tilesArray = this.additionalTilesets;
        int n = this.additionalTilesets.length;
        int n2 = 0;
        while (n2 < n) {
            Tiles tiles2 = tilesArray[n2];
            if (tiles2 == tiles) {
                return true;
            }
            ++n2;
        }
        return super.contains(tiles);
    }

    public void updateAdditionalTilesets(Tiles[] tilesArray, Tiles[] tilesArray2) {
        int[] nArray = this.getAdditionalTilesetAddresses();
        this.additionalTilesets = new Tiles[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            Tiles tiles;
            boolean bl = false;
            Tiles[] tilesArray3 = tilesArray2;
            int n2 = tilesArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                tiles = tilesArray3[n3];
                if ((0x8000 | tiles.getSource() & 0x3FFF) == nArray[n]) {
                    this.setAdditionalTileset(n, tiles);
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                tilesArray3 = tilesArray;
                n2 = tilesArray.length;
                n3 = 0;
                while (n3 < n2) {
                    tiles = tilesArray3[n3];
                    if ((0x8000 | tiles.getSource() & 0x3FFF) == nArray[n]) {
                        this.setAdditionalTileset(n, tiles);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private void updateLevelTilesImmediately() {
        int n = RomManager.StaticAccess.readWord(5485 + this.level * 2);
        this.memory[49696] = 1;
        this.memory[49697] = 0;
        this.memory[49698] = 0;
        this.memory[49699] = n & 0xFF;
        this.memory[49700] = n >> 8;
        this.memory[49701] = 0;
        this.cpu.execute(5519);
        RomManager.StaticAccess.loadBank2(this.memory, 3);
    }

    public int getMainTilesetAddress() {
        return RomManager.StaticAccess.READ_WORD(33920 + this.level * 2, 3);
    }

    public boolean hasClearTiles() {
        return this.getPointerClearTiles() >= 0;
    }

    public boolean canRemoveClearTiles() {
        int n = this.getPointerClearTiles();
        return n >= 0 && RomManager.StaticAccess.readByte(n) == 205;
    }

    private int getPointerClearTiles() {
        int n = RomManager.StaticAccess.READ_WORD(3709 + this.level * 2, 3);
        boolean bl = false;
        while (!bl) {
            switch (RomManager.StaticAccess.readByte(n++)) {
                case 1: 
                case 17: {
                    n += 2;
                    break;
                }
                case 33: {
                    n += 2;
                    break;
                }
                case 58: {
                    n += 2;
                    break;
                }
                case 195: {
                    bl = true;
                }
                case 205: {
                    if (RomManager.StaticAccess.readWord(n) == 4188) {
                        return n - 1;
                    }
                    n += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n;
                }
            }
        }
        return -1;
    }

    public boolean hasMainTileset() {
        return this.getPointerToMainTilesetDestination() >= 0;
    }

    public boolean canRemoveMainTileset() {
        int n = this.getPointerToMainTilesetDestination() - 1;
        return n >= 0 && (RomManager.StaticAccess.readByte(n + 3) == 205 || n != RomManager.StaticAccess.READ_WORD(3709 + this.level * 2, 3));
    }

    public int[] getAdditionalTilesetAddresses() {
        Integer[] integerArray = this.getPointersToAdditionalTilesetAddresses();
        int[] nArray = new int[integerArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = RomManager.StaticAccess.READ_WORD(integerArray[n], 3);
            ++n;
        }
        return nArray;
    }

    private int getPointerToMainTilesetDestination() {
        int n = RomManager.StaticAccess.READ_WORD(3709 + this.level * 2, 3);
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl3) {
            switch (RomManager.StaticAccess.readByte(n++)) {
                case 17: {
                    n2 = n;
                }
                case 1: {
                    n += 2;
                    break;
                }
                case 33: {
                    bl2 = false;
                    n += 2;
                    break;
                }
                case 58: {
                    bl = RomManager.StaticAccess.readWord(n) == 49187;
                    n += 2;
                    break;
                }
                case 195: {
                    bl3 = true;
                }
                case 205: {
                    if (MiracleWorldDataModel.hasLevelTilesetsPerLevel() && RomManager.StaticAccess.readWord(n) == 4199) {
                        bl = true;
                        bl2 = true;
                    }
                    if (n2 >= 0 && bl && bl2) {
                        return n2;
                    }
                    if (RomManager.StaticAccess.readWord(n) != 388) {
                        n2 = -1;
                    }
                    n += 2;
                    break;
                }
                case 46: {
                    bl2 = false;
                }
                case 6: {
                    ++n;
                    break;
                }
                case 62: {
                    bl = RomManager.StaticAccess.readByte(n++) == this.level + 1;
                    break;
                }
                case 215: {
                    if (!bl) {
                        n2 = -1;
                    }
                    bl2 = true;
                    break;
                }
                case 247: {
                    n2 = -1;
                }
            }
        }
        if (bl && bl2 && n2 >= 0) {
            return n2;
        }
        return -1;
    }

    private Integer[] getPointersToAdditionalTilesetAddresses() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = RomManager.StaticAccess.READ_WORD(3709 + this.level * 2, 3);
        int n2 = -1;
        while (RomManager.StaticAccess.readByte(n) != 195) {
            switch (RomManager.StaticAccess.readByte(n++)) {
                case 33: {
                    n2 = n;
                }
                case 1: 
                case 17: 
                case 58: {
                    n += 2;
                    break;
                }
                case 205: {
                    if (n2 >= 0 && (RomManager.StaticAccess.readWord(n) == 659 || RomManager.StaticAccess.readWord(n) == 4206)) {
                        arrayList.add(n2);
                    }
                    n2 = -1;
                    n += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n;
                    break;
                }
                case 215: {
                    n2 = -1;
                    break;
                }
                case 247: {
                    if (n2 >= 0) {
                        arrayList.add(n2);
                    }
                    n2 = -1;
                }
            }
        }
        if (n2 >= 0) {
            arrayList.add(n2);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public void moveCodeTo(int n) {
        int n2 = this.getCodePointer();
        int n3 = RomManager.StaticAccess.readWord(n2);
        int n4 = this.findEndOfCode();
        RomManager.StaticAccess.copyBytes(n3, n, n4 - n3);
        RomManager.StaticAccess.writeWord(n2, n);
        TransactionManager.getInstance().addTransactionObject(this, -1);
    }

    public int findEndOfCode() {
        int n = this.getCodePointer();
        boolean bl = false;
        int n2 = RomManager.StaticAccess.readWord(n);
        while (n2 < 4188 && !bl) {
            switch (RomManager.StaticAccess.readByte(n2)) {
                case 0: 
                case 215: 
                case 247: {
                    break;
                }
                case 195: {
                    bl = true;
                }
                case 1: 
                case 17: 
                case 33: 
                case 58: 
                case 205: {
                    n2 += 2;
                    break;
                }
                case 6: 
                case 46: 
                case 62: {
                    ++n2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown instruction: " + Integer.toHexString(RomManager.StaticAccess.readByte(n2)) + " at " + Integer.toHexString(n2));
                }
            }
            ++n2;
        }
        return n2;
    }

    private int getCodePointer() {
        return LevelTileset.findCodePointerTable() + (this.level + 1) * 2;
    }

    private static int findCodePointerTable() {
        int n = 3692;
        while (RomManager.StaticAccess.readByte(n) != 201) {
            if (RomManager.StaticAccess.readByte(n) == 33 && RomManager.StaticAccess.readByte(n + 3) == 231) break;
            if (RomManager.StaticAccess.readByte(n) == 33 || RomManager.StaticAccess.readByte(n) == 17 || RomManager.StaticAccess.readByte(n) == 205 || RomManager.StaticAccess.readByte(n) == 58) {
                n += 2;
            }
            ++n;
        }
        return RomManager.StaticAccess.readWord(n + 1);
    }
}

