/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editors.TextProvider;
import java.util.LinkedList;
import rom.RomManager;

public class Demo
implements Changable {
    private final int addressBank;
    private final int addressLevels;
    private final int addressPointers;
    private final int addressCount;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public Demo(int n, int n2, int n3, int n4) {
        this.addressBank = n;
        this.addressLevels = n2;
        this.addressPointers = n3;
        this.addressCount = n4;
    }

    public int getBank() {
        return RomManager.StaticAccess.readByte(this.addressBank);
    }

    public int getCount() {
        return RomManager.StaticAccess.readByte(this.addressCount);
    }

    public int getLevel(int n) {
        return RomManager.StaticAccess.readByte(this.addressLevels + n);
    }

    public int getPointer(int n) {
        return RomManager.StaticAccess.readWord(this.addressPointers + 2 * n);
    }

    public void swapButtons() {
        int n = 0;
        while (n < this.getCount()) {
            if (this.getPointer(n) >= 32768 && this.getPointer(n) < 49152) {
                int n2 = this.RESOLVE_ADDRESS(this.getPointer(n));
                while (RomManager.StaticAccess.readByte(n2) > 0) {
                    if ((RomManager.StaticAccess.readByte(n2 + 1) & 0x30) != 48) {
                        if ((RomManager.StaticAccess.readByte(n2 + 1) & 0x10) != 0) {
                            RomManager.StaticAccess.writeByte(n2 + 1, RomManager.StaticAccess.readByte(n2 + 1) & 0xFFFFFFCF | 0x20);
                        } else if ((RomManager.StaticAccess.readByte(n2 + 1) & 0x20) != 0) {
                            RomManager.StaticAccess.writeByte(n2 + 1, RomManager.StaticAccess.readByte(n2 + 1) & 0xFFFFFFCF | 0x10);
                        }
                    }
                    n2 += 2;
                }
            }
            ++n;
        }
    }

    protected final int RESOLVE_ADDRESS(int n) {
        return RomManager.RESOLVE_ADDRESS(n, this.getBank());
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeDemo");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

